// ----------------------------------------------------------------------------
// Notification routines to keep dialogs and views up to date
// when objects are created, deleted, or changed.
//
// Caution: Callback routines invoked by a notifier should not delete the
// object the notice is associated with.  Other callbacks receiving the same
// notice would then get a pointer to a deleted object.
//
#ifndef NOTIFIER_HEADER_INCLUDED
#define NOTIFIER_HEADER_INCLUDED

#include "list.h"		// use List

class Notification;

enum Notice_Type
{
  nt_will_delete_atom,
  nt_created_condition,
  nt_will_delete_condition,
  nt_added_condition_to_molecule,
  nt_removed_condition_from_molecule,
  nt_will_delete_crosspeak,
  nt_will_delete_grid,
  nt_will_delete_group,
  nt_will_delete_label,
  nt_will_delete_line,
  nt_created_molecule,
  nt_will_delete_molecule,
  nt_added_molecule_to_project,
  nt_removed_molecule_from_project,
  nt_created_ornament,
  nt_will_delete_ornament,
  nt_selected_ornament,
  nt_unselected_ornament,
  nt_selected_ornaments_changed,
  nt_will_change_ornament,
  nt_changed_ornament,
  nt_changed_ornaments,
  nt_will_drag_peak,
  nt_dragged_peak,
  nt_will_delete_project,
  nt_will_delete_py_callback,
  nt_created_resonance,
  nt_will_delete_resonance,
  nt_added_resonance_to_condition,
  nt_removed_resonance_from_condition,
  nt_changed_resonance,
  nt_will_delete_session,
  nt_created_spectrum,
  nt_will_delete_spectrum,
  nt_added_spectrum_to_project,
  nt_removed_spectrum_from_project,
  nt_changed_spectrum_condition,
  nt_renamed_spectrum,
  nt_resized_spectrum_labels,
  nt_shifted_spectrum,
  nt_drag_sregion,
  nt_created_view,
  nt_will_delete_view,
  nt_deleted_view_of_spectrum,
  nt_renamed_view,
  nt_added_view_to_project,
  nt_removed_view_from_project,
  nt_selected_view,
  nt_showed_view,
  nt_changed_view_contours,
  nt_changed_pointer_mode,
  nt_end
};

typedef void (*Notice_Callback)(void *cb_data, void *object);

// ----------------------------------------------------------------------------
// Multiple calls to notify_me() with the same notice type, callback and
// callback data will register only one callback request.  The return value
// of dont_notify_me() indicates whether a registered request matching
// the specified notice type, callback and callback data was found.
//
class Notifier
{
public:
  Notifier();
  ~Notifier();

  void notify_me(Notice_Type, Notice_Callback cb, void *cb_data);
  bool dont_notify_me(Notice_Type, Notice_Callback cb, void *cb_data);
  void send_notice(Notice_Type notice_type, void *object);

private:
  List notice_lists;
  List dispatch_lists;

  List &notice_list(Notice_Type notice_type);
  Notification *find(Notice_Type, Notice_Callback cb, void *cb_data);
};

#endif
