// ----------------------------------------------------------------------------
//

#include "list.h"
#include "memalloc.h"		// use new()
#include "num.h"	// Use min(), max()
#include "region.h"
#include "rectangle.h"

static void difference(const Rectangle &r1, const Rectangle &r2, List &pieces);
static bool contains(const List &rects, int rbegin, int rend, Rectangle r);
static bool contains(const List &rects, int rbegin, int rend,
		     const List &rlist);
static void delete_rectangles(List &rects);

// ----------------------------------------------------------------------------
//
Region2::Region2()
{
}

// ----------------------------------------------------------------------------
//
Region2::~Region2()
{
  erase();
}


// ----------------------------------------------------------------------------
//
const List &Region2::rectangles() const
{
  return rects;
}

// ----------------------------------------------------------------------------
//
Rectangle Region2::first_rectangle() const
{
  return *(Rectangle *) rectangles()[0];
}

// ----------------------------------------------------------------------------
//
void Region2::add(Rectangle r)
{
  if (!contains(r))
    {
      subtract(r);
      rects.append(new Rectangle(r));
    }
}

// ----------------------------------------------------------------------------
//
void Region2::subtract(Rectangle r)
{
  List new_rects;

  for (int ri = 0 ; ri < rects.size() ; ++ri)
    {
      Rectangle &piece = *(Rectangle *) rects[ri];
      if (r.intersects_interior(piece))
	{
	  difference(piece, r, new_rects);
	  delete &piece;
	}
      else
	new_rects.append(&piece);
    }

  rects = new_rects;
}

// ----------------------------------------------------------------------------
//
static void difference(const Rectangle &r1, const Rectangle &r2, List &pieces) 
{
  if (r1.no_interior() || r2.no_interior())
    return;

  if (!r2.intersects_interior(r1))
    pieces.append(new Rectangle(r1));
  else
    {
      if (r1.min(X) < r2.min(X))
	pieces.append(new Rectangle(r1.min(X), r1.min(Y),
				    r2.min(X), r1.max(Y)));
      if (r1.max(X) > r2.max(X))
	pieces.append(new Rectangle(r2.max(X), r1.min(Y),
				    r1.max(X), r1.max(Y)));
      if (r1.min(Y) < r2.min(Y))
	pieces.append(new Rectangle(max(r1.min(X), r2.min(X)), r1.min(Y),
				    min(r1.max(X), r2.max(X)), r2.min(Y)));
      if (r1.max(Y) > r2.max(Y))
	pieces.append(new Rectangle(max(r1.min(X), r2.min(X)), r2.max(Y),
				    min(r1.max(X), r2.max(X)), r1.max(Y)));
    }
}

// ----------------------------------------------------------------------------
//
void Region2::intersect(Rectangle r)
{
  List new_rects;

  for (int ri = 0 ; ri < rects.size() ; ++ri)
    {
      Rectangle rect = *(Rectangle *) rects[ri];
      rect.clip(r);
      if (!rect.no_interior())
	new_rects.append(new Rectangle(rect));
    }
  erase();
  rects = new_rects;
}

// ----------------------------------------------------------------------------
//
bool Region2::intersects(Rectangle r) const
{
  if (r.no_interior())
    return false;

  for (int ri = 0 ; ri < rects.size() ; ++ri)
    if (r.intersects_interior(*(Rectangle *) rects[ri]))
      return true;

  return false;
}

// ----------------------------------------------------------------------------
//
bool Region2::contains(Rectangle r) const
{
  return ::contains(rects, 0, rects.size(), r);
}

// ----------------------------------------------------------------------------
//
static bool contains(const List &rects, int rbegin, int rend, Rectangle r)
{
  if (r.no_interior())
    return true;

  for (int ri = rbegin ; ri < rend ; ++ri)
    {
      Rectangle rect = *(Rectangle *) rects[ri];
      if (rect.intersects_interior(r))
	{
	  List rlist;
	  difference(r, rect, rlist);
	  bool c = contains(rects, ri+1, rend, rlist);
	  delete_rectangles(rlist);
	  return c;
	}
    }

  return false;
}

// ----------------------------------------------------------------------------
//
static bool contains(const List &rects, int rbegin, int rend,
		     const List &rlist)
{
  for (int ri = 0 ; ri < rlist.size() ; ++ri)
    if (!contains(rects, rbegin, rend, *(Rectangle *) rlist[ri]))
      return false;

  return true;
}

// ----------------------------------------------------------------------------
//
void Region2::erase()
{
  delete_rectangles(rects);
}

// ----------------------------------------------------------------------------
//
static void delete_rectangles(List &rects)
{
  for (int r = 0 ; r < rects.size() ; ++r)
    delete (Rectangle *) rects[r];
  rects.erase();
}

// ----------------------------------------------------------------------------
//
bool Region2::is_empty() const
{
  return rects.empty();
}
