// ----------------------------------------------------------------------------
//

#include "crosspeak.h"		// use CrossPeak
#include "label.h"		// use Label
#include "list.h"		// Use List
#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "ornament.h"		// Use Ornament
#include "project.h"		// Use Project
#include "session.h"		// use Session
#include "uidialogs.h"		// use help_cb()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "winsystem.h"		// Use ws.edit_field()

// ----------------------------------------------------------------------------
//
class note_dialog : public Dialog
{
public:
  note_dialog(Session &);
  ~note_dialog();

  static note_dialog *the(Session &);

  void show();
  void update();

private:
  Widget note;

  static void selection_changed_cb(void *, void *);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_ornament_note_dialog(Session &s)
  { note_dialog::the(s)->show(); }

// ----------------------------------------------------------------------------
//
note_dialog::note_dialog(Session &s) : Dialog(s, "noteDialog")
{
  note = ws.edit_field(dialog, "note");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, note, separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_selected_ornaments_changed, selection_changed_cb, this);
}

// ----------------------------------------------------------------------------
//
note_dialog::~note_dialog()
{
  session.dialog_table().delete_dialog("note_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_selected_ornaments_changed, selection_changed_cb, this);
}

// ----------------------------------------------------------------------------
// The default note_dialog instance.
//
note_dialog *note_dialog::the(Session &s)
{
  Stringy name = "note_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new note_dialog(s));
  return (note_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void note_dialog::selection_changed_cb(void *ndialog, void *)
{
  note_dialog *nd = (note_dialog *) ndialog;

  if (nd->shown())
    nd->update();
}

// ----------------------------------------------------------------------------
//
void note_dialog::show()
{
  update();
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void note_dialog::update()
{
  CrossPeak *xp = session.project().single_peak_selected();
  Stringy n = (xp ? xp->GetNote() : Stringy(""));
  ws.set_edit_value(note, n);
}

// ----------------------------------------------------------------------------
// Notes are only applied to crosspeaks.
//
void note_dialog::apply()
{
  Stringy n = ws.edit_value(note);
  List sel = session.project().selected_ornaments();
  for (int oi = 0 ; oi < sel.size() ; ++oi)
    {
      Ornament *op = (Ornament *) sel[oi];
      CrossPeak *xp = (is_crosspeak(op) ? (CrossPeak *) op :
		       (op->type() == label ? ((Label *)op)->attached() :
			NULL));
      if (xp)
	xp->SetNote(n);
    }
}
