// ----------------------------------------------------------------------------
//

#include "memalloc.h"		// use new()
#include "num.h"		// Use max()
#include "project.h"		// use Project
#include "session.h"		// use Session
#include "stringc.h"		// Use Stringy
#include "uicomponents.h"	// Use View_Menu
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"		// use view
#include "winsystem.h"		// use ws.create_dialog(), ...

// ----------------------------------------------------------------------------
//
class overlay_dialog : public Dialog
{
public:
  overlay_dialog(Session &);
  ~overlay_dialog();

  static overlay_dialog *the(Session &);

  void show();
  void update();

private:
  Widget overlay_list;
  View_Menu *from_view, *onto_view;

  static void add_cb(Widget, CB_Data, CB_Data);
  static void remove_cb(Widget, CB_Data, CB_Data);
};

// ----------------------------------------------------------------------------
//
void show_overlay_dialog(Session &s)
  { overlay_dialog::the(s)->show(); }

// ----------------------------------------------------------------------------
//
overlay_dialog::overlay_dialog(Session &s) : Dialog(s, "overlayDialog")
{
  Widget scroller = ws.create_scrolled_list(dialog, "list", &overlay_list);
  ws.extended_selection_list(overlay_list);
  from_view = new View_Menu(s, dialog, "fromView");
  onto_view = new View_Menu(s, dialog, "ontoView");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "add", add_cb, this,
			       "remove", remove_cb, this,
			       "close", close_cb, this,
			       NULL);

  ws.column_attachments(scroller, scroller,
		     from_view->option_menu(), onto_view->option_menu(),
		     separator, controls, END_OF_WIDGETS);
}

// ----------------------------------------------------------------------------
//
overlay_dialog::~overlay_dialog()
{
  session.dialog_table().delete_dialog("overlay_dialog", this);

  delete from_view;
  delete onto_view;
}

// ----------------------------------------------------------------------------
// The default overlay_dialog instance.
//
overlay_dialog *overlay_dialog::the(Session &s)
{
  Stringy name = "overlay_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new overlay_dialog(s));
  return (overlay_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void overlay_dialog::add_cb(Widget, CB_Data client_data, CB_Data)
{
  overlay_dialog *od = (overlay_dialog *) client_data;
  Project &proj = od->session.project();
  View *from = proj.find_view(od->ws.option_selected(od->from_view->option_menu()));
  View *onto = proj.find_view(od->ws.option_selected(od->onto_view->option_menu()));
  if (from && onto)
    {
      proj.add_overlay(from, onto);
      od->update();
    }
}

// ----------------------------------------------------------------------------
//
void overlay_dialog::remove_cb(Widget, CB_Data client_data, CB_Data)
{
  overlay_dialog *od = (overlay_dialog *) client_data;

  Project &proj = od->session.project();
  List olist = od->ws.selected_list_items(od->overlay_list);
  if (olist.empty())
    {
      Stringy fname = od->ws.option_selected(od->from_view->option_menu());
      View *from = proj.find_view(fname);
      Stringy oname = od->ws.option_selected(od->onto_view->option_menu());
      View *onto = proj.find_view(oname);
      if (from && onto)
	proj.remove_overlay(from, onto);
    }
  else
    {
      for (int oi = 0 ; oi < olist.size() ; ++oi)
	{
	  Stringy *otext = (Stringy *) olist[oi];
	  Stringy rest;
	  Stringy from_name = first_token(*otext, &rest);
	  Stringy onto_name = first_token(rest, &rest);
	  View *from = proj.find_view(from_name);
	  View *onto = proj.find_view(onto_name);
	  if (from && onto)
	    proj.remove_overlay(from, onto);
	}
      free_string_list_entries(olist);
    }

  od->update();
}

// ----------------------------------------------------------------------------
//
void overlay_dialog::show()
{
  update();
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}


// ----------------------------------------------------------------------------
//
#define ONTO_VIEW_COLUMN 25

static Stringy list_text(View *from, View *onto)
{
  int space_count = max(1, (int) (ONTO_VIEW_COLUMN - from->name().length()));

  char space_format[64];
  sprintf(space_format, "%%%ds", space_count);
  Stringy spaces = formatted_string(space_format, "");

  return from->name() + spaces + onto->name();
}

// ----------------------------------------------------------------------------
//
void overlay_dialog::update()
{
  ws.delete_list_items(overlay_list);

  int count = 0;
  Project &proj = session.project();
  List vlist = proj.view_list();
  for (int vi = 0 ; vi < vlist.size() ; ++vi)
    {
      View *onto = (View *) vlist[vi];
      List froms = proj.overlaid_views(onto);
      for (int fvi = 0 ; fvi < froms.size() ; ++fvi)
	{
	  View *from = (View *) froms[fvi];
	  ws.add_list_item(overlay_list, list_text(from, onto));
	  count += 1;
	}
    }

  ws.set_visible_list_length(overlay_list, count + 1);
}
