// ----------------------------------------------------------------------------
//
#include "memalloc.h"		// use new()
#include "num.h"		// Use nearest_int()
#include "project.h"		// use Project
#include "session.h"		// use Session
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"		// use View
#include "winsystem.h"		// use WinSys

// ----------------------------------------------------------------------------
//
class preference_dialog : public Dialog
{
public:
  preference_dialog(Session &);
  ~preference_dialog();

  static preference_dialog *the(Session &);

  void show();
  void update();

private:
  Widget toggles, keytimeout, autobackup, cachesize;

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_preference_dialog(Session &s)
  { preference_dialog::the(s)->show(); }

// ----------------------------------------------------------------------------
//
preference_dialog::preference_dialog(Session &s)
  : Dialog(s, "preferenceDialog")
{
  const char *swnames[] = {"savePrompt",
			   "resizeViews",
			   "contourGraying",
			   NULL};
  toggles = ws.switches(dialog, "switches", swnames);

  keytimeout = ws.edit_field(dialog, "keyTimeout");
  autobackup = ws.edit_field(dialog, "autoBackup");
  cachesize = ws.edit_field(dialog, "cacheSize");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       NULL);

  ws.column_attachments(separator, toggles, keytimeout, autobackup, cachesize,
		     separator, controls, END_OF_WIDGETS);
}

// ----------------------------------------------------------------------------
//
preference_dialog::~preference_dialog()
{
  session.dialog_table().delete_dialog("preference_dialog", this);
}

// ----------------------------------------------------------------------------
// The default preference_dialog instance.
//
preference_dialog *preference_dialog::the(Session &s)
{
  Stringy name = "preference_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new preference_dialog(s));
  return (preference_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void preference_dialog::show()
{
  update();
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void preference_dialog::update()
{
  Preferences &pref = session.project().preferences;

  ws.set_switch(toggles, "savePrompt", pref.prompt_before_overwrite);
  ws.set_switch(toggles, "resizeViews", pref.resize_views);
  ws.set_switch(toggles, "contourGraying", pref.contour_graying);

  if (pref.key_timeout_interval == 0)
    ws.set_edit_value(keytimeout, "");
  else
    ws.set_numeric_edit_value(keytimeout, "%.1f",
			   pref.key_timeout_interval / 1000.0);

  if (pref.auto_backup_interval == 0)
    ws.set_edit_value(autobackup, "");
  else
    ws.set_numeric_edit_value(autobackup, "%.0f", pref.auto_backup_interval / 60);

  ws.set_numeric_edit_value(cachesize, "%.0f", pref.memory_cache_size);
}

// ----------------------------------------------------------------------------
//
void preference_dialog::apply()
{
  Project &proj = session.project();
  Preferences &pref = proj.preferences;

  pref.prompt_before_overwrite = ws.switch_state(toggles, "savePrompt");
  pref.resize_views = ws.switch_state(toggles, "resizeViews");
  pref.contour_graying = ws.switch_state(toggles, "contourGraying");

  List vlist = proj.view_list();
  for (int vi = 0 ; vi < vlist.size() ; ++vi)
    ((View *) vlist[vi])->set_contour_graying(pref.contour_graying);

  double seconds = ws.numeric_edit_value(keytimeout);
  pref.key_timeout_interval = nearest_int(seconds * 1000);

  double minutes = ws.numeric_edit_value(autobackup);
  proj.set_auto_backup(nearest_int(minutes * 60));

  double mbytes = ws.numeric_edit_value(cachesize);
  proj.set_cache_size(nearest_int(mbytes));
}
