# -----------------------------------------------------------------------------
# Copy peaks from one spectrum to another possibly reducing dimension.
# Only create new peaks that are sufficiently far from existing peaks.
#
import Tkinter

import axes
import pythonshell
import pyutil
import sparky
import sputil
import tkutil

# -----------------------------------------------------------------------------
#
class peak_projection_dialog(tkutil.Dialog):

  # ---------------------------------------------------------------------------
  #
  def __init__(self, session):

    self.session = session
    
    tkutil.Dialog.__init__(self, session.tk, 'Peak Projection')

    self.from_spectrum = sputil.spectrum_menu(session, self.top, 'From: ')
    self.from_spectrum.frame.pack(side = 'top', anchor = 'w')

    self.to_spectrum = sputil.spectrum_menu(session, self.top, 'To: ')
    self.to_spectrum.frame.pack(side = 'top', anchor = 'w')

    er = tkutil.entry_row(self.top, 'Minimum separation (ppm): ',
                          ('w1', '', 4), ('w2', '', 4))
    self.separation = er.variables
    er.frame.pack(side = 'top', anchor = 'w')

    self.message = Tkinter.Label(self.top, anchor = 'w')
    self.message.pack(side = 'top', fill = 'x', expand = 1)

    br = tkutil.button_row(self.top,
			   ('Ok', self.ok_cb),
			   ('Apply', self.apply_cb),
			   ('Close', self.close_cb),
			   )
    br.frame.pack(side = 'top', anchor = 'w')

  # ---------------------------------------------------------------------------
  #
  def apply_cb(self):

    from_spect = self.from_spectrum.spectrum()
    to_spect = self.to_spectrum.spectrum()
    axes = self.axis_map(from_spect, to_spect)

    if axes == None:
      return
    
    w1_sep, w2_sep = tkutil.float_variable_values(self.separation)
    cluster = pyutil.cluster((w1_sep, w2_sep))

    for peak in to_spect.peak_list():
      cluster.add_point(peak.frequency, peak)

    a1, a2 = axes
    peaks = []
    for peak in from_spect.peak_list():
      freq = (peak.frequency[a1], peak.frequency[a2])
      if not cluster.has_nearby_point(freq):
        p = to_spect.place_peak(freq)
        p.note = 'from ' + from_spect.name
        cluster.add_point(freq, p)
        peaks.append(p)

    if peaks:
      self.session.unselect_all_ornaments()
    for peak in peaks:
      peak.selected = 1

    self.message['text'] = 'Created %d peaks' % len(peaks)

  # ---------------------------------------------------------------------------
  #
  def axis_map(self, from_spect, to_spect):

    if from_spect == None or to_spect == None or to_spect.dimension != 2:
      return None

    axes = []
    for nucleus in to_spect.nuclei:
      a = axes.unique_nucleus_axis(from_spect, nucleus)
      if a == None:
        self.message['text'] = "Can't map %s axis" % nucleus
        return None
      axes.append(a)

    return axes

# -----------------------------------------------------------------------------
#
def show_dialog(session):
  sputil.the_dialog(peak_projection_dialog,session).show_window(1)

# -----------------------------------------------------------------------------
#
def add_commands(session):
  pythonshell.add_command('pp', 'Project peaks (pp)',
                          'peakto2d', 'show_dialog', session)
