# -----------------------------------------------------------------------------
# Take snapshots of Sparky spectrum window.
#

import os
import string
import time

import sparky
from sparky import sputil
from sparky import tkutil

# -----------------------------------------------------------------------------
#
class Snapshot_Dialog(tkutil.Dialog):

  def __init__(self, session):
    
    self.session = session
    
    tkutil.Dialog.__init__(self, session.tk, 'Spectrum Snapshot')

    p = tkutil.entry_field(self.top, 'Save as: ', initial = 'spectrum.xwd',
                           width = 30)
    p.frame.grid(row = 0, column = 0, sticky = 'nw')
    self.path = p.variable

    br = tkutil.button_row(self.top,
			   ('Snapshot', self.snapshot_cb),
                           ('Movie', self.movie_cb),
			   ('Close', self.close_cb),
			   )
    br.frame.grid(row = 1, column = 0, sticky = 'nw')
    
  # ---------------------------------------------------------------------------
  #
  def snapshot_cb(self):

    view = self.session.selected_view()
    if view:
      id = self.top.tk.call('winfo', 'id', view.frame)
      path = self.path.get()
      time.sleep(1)             # give time to move pointer onto spectrum
      self.top.update()         # make sure everything is redrawn
      status = os.system('xwd -out %s -id %s' % (path, id))
    
  # ---------------------------------------------------------------------------
  #
  def movie_cb(self):

    view = self.session.selected_view()
    if view == None:
      return

    sp = view.spectrum
    if sp.dimension != 3:
      return

    #
    # Make window size a multiple of 4.  This is required by
    # movie compression schemes.
    #
#    width = int(self.top.tk.call(view.frame, 'cget', '-width'))
#    w4 = 4 * (width / 4)
#    height = int(self.top.tk.call(view.frame, 'cget', '-height'))
#    h4 = 4 * (height / 4)
#    self.top.tk.call(view.frame, 'configure', '-width',
#		     '%d' % w4, '-height', '%d' % h4)

    id = self.top.tk.call('winfo', 'id', view.frame)
    path = self.path.get()
    zaxis = view.axis_order[2]
    n = sp.data_size[zaxis]
    ppm_step = sp.spectrum_width[zaxis] / n
    ppm_max = sp.region[1][zaxis]
    files = []
    for k in range(n):
      c = list(view.center)
      c[zaxis] = ppm_max - k * ppm_step
      view.center = c
      self.top.update()         # make sure everything is redrawn
      file = '%s%03d.xwd' % (path, k)
      os.system('xwd -out %s -id %s -silent' % (file, id))
      tifffile = '%s%03d.tiff' % (path, k)
      os.system('/usr/lib/print/xwd2stiff -O %s %s' % (tifffile, file))
      files.append(tifffile)
    fstring = string.join(files, ' ')
    os.system('makemovie -o %s.qt -f qt -c qt_video %s' % (path, fstring))

# -----------------------------------------------------------------------------
#
def show_snapshot_dialog(session):
  sputil.the_dialog(Snapshot_Dialog, session).show_window(1)
