@echo off

rem
rem Start up Sparky for MS Windows 95/98/NT
rem
rem If Python is available start it as a Python extension.
rem Otherwise start the standalone version of Sparky.
rem
rem Sparky uses the SPARKY_INSTALL environment variable to find its
rem application resource file and print prolog file.  Sparky will not
rem start if this path is not correct.  Paths to the Python executable
rem and Netscape directory are optional.
rem
rem Things that work in Windows NT but not Windows 95
rem
rem	1) mixing / and \ in paths
rem	2) spaces in path names
rem	3) checking existance of a directory with exist
rem	4) errorlevel set when command is not found
rem	5) LF line termination instead of CRLF
rem

rem
rem Change the variables below to the correct paths.
rem If you do not have Python or Chimera just leave those lines alone.
rem

rem The following line sets the Sparky installation directory.
set SPARKY_INSTALL=%~dp0..
set PYTHON="%SPARKY_INSTALL%\python2.5\python.exe"
set CHIMERA=c:\Progra~1\Chimera

rem
rem There is nothing user customizable below here.
rem

if exist "%SPARKY_INSTALL%\bin\sparky-no-python.exe" goto startsparky

echo The path in the sparky.bat file indicating where Sparky
echo is installed is incorrect.  You need to edit sparky.bat
echo to specify the correct path.
pause
goto end

:startsparky

set TCL_TK_LIB=%SPARKY_INSTALL%\lib
set TK_LIBRARY=%TCL_TK_LIB%\tk8.4
set TCL_LIBRARY=%TCL_TK_LIB%\tcl8.4

set PATH=%TCL_TK_LIB%;%PATH%;%NETSCAPE_PATH%

if exist %PYTHON% goto runpython

echo Running Sparky without Python
"%SPARKY_INSTALL%\bin\sparky-no-python.exe"
goto end

:runpython

echo Running Sparky with Python

rem Set variables for using Chimera
set TIX_LIBRARY=%CHIMERA%\lib\tix8.2
rem The brackets are needed in TCLLIBPATH because of a bug in init.tcl
set TCLLIBPATH={%CHIMERA%\lib}
set PATH=%PATH%;%CHIMERA%\bin

set PYTHONPATH=%SPARKY_INSTALL%\python;%SPARKY_INSTALL%\python\lib-tk
%PYTHON% -c "import sparky; sparky.start_session()"

:end
echo Finished
