// ----------------------------------------------------------------------------
// Table of key, value pairs attached to objects by extensions.
// For example the integration dialog can attach default integration
// parameters to spectra to be saved between sessions.
//
// Keys and values are strings.  To make it easy to save in files
// keys must contain no spaces and values must contain no newlines.
// If these conditions are violated save_value() returns false and
// the (key, value) is not saved.
//
#ifndef ATTACHEDDATA_HEADER_INCLUDED
#define ATTACHEDDATA_HEADER_INCLUDED

#include "table.h"		// use Table

class List;
class Stringy;

// ----------------------------------------------------------------------------
//
class AttachedData
{
public:
  AttachedData();
  virtual ~AttachedData();

  bool save_value(const Stringy &key, const Stringy &value);
  bool saved_value(const Stringy &key, Stringy *value) const;
  List keys() const;

private:
  Table key_value;

  void remove_entry(const Stringy &key);
};

#endif
