// ----------------------------------------------------------------------------
// Groups represent amino acid residues or nucleic acid bases.
//
// The group name can be any text string.  The name is divided
// into 3 parts, a symbol, a number, and a suffix.  The symbol
// is the leading part up to the first numeral, the numerals up
// to the first non-numeral comprise the number, and the rest is
// the suffix.  For example P37a separates as "P", 37, "a".
// If there are no numerals the number is zero.  The symbol
// conventionally represents the residue or base type.  The number
// is the sequence number.  And the suffix can be used to represent
// different species.
//
#ifndef GROUP_HEADER_INCLUDED
#define GROUP_HEADER_INCLUDED

#include "stringc.h"		// Use Stringy

// ----------------------------------------------------------------------------
//
class Group
{
public:
  Group(const Stringy &name);
  virtual ~Group();

  const Stringy &name() const;
  const Stringy &symbol() const;
  int number() const;
  const Stringy &suffix() const;

private:
  Stringy mName, mSymbol, mSuffix;
  int mNum;
};

#endif
