// ----------------------------------------------------------------------------
// Find peak volumes by fitting Gaussian or Lorentzian function or summing
// data heights within a box or ellipse.
//
#ifndef INTEGRATION_HEADER_INCLUDED
#define INTEGRATION_HEADER_INCLUDED

#include "spoint.h"		// use SPoint, SRegion

class List;
class Reporter;
class Spectrum;
class SpectrumData;
class Wait;

// ----------------------------------------------------------------------------
// Integration methods
//
enum Integration_Method
{ INTEGRATE_NONE, INTEGRATE_GAUSSIAN, INTEGRATE_LORENTZIAN,
  INTEGRATE_BOX, INTEGRATE_ELLIPSE, INTEGRATE_MANUAL
};
extern const char *Integration_Method_Short_Names[];
extern const char *Integration_Method_Names[];

// ----------------------------------------------------------------------------
// Parameters describing integration options
//
class Integration_Parameters
{
public:
  Integration_Parameters(SpectrumData *sp);

  Integration_Method	integration_method;

  bool		contoured_data;		// use data above lowest contour
  bool		rectangle_data;		// use data in selected rectangle

  bool		allow_motion;		// allow peaks to move
  SPoint	motion_range;		// maximum peak motion

  bool		adjust_linewidths;	// fit linewidths
  SRegion	linewidth_range;	// range of allowed linewidths

  bool		fit_baseline;

  bool		contour_grouping;	// above lowest contour
  bool		distance_grouping;	// group close peaks
  SPoint	grouping_dist;		// peak grouping distance

  bool		subtract_peaks;		// Subtract off other fit peaks

  int		maxiterations;		// max # of iterations
  double	tolerance;		// convergence criterion (%)
};

void integrate_list(Spectrum *sp, const List &peaks, const SRegion &region,
		    double positive_threshold, double negative_threshold,
		    Wait *, Reporter &);

#endif
