/*
 * Peak integration is done by fitting known lineshapes to the
 * integration volume. The lineshapes can be either Gaussian or
 * Lorentzian. 
 *
 * To do the linefitting we use temporary peaks that are the
 * theoretical lineshape and that have modifiable parameters.
 * These are called LinefitPeaks.
 *
 * We also need a volume of data to fit over, and a mask on that
 * data. The data comes from the spectrum. The mask limits the linefit
 * to a portion of that data.
 */

#ifndef _Linefit_h
#define _Linefit_h

#include "integrate.h"			// Use Integration_Parameters

class IRegion;
class List;
class Marked_Region;
class Reporter;
class Wait;

bool linefit(const List &peaks, const Marked_Region &data_mask,
	     const Integration_Parameters &ip, Wait *wait, Reporter &);

void add_fit_peaks(const List &peaks, double scale,
		   const IRegion &region, float *data);

#endif
