// ----------------------------------------------------------------------------
// Request a new datafile location.
//

#include "memalloc.h"		// use new()
#include "session.h"		// use Session
#include "stringc.h"		// Use Stringy
#include "system.h"		// use file_directory()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "winsystem.h"		// use WinSys

// ----------------------------------------------------------------------------
//
class data_location_dialog : public Dialog
{
public:
  data_location_dialog(Session &);
  ~data_location_dialog();

  static data_location_dialog *the(Session &);

  Stringy show(const Stringy &data_path);

private:
  Widget heading, filename;
  Stringy new_data_path;
  bool replied;

  static void ok_cb(Widget, CB_Data, CB_Data);
  static void browse_cb(Widget, CB_Data, CB_Data);
  static void close_cb(Widget, CB_Data, CB_Data);
};

// ----------------------------------------------------------------------------
//
Stringy request_new_data_location(Session &s, const Stringy &data_path)
  { return data_location_dialog::the(s)->show(data_path); }

// ----------------------------------------------------------------------------
//
data_location_dialog::data_location_dialog(Session &s)
  : Dialog(s, "dataLocationDialog")
{
  heading = ws.create_label(dialog, "heading");

  filename = ws.edit_field(dialog, "file");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "browse", browse_cb, this,
			       "cancel", close_cb, this,
			       NULL);

  ws.column_attachments(separator, heading, filename,
		     separator, controls, END_OF_WIDGETS);
}

// ----------------------------------------------------------------------------
//
data_location_dialog::~data_location_dialog()
{
  session.dialog_table().delete_dialog("data_location_dialog", this);
}

// ----------------------------------------------------------------------------
// The default data_location_dialog instance.
//
data_location_dialog *data_location_dialog::the(Session &s)
{
  Stringy name = "data_location_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new data_location_dialog(s));
  return (data_location_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void data_location_dialog::ok_cb(Widget, CB_Data client_data, CB_Data)
{
  data_location_dialog *ld = (data_location_dialog *) client_data;
  ld->ws.unshow_dialog(ld->dialog);
  ld->new_data_path = ld->ws.edit_value(ld->filename);
  ld->replied = true;
}

// ----------------------------------------------------------------------------
//
void data_location_dialog::browse_cb(Widget, CB_Data client_data, CB_Data)
{
  data_location_dialog *ld = (data_location_dialog *) client_data;
  Stringy dir = file_directory(ld->ws.edit_value(ld->filename));
  Stringy path = ld->ws.open_file_dialog(ld->dialog, "New data path",
					 dir, "nmrdata", !dir.is_empty());
  if (! path.is_empty())
    ld->ws.set_edit_value(ld->filename, path);
}

// ----------------------------------------------------------------------------
//
void data_location_dialog::close_cb(Widget, CB_Data client_data, CB_Data)
{
  data_location_dialog *ld = (data_location_dialog *) client_data;
  ld->ws.unshow_dialog(ld->dialog);
  ld->new_data_path = "";
  ld->replied = true;
}

// ----------------------------------------------------------------------------
//
Stringy data_location_dialog::show(const Stringy &data_path)
{
  Stringy suggest_path = data_path;
  if (!new_data_path.is_empty())
    {
      Stringy path = file_path(file_directory(new_data_path),
			       file_name(data_path));
      if (file_exists(path))
	suggest_path = path;
    }

  new_data_path = "";

  Stringy h = formatted_string("NMR data file\n\n  %s\n\nis unreadable.\n",
			       data_path.cstring());
  ws.set_label_text(heading, h);
  ws.set_edit_value(filename, suggest_path);

  this->replied = false;
  ws.show_dialog(dialog);
  ws.process_until_modal_reply(dialog, &replied);

  return new_data_path;
}
