// ----------------------------------------------------------------------------
//  Dialogs
//

#ifndef UIDIALOGS_HEADER_INCLUDED
#define UIDIALOGS_HEADER_INCLUDED

#include "winsystem.h"		// use Widget, CB_Data

class Condition;
class CrossPeak;
class Ornament;
class Session;
class Spectrum;
class SPoint;
class Stringy;
class View;

void show_assignment_dialog(Session &, CrossPeak *xp);
void update_assignment_dialog_guesses(Session &);
void show_assignment_copy_dialog(Session &, Spectrum *sp);
void show_contour_dialog(Session &, View *view);
Stringy request_new_data_location(Session &, const Stringy &data_path);
void help_cb(Widget help_button, CB_Data, CB_Data);
void show_help(Session &, const Stringy &topic);
void show_manual_url(Session &, const Stringy &manual_url);
void show_guess_dialog(Session &, Spectrum *sp);
void update_guess_dialog(Session &, Spectrum *sp);
void show_integration_dialog(Session &, Spectrum *sp);
void show_label_dialog(Session &, Ornament *peak_or_label);
void show_label_dialog(Session &, Spectrum *sp, const SPoint &position);
void show_midas_dialog(Session &, Spectrum *sp);
void show_ornament_dialog(Session &);
void show_ornament_color_dialog(Session &);
void show_ornament_note_dialog(Session &);
void show_ornament_size_dialog(Session &, Spectrum *sp);
void show_overlay_dialog(Session &);
void show_pick_dialog(Session &, Spectrum *sp);
void show_predefined_resonance_dialog(Session &);
void show_preference_dialog(Session &);
void show_print_dialog(Session &, View *view);
void show_rename_dialog(Session &);
void show_resonance_list_dialog(Session &, const Condition &c);
void show_resonance_table_dialog(Session &, Spectrum *sp);
void show_spectrum_dialog(Session &, Spectrum *sp);
void show_sync_dialog(Session &);
void show_view_dialog(Session &, View *view);
void show_view_depth_dialog(Session &, View *view);
void show_view_list_dialog(Session &);

#endif
