// ----------------------------------------------------------------------------
// Show sections of the manual using Netscape
//

#include <string.h>		// use strchr()

#include "paths.h"		// use installation_path(), SPARKY_MANUAL
#include "reporter.h"		// use Reporter
#include "session.h"		// use Session
#include "stringc.h"		// use Stringy
#include "system.h"		// use show_url(), path_separator()
#include "uidialogs.h"		// use show_manual_url()
#include "uimain.h"		// use query()
#include "utility.h"		// use warning()
#include "winsystem.h"		// use Widget

// ----------------------------------------------------------------------------
// URL is retrieved from option database.
//
void show_help(Session &s, const Stringy &topic)
{
  WinSys &ws = s.window_system();
  Stringy url = ws.read_application_resource(ws.main_widget(),
					     topic + "Url", "Url", "");
  show_manual_url(s, url);
}

// ----------------------------------------------------------------------------
//
void show_manual_url(Session &s, const Stringy &manual_url)
{
  Stringy mandir = installation_path(SPARKY_MANUAL);
  Stringy page = (manual_url.is_empty() ? Stringy("index.html") : manual_url);
  Stringy path = file_path(mandir, page);
  path = replace_character(path, path_separator().cstring()[0], '/');
  Stringy url = "file://" + path;
  Stringy error_msg;
  if (!show_url(url, &error_msg))
    {
      Reporter &rr = s.reporter();
      rr.warning("Unable to show:\n"
		 "%s\n"
		 "You can view this in any web browser.\n\n"
		 "%s",
		 url.cstring(), error_msg.cstring());
    }
}
