// ----------------------------------------------------------------------------
//

#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "uicomponents.h"	// Use View_Menu
#include "uidialogs.h"		// use help_cb()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"
#include "winsystem.h"		// use WinSys

// ----------------------------------------------------------------------------
//
class view_dialog : public Dialog
{
public:
  view_dialog(Session &);
  ~view_dialog();

  static view_dialog *the(Session &);

  void show(View *view);
  void update(View *view);

private:
  Widget units_menu, aspect_field, assignformat_field, toggles;
  View_Menu *view_menu;
  View *view;

  static void will_delete_view_cb(void *vdialog, void *view);
  static void view_menu_cb(Widget, CB_Data, CB_Data);
  static void depth_cb(Widget, CB_Data, CB_Data);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_view_dialog(Session &s, View *view)
  { view_dialog::the(s)->show(view); }

// ----------------------------------------------------------------------------
//
view_dialog::view_dialog(Session &s) : Dialog(s, "viewDialog")
{
  this->view = NULL;

  view_menu = new View_Menu(s, dialog, "viewMenu");
  ws.option_callback(view_menu->option_menu(), view_menu_cb, this);

  const char *units[] = {"ppm", "hz", "index", NULL};
  units_menu = ws.option_menu(dialog, "units", units);
  aspect_field = ws.edit_field(dialog, "aspect");
  assignformat_field = ws.edit_field(dialog, "assignFormat");
  Widget depth_button = ws.push_button(dialog, "depth", depth_cb, this);

  const char *names[] = {"ornaments",
			  "labels",
			  "peaks",
			  "peakGroups",
			  "grids",
			  "lines",
			  "atomNames",
			  "crosshair",
			  "transposeCrosshair",
			  "crosshairOther",
			  "scales",
			  "scrollbars",
			  "resonancePanels",
			  "resFilter",
			  "slicePanels",
			  "scaleSlices",
			  "sliceSubtract",
			  "peakInfo",
			  "contourScale",
			  "subtractPeaks",
			  NULL};
  toggles = ws.switches(dialog, "switches", names, 2);

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, view_menu->option_menu(),
		     units_menu, aspect_field,
		     assignformat_field, depth_button, toggles,
		     separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_will_delete_view, will_delete_view_cb, this);
}

// ----------------------------------------------------------------------------
//
view_dialog::~view_dialog()
{
  session.dialog_table().delete_dialog("view_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_will_delete_view, will_delete_view_cb, this);

  delete view_menu;
}

// ----------------------------------------------------------------------------
// The default view_dialog instance.
//
view_dialog *view_dialog::the(Session &s)
{
  Stringy name = "view_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new view_dialog(s));
  return (view_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void view_dialog::will_delete_view_cb(void *vdialog, void *view)
{
  view_dialog *vd = (view_dialog *) vdialog;
  View *v = (View *) view;

  if (vd->view == v)
    vd->update(NULL);
}

// ----------------------------------------------------------------------------
//
void view_dialog::view_menu_cb(Widget, CB_Data vdialog, CB_Data)
{
  view_dialog *vd = (view_dialog *) vdialog;
  View *view = vd->view_menu->selected_view();
  if (view)
    vd->update(view);
}

// ----------------------------------------------------------------------------
//
void view_dialog::depth_cb(Widget, CB_Data vdialog, CB_Data)
{
  view_dialog *vd = (view_dialog *) vdialog;
  show_view_depth_dialog(vd->session, vd->view);
}

// ----------------------------------------------------------------------------
//
void view_dialog::show(View *view)
{
  update(view);
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void view_dialog::update(View *view)
{
  this->view = view;

  View_Settings s = (view == NULL ? View_Settings(NULL) : view->settings());

  Stringy dialog_title = Stringy("View Settings ") + s.view_name;
  ws.set_dialog_title(dialog, dialog_title);

  view_menu->set_view_choice(view);

  ws.set_option(units_menu, index_name(Unit_Names, s.scale_units));

  double aspect = (view == NULL ? 1 : view->aspect());
  ws.set_numeric_edit_value(aspect_field, "%.2f", aspect);

  Stringy format = (view == NULL ? "" : view->spectrum()->assignment_format());
  ws.set_edit_value(assignformat_field, format);

  ws.set_switch(toggles, "ornaments", s.show_ornaments);
  ws.set_switch(toggles, "labels", s.show_labels);
  ws.set_switch(toggles, "peaks", s.show_peaks);
  ws.set_switch(toggles, "peakGroups", s.show_peakgroups);
  ws.set_switch(toggles, "grids", s.show_grids);
  ws.set_switch(toggles, "lines", s.show_lines);
  ws.set_switch(toggles, "atomNames", s.show_nucleus_names);
  ws.set_switch(toggles, "crosshair", s.show_crosshair);
  ws.set_switch(toggles, "transposeCrosshair", s.show_transpose_crosshair);
  ws.set_switch(toggles, "crosshairOther", s.show_crosshair_from_other_views);

  ws.set_switch(toggles, "scales", s.show_scales);
  ws.set_switch(toggles, "scrollbars", s.show_scrollbars);
  ws.set_switch(toggles, "resonancePanels", s.show_resonance_panels);
  ws.set_switch(toggles, "resFilter", s.filter_resonances);
  ws.set_switch(toggles, "slicePanels", s.show_slices);
  ws.set_switch(toggles, "scaleSlices", s.slice_auto_scale);
  ws.set_switch(toggles, "sliceSubtract", s.slice_subtract_peaks);
  ws.set_switch(toggles, "peakInfo", s.show_peak_info);
  ws.set_switch(toggles, "contourScale", s.show_contour_scale);
  ws.set_switch(toggles, "subtractPeaks", s.subtract_fit_peaks);
}

// ----------------------------------------------------------------------------
//
void view_dialog::apply()
{
  if (view == NULL)
    return;

  double aspect = ws.numeric_edit_value(aspect_field);
  if (aspect > 0)
    view->set_aspect(aspect);

  Stringy assignformat = ws.edit_value(assignformat_field);
  view->spectrum()->set_assignment_format(assignformat);

  View_Settings s = view->settings();

  int u = name_index(Unit_Names, ws.option_selected(units_menu));
  s.scale_units = (u >= 0 ? (Units) u : PPM);

  s.show_ornaments = ws.switch_state(toggles, "ornaments");
  s.show_labels =  ws.switch_state(toggles, "labels");
  s.show_peaks = ws.switch_state(toggles, "peaks");
  s.show_peakgroups = ws.switch_state(toggles, "peakGroups");
  s.show_grids = ws.switch_state(toggles, "grids");
  s.show_lines = ws.switch_state(toggles, "lines");
  s.show_nucleus_names = ws.switch_state(toggles, "atomNames");

  s.show_crosshair = ws.switch_state(toggles, "crosshair");
  s.show_transpose_crosshair = ws.switch_state(toggles, "transposeCrosshair");
  s.show_crosshair_from_other_views = ws.switch_state(toggles, "crosshairOther");

  s.show_scales = ws.switch_state(toggles, "scales");
  s.show_scrollbars = ws.switch_state(toggles, "scrollbars");
  s.show_resonance_panels = ws.switch_state(toggles, "resonancePanels");
  s.filter_resonances = ws.switch_state(toggles, "resFilter");
  s.show_slices = ws.switch_state(toggles, "slicePanels");
  s.slice_auto_scale = ws.switch_state(toggles, "scaleSlices");
  s.slice_subtract_peaks = ws.switch_state(toggles, "sliceSubtract");
  s.show_peak_info = ws.switch_state(toggles, "peakInfo");
  s.show_contour_scale = ws.switch_state(toggles, "contourScale");

  s.subtract_fit_peaks = ws.switch_state(toggles, "subtractPeaks");

  view->configure(s);
}
