// ----------------------------------------------------------------------------
//
#include <stdarg.h>		// Use ...
#include <stdio.h>		// Use fprintf()

#include "utility.h"
#include "system.h"		// Use core_dump()

#define MAX_LINE_LENGTH		4096

// ----------------------------------------------------------------------------
//  Display a warning message to stderr.
//
void warn(const char *format, ...)
{
	va_list	args;
	char	buf[MAX_LINE_LENGTH];

	va_start(args, format);
	vsprintf(buf, format, args);
	va_end(args);

	fprintf(stderr, "Warning: %s", buf);
}

// ----------------------------------------------------------------------------
//  Display an error message and exit.
//
#define EXIT_FATAL_ERROR 817

void fatal_error(const char *format, ...)
{
	va_list	args;
	char	buf[MAX_LINE_LENGTH];

	va_start(args, format);
	vsprintf(buf, format, args);
	va_end(args);

	fprintf(stderr, "Fatal Error:  %s\n", buf);

	core_dump();
}
