# -----------------------------------------------------------------------------
# Example sparky_init.py file that adds accelerators zu and zd 
# to move one plane up or down in a 3D spectrum.
#
# Make a directory ~/Sparky/Python and and create a file called
# sparky_init.py containing this code.
#
# The initialize_session() function in your sparky_init.py file is run
# whenever you start Sparky.  The code below adds accelerators zu an zd
# to the Extension menu.  When invoked they run the step_upfield() and
# step_downfield() functions which act on the currently selected "view"
# ie. spectrum window.  All you have to do is start Sparky to try them.
#

# -----------------------------------------------------------------------------
# Start up file run when Sparky starts Python interpretter.
#

def initialize_session(session):

  def zu_cmd(s = session): step_upfield(s)
  session.add_command('zu', 'Step upfield', zu_cmd)
  def zd_cmd(s = session): step_downfield(s)
  session.add_command('zd', 'Step downfield', zd_cmd)

# -----------------------------------------------------------------------------
# Commands to step one plane in a 3D spectrum.
#

def step_downfield(session):
  z_step(session, 1)

def step_upfield(session):
  z_step(session, -1)

def z_step(session, n):
  v = session.selected_view()
  if v:
    s = v.spectrum
    if s.dimension == 3:
      z_axis = v.axis_order[2]
      ppm_step = s.spectrum_width[z_axis] / s.data_size[z_axis]
      center = list(v.center)
      center[z_axis] = center[z_axis] + n * ppm_step
      v.center = center
