# ---------------------------------------------------------------------------
# Amino acid chemical shift statistics from BioMagResBank
#
# Statistics Calculated for Selected Chemical Shifts from Atoms in the
# 20 Common Amino Acids
#
# BMRB Entries not included in the calculations for this table contained
# chemical shifts outside eight standard deviations from the mean
# calculated for the full BMRB database or a chemical shift for at least
# one carbon bound proton that was greater than 10ppm or was less than
# -2.5ppm.  These criteria were used to eliminate from the calculations
# chemical shifts from paramagnetic proteins, from proteins with
# aromatic prosthetic groups, and from entries where unusual chemical
# shift referencing was used.  Of the 145,398 possible chemical shifts
# in the BMRB database, 123,360 were included in calculating this table.
#

import string
import sys

import atomnames
import sparky
import pyutil

# -----------------------------------------------------------------------------
#
stat_lines = (
"ALA     H        H        1471        5.29       11.35       8.19       0.61",
"ALA     HA       H        1456        1.92        6.16       4.26       0.44",
"ALA     HB       H        1368       -0.56        3.70       1.38       0.29",
"ALA     C        C        141       171.00      181.70     177.58       2.42",
"ALA     CA       C        284        47.15       56.70      52.47       2.14",
"ALA     CB       C        204        14.50       23.40      18.60       1.81",
"ALA     N        N        493        99.44      136.80     123.24       4.23",
"ARG     H        H        964         5.02       11.15       8.27       0.59",
"ARG     HA       H        912         2.12        8.85       4.30       0.45",
"ARG     HB2      H        823        -0.38        3.29       1.75       0.31",
"ARG     HB3      H        823         0.17        3.29       1.79       0.26",
"ARG     HG2      H        646        -0.64        2.34       1.58       0.25",
"ARG     HG3      H        646        -0.22        2.39       1.59       0.24",
"ARG     HD2      H        648         1.81        3.85       3.13       0.19",
"ARG     HD3      H        648         1.81        3.70       3.15       0.17",
"ARG     HE       H        476         3.25       11.15       7.31       0.51",
"ARG     HH11     H        78          6.26        7.49       6.72       0.20",
"ARG     HH12     H        77          6.26        7.49       6.72       0.20",
"ARG     HH21     H        78          6.26        7.49       6.72       0.20",
"ARG     HH22     H        78          6.26        7.49       6.72       0.20",
"ARG     C        C        81        168.67      181.50     175.45       2.86",
"ARG     CA       C        153        50.50       60.90      56.42       2.49",
"ARG     CB       C        78         27.00       35.70      30.70       1.78",
"ARG     CG       C        50         23.70       29.90      26.60       1.32",
"ARG     CD       C        55         40.70       45.20      42.64       0.89",
"ARG     CZ       C        7         157.70      158.04     157.85       0.13",
"ARG     N        N        230       103.60      130.90     120.76       4.24",
"ARG     NE       N        20         81.60       89.10      85.48       1.67",
"ARG     NH1      N        5          72.60       72.90      72.74       0.12",
"ARG     NH2      N        5          72.60       72.90      72.74       0.12",
"ASN     H        H        940         5.32       11.26       8.35       0.66",
"ASN     HA       H        907         3.45        6.25       4.71       0.39",
"ASN     HB2      H        816         0.57        4.25       2.75       0.35",
"ASN     HB3      H        815         0.26        3.83       2.81       0.34",
"ASN     HD21     H        487         5.11        9.19       7.14       0.46",
"ASN     HD22     H        487         3.14        9.40       7.31       0.58",
"ASN     C        C        107       170.00      179.70     174.86       1.71",
"ASN     CA       C        187        47.65       58.20      53.08       1.97",
"ASN     CB       C        130        33.50       44.00      38.34       1.74",
"ASN     CG       C        13        173.50      177.10     175.15       1.14",
"ASN     N        N        286       106.30      132.70     119.19       4.96",
"ASN     ND2      N        76        107.50      120.22     113.58       2.51",
"ASP     H        H        1083        6.39       11.54       8.37       0.57",
"ASP     HA       H        1044        2.59        6.33       4.63       0.31",
"ASP     HB2      H        951         1.33        6.60       2.72       0.30",
"ASP     HB3      H        951         1.14        3.83       2.77       0.27",
"ASP     C        C        138       172.20      181.80     176.56       1.61",
"ASP     CA       C        211        48.50       58.50      53.97       1.94",
"ASP     CB       C        138        34.45       44.00      40.60       1.64",
"ASP     CG       C        10        173.49      178.70     176.08       1.65",
"ASP     N        N        349       109.90      133.40     120.64       4.22",
"CYS     H        H        960         6.52       10.71       8.43       0.67",
"CYS     HA       H        980         1.70        6.12       4.72       0.59",
"CYS     HB2      H        935         0.62        4.38       2.94       0.41",
"CYS     HB3      H        935         0.14        4.41       3.04       0.42",
"CYS     C        C        56        171.03      178.20     173.55       1.86",
"CYS     CA       C        73         50.30       65.60      56.37       3.50",
"CYS     CB       C        46         24.65       64.70      38.09       8.35",
"CYS     N        N        121       111.10      132.39     118.68       3.86",
"GLN     H        H        767         5.93       11.94       8.21       0.62",
"GLN     HA       H        726         3.10        6.00       4.30       0.44",
"GLN     HB2      H        628         0.10        2.62       2.02       0.26",
"GLN     HB3      H        628         0.48        4.04       2.07       0.26",
"GLN     HG2      H        523         0.26        3.28       2.30       0.32",
"GLN     HG3      H        523         0.26        3.28       2.33       0.26",
"GLN     HE21     H        339         5.45        8.27       7.04       0.42",
"GLN     HE22     H        339         5.08        8.83       7.18       0.46",
"GLN     C        C        73        170.70      179.60     175.94       2.01",
"GLN     CA       C        145        50.70       61.70      55.91       2.34",
"GLN     CB       C        98         23.20       38.08      29.08       2.19",
"GLN     CG       C        63         27.98       36.10      33.24       1.07",
"GLN     CD       C        10        178.40      180.70     179.39       0.77",
"GLN     N        N        259       111.60      132.80     120.16       4.05",
"GLN     NE2      N        64        105.80      121.20     111.95       2.52",
"GLU     H        H        1302        6.15       10.93       8.31       0.62",
"GLU     HA       H        1249        2.54        6.29       4.27       0.43",
"GLU     HB2      H        1066        0.48        2.91       2.03       0.23",
"GLU     HB3      H        1066        0.50        2.91       2.06       0.21",
"GLU     HG2      H        871         1.10        3.20       2.33       0.22",
"GLU     HG3      H        871         0.66        3.14       2.34       0.22",
"GLU     C        C        165       169.10      180.50     177.03       2.19",
"GLU     CA       C        273        50.95       60.70      56.96       2.37",
"GLU     CB       C        161        26.30       36.00      30.14       1.81",
"GLU     CG       C        129        28.10       38.20      35.47       1.74",
"GLU     CD       C        12        177.76      182.20     180.27       1.67",
"GLU     N        N        446       112.30      132.20     120.82       3.48",
"GLY     H        H        1543        4.45       12.22       8.36       0.73",
"GLY     HA2      H        1487        0.34        6.17       3.85       0.43",
"GLY     HA3      H        1480        1.27        6.01       4.01       0.38",
"GLY     C        C        135       168.40      181.10     173.39       1.84",
"GLY     CA       C        318        39.70       49.60      44.71       1.38",
"GLY     N        N        443        88.30      121.60     109.19       4.07",
"HIS     H        H        450         5.82       10.80       8.28       0.75",
"HIS     HA       H        464         2.46        8.90       4.63       0.53",
"HIS     HB2      H        425         0.37        8.70       3.10       0.51",
"HIS     HB3      H        425         0.81        8.70       3.14       0.52",
"HIS     HD1      H        52          6.46       17.20      11.22       3.80",
"HIS     HD2      H        536         4.30        8.82       7.10       0.54",
"HIS     HE1      H        581         3.21        9.60       8.12       0.55",
"HIS     HE2      H        39          6.87       16.53      10.74       3.27",
"HIS     C        C        48        170.50      179.31     174.49       2.15",
"HIS     CA       C        88         51.60       60.70      55.06       2.37",
"HIS     CB       C        71         24.75       35.31      29.92       2.28",
"HIS     CG       C        39        122.67      136.80     130.59       3.41",
"HIS     CD2      C        28        115.90      125.90     119.00       2.09",
"HIS     CE1      C        26        133.30      138.60     135.93       1.15",
"HIS     N        N        124       105.00      129.70     118.86       4.58",
"HIS     ND1      N        23        168.20      248.00     192.74      17.24",
"HIS     NE2      N        23        166.70      231.50     180.95      15.19",
"ILE     H        H        836         6.15       10.28       8.26       0.66",
"ILE     HA       H        833         1.03        5.99       4.23       0.57",
"ILE     HB       H        797        -1.12        2.78       1.78       0.34",
"ILE     HG12     H        632         0.03        2.44       1.22       0.38",
"ILE     HG13     H        632        -2.04        2.88       1.27       0.41",
"ILE     HG2      H        740        -2.07        1.77       0.79       0.33",
"ILE     HD1      H        63         -1.20        1.14       0.61       0.48",
"ILE     C        C        93        169.40      179.30     175.53       1.95",
"ILE     CA       C        156        52.30       66.44      60.84       2.89",
"ILE     CB       C        97         32.20       43.10      38.66       2.26",
"ILE     CG1      C        62         20.66       38.25      27.14       2.71",
"ILE     CG2      C        90         12.26       20.40      16.45       1.60",
"ILE     CD1      C        46          9.30       15.90      12.79       1.64",
"ILE     N        N        276       108.20      133.70     122.45       4.68",
"LEU     H        H        1557        5.94       10.53       8.22       0.60",
"LEU     HA       H        1516        1.95        5.96       4.31       0.44",
"LEU     HB2      H        1348        0.00        2.57       1.61       0.32",
"LEU     HB3      H        1348       -1.21        2.68       1.62       0.33",
"LEU     HG       H        1230       -1.06        3.90       1.52       0.31",
"LEU     HD1      H        1339       -0.83        2.15       0.76       0.26",
"LEU     HD2      H        1341       -1.03        2.78       0.77       0.29",
"LEU     C        C        126       169.30      180.40     176.77       2.02",
"LEU     CA       C        271        50.40       59.96      54.86       2.11",
"LEU     CB       C        165        36.30       50.90      42.57       2.18",
"LEU     CG       C        133        22.20       36.83      26.64       1.89",
"LEU     CD1      C        207        16.91       28.48      24.30       1.89",
"LEU     CD2      C        209        16.91       28.30      24.03       1.90",
"LEU     N        N        503       111.00      134.60     121.88       4.40",
"LYS     H        H        1632        6.29       11.53       8.24       0.66",
"LYS     HA       H        1530        2.54        5.79       4.26       0.41",
"LYS     HB2      H        1330        0.16        3.77       1.77       0.25",
"LYS     HB3      H        1331        0.14        3.77       1.81       0.24",
"LYS     HG2      H        927         0.05        2.99       1.37       0.27",
"LYS     HG3      H        927        -0.02        2.99       1.39       0.26",
"LYS     HD2      H        819         0.46        3.18       1.62       0.24",
"LYS     HD3      H        819         0.46        3.18       1.63       0.24",
"LYS     HE2      H        815         1.63        3.93       2.93       0.18",
"LYS     HE3      H        814         1.80        3.93       2.94       0.16",
"LYS     HZ       H        220         6.96        9.26       7.53       0.17",
"LYS     C        C        157       170.20      181.50     176.70       2.10",
"LYS     CA       C        334        49.50       61.75      56.51       2.20",
"LYS     CB       C        204        23.90       39.00      32.69       1.88",
"LYS     CG       C        122        22.10       26.90      24.54       0.94",
"LYS     CD       C        121        24.34       33.90      28.75       1.01",
"LYS     CE       C        129        36.31       43.09      41.28       1.07",
"LYS     N        N        571       109.60      131.70     121.35       3.96",
"LYS     NZ       N        2          33.70       34.10      33.90       0.28",
"MET     H        H        347         6.33        9.62       8.32       0.58",
"MET     HA       H        351         3.46        6.00       4.41       0.41",
"MET     HB2      H        278        -0.97        2.84       1.99       0.44",
"MET     HB3      H        278        -0.97        2.86       2.02       0.42",
"MET     HG2      H        220         0.55        3.80       2.47       0.33",
"MET     HG3      H        221         0.55        3.80       2.49       0.31",
"MET     HE       H        202        -0.19        3.30       1.85       0.60",
"MET     C        C        60        134.00      180.20     175.91       5.98",
"MET     CA       C        94         50.80       59.70      55.50       2.19",
"MET     CB       C        53         25.50       39.80      32.65       2.85",
"MET     CG       C        38         26.40       34.32      31.38       1.57",
"MET     CE       C        38         12.90       40.00      16.87       5.59",
"MET     N        N        138       109.60      131.30     120.37       4.43",
"PHE     H        H        730         5.72       11.10       8.46       0.73",
"PHE     HA       H        746         3.15        6.30       4.66       0.57",
"PHE     HB2      H        678         1.39        4.14       2.95       0.35",
"PHE     HB3      H        678         1.48        3.79       3.03       0.34",
"PHE     HD1      H        887         2.02        7.90       6.76       1.09",
"PHE     HD2      H        889         2.02        7.90       6.76       1.09",
"PHE     HE1      H        862         2.95        8.80       6.80       1.09",
"PHE     HE2      H        864         2.95        8.80       6.80       1.09",
"PHE     HZ       H        762         3.04        9.50       6.81       0.99",
"PHE     C        C        120       169.75      178.90     175.05       2.19",
"PHE     CA       C        181        52.30       63.70      57.91       2.71",
"PHE     CB       C        127        34.10       45.54      39.88       2.07",
"PHE     CG       C        15        136.20      139.50     137.98       1.03",
"PHE     CD1      C        68        119.10      133.20     131.06       1.76",
"PHE     CD2      C        68        119.10      133.20     131.06       1.76",
"PHE     CE1      C        65        127.60      131.80     130.10       0.93",
"PHE     CE2      C        65        127.60      131.80     130.14       0.88",
"PHE     CZ       C        61        126.70      132.60     128.74       1.13",
"PHE     N        N        260       111.70      131.50     121.34       4.11",
"PRO     HA       H        750         1.63        5.75       4.42       0.36",
"PRO     HB2      H        667         0.07        3.69       1.99       0.42",
"PRO     HB3      H        666         0.14        3.79       2.11       0.42",
"PRO     HG2      H        588        -0.19        3.54       1.90       0.38",
"PRO     HG3      H        588        -0.19        3.71       1.95       0.36",
"PRO     HD2      H        640         1.34        4.62       3.59       0.38",
"PRO     HD3      H        640         0.39        5.16       3.66       0.42",
"PRO     C        C        76        172.90      180.30     176.48       1.95",
"PRO     CA       C        153        56.90       66.70      62.96       1.58",
"PRO     CB       C        103        28.50       34.90      31.80       1.13",
"PRO     CG       C        75         23.27       28.40      26.71       1.32",
"PRO     CD       C        90         47.68       52.08      49.89       1.01",
"PRO     N        N        18        115.60      138.77     131.49       6.88",
"SER     H        H        1253        6.08       10.36       8.31       0.60",
"SER     HA       H        1252        1.91        6.12       4.53       0.43",
"SER     HB2      H        1121        1.42        4.51       3.84       0.29",
"SER     HB3      H        1120        1.50        4.78       3.86       0.31",
"SER     HG       H        22          3.42        8.97       5.23       0.95",
"SER     C        C        128       170.20      177.86     174.48       1.50",
"SER     CA       C        230        53.25       64.50      58.06       2.06",
"SER     CB       C        183        60.45       70.80      63.80       1.58",
"SER     N        N        320       103.00      127.35     116.61       3.93",
"THR     H        H        1152        6.33       11.01       8.26       0.67",
"THR     HA       H        1151        0.87        6.27       4.50       0.51",
"THR     HB       H        1064        0.92        5.90       4.17       0.41",
"THR     HG1      H        67          0.32        8.21       4.27       1.68",
"THR     HG2      H        1063       -0.45        4.07       1.16       0.33",
"THR     C        C        124       170.90      180.60     174.69       1.68",
"THR     CA       C        247        56.70       69.50      61.46       2.69",
"THR     CB       C        168        62.59       75.80      69.20       1.90",
"THR     CG2      C        131        17.10       24.80      20.85       1.17",
"THR     N        N        356        97.70      130.44     115.28       5.48",
"TRP     H        H        256         5.49       10.76       8.38       0.85",
"TRP     HA       H        245         2.87        6.75       4.73       0.59",
"TRP     HB2      H        225         1.82        4.54       3.19       0.35",
"TRP     HB3      H        225         1.82        4.49       3.24       0.34",
"TRP     HD1      H        317         5.81        8.93       7.16       0.37",
"TRP     HE1      H        278         7.58       11.90      10.14       0.54",
"TRP     HE3      H        330         1.85        8.98       7.02       1.32",
"TRP     HZ2      H        345         2.63        8.64       6.98       1.15",
"TRP     HZ3      H        343         0.76        8.20       6.49       1.29",
"TRP     HH2      H        342         2.84        8.28       6.67       1.18",
"TRP     C        C        16        173.00      179.20     176.22       1.98",
"TRP     CA       C        45         52.00       62.41      56.83       2.70",
"TRP     CB       C        31         25.15       34.30      29.79       2.09",
"TRP     CG       C        81        107.50      114.60     110.35       1.55",
"TRP     CD1      C        58        119.50      129.70     125.53       1.47",
"TRP     CD2      C        64        126.20      130.10     127.53       0.93",
"TRP     CE2      C        50        135.51      139.20     137.73       0.96",
"TRP     CE3      C        24        116.50      122.20     119.39       1.29",
"TRP     CZ2      C        27        111.40      115.30     113.56       1.12",
"TRP     CZ3      C        25        117.50      129.70     121.08       2.12",
"TRP     CH2      C        25        120.21      124.30     123.09       0.94",
"TRP     N        N        62        101.75      130.00     120.20       4.54",
"TRP     NE1      N        27        126.47      132.40     130.34       1.52",
"TYR     H        H        724         5.64       10.89       8.40       0.74",
"TYR     HA       H        754         3.25        6.65       4.67       0.54",
"TYR     HB2      H        720         0.70        4.70       2.88       0.35",
"TYR     HB3      H        720         1.46        4.70       2.98       0.31",
"TYR     HD1      H        992         2.77        7.80       6.80       0.84",
"TYR     HD2      H        994         2.77        8.50       6.80       0.84",
"TYR     HE1      H        1000        2.61        8.62       6.57       0.76",
"TYR     HE2      H        1002        2.61        8.62       6.58       0.76",
"TYR     HH       H        16          5.99       10.16       9.02       1.08",
"TYR     C        C        51        170.50      178.70     175.11       1.96",
"TYR     CA       C        131        52.40       62.90      56.78       2.29",
"TYR     CB       C        95         33.75       44.50      38.91       2.18",
"TYR     CG       C        46        125.70      131.10     129.36       1.26",
"TYR     CD1      C        76        130.60      134.70     132.05       0.97",
"TYR     CD2      C        77        129.27      134.70     132.02       1.01",
"TYR     CE1      C        80        112.70      118.70     116.88       0.98",
"TYR     CE2      C        80        115.00      119.50     117.01       0.91",
"TYR     CZ       C        50        153.54      162.70     156.37       2.49",
"TYR     N        N        171       110.00      132.30     120.95       5.24",
"VAL     H        H        1249        4.88       10.46       8.26       0.71",
"VAL     HA       H        1237        1.73        6.09       4.15       0.55",
"VAL     HB       H        1165       -0.29        3.42       1.97       0.35",
"VAL     HG1      H        1165       -0.57        5.98       0.81       0.36",
"VAL     HG2      H        1164       -2.32        6.06       0.83       0.38",
"VAL     C        C        116       171.00      181.60     175.77       2.11",
"VAL     CA       C        234        55.90       70.39      61.83       2.93",
"VAL     CB       C        153        28.30       37.70      32.73       1.87",
"VAL     CG1      C        144        15.30       24.70      20.66       1.64",
"VAL     CG2      C        140        15.50       26.30      20.81       1.69",
"VAL     N        N        399        96.29      136.80     121.00       5.85",
)

# -----------------------------------------------------------------------------
#
class atom_stats:

  def __init__(self, gsym, aname, nucleus, count, fmin, fmax, fave, fdev):

    self.group_symbol = gsym
    self.atom_name = aname
    self.nucleus = nucleus
    self.count = count
    self.minimum_shift = fmin
    self.maximum_shift = fmax
    self.average_shift = fave
    self.shift_deviation = fdev

# -----------------------------------------------------------------------------
#
def atom_statistics(group_symbol, atom_name):

  ast = atom_statistics_table()
  key = (group_symbol, atom_name)
  if ast.has_key(key):
    return ast[key]
  
  return None

# -----------------------------------------------------------------------------
#
atom_stat_table = None
def atom_statistics_table():
  
  global atom_stat_table
  if atom_stat_table == None:
    atom_stat_table = {}
    nucleus_translation = { 'H':'1H', 'N':'15N', 'C':'13C' }
    for line in stat_lines:
      fields = string.split(line)
      gsym = atomnames.aaa_to_a[fields[0]]
      aname = fields[1]
      nucleus = nucleus_translation[fields[2]]
      count = string.atoi(fields[3])
      fmin = string.atof(fields[4])
      fmax = string.atof(fields[5])
      fave = string.atof(fields[6])
      fdev = string.atof(fields[7])
      atom_stat_table[(gsym, aname)] = \
        atom_stats(gsym, aname, nucleus, count, fmin, fmax, fave, fdev)

  return atom_stat_table
