from chimerax.atomic import Structure
atom_lookup = {}
for m in session.models:
	if not isinstance(m, Structure):
		continue
	chains = atom_lookup.setdefault(m.id_string, {})
	for chain in m.chains:
		residues = chains.setdefault(chain.chain_id, {})
		for r in chain.existing_residues:
			atoms = residues.setdefault("%d%s" % (r.number, r.insertion_code), {})
			for a in r.atoms:
				atoms[a.name] = a


def spec_to_atom(spec):
	model_spec, remainder = spec.split('/')
	model = atom_lookup[model_spec[1:]]
	chain_id, remainder = remainder.split(':')
	chain = model[chain_id]
	res_id, atom_name = remainder.split('@')
	residue = chain[res_id]
	return residue[atom_name]

pbg = session.pb_manager.get_group("custom pseudobonds")
import sys
with open(sys.argv[1], "r") as pb_file:
	for line in pb_file:
		a1, a2 = [spec_to_atom(spec) for spec in line.strip().split()]
		pbg.new_pseudobond(a1, a2)
session.models.add([pbg])




