import chimera, _surface, numpy
from numpy import array, single as floatc, intc

def addAtom(molecule, id, residue, x, y, z, radius):
    at = molecule.newAtom(id, chimera.Element("Tunn"))
    at.setCoord(chimera.Coord(x,y,z))
    at.radius = radius
    residue.addAtom(at)

def Tunnel1(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel1", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.49, -48.02, .78, 1.20)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.47, -48.05, .79, 1.17)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.45, -48.07, .79, 1.14)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.44, -48.09, .79, 1.12)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.43, -48.11, .79, 1.10)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.42, -48.11, .79, 1.10)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.42, -48.10, .78, 1.10)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.42, -48.08, .77, 1.12)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.44, -48.04, .75, 1.14)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.46, -47.99, .72, 1.18)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.50, -47.92, .68, 1.23)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.54, -47.83, .64, 1.30)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.59, -47.72, .59, 1.36)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.65, -47.61, .54, 1.52)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.70, -47.50, .49, 1.74)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.76, -47.38, .44, 1.81)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.81, -47.27, .39, 1.79)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.85, -47.16, .34, 1.82)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.89, -47.07, .30, 1.85)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.92, -47.00, .27, 1.85)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.93, -46.94, .24, 1.84)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.94, -46.89, .22, 1.83)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.93, -46.85, .20, 1.83)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.93, -46.81, .19, 1.84)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.91, -46.78, .17, 1.85)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.90, -46.75, .14, 1.86)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.88, -46.71, .11, 1.87)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.86, -46.66, .07, 1.87)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.84, -46.59, .02, 1.87)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.83, -46.52, -.05, 1.87)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.81, -46.43, -.12, 1.88)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.80, -46.34, -.20, 1.89)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.79, -46.24, -.28, 1.89)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.78, -46.14, -.36, 1.92)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.78, -46.04, -.44, 2.00)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.78, -45.95, -.52, 1.91)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.77, -45.86, -.59, 1.61)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.77, -45.78, -.65, 1.45)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.78, -45.71, -.71, 1.41)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.79, -45.65, -.74, 1.35)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.81, -45.60, -.77, 1.30)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.85, -45.54, -.78, 1.28)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.91, -45.49, -.76, 1.28)
    addAtom(tunnelObject, "Tunnel1", tunnel, 2.99, -45.43, -.73, 1.30)
    addAtom(tunnelObject, "Tunnel1", tunnel, 3.11, -45.37, -.68, 1.34)
    addAtom(tunnelObject, "Tunnel1", tunnel, 3.25, -45.30, -.61, 1.42)
    addAtom(tunnelObject, "Tunnel1", tunnel, 3.44, -45.21, -.51, 1.54)
    addAtom(tunnelObject, "Tunnel1", tunnel, 3.67, -45.12, -.38, 1.71)
    addAtom(tunnelObject, "Tunnel1", tunnel, 3.93, -45.01, -.24, 1.90)
    addAtom(tunnelObject, "Tunnel1", tunnel, 4.21, -44.90, -.08, 2.08)
    addAtom(tunnelObject, "Tunnel1", tunnel, 4.51, -44.78, .09, 2.24)
    addAtom(tunnelObject, "Tunnel1", tunnel, 4.80, -44.67, .25, 2.41)
    addAtom(tunnelObject, "Tunnel1", tunnel, 5.09, -44.55, .42, 2.61)
    addAtom(tunnelObject, "Tunnel1", tunnel, 5.36, -44.45, .56, 2.79)
    addAtom(tunnelObject, "Tunnel1", tunnel, 5.59, -44.35, .70, 2.97)
    addAtom(tunnelObject, "Tunnel1", tunnel, 5.79, -44.27, .80, 3.12)
    addAtom(tunnelObject, "Tunnel1", tunnel, 5.95, -44.21, .88, 3.14)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.06, -44.16, .93, 3.12)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.13, -44.12, .96, 3.13)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.18, -44.11, .97, 3.15)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.20, -44.10, .96, 3.16)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.21, -44.11, .94, 3.18)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.22, -44.13, .91, 3.21)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.23, -44.16, .87, 3.24)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.24, -44.20, .83, 3.27)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.27, -44.26, .80, 3.26)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.32, -44.31, .77, 3.20)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.38, -44.37, .74, 3.16)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.46, -44.42, .70, 3.12)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.55, -44.46, .66, 3.10)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.65, -44.49, .62, 3.10)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.76, -44.49, .57, 3.12)
    addAtom(tunnelObject, "Tunnel1", tunnel, 6.88, -44.46, .51, 3.17)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.01, -44.40, .44, 3.22)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.15, -44.30, .36, 3.24)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.29, -44.17, .26, 3.20)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.44, -44.01, .16, 3.15)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.58, -43.84, .04, 3.13)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.71, -43.66, -.09, 3.12)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.84, -43.48, -.22, 3.15)
    addAtom(tunnelObject, "Tunnel1", tunnel, 7.95, -43.32, -.36, 3.21)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.05, -43.19, -.50, 3.20)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.13, -43.09, -.64, 3.09)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.18, -43.04, -.79, 2.93)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.21, -43.03, -.93, 2.78)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.22, -43.06, -1.08, 2.66)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.22, -43.13, -1.23, 2.55)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.21, -43.22, -1.37, 2.46)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.19, -43.34, -1.52, 2.38)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.17, -43.46, -1.66, 2.32)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.15, -43.58, -1.81, 2.26)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.14, -43.70, -1.95, 2.22)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.14, -43.81, -2.09, 2.17)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.16, -43.90, -2.23, 2.11)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.19, -43.98, -2.37, 2.06)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.22, -44.04, -2.50, 2.00)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.26, -44.09, -2.61, 1.95)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.31, -44.13, -2.71, 1.91)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.35, -44.17, -2.79, 1.87)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.38, -44.19, -2.85, 1.85)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.41, -44.21, -2.88, 1.84)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.42, -44.23, -2.88, 1.85)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.43, -44.24, -2.85, 1.88)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.42, -44.25, -2.80, 1.92)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.40, -44.26, -2.74, 1.96)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.38, -44.28, -2.69, 2.01)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.36, -44.29, -2.65, 2.05)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.34, -44.30, -2.65, 2.06)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.33, -44.32, -2.69, 2.05)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.33, -44.33, -2.78, 2.01)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.34, -44.35, -2.94, 1.93)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.37, -44.38, -3.17, 1.82)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.42, -44.40, -3.48, 1.69)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.47, -44.43, -3.83, 1.56)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.54, -44.46, -4.21, 1.48)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.60, -44.49, -4.60, 1.43)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.67, -44.52, -4.99, 1.45)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.72, -44.56, -5.36, 1.52)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.77, -44.59, -5.68, 1.62)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.81, -44.62, -5.95, 1.67)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.82, -44.64, -6.15, 1.65)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.83, -44.67, -6.28, 1.61)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.82, -44.69, -6.34, 1.59)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.81, -44.71, -6.37, 1.59)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.79, -44.73, -6.35, 1.61)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.79, -44.74, -6.32, 1.63)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.79, -44.75, -6.28, 1.65)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.81, -44.75, -6.24, 1.68)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.86, -44.75, -6.21, 1.71)
    addAtom(tunnelObject, "Tunnel1", tunnel, 8.92, -44.73, -6.22, 1.72)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.02, -44.72, -6.25, 1.72)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.13, -44.70, -6.31, 1.73)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.26, -44.67, -6.39, 1.74)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.40, -44.64, -6.48, 1.77)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.53, -44.61, -6.58, 1.80)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.67, -44.59, -6.68, 1.84)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.79, -44.56, -6.77, 1.89)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.90, -44.54, -6.85, 1.93)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.98, -44.52, -6.91, 1.97)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.04, -44.51, -6.95, 1.99)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.08, -44.50, -6.98, 2.01)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.10, -44.49, -6.99, 2.02)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.11, -44.49, -6.99, 2.02)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.10, -44.49, -6.98, 2.02)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.08, -44.50, -6.98, 2.01)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.06, -44.50, -6.97, 2.00)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.04, -44.51, -6.97, 1.99)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.03, -44.52, -6.98, 1.98)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.01, -44.53, -7.01, 1.97)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.00, -44.54, -7.04, 1.96)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.00, -44.55, -7.08, 1.96)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.99, -44.56, -7.13, 1.95)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.99, -44.57, -7.19, 1.95)
    addAtom(tunnelObject, "Tunnel1", tunnel, 9.99, -44.58, -7.26, 1.95)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.00, -44.59, -7.32, 1.95)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.00, -44.60, -7.40, 1.96)
    addAtom(tunnelObject, "Tunnel1", tunnel, 10.01, -44.61, -7.47, 1.96)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel1"
Tunnel1(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel2(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel2", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.49, -48.02, .78, 1.20)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.54, -48.05, .86, 1.21)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.58, -48.07, .94, 1.23)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.63, -48.10, 1.02, 1.25)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.67, -48.12, 1.09, 1.27)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.72, -48.14, 1.15, 1.29)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.76, -48.15, 1.20, 1.32)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.80, -48.16, 1.24, 1.34)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.83, -48.16, 1.27, 1.37)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.86, -48.16, 1.29, 1.39)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.89, -48.15, 1.30, 1.41)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.92, -48.14, 1.30, 1.44)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.95, -48.13, 1.31, 1.47)
    addAtom(tunnelObject, "Tunnel2", tunnel, 2.98, -48.12, 1.32, 1.50)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.01, -48.10, 1.35, 1.53)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.04, -48.09, 1.40, 1.58)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.08, -48.07, 1.48, 1.65)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.12, -48.06, 1.58, 1.72)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.16, -48.06, 1.69, 1.74)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.20, -48.06, 1.82, 1.70)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.24, -48.06, 1.95, 1.64)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.27, -48.06, 2.07, 1.58)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.30, -48.07, 2.18, 1.53)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.32, -48.09, 2.27, 1.50)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.34, -48.11, 2.34, 1.48)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.34, -48.14, 2.38, 1.48)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.35, -48.16, 2.40, 1.48)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.35, -48.18, 2.40, 1.50)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.35, -48.19, 2.40, 1.51)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.35, -48.19, 2.39, 1.51)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.37, -48.18, 2.38, 1.51)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.39, -48.14, 2.39, 1.50)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.42, -48.08, 2.41, 1.47)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.47, -48.01, 2.44, 1.42)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.52, -47.93, 2.48, 1.38)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.60, -47.85, 2.53, 1.35)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.69, -47.78, 2.60, 1.33)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.79, -47.73, 2.66, 1.34)
    addAtom(tunnelObject, "Tunnel2", tunnel, 3.91, -47.71, 2.73, 1.37)
    addAtom(tunnelObject, "Tunnel2", tunnel, 4.04, -47.73, 2.80, 1.45)
    addAtom(tunnelObject, "Tunnel2", tunnel, 4.19, -47.79, 2.87, 1.57)
    addAtom(tunnelObject, "Tunnel2", tunnel, 4.35, -47.89, 2.94, 1.72)
    addAtom(tunnelObject, "Tunnel2", tunnel, 4.52, -48.01, 3.01, 1.87)
    addAtom(tunnelObject, "Tunnel2", tunnel, 4.68, -48.16, 3.08, 1.97)
    addAtom(tunnelObject, "Tunnel2", tunnel, 4.83, -48.32, 3.15, 2.05)
    addAtom(tunnelObject, "Tunnel2", tunnel, 4.96, -48.48, 3.23, 2.11)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.08, -48.64, 3.32, 2.14)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.16, -48.78, 3.41, 2.13)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.22, -48.90, 3.51, 2.10)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.26, -49.00, 3.61, 2.08)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.29, -49.08, 3.72, 2.06)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.32, -49.14, 3.83, 2.05)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.37, -49.18, 3.95, 2.03)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.45, -49.20, 4.06, 2.04)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.57, -49.20, 4.18, 2.09)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.74, -49.17, 4.29, 2.12)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.95, -49.13, 4.40, 2.11)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.20, -49.08, 4.50, 2.09)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.47, -49.02, 4.60, 2.08)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.74, -48.96, 4.69, 2.12)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.00, -48.89, 4.78, 2.20)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.23, -48.84, 4.86, 2.30)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.43, -48.79, 4.93, 2.35)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.57, -48.77, 4.98, 2.32)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.65, -48.75, 5.03, 2.27)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.69, -48.75, 5.07, 2.26)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.69, -48.76, 5.11, 2.27)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.67, -48.78, 5.13, 2.30)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.64, -48.80, 5.16, 2.35)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.59, -48.81, 5.18, 2.39)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.55, -48.83, 5.19, 2.43)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.52, -48.83, 5.21, 2.43)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.49, -48.83, 5.23, 2.42)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.48, -48.83, 5.26, 2.40)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.47, -48.84, 5.29, 2.39)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.47, -48.85, 5.33, 2.40)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.47, -48.87, 5.38, 2.41)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.47, -48.90, 5.45, 2.44)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.47, -48.94, 5.53, 2.46)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.46, -49.01, 5.63, 2.46)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.46, -49.09, 5.74, 2.40)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.45, -49.18, 5.87, 2.31)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.45, -49.26, 6.00, 2.21)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.44, -49.35, 6.13, 2.14)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.45, -49.43, 6.27, 2.08)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.45, -49.50, 6.39, 2.03)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.47, -49.55, 6.52, 2.00)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.49, -49.58, 6.63, 1.99)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.51, -49.59, 6.73, 1.98)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.54, -49.59, 6.83, 1.99)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.56, -49.58, 6.92, 2.01)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.59, -49.56, 7.01, 2.02)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.61, -49.54, 7.09, 2.04)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.62, -49.51, 7.18, 2.04)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.62, -49.49, 7.26, 2.04)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.60, -49.48, 7.35, 2.03)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.58, -49.46, 7.43, 2.01)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.55, -49.45, 7.53, 1.99)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.50, -49.43, 7.63, 1.95)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.44, -49.41, 7.73, 1.90)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.37, -49.37, 7.84, 1.85)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.28, -49.33, 7.96, 1.80)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.18, -49.28, 8.08, 1.75)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.07, -49.22, 8.21, 1.69)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.95, -49.15, 8.35, 1.64)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.82, -49.09, 8.48, 1.60)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.70, -49.03, 8.61, 1.56)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.57, -48.99, 8.73, 1.53)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.45, -48.96, 8.84, 1.49)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.33, -48.95, 8.93, 1.45)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.23, -48.97, 9.00, 1.40)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.13, -49.01, 9.06, 1.36)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.05, -49.05, 9.12, 1.32)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.98, -49.08, 9.18, 1.28)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.92, -49.10, 9.25, 1.27)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.87, -49.10, 9.34, 1.33)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.83, -49.06, 9.45, 1.42)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.81, -48.98, 9.59, 1.47)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.80, -48.84, 9.77, 1.46)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.80, -48.67, 9.97, 1.41)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.81, -48.47, 10.19, 1.35)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.82, -48.26, 10.41, 1.30)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.85, -48.05, 10.61, 1.29)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.87, -47.86, 10.79, 1.31)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.90, -47.69, 10.94, 1.34)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.93, -47.57, 11.04, 1.36)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.95, -47.49, 11.10, 1.38)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.97, -47.46, 11.12, 1.38)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.98, -47.45, 11.11, 1.38)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.98, -47.46, 11.09, 1.37)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.97, -47.49, 11.06, 1.36)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.94, -47.53, 11.04, 1.35)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.89, -47.57, 11.04, 1.39)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.82, -47.60, 11.06, 1.52)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.73, -47.62, 11.12, 1.66)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.63, -47.62, 11.20, 1.68)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.52, -47.62, 11.31, 1.61)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.42, -47.60, 11.43, 1.54)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.32, -47.56, 11.58, 1.52)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.24, -47.51, 11.73, 1.53)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.17, -47.44, 11.90, 1.52)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.13, -47.35, 12.07, 1.49)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.12, -47.25, 12.25, 1.44)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.12, -47.14, 12.42, 1.40)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.14, -47.02, 12.58, 1.40)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.17, -46.91, 12.73, 1.44)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.20, -46.81, 12.87, 1.49)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.23, -46.72, 12.98, 1.55)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.26, -46.66, 13.07, 1.58)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.28, -46.61, 13.12, 1.57)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.29, -46.59, 13.15, 1.56)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.29, -46.58, 13.16, 1.56)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.29, -46.58, 13.16, 1.56)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.29, -46.60, 13.14, 1.56)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.28, -46.62, 13.11, 1.57)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.27, -46.64, 13.09, 1.58)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.26, -46.66, 13.06, 1.58)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.25, -46.68, 13.05, 1.57)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.24, -46.69, 13.04, 1.56)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.23, -46.69, 13.04, 1.55)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.23, -46.69, 13.05, 1.54)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.23, -46.68, 13.07, 1.55)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.24, -46.66, 13.10, 1.57)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.25, -46.62, 13.15, 1.59)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.26, -46.58, 13.21, 1.58)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.28, -46.52, 13.28, 1.57)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.31, -46.46, 13.36, 1.55)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.34, -46.39, 13.44, 1.53)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.37, -46.32, 13.53, 1.54)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.41, -46.26, 13.62, 1.55)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.45, -46.20, 13.71, 1.52)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.49, -46.14, 13.78, 1.44)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.53, -46.10, 13.85, 1.36)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.56, -46.07, 13.90, 1.30)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.60, -46.05, 13.95, 1.25)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.62, -46.02, 13.98, 1.22)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.63, -46.00, 14.00, 1.19)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.62, -45.97, 14.02, 1.16)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.60, -45.93, 14.02, 1.15)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.55, -45.88, 14.01, 1.14)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.47, -45.81, 13.99, 1.13)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.38, -45.72, 13.97, 1.13)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.29, -45.61, 13.95, 1.13)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.19, -45.48, 13.92, 1.14)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.12, -45.33, 13.90, 1.14)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.07, -45.15, 13.90, 1.15)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.06, -44.96, 13.90, 1.14)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.10, -44.74, 13.92, 1.13)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.19, -44.49, 13.96, 1.12)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.32, -44.23, 14.02, 1.13)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.48, -43.97, 14.08, 1.16)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.66, -43.71, 14.14, 1.23)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.83, -43.47, 14.21, 1.33)
    addAtom(tunnelObject, "Tunnel2", tunnel, 5.99, -43.24, 14.26, 1.44)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.12, -43.06, 14.29, 1.56)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.20, -42.91, 14.31, 1.67)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.24, -42.81, 14.31, 1.75)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.25, -42.75, 14.29, 1.80)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.23, -42.72, 14.27, 1.84)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.21, -42.70, 14.27, 1.85)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.19, -42.70, 14.28, 1.84)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.19, -42.70, 14.31, 1.81)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.23, -42.70, 14.39, 1.77)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.31, -42.68, 14.52, 1.73)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.43, -42.64, 14.69, 1.69)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.59, -42.60, 14.89, 1.67)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.77, -42.54, 15.12, 1.68)
    addAtom(tunnelObject, "Tunnel2", tunnel, 6.97, -42.49, 15.36, 1.72)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.16, -42.43, 15.60, 1.79)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.35, -42.37, 15.83, 1.88)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.51, -42.32, 16.04, 1.98)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.64, -42.28, 16.21, 2.07)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.73, -42.25, 16.36, 2.15)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.80, -42.23, 16.48, 2.20)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.84, -42.22, 16.57, 2.24)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.87, -42.22, 16.65, 2.27)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.88, -42.21, 16.71, 2.28)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.89, -42.22, 16.76, 2.29)
    addAtom(tunnelObject, "Tunnel2", tunnel, 7.88, -42.22, 16.81, 2.29)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel2"
Tunnel2(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel3(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel3", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.49, -48.02, .78, 1.20)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.53, -48.04, .84, 1.21)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.56, -48.06, .91, 1.22)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.60, -48.08, .97, 1.24)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.64, -48.10, 1.03, 1.25)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.67, -48.12, 1.09, 1.27)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.71, -48.13, 1.14, 1.29)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.74, -48.14, 1.18, 1.31)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.77, -48.15, 1.22, 1.33)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.80, -48.16, 1.25, 1.35)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.83, -48.16, 1.27, 1.37)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.86, -48.16, 1.29, 1.38)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.88, -48.16, 1.29, 1.40)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.90, -48.15, 1.30, 1.42)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.93, -48.14, 1.30, 1.44)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.95, -48.13, 1.31, 1.47)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.97, -48.12, 1.32, 1.49)
    addAtom(tunnelObject, "Tunnel3", tunnel, 2.99, -48.11, 1.34, 1.52)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.02, -48.10, 1.37, 1.55)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.05, -48.08, 1.41, 1.58)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.07, -48.08, 1.47, 1.63)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.10, -48.07, 1.55, 1.69)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.14, -48.06, 1.63, 1.76)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.17, -48.06, 1.73, 1.77)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.20, -48.06, 1.83, 1.72)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.23, -48.06, 1.93, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.26, -48.06, 2.03, 1.59)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.29, -48.07, 2.13, 1.55)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.31, -48.08, 2.21, 1.52)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.32, -48.09, 2.28, 1.50)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.34, -48.11, 2.33, 1.48)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.34, -48.13, 2.37, 1.48)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.35, -48.15, 2.39, 1.48)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.35, -48.17, 2.40, 1.49)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.35, -48.18, 2.40, 1.50)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.35, -48.19, 2.40, 1.51)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.35, -48.20, 2.39, 1.51)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.36, -48.19, 2.39, 1.51)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.37, -48.17, 2.38, 1.51)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.39, -48.14, 2.39, 1.50)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.41, -48.09, 2.40, 1.47)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.45, -48.04, 2.42, 1.44)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.49, -47.97, 2.46, 1.41)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.54, -47.91, 2.49, 1.37)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.60, -47.85, 2.54, 1.35)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.67, -47.79, 2.58, 1.33)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.75, -47.74, 2.63, 1.33)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.84, -47.72, 2.69, 1.35)
    addAtom(tunnelObject, "Tunnel3", tunnel, 3.94, -47.71, 2.74, 1.39)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.04, -47.73, 2.80, 1.45)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.16, -47.77, 2.85, 1.54)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.29, -47.84, 2.91, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.42, -47.93, 2.96, 1.77)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.55, -48.04, 3.02, 1.90)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.67, -48.16, 3.08, 2.01)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.80, -48.28, 3.14, 2.06)
    addAtom(tunnelObject, "Tunnel3", tunnel, 4.91, -48.41, 3.20, 2.07)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.01, -48.54, 3.26, 2.09)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.09, -48.66, 3.33, 2.12)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.16, -48.77, 3.41, 2.15)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.21, -48.87, 3.48, 2.13)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.24, -48.95, 3.57, 2.09)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.27, -49.02, 3.65, 2.07)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.29, -49.08, 3.74, 2.06)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.32, -49.13, 3.83, 2.05)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.36, -49.16, 3.92, 2.03)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.41, -49.19, 4.01, 2.04)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.49, -49.20, 4.10, 2.08)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.59, -49.19, 4.19, 2.12)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.72, -49.18, 4.28, 2.12)
    addAtom(tunnelObject, "Tunnel3", tunnel, 5.88, -49.15, 4.37, 2.09)
    addAtom(tunnelObject, "Tunnel3", tunnel, 6.07, -49.12, 4.45, 2.07)
    addAtom(tunnelObject, "Tunnel3", tunnel, 6.28, -49.08, 4.53, 2.07)
    addAtom(tunnelObject, "Tunnel3", tunnel, 6.49, -49.03, 4.61, 2.08)
    addAtom(tunnelObject, "Tunnel3", tunnel, 6.70, -48.98, 4.68, 2.11)
    addAtom(tunnelObject, "Tunnel3", tunnel, 6.91, -48.93, 4.75, 2.17)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.11, -48.88, 4.82, 2.24)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.29, -48.84, 4.88, 2.31)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.44, -48.79, 4.93, 2.33)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.55, -48.76, 4.98, 2.32)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.64, -48.73, 5.02, 2.29)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.69, -48.71, 5.05, 2.26)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.72, -48.69, 5.09, 2.24)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.72, -48.69, 5.11, 2.25)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.71, -48.69, 5.13, 2.28)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.68, -48.71, 5.15, 2.31)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.64, -48.73, 5.17, 2.35)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.60, -48.77, 5.18, 2.39)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.55, -48.82, 5.19, 2.41)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.50, -48.89, 5.21, 2.40)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.46, -48.95, 5.22, 2.33)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.42, -49.02, 5.23, 2.26)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.39, -49.08, 5.25, 2.21)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.37, -49.13, 5.27, 2.18)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.36, -49.15, 5.30, 2.15)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.37, -49.15, 5.34, 2.17)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.39, -49.11, 5.39, 2.28)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.42, -49.04, 5.46, 2.42)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.48, -48.91, 5.53, 2.43)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.56, -48.73, 5.62, 2.25)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.65, -48.52, 5.73, 2.03)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.75, -48.27, 5.83, 1.90)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.87, -48.00, 5.94, 1.84)
    addAtom(tunnelObject, "Tunnel3", tunnel, 7.98, -47.72, 6.05, 1.81)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.10, -47.43, 6.16, 1.79)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.21, -47.16, 6.25, 1.76)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.31, -46.91, 6.33, 1.77)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.40, -46.69, 6.39, 1.87)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.46, -46.50, 6.43, 2.07)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.51, -46.37, 6.45, 2.19)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.55, -46.27, 6.45, 2.10)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.56, -46.22, 6.44, 1.90)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.57, -46.20, 6.43, 1.78)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.56, -46.21, 6.42, 1.79)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.55, -46.25, 6.41, 1.94)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.53, -46.32, 6.42, 2.14)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.50, -46.41, 6.45, 2.23)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.48, -46.51, 6.50, 2.10)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.45, -46.64, 6.58, 1.93)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.42, -46.77, 6.70, 1.87)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.40, -46.92, 6.83, 1.91)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.38, -47.06, 6.98, 1.96)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.36, -47.20, 7.14, 2.00)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.35, -47.34, 7.30, 2.08)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.34, -47.46, 7.46, 2.20)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.33, -47.57, 7.61, 2.25)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.33, -47.66, 7.74, 2.15)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.34, -47.73, 7.85, 1.99)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.35, -47.77, 7.93, 1.87)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.37, -47.78, 7.99, 1.82)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.40, -47.77, 8.02, 1.80)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.43, -47.75, 8.04, 1.79)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.47, -47.71, 8.04, 1.80)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.51, -47.67, 8.04, 1.81)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.57, -47.63, 8.04, 1.83)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.63, -47.60, 8.04, 1.85)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.69, -47.57, 8.05, 1.86)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.76, -47.56, 8.07, 1.84)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.84, -47.57, 8.11, 1.80)
    addAtom(tunnelObject, "Tunnel3", tunnel, 8.93, -47.59, 8.16, 1.76)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.02, -47.63, 8.22, 1.71)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.12, -47.67, 8.29, 1.66)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.22, -47.71, 8.36, 1.61)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.33, -47.76, 8.42, 1.57)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.44, -47.80, 8.48, 1.54)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.56, -47.83, 8.52, 1.54)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.68, -47.85, 8.55, 1.55)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.81, -47.85, 8.56, 1.57)
    addAtom(tunnelObject, "Tunnel3", tunnel, 9.94, -47.83, 8.55, 1.60)
    addAtom(tunnelObject, "Tunnel3", tunnel, 10.08, -47.79, 8.52, 1.61)
    addAtom(tunnelObject, "Tunnel3", tunnel, 10.22, -47.74, 8.49, 1.62)
    addAtom(tunnelObject, "Tunnel3", tunnel, 10.36, -47.68, 8.45, 1.63)
    addAtom(tunnelObject, "Tunnel3", tunnel, 10.51, -47.60, 8.42, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 10.66, -47.52, 8.40, 1.67)
    addAtom(tunnelObject, "Tunnel3", tunnel, 10.82, -47.43, 8.40, 1.68)
    addAtom(tunnelObject, "Tunnel3", tunnel, 10.98, -47.33, 8.42, 1.64)
    addAtom(tunnelObject, "Tunnel3", tunnel, 11.15, -47.23, 8.47, 1.55)
    addAtom(tunnelObject, "Tunnel3", tunnel, 11.31, -47.13, 8.56, 1.45)
    addAtom(tunnelObject, "Tunnel3", tunnel, 11.48, -47.03, 8.69, 1.35)
    addAtom(tunnelObject, "Tunnel3", tunnel, 11.65, -46.93, 8.84, 1.28)
    addAtom(tunnelObject, "Tunnel3", tunnel, 11.82, -46.84, 9.02, 1.25)
    addAtom(tunnelObject, "Tunnel3", tunnel, 11.98, -46.75, 9.21, 1.26)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.13, -46.67, 9.40, 1.30)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.28, -46.59, 9.59, 1.37)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.40, -46.52, 9.77, 1.46)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.51, -46.46, 9.94, 1.56)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.60, -46.42, 10.07, 1.63)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.67, -46.38, 10.17, 1.67)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.72, -46.36, 10.24, 1.67)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.74, -46.35, 10.28, 1.66)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.76, -46.34, 10.29, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.75, -46.34, 10.29, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.74, -46.34, 10.27, 1.66)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.72, -46.35, 10.24, 1.69)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.70, -46.36, 10.20, 1.72)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.67, -46.37, 10.16, 1.73)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.65, -46.37, 10.13, 1.68)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.62, -46.37, 10.10, 1.62)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.61, -46.37, 10.08, 1.59)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.59, -46.36, 10.07, 1.59)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.58, -46.35, 10.07, 1.59)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.58, -46.34, 10.08, 1.59)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.58, -46.34, 10.09, 1.59)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.59, -46.33, 10.10, 1.59)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.60, -46.33, 10.13, 1.60)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.63, -46.32, 10.15, 1.62)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.66, -46.33, 10.19, 1.63)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.69, -46.34, 10.22, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.74, -46.35, 10.26, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.79, -46.35, 10.31, 1.63)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.85, -46.35, 10.36, 1.60)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.91, -46.34, 10.42, 1.56)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.97, -46.31, 10.48, 1.54)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.04, -46.26, 10.55, 1.53)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.11, -46.19, 10.62, 1.55)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.18, -46.08, 10.71, 1.58)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.25, -45.95, 10.80, 1.65)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.32, -45.78, 10.89, 1.72)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.39, -45.59, 10.99, 1.77)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.45, -45.38, 11.09, 1.77)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.49, -45.16, 11.19, 1.77)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.53, -44.94, 11.28, 1.77)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.56, -44.73, 11.36, 1.79)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.56, -44.52, 11.43, 1.83)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.55, -44.34, 11.48, 1.88)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.52, -44.18, 11.51, 1.90)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.46, -44.05, 11.52, 1.89)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.38, -43.97, 11.51, 1.87)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.28, -43.90, 11.48, 1.85)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.19, -43.86, 11.44, 1.82)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.09, -43.83, 11.40, 1.79)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.01, -43.80, 11.35, 1.75)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.95, -43.77, 11.31, 1.72)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.92, -43.73, 11.27, 1.69)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.93, -43.68, 11.25, 1.67)
    addAtom(tunnelObject, "Tunnel3", tunnel, 12.99, -43.60, 11.25, 1.66)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.09, -43.49, 11.27, 1.67)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.25, -43.35, 11.31, 1.72)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.46, -43.18, 11.37, 1.81)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.70, -42.99, 11.45, 1.94)
    addAtom(tunnelObject, "Tunnel3", tunnel, 13.98, -42.77, 11.55, 2.10)
    addAtom(tunnelObject, "Tunnel3", tunnel, 14.29, -42.55, 11.65, 2.30)
    addAtom(tunnelObject, "Tunnel3", tunnel, 14.63, -42.30, 11.77, 2.55)
    addAtom(tunnelObject, "Tunnel3", tunnel, 14.98, -42.05, 11.89, 2.84)
    addAtom(tunnelObject, "Tunnel3", tunnel, 15.34, -41.79, 12.02, 3.17)
    addAtom(tunnelObject, "Tunnel3", tunnel, 15.70, -41.53, 12.15, 3.53)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel3"
Tunnel3(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel4(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel4", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.49, -48.02, .78, 1.20)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.47, -48.05, .79, 1.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.45, -48.07, .79, 1.14)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.44, -48.09, .79, 1.12)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.43, -48.11, .79, 1.10)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.42, -48.11, .79, 1.10)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.42, -48.10, .78, 1.10)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.42, -48.08, .77, 1.12)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.44, -48.04, .75, 1.15)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.47, -47.98, .72, 1.19)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.50, -47.91, .68, 1.24)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.55, -47.81, .64, 1.29)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.60, -47.71, .59, 1.38)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.65, -47.60, .53, 1.52)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.71, -47.48, .48, 1.67)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.77, -47.36, .43, 1.79)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.82, -47.25, .38, 1.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.86, -47.15, .33, 1.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.90, -47.06, .29, 1.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.92, -46.98, .26, 1.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.93, -46.93, .24, 1.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.94, -46.88, .22, 1.83)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.93, -46.84, .20, 1.83)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.92, -46.81, .18, 1.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.91, -46.77, .16, 1.85)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.89, -46.74, .13, 1.86)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.87, -46.69, .10, 1.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.85, -46.64, .06, 1.88)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.84, -46.57, .00, 1.88)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.82, -46.49, -.07, 1.88)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.81, -46.40, -.14, 1.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.80, -46.30, -.22, 1.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.79, -46.20, -.31, 1.91)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.78, -46.10, -.39, 1.98)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.78, -46.01, -.47, 2.03)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.77, -45.91, -.55, 1.94)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.77, -45.83, -.62, 1.70)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.77, -45.75, -.68, 1.46)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.78, -45.69, -.72, 1.34)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.80, -45.63, -.76, 1.31)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.83, -45.58, -.77, 1.30)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.88, -45.53, -.77, 1.29)
    addAtom(tunnelObject, "Tunnel4", tunnel, 2.95, -45.47, -.75, 1.29)
    addAtom(tunnelObject, "Tunnel4", tunnel, 3.05, -45.41, -.71, 1.31)
    addAtom(tunnelObject, "Tunnel4", tunnel, 3.18, -45.34, -.65, 1.38)
    addAtom(tunnelObject, "Tunnel4", tunnel, 3.35, -45.26, -.56, 1.49)
    addAtom(tunnelObject, "Tunnel4", tunnel, 3.55, -45.16, -.44, 1.64)
    addAtom(tunnelObject, "Tunnel4", tunnel, 3.80, -45.05, -.30, 1.81)
    addAtom(tunnelObject, "Tunnel4", tunnel, 4.07, -44.93, -.15, 1.98)
    addAtom(tunnelObject, "Tunnel4", tunnel, 4.35, -44.81, .02, 2.15)
    addAtom(tunnelObject, "Tunnel4", tunnel, 4.65, -44.68, .19, 2.32)
    addAtom(tunnelObject, "Tunnel4", tunnel, 4.94, -44.57, .35, 2.50)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.22, -44.46, .51, 2.70)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.48, -44.37, .65, 2.91)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.71, -44.29, .77, 3.08)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.91, -44.24, .85, 3.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.06, -44.22, .91, 3.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.17, -44.21, .94, 3.15)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.25, -44.21, .95, 3.16)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.30, -44.22, .94, 3.18)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.32, -44.23, .92, 3.21)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.32, -44.24, .90, 3.23)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.30, -44.24, .87, 3.25)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.27, -44.23, .84, 3.26)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.22, -44.20, .82, 3.27)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.17, -44.14, .80, 3.25)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.12, -44.07, .79, 3.23)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.06, -43.99, .79, 3.21)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.99, -43.89, .79, 3.21)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.93, -43.79, .79, 3.21)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.87, -43.69, .80, 3.22)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.82, -43.59, .81, 3.24)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.77, -43.49, .81, 3.25)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.74, -43.40, .81, 3.24)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.71, -43.32, .82, 3.23)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.69, -43.25, .82, 3.22)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.67, -43.20, .82, 3.21)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.66, -43.15, .82, 3.20)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.65, -43.12, .83, 3.20)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.63, -43.09, .84, 3.20)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.61, -43.08, .86, 3.22)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.59, -43.09, .88, 3.24)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.55, -43.11, .91, 3.22)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.51, -43.14, .95, 3.16)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.46, -43.17, .99, 3.09)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.41, -43.20, 1.03, 3.02)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.38, -43.22, 1.06, 2.97)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.36, -43.22, 1.08, 2.95)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.35, -43.20, 1.07, 2.96)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.37, -43.14, 1.05, 3.01)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.43, -43.05, .99, 3.09)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.52, -42.91, .91, 3.16)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.64, -42.72, .78, 3.18)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.80, -42.49, .63, 3.14)
    addAtom(tunnelObject, "Tunnel4", tunnel, 5.98, -42.24, .46, 3.09)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.17, -41.97, .28, 3.05)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.36, -41.70, .09, 3.04)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.55, -41.43, -.09, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.73, -41.19, -.26, 3.11)
    addAtom(tunnelObject, "Tunnel4", tunnel, 6.88, -40.97, -.41, 3.16)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.01, -40.80, -.53, 3.19)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.09, -40.68, -.62, 3.19)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.15, -40.60, -.68, 3.16)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.18, -40.55, -.71, 3.12)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.20, -40.53, -.73, 3.08)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.20, -40.53, -.72, 3.08)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.20, -40.54, -.70, 3.10)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.20, -40.55, -.67, 3.13)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.20, -40.55, -.64, 3.15)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.22, -40.54, -.60, 3.16)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.25, -40.51, -.56, 3.15)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.30, -40.47, -.53, 3.12)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.36, -40.40, -.50, 3.09)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.44, -40.33, -.47, 3.04)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.53, -40.23, -.44, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.63, -40.13, -.41, 2.96)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.74, -40.02, -.39, 2.93)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.85, -39.89, -.36, 2.90)
    addAtom(tunnelObject, "Tunnel4", tunnel, 7.98, -39.77, -.34, 2.88)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.10, -39.63, -.32, 2.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.23, -39.50, -.29, 2.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.36, -39.36, -.27, 2.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.49, -39.23, -.25, 2.88)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.61, -39.10, -.23, 2.90)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.72, -38.99, -.21, 2.93)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.83, -38.88, -.19, 2.95)
    addAtom(tunnelObject, "Tunnel4", tunnel, 8.92, -38.78, -.17, 2.98)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.00, -38.70, -.15, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.06, -38.64, -.13, 3.02)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.11, -38.59, -.12, 3.03)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.14, -38.56, -.10, 3.04)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.17, -38.54, -.09, 3.04)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.18, -38.53, -.08, 3.03)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.19, -38.52, -.07, 3.02)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.18, -38.53, -.06, 3.01)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.18, -38.53, -.06, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.17, -38.54, -.05, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.16, -38.55, -.05, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.15, -38.56, -.05, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.14, -38.57, -.06, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.14, -38.58, -.06, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.13, -38.58, -.06, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.13, -38.58, -.06, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.14, -38.58, -.06, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.15, -38.57, -.06, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.17, -38.56, -.06, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.20, -38.53, -.05, 2.99)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.24, -38.50, -.04, 2.97)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.29, -38.47, -.03, 2.95)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.35, -38.42, -.02, 2.93)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.42, -38.36, .00, 2.90)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.51, -38.30, .01, 2.88)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.61, -38.22, .02, 2.86)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.73, -38.13, .02, 2.85)
    addAtom(tunnelObject, "Tunnel4", tunnel, 9.87, -38.02, .02, 2.85)
    addAtom(tunnelObject, "Tunnel4", tunnel, 10.03, -37.91, .02, 2.86)
    addAtom(tunnelObject, "Tunnel4", tunnel, 10.20, -37.78, .01, 2.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 10.38, -37.65, .00, 2.90)
    addAtom(tunnelObject, "Tunnel4", tunnel, 10.56, -37.51, -.02, 2.92)
    addAtom(tunnelObject, "Tunnel4", tunnel, 10.75, -37.38, -.03, 2.94)
    addAtom(tunnelObject, "Tunnel4", tunnel, 10.93, -37.25, -.05, 2.95)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.10, -37.13, -.07, 2.96)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.25, -37.02, -.08, 2.98)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.38, -36.93, -.10, 3.01)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.49, -36.86, -.11, 3.03)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.57, -36.82, -.11, 3.04)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.62, -36.79, -.12, 3.05)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.66, -36.77, -.12, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.68, -36.77, -.12, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.69, -36.78, -.12, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.69, -36.79, -.11, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.69, -36.80, -.10, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.68, -36.81, -.09, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.67, -36.82, -.07, 3.07)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.67, -36.82, -.06, 3.08)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.67, -36.82, -.05, 3.09)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.68, -36.81, -.04, 3.10)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.70, -36.80, -.04, 3.11)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.74, -36.78, -.05, 3.11)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.79, -36.76, -.08, 3.10)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.86, -36.74, -.12, 3.08)
    addAtom(tunnelObject, "Tunnel4", tunnel, 11.95, -36.71, -.18, 3.05)
    addAtom(tunnelObject, "Tunnel4", tunnel, 12.06, -36.68, -.25, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 12.19, -36.65, -.36, 2.94)
    addAtom(tunnelObject, "Tunnel4", tunnel, 12.34, -36.61, -.48, 2.88)
    addAtom(tunnelObject, "Tunnel4", tunnel, 12.51, -36.57, -.62, 2.82)
    addAtom(tunnelObject, "Tunnel4", tunnel, 12.68, -36.52, -.78, 2.77)
    addAtom(tunnelObject, "Tunnel4", tunnel, 12.85, -36.46, -.96, 2.74)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.03, -36.38, -1.16, 2.72)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.19, -36.30, -1.38, 2.72)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.35, -36.20, -1.61, 2.74)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.49, -36.09, -1.85, 2.80)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.62, -35.96, -2.11, 2.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.73, -35.82, -2.37, 2.91)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.82, -35.69, -2.63, 2.91)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.90, -35.55, -2.89, 2.90)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.97, -35.43, -3.14, 2.90)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.02, -35.32, -3.37, 2.95)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.05, -35.23, -3.59, 3.00)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.08, -35.17, -3.78, 3.05)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.09, -35.15, -3.94, 3.07)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.09, -35.15, -4.07, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.08, -35.19, -4.17, 3.02)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.06, -35.25, -4.24, 3.01)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.04, -35.33, -4.30, 3.03)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.02, -35.42, -4.34, 3.06)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.99, -35.52, -4.38, 3.07)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.96, -35.61, -4.41, 3.04)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.94, -35.70, -4.43, 2.98)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.91, -35.78, -4.46, 2.91)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.90, -35.85, -4.50, 2.85)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.88, -35.90, -4.54, 2.80)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.88, -35.93, -4.58, 2.78)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.88, -35.96, -4.63, 2.77)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.88, -35.98, -4.68, 2.77)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.89, -35.98, -4.73, 2.78)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.92, -35.98, -4.78, 2.80)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.94, -35.98, -4.83, 2.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 13.98, -35.97, -4.87, 2.87)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.03, -35.95, -4.91, 2.92)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.08, -35.93, -4.96, 2.97)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.14, -35.92, -5.01, 3.05)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.19, -35.90, -5.07, 3.12)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.25, -35.89, -5.14, 3.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.30, -35.87, -5.23, 3.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.35, -35.87, -5.33, 3.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.39, -35.87, -5.47, 3.19)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.42, -35.88, -5.63, 3.22)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.44, -35.90, -5.82, 3.22)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.46, -35.92, -6.03, 3.19)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.46, -35.95, -6.26, 3.15)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.46, -35.97, -6.50, 3.15)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.46, -35.98, -6.75, 3.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.46, -35.97, -6.99, 3.17)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.46, -35.95, -7.23, 3.13)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.47, -35.91, -7.44, 3.08)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.49, -35.84, -7.64, 3.02)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.52, -35.75, -7.81, 2.95)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.56, -35.62, -7.95, 2.89)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.61, -35.47, -8.07, 2.84)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.66, -35.30, -8.17, 2.81)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.72, -35.12, -8.26, 2.78)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.79, -34.92, -8.33, 2.76)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.86, -34.71, -8.40, 2.76)
    addAtom(tunnelObject, "Tunnel4", tunnel, 14.93, -34.50, -8.46, 2.77)
    addAtom(tunnelObject, "Tunnel4", tunnel, 15.01, -34.28, -8.51, 2.79)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel4"
Tunnel4(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel5(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel5", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.49, -48.02, .78, 1.20)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.47, -48.05, .78, 1.17)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.45, -48.07, .79, 1.14)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.44, -48.09, .79, 1.12)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.43, -48.10, .79, 1.10)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.42, -48.11, .79, 1.10)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.42, -48.10, .78, 1.10)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.42, -48.08, .77, 1.11)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.44, -48.05, .75, 1.14)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.46, -48.00, .72, 1.18)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.49, -47.93, .69, 1.23)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.53, -47.84, .65, 1.29)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.58, -47.74, .60, 1.36)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.64, -47.63, .55, 1.45)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.69, -47.52, .50, 1.56)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.75, -47.41, .45, 1.67)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.80, -47.29, .40, 1.77)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.84, -47.19, .35, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.88, -47.10, .31, 1.86)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.91, -47.02, .28, 1.85)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.93, -46.95, .25, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.94, -46.90, .23, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.94, -46.86, .21, 1.83)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.93, -46.83, .19, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.92, -46.79, .17, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.90, -46.76, .15, 1.85)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.88, -46.72, .12, 1.86)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.87, -46.68, .09, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.85, -46.62, .04, 1.88)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.83, -46.55, -.02, 1.88)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.82, -46.47, -.09, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.81, -46.38, -.16, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.80, -46.29, -.24, 1.88)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.79, -46.19, -.32, 1.93)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.78, -46.09, -.40, 2.00)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.78, -46.00, -.48, 2.02)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.77, -45.91, -.56, 1.91)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.77, -45.82, -.62, 1.69)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.77, -45.75, -.68, 1.46)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.78, -45.69, -.72, 1.34)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.79, -45.63, -.76, 1.30)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.82, -45.57, -.77, 1.30)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.87, -45.52, -.77, 1.29)
    addAtom(tunnelObject, "Tunnel5", tunnel, 2.93, -45.47, -.76, 1.29)
    addAtom(tunnelObject, "Tunnel5", tunnel, 3.03, -45.41, -.72, 1.31)
    addAtom(tunnelObject, "Tunnel5", tunnel, 3.15, -45.34, -.66, 1.36)
    addAtom(tunnelObject, "Tunnel5", tunnel, 3.31, -45.27, -.58, 1.45)
    addAtom(tunnelObject, "Tunnel5", tunnel, 3.51, -45.18, -.47, 1.61)
    addAtom(tunnelObject, "Tunnel5", tunnel, 3.75, -45.08, -.34, 1.80)
    addAtom(tunnelObject, "Tunnel5", tunnel, 4.01, -44.98, -.19, 1.99)
    addAtom(tunnelObject, "Tunnel5", tunnel, 4.30, -44.86, -.03, 2.15)
    addAtom(tunnelObject, "Tunnel5", tunnel, 4.59, -44.75, .13, 2.30)
    addAtom(tunnelObject, "Tunnel5", tunnel, 4.88, -44.64, .30, 2.46)
    addAtom(tunnelObject, "Tunnel5", tunnel, 5.16, -44.53, .45, 2.66)
    addAtom(tunnelObject, "Tunnel5", tunnel, 5.41, -44.43, .60, 2.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 5.64, -44.34, .72, 2.99)
    addAtom(tunnelObject, "Tunnel5", tunnel, 5.83, -44.26, .82, 3.07)
    addAtom(tunnelObject, "Tunnel5", tunnel, 5.97, -44.20, .89, 3.12)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.07, -44.15, .93, 3.14)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.13, -44.12, .96, 3.14)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.17, -44.11, .96, 3.15)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.20, -44.11, .95, 3.17)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.21, -44.12, .92, 3.19)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.21, -44.14, .90, 3.22)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.22, -44.17, .86, 3.26)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.24, -44.21, .83, 3.28)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.28, -44.26, .80, 3.27)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.33, -44.31, .78, 3.23)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.40, -44.36, .75, 3.18)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.48, -44.40, .73, 3.15)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.57, -44.44, .69, 3.14)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.67, -44.46, .65, 3.15)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.78, -44.47, .60, 3.17)
    addAtom(tunnelObject, "Tunnel5", tunnel, 6.90, -44.45, .54, 3.21)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.01, -44.40, .45, 3.22)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.13, -44.32, .35, 3.22)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.25, -44.21, .24, 3.20)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.37, -44.07, .11, 3.18)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.49, -43.92, -.03, 3.17)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.60, -43.76, -.17, 3.19)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.72, -43.59, -.31, 3.26)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.84, -43.43, -.44, 3.31)
    addAtom(tunnelObject, "Tunnel5", tunnel, 7.96, -43.27, -.56, 3.28)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.07, -43.14, -.66, 3.15)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.19, -43.03, -.74, 2.99)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.30, -42.95, -.80, 2.85)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.41, -42.90, -.83, 2.79)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.53, -42.87, -.84, 2.76)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.64, -42.85, -.84, 2.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.75, -42.86, -.82, 2.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.87, -42.87, -.79, 2.77)
    addAtom(tunnelObject, "Tunnel5", tunnel, 8.99, -42.90, -.75, 2.82)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.10, -42.93, -.71, 2.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.23, -42.96, -.67, 2.88)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.35, -42.99, -.62, 2.86)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.47, -43.02, -.58, 2.82)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.60, -43.04, -.54, 2.79)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.72, -43.06, -.50, 2.76)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.84, -43.09, -.46, 2.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 9.95, -43.11, -.42, 2.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.05, -43.13, -.39, 2.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.14, -43.16, -.35, 2.74)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.22, -43.18, -.31, 2.71)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.29, -43.20, -.27, 2.72)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.34, -43.23, -.24, 2.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.38, -43.25, -.20, 3.05)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.42, -43.28, -.16, 3.23)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.45, -43.31, -.12, 3.25)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.47, -43.35, -.09, 3.12)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.50, -43.38, -.05, 2.97)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.52, -43.42, -.01, 2.89)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.55, -43.46, .02, 2.90)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.59, -43.50, .06, 2.98)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.64, -43.55, .09, 3.09)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.69, -43.60, .13, 3.21)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.74, -43.64, .16, 3.27)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.79, -43.69, .20, 3.26)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.85, -43.74, .23, 3.24)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.89, -43.77, .26, 3.22)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.93, -43.81, .28, 3.22)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.96, -43.83, .31, 3.23)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.97, -43.85, .33, 3.23)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.97, -43.86, .35, 3.23)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.96, -43.86, .37, 3.21)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.95, -43.86, .38, 3.19)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.93, -43.85, .38, 3.19)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.92, -43.85, .38, 3.22)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.92, -43.85, .37, 3.26)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.93, -43.86, .35, 3.24)
    addAtom(tunnelObject, "Tunnel5", tunnel, 10.97, -43.88, .32, 3.11)
    addAtom(tunnelObject, "Tunnel5", tunnel, 11.04, -43.92, .28, 2.93)
    addAtom(tunnelObject, "Tunnel5", tunnel, 11.13, -43.97, .23, 2.82)
    addAtom(tunnelObject, "Tunnel5", tunnel, 11.26, -44.04, .16, 2.83)
    addAtom(tunnelObject, "Tunnel5", tunnel, 11.41, -44.12, .09, 2.88)
    addAtom(tunnelObject, "Tunnel5", tunnel, 11.58, -44.22, .02, 2.86)
    addAtom(tunnelObject, "Tunnel5", tunnel, 11.75, -44.31, -.06, 2.74)
    addAtom(tunnelObject, "Tunnel5", tunnel, 11.93, -44.41, -.13, 2.56)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.10, -44.50, -.21, 2.39)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.27, -44.59, -.27, 2.24)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.41, -44.67, -.33, 2.12)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.53, -44.74, -.38, 2.03)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.63, -44.79, -.41, 1.95)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.70, -44.83, -.43, 1.89)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.76, -44.86, -.44, 1.85)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.80, -44.90, -.45, 1.82)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.85, -44.94, -.44, 1.81)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.89, -44.98, -.43, 1.79)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.94, -45.04, -.42, 1.78)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.01, -45.11, -.40, 1.76)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.09, -45.21, -.38, 1.74)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.20, -45.32, -.37, 1.74)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.32, -45.46, -.35, 1.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.46, -45.62, -.32, 1.77)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.60, -45.78, -.30, 1.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.73, -45.96, -.26, 1.70)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.85, -46.14, -.22, 1.67)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.96, -46.32, -.17, 1.69)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.05, -46.49, -.12, 1.77)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.10, -46.66, -.04, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.12, -46.82, .04, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.11, -46.96, .13, 1.79)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.07, -47.09, .23, 1.71)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.01, -47.21, .34, 1.63)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.94, -47.32, .44, 1.58)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.87, -47.42, .53, 1.58)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.80, -47.51, .62, 1.65)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.75, -47.59, .69, 1.72)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.71, -47.66, .75, 1.75)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.70, -47.72, .78, 1.73)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.72, -47.78, .79, 1.70)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.77, -47.84, .78, 1.69)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.83, -47.89, .76, 1.70)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.91, -47.94, .72, 1.73)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.00, -47.99, .66, 1.76)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.08, -48.05, .61, 1.80)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.17, -48.11, .54, 1.85)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.24, -48.17, .48, 1.89)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.30, -48.24, .42, 1.92)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.35, -48.32, .36, 1.90)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.38, -48.41, .30, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.39, -48.50, .25, 1.83)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.40, -48.59, .21, 1.83)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.40, -48.68, .17, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.39, -48.76, .13, 1.86)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.38, -48.84, .09, 1.89)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.37, -48.91, .06, 1.91)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.37, -48.96, .03, 1.91)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.37, -49.01, .01, 1.90)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.37, -49.04, -.02, 1.88)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.38, -49.06, -.04, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.39, -49.07, -.06, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.40, -49.08, -.08, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.41, -49.08, -.10, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.41, -49.09, -.12, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.40, -49.09, -.15, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.39, -49.10, -.18, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.37, -49.12, -.21, 1.87)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.33, -49.15, -.25, 1.84)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.29, -49.18, -.30, 1.80)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.24, -49.23, -.34, 1.76)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.19, -49.29, -.40, 1.72)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.14, -49.35, -.46, 1.69)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.08, -49.43, -.52, 1.67)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.03, -49.52, -.60, 1.66)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.98, -49.62, -.68, 1.67)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.94, -49.74, -.76, 1.66)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.91, -49.87, -.85, 1.63)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.88, -50.00, -.95, 1.62)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.86, -50.14, -1.05, 1.62)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.84, -50.28, -1.16, 1.64)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.83, -50.42, -1.26, 1.64)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.81, -50.55, -1.36, 1.61)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.79, -50.67, -1.47, 1.55)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.77, -50.78, -1.56, 1.48)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.74, -50.87, -1.66, 1.42)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.70, -50.93, -1.74, 1.36)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.66, -50.98, -1.83, 1.32)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.62, -51.01, -1.91, 1.31)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.57, -51.02, -1.99, 1.32)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.52, -51.02, -2.07, 1.33)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.47, -51.02, -2.15, 1.35)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.42, -51.01, -2.24, 1.37)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.37, -51.00, -2.34, 1.40)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.32, -50.99, -2.45, 1.42)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.28, -50.98, -2.57, 1.44)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.25, -50.98, -2.70, 1.46)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.22, -50.99, -2.84, 1.47)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.19, -51.00, -2.99, 1.49)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.17, -51.01, -3.13, 1.51)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.16, -51.02, -3.27, 1.53)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.16, -51.03, -3.41, 1.55)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.16, -51.04, -3.53, 1.57)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.17, -51.04, -3.64, 1.58)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.18, -51.04, -3.74, 1.59)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.21, -51.04, -3.81, 1.60)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.23, -51.03, -3.87, 1.60)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.26, -51.02, -3.92, 1.60)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.28, -51.00, -3.96, 1.60)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.30, -50.99, -4.00, 1.61)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.30, -50.97, -4.05, 1.63)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.30, -50.94, -4.10, 1.67)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.27, -50.92, -4.16, 1.74)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.23, -50.90, -4.24, 1.83)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.17, -50.87, -4.34, 1.89)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.09, -50.85, -4.46, 1.93)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.00, -50.83, -4.60, 1.94)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.91, -50.81, -4.75, 1.94)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.84, -50.80, -4.92, 1.94)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.79, -50.80, -5.10, 1.99)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.76, -50.81, -5.29, 2.11)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.77, -50.83, -5.49, 2.27)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.83, -50.86, -5.70, 2.39)
    addAtom(tunnelObject, "Tunnel5", tunnel, 12.95, -50.90, -5.92, 2.43)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.11, -50.96, -6.15, 2.43)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.32, -51.03, -6.38, 2.43)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.55, -51.10, -6.61, 2.47)
    addAtom(tunnelObject, "Tunnel5", tunnel, 13.79, -51.17, -6.84, 2.53)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.05, -51.24, -7.07, 2.63)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.29, -51.30, -7.30, 2.76)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.51, -51.35, -7.52, 2.91)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.70, -51.39, -7.73, 3.05)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.85, -51.41, -7.94, 3.18)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.95, -51.42, -8.14, 3.30)
    addAtom(tunnelObject, "Tunnel5", tunnel, 15.00, -51.40, -8.33, 3.40)
    addAtom(tunnelObject, "Tunnel5", tunnel, 15.01, -51.37, -8.52, 3.52)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.99, -51.33, -8.70, 3.66)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.95, -51.27, -8.87, 3.82)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.88, -51.21, -9.04, 3.95)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.79, -51.14, -9.20, 4.00)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.69, -51.06, -9.37, 3.99)
    addAtom(tunnelObject, "Tunnel5", tunnel, 14.59, -50.99, -9.53, 3.95)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel5"
Tunnel5(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel6(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel6", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.49, -48.02, .78, 1.20)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.47, -48.06, .79, 1.16)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.44, -48.08, .79, 1.13)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.43, -48.10, .79, 1.11)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.42, -48.11, .79, 1.10)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.42, -48.10, .78, 1.11)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.43, -48.06, .76, 1.13)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.46, -48.00, .72, 1.16)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.51, -47.90, .68, 1.23)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.56, -47.78, .62, 1.36)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.63, -47.64, .56, 1.55)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.70, -47.50, .49, 1.72)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.77, -47.35, .42, 1.83)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.83, -47.21, .36, 1.86)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.88, -47.09, .31, 1.86)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.92, -46.99, .27, 1.84)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.93, -46.92, .24, 1.83)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.94, -46.86, .21, 1.83)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.93, -46.82, .19, 1.84)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.91, -46.78, .16, 1.85)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.89, -46.73, .13, 1.86)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.86, -46.67, .08, 1.86)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.84, -46.59, .02, 1.86)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.82, -46.49, -.07, 1.88)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.80, -46.38, -.16, 1.92)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.79, -46.26, -.26, 1.93)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.78, -46.13, -.37, 1.88)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.78, -46.00, -.47, 1.76)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.77, -45.89, -.57, 1.61)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.77, -45.79, -.65, 1.48)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.78, -45.70, -.71, 1.39)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.80, -45.63, -.76, 1.33)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.84, -45.56, -.78, 1.29)
    addAtom(tunnelObject, "Tunnel6", tunnel, 2.92, -45.50, -.77, 1.27)
    addAtom(tunnelObject, "Tunnel6", tunnel, 3.03, -45.42, -.72, 1.31)
    addAtom(tunnelObject, "Tunnel6", tunnel, 3.19, -45.33, -.64, 1.40)
    addAtom(tunnelObject, "Tunnel6", tunnel, 3.41, -45.23, -.52, 1.55)
    addAtom(tunnelObject, "Tunnel6", tunnel, 3.70, -45.09, -.36, 1.72)
    addAtom(tunnelObject, "Tunnel6", tunnel, 4.03, -44.95, -.17, 1.93)
    addAtom(tunnelObject, "Tunnel6", tunnel, 4.39, -44.79, .04, 2.15)
    addAtom(tunnelObject, "Tunnel6", tunnel, 4.76, -44.64, .25, 2.40)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.12, -44.50, .45, 2.66)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.46, -44.38, .64, 2.89)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.75, -44.28, .78, 3.05)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.97, -44.23, .88, 3.13)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.14, -44.21, .93, 3.15)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.24, -44.21, .95, 3.17)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.30, -44.22, .94, 3.19)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.32, -44.24, .91, 3.21)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.31, -44.25, .88, 3.23)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.27, -44.23, .84, 3.26)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.21, -44.19, .81, 3.26)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.15, -44.11, .80, 3.25)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.07, -44.01, .79, 3.22)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.99, -43.89, .79, 3.21)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.92, -43.77, .80, 3.22)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.85, -43.64, .80, 3.23)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.78, -43.51, .81, 3.24)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.74, -43.40, .82, 3.24)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.70, -43.30, .82, 3.23)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.68, -43.22, .82, 3.21)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.66, -43.16, .82, 3.20)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.65, -43.11, .83, 3.20)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.63, -43.09, .85, 3.21)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.60, -43.09, .87, 3.23)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.56, -43.10, .91, 3.21)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.50, -43.14, .96, 3.15)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.44, -43.18, 1.01, 3.06)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.39, -43.21, 1.05, 2.99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.36, -43.22, 1.08, 2.97)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.35, -43.19, 1.07, 3.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.39, -43.11, 1.03, 3.04)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.48, -42.96, .94, 3.09)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.63, -42.73, .79, 3.12)
    addAtom(tunnelObject, "Tunnel6", tunnel, 5.83, -42.44, .60, 3.10)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.06, -42.12, .38, 3.06)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.31, -41.77, .14, 3.03)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.55, -41.44, -.09, 3.08)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.77, -41.14, -.30, 3.20)
    addAtom(tunnelObject, "Tunnel6", tunnel, 6.95, -40.88, -.47, 3.31)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.07, -40.71, -.60, 3.32)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.15, -40.60, -.68, 3.22)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.19, -40.54, -.72, 3.11)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.20, -40.53, -.72, 3.06)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.20, -40.53, -.70, 3.08)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.20, -40.55, -.67, 3.12)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.21, -40.55, -.62, 3.17)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.23, -40.53, -.58, 3.19)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.29, -40.48, -.54, 3.17)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.37, -40.40, -.50, 3.12)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.47, -40.29, -.46, 3.04)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.59, -40.17, -.43, 2.97)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.72, -40.03, -.39, 2.92)
    addAtom(tunnelObject, "Tunnel6", tunnel, 7.87, -39.88, -.36, 2.89)
    addAtom(tunnelObject, "Tunnel6", tunnel, 8.02, -39.72, -.33, 2.88)
    addAtom(tunnelObject, "Tunnel6", tunnel, 8.19, -39.55, -.30, 2.87)
    addAtom(tunnelObject, "Tunnel6", tunnel, 8.35, -39.38, -.27, 2.87)
    addAtom(tunnelObject, "Tunnel6", tunnel, 8.51, -39.21, -.24, 2.89)
    addAtom(tunnelObject, "Tunnel6", tunnel, 8.66, -39.05, -.22, 2.91)
    addAtom(tunnelObject, "Tunnel6", tunnel, 8.80, -38.91, -.19, 2.94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 8.92, -38.79, -.17, 2.98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.01, -38.69, -.15, 3.01)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.09, -38.61, -.13, 3.03)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.14, -38.56, -.11, 3.04)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.17, -38.53, -.09, 3.03)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.18, -38.52, -.08, 3.02)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.19, -38.52, -.07, 3.02)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.18, -38.53, -.06, 3.01)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.17, -38.54, -.05, 3.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.16, -38.56, -.05, 2.99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.14, -38.58, -.05, 2.98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.13, -38.59, -.05, 2.98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.13, -38.60, -.05, 2.97)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.13, -38.60, -.06, 2.98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.14, -38.59, -.06, 2.98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.17, -38.56, -.06, 2.99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.21, -38.52, -.05, 2.99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.26, -38.47, -.05, 2.98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.34, -38.40, -.04, 2.96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.43, -38.32, -.03, 2.94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.54, -38.23, -.02, 2.91)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.67, -38.14, -.01, 2.88)
    addAtom(tunnelObject, "Tunnel6", tunnel, 9.83, -38.04, .01, 2.86)
    addAtom(tunnelObject, "Tunnel6", tunnel, 10.00, -37.94, .03, 2.83)
    addAtom(tunnelObject, "Tunnel6", tunnel, 10.19, -37.85, .05, 2.81)
    addAtom(tunnelObject, "Tunnel6", tunnel, 10.40, -37.77, .08, 2.80)
    addAtom(tunnelObject, "Tunnel6", tunnel, 10.60, -37.70, .11, 2.78)
    addAtom(tunnelObject, "Tunnel6", tunnel, 10.80, -37.66, .13, 2.77)
    addAtom(tunnelObject, "Tunnel6", tunnel, 10.99, -37.66, .16, 2.76)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.15, -37.69, .19, 2.73)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.28, -37.77, .21, 2.70)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.38, -37.91, .24, 2.65)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.44, -38.07, .26, 2.60)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.48, -38.25, .28, 2.54)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.50, -38.44, .29, 2.50)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.50, -38.61, .30, 2.47)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.48, -38.76, .30, 2.45)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.46, -38.86, .29, 2.44)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.43, -38.91, .28, 2.45)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.40, -38.92, .26, 2.46)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.38, -38.90, .24, 2.48)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.37, -38.88, .24, 2.48)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.38, -38.86, .24, 2.48)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.41, -38.86, .27, 2.46)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.47, -38.90, .33, 2.42)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.57, -38.98, .41, 2.34)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.69, -39.11, .52, 2.24)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.83, -39.26, .64, 2.12)
    addAtom(tunnelObject, "Tunnel6", tunnel, 11.97, -39.43, .77, 1.99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.12, -39.60, .88, 1.86)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.26, -39.75, .98, 1.74)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.39, -39.88, 1.05, 1.64)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.48, -39.98, 1.08, 1.56)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.56, -40.03, 1.08, 1.48)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.64, -40.06, 1.06, 1.41)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.73, -40.06, 1.03, 1.34)
    addAtom(tunnelObject, "Tunnel6", tunnel, 12.85, -40.05, 1.03, 1.27)
    addAtom(tunnelObject, "Tunnel6", tunnel, 13.01, -40.03, 1.04, 1.22)
    addAtom(tunnelObject, "Tunnel6", tunnel, 13.23, -40.00, 1.11, 1.18)
    addAtom(tunnelObject, "Tunnel6", tunnel, 13.52, -39.98, 1.22, 1.15)
    addAtom(tunnelObject, "Tunnel6", tunnel, 13.88, -39.97, 1.40, 1.13)
    addAtom(tunnelObject, "Tunnel6", tunnel, 14.29, -39.97, 1.62, 1.09)
    addAtom(tunnelObject, "Tunnel6", tunnel, 14.72, -39.97, 1.86, 1.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 15.15, -39.98, 2.10, .89)
    addAtom(tunnelObject, "Tunnel6", tunnel, 15.55, -40.00, 2.34, .84)
    addAtom(tunnelObject, "Tunnel6", tunnel, 15.90, -40.01, 2.55, .97)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.17, -40.03, 2.72, 1.26)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.35, -40.05, 2.84, 1.53)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.47, -40.06, 2.91, 1.59)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.52, -40.08, 2.94, 1.44)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.53, -40.10, 2.95, 1.24)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.51, -40.13, 2.94, 1.13)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.48, -40.15, 2.91, 1.14)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.45, -40.17, 2.89, 1.17)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.43, -40.20, 2.87, 1.17)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.43, -40.22, 2.85, 1.16)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.45, -40.24, 2.83, 1.20)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.48, -40.25, 2.82, 1.33)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.53, -40.26, 2.81, 1.50)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.60, -40.26, 2.80, 1.64)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.68, -40.24, 2.80, 1.69)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.79, -40.21, 2.79, 1.66)
    addAtom(tunnelObject, "Tunnel6", tunnel, 16.91, -40.17, 2.78, 1.56)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.04, -40.12, 2.77, 1.40)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.18, -40.07, 2.76, 1.24)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.32, -40.01, 2.75, 1.12)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.45, -39.96, 2.73, 1.07)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.58, -39.91, 2.72, 1.05)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.69, -39.87, 2.70, 1.03)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.78, -39.84, 2.69, 1.01)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.86, -39.82, 2.67, .99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.93, -39.80, 2.66, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 17.98, -39.78, 2.65, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.03, -39.76, 2.64, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.06, -39.74, 2.63, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.09, -39.71, 2.63, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.10, -39.68, 2.63, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.12, -39.64, 2.64, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.13, -39.60, 2.65, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.15, -39.56, 2.66, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.16, -39.53, 2.67, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.18, -39.50, 2.68, .97)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.21, -39.48, 2.69, .96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.25, -39.47, 2.70, .95)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.31, -39.47, 2.70, .94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.37, -39.47, 2.70, .93)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.44, -39.48, 2.69, .92)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.53, -39.50, 2.67, .92)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.62, -39.51, 2.65, .92)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.73, -39.52, 2.61, .93)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.86, -39.54, 2.57, .95)
    addAtom(tunnelObject, "Tunnel6", tunnel, 18.98, -39.55, 2.52, .96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.12, -39.55, 2.47, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.25, -39.55, 2.42, 1.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.37, -39.54, 2.39, 1.03)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.48, -39.52, 2.38, 1.05)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.58, -39.49, 2.39, 1.06)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.65, -39.45, 2.42, 1.04)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.71, -39.41, 2.49, 1.02)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.74, -39.36, 2.56, 1.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.77, -39.30, 2.65, .99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.78, -39.25, 2.75, .99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.79, -39.21, 2.84, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.79, -39.17, 2.92, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.79, -39.14, 2.99, .96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.79, -39.12, 3.03, .94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.79, -39.11, 3.07, .91)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.80, -39.09, 3.10, .90)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.82, -39.07, 3.11, .91)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.85, -39.04, 3.13, .94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.89, -38.99, 3.15, .95)
    addAtom(tunnelObject, "Tunnel6", tunnel, 19.95, -38.91, 3.17, .96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.03, -38.82, 3.19, .96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.12, -38.71, 3.22, .95)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.21, -38.59, 3.25, .94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.29, -38.47, 3.28, .94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.37, -38.37, 3.31, .95)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.44, -38.27, 3.33, .96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.48, -38.21, 3.34, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.50, -38.17, 3.35, .99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.50, -38.16, 3.34, 1.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.49, -38.16, 3.34, 1.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.47, -38.17, 3.34, 1.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.46, -38.19, 3.34, 1.00)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.46, -38.20, 3.34, .99)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.47, -38.20, 3.36, .97)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.51, -38.18, 3.38, .96)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.56, -38.15, 3.41, .94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.63, -38.10, 3.45, .93)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.71, -38.04, 3.49, .92)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.80, -37.96, 3.54, .92)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.89, -37.88, 3.58, .94)
    addAtom(tunnelObject, "Tunnel6", tunnel, 20.98, -37.78, 3.62, .98)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.06, -37.68, 3.66, 1.03)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.14, -37.57, 3.70, 1.09)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.21, -37.46, 3.72, 1.14)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.27, -37.35, 3.74, 1.18)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.31, -37.26, 3.76, 1.18)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.34, -37.18, 3.77, 1.17)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.35, -37.11, 3.77, 1.16)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.35, -37.08, 3.76, 1.14)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.33, -37.06, 3.74, 1.12)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.30, -37.06, 3.73, 1.11)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.28, -37.07, 3.72, 1.09)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.27, -37.08, 3.72, 1.08)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.28, -37.10, 3.73, 1.08)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.32, -37.11, 3.77, 1.11)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.40, -37.11, 3.83, 1.20)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.52, -37.10, 3.91, 1.34)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.67, -37.08, 4.01, 1.49)
    addAtom(tunnelObject, "Tunnel6", tunnel, 21.83, -37.05, 4.12, 1.59)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.00, -37.02, 4.23, 1.62)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.16, -36.99, 4.35, 1.62)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.31, -36.96, 4.45, 1.63)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.43, -36.95, 4.53, 1.64)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.51, -36.94, 4.59, 1.66)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.57, -36.94, 4.63, 1.67)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.60, -36.95, 4.66, 1.67)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.61, -36.96, 4.67, 1.68)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.60, -36.98, 4.67, 1.69)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.58, -37.01, 4.67, 1.71)
    addAtom(tunnelObject, "Tunnel6", tunnel, 22.56, -37.03, 4.66, 1.72)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel6"
Tunnel6(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel7(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel7", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.49, -48.02, .78, 1.20)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.54, -48.05, .87, 1.22)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.59, -48.08, .95, 1.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.64, -48.10, 1.03, 1.25)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.69, -48.12, 1.11, 1.27)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.73, -48.14, 1.17, 1.30)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.78, -48.15, 1.22, 1.33)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.81, -48.16, 1.26, 1.35)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.85, -48.16, 1.28, 1.38)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.88, -48.16, 1.29, 1.41)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.91, -48.15, 1.30, 1.44)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.94, -48.13, 1.31, 1.46)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.97, -48.12, 1.32, 1.49)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.01, -48.10, 1.35, 1.52)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.04, -48.09, 1.40, 1.57)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.08, -48.07, 1.48, 1.66)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.12, -48.06, 1.59, 1.75)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.16, -48.06, 1.71, 1.80)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.21, -48.06, 1.85, 1.76)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.25, -48.06, 1.99, 1.66)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.28, -48.07, 2.12, 1.56)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.31, -48.08, 2.23, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.33, -48.10, 2.31, 1.48)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.34, -48.13, 2.36, 1.48)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.35, -48.15, 2.39, 1.48)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.35, -48.18, 2.40, 1.49)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.35, -48.19, 2.40, 1.51)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.35, -48.19, 2.39, 1.51)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.36, -48.18, 2.38, 1.51)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.39, -48.14, 2.39, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.42, -48.08, 2.41, 1.46)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.47, -48.00, 2.44, 1.42)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.54, -47.91, 2.49, 1.38)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.62, -47.83, 2.55, 1.34)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.72, -47.76, 2.62, 1.33)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.84, -47.72, 2.69, 1.35)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.97, -47.71, 2.76, 1.40)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.13, -47.75, 2.84, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.29, -47.85, 2.91, 1.67)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.47, -47.97, 2.98, 1.86)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.64, -48.13, 3.06, 2.02)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.81, -48.29, 3.14, 2.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.95, -48.47, 3.23, 2.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.08, -48.63, 3.32, 2.12)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.17, -48.78, 3.41, 2.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.22, -48.91, 3.52, 2.10)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.26, -49.01, 3.63, 2.08)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.30, -49.09, 3.75, 2.05)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.34, -49.15, 3.87, 2.03)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.40, -49.18, 3.99, 2.04)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.50, -49.20, 4.11, 2.07)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.65, -49.19, 4.24, 2.10)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.86, -49.16, 4.35, 2.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.11, -49.11, 4.47, 2.09)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.39, -49.06, 4.58, 2.07)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.68, -48.99, 4.68, 2.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.96, -48.92, 4.77, 2.20)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.22, -48.86, 4.85, 2.29)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.43, -48.80, 4.93, 2.32)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.58, -48.75, 4.99, 2.30)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.67, -48.71, 5.04, 2.26)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.71, -48.69, 5.08, 2.24)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.72, -48.68, 5.11, 2.25)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.69, -48.70, 5.14, 2.30)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.64, -48.73, 5.16, 2.36)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.58, -48.79, 5.18, 2.41)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.52, -48.87, 5.20, 2.41)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.46, -48.96, 5.22, 2.33)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.41, -49.06, 5.25, 2.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.38, -49.14, 5.28, 2.18)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.36, -49.18, 5.32, 2.20)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.37, -49.16, 5.38, 2.25)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.41, -49.08, 5.45, 2.26)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.48, -48.90, 5.54, 2.18)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.59, -48.62, 5.64, 2.06)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.72, -48.28, 5.77, 1.93)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.87, -47.89, 5.90, 1.83)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.02, -47.50, 6.04, 1.76)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.17, -47.13, 6.17, 1.73)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.31, -46.82, 6.29, 1.76)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.43, -46.59, 6.41, 1.86)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.52, -46.46, 6.50, 2.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.57, -46.43, 6.58, 2.18)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.59, -46.45, 6.63, 2.27)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.59, -46.49, 6.65, 2.24)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.55, -46.53, 6.64, 2.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.48, -46.52, 6.60, 1.93)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.39, -46.44, 6.52, 1.77)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.26, -46.25, 6.41, 1.65)
    addAtom(tunnelObject, "Tunnel7", tunnel, 8.12, -45.96, 6.26, 1.56)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.96, -45.60, 6.09, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.80, -45.20, 5.92, 1.47)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.64, -44.79, 5.75, 1.47)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.49, -44.39, 5.59, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.36, -44.05, 5.45, 1.54)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.25, -43.79, 5.36, 1.54)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.18, -43.61, 5.31, 1.52)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.14, -43.52, 5.29, 1.47)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.11, -43.48, 5.30, 1.44)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.09, -43.47, 5.33, 1.42)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.09, -43.48, 5.37, 1.42)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.08, -43.50, 5.42, 1.41)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.07, -43.49, 5.47, 1.40)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.05, -43.44, 5.50, 1.38)
    addAtom(tunnelObject, "Tunnel7", tunnel, 7.02, -43.37, 5.53, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.98, -43.28, 5.55, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.94, -43.18, 5.56, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.90, -43.07, 5.57, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.86, -42.97, 5.58, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.82, -42.88, 5.60, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.78, -42.81, 5.61, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.75, -42.76, 5.63, 1.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.72, -42.73, 5.65, 1.36)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.69, -42.70, 5.68, 1.35)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.66, -42.68, 5.72, 1.34)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.64, -42.65, 5.76, 1.33)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.61, -42.62, 5.81, 1.33)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.58, -42.58, 5.87, 1.34)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.55, -42.52, 5.93, 1.35)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.52, -42.44, 6.00, 1.38)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.49, -42.36, 6.07, 1.41)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.45, -42.27, 6.14, 1.46)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.41, -42.18, 6.21, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.36, -42.09, 6.27, 1.55)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.31, -41.99, 6.32, 1.56)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.25, -41.90, 6.36, 1.56)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.19, -41.81, 6.40, 1.55)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.13, -41.73, 6.42, 1.53)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.07, -41.65, 6.45, 1.51)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.01, -41.57, 6.47, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.96, -41.50, 6.49, 1.48)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.91, -41.43, 6.52, 1.47)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.86, -41.37, 6.55, 1.46)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.82, -41.30, 6.58, 1.46)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.78, -41.24, 6.61, 1.45)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.72, -41.17, 6.63, 1.45)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.66, -41.09, 6.64, 1.46)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.58, -41.01, 6.63, 1.50)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.47, -40.91, 6.60, 1.57)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.34, -40.79, 6.54, 1.69)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.18, -40.66, 6.46, 1.82)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.00, -40.53, 6.37, 1.92)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.82, -40.39, 6.26, 1.98)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.63, -40.26, 6.14, 2.00)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.46, -40.14, 6.03, 1.98)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.30, -40.03, 5.92, 1.94)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.17, -39.95, 5.82, 1.91)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.06, -39.90, 5.73, 1.90)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.99, -39.87, 5.65, 1.92)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.93, -39.85, 5.58, 1.95)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.88, -39.84, 5.52, 1.98)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.85, -39.83, 5.47, 2.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.82, -39.82, 5.42, 2.04)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.79, -39.81, 5.37, 2.07)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.76, -39.78, 5.32, 2.09)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.73, -39.74, 5.28, 2.12)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.70, -39.69, 5.23, 2.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.68, -39.63, 5.19, 2.15)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.66, -39.56, 5.16, 2.16)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.65, -39.49, 5.13, 2.18)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.65, -39.41, 5.10, 2.19)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.67, -39.33, 5.08, 2.20)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.70, -39.25, 5.07, 2.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.74, -39.16, 5.07, 2.22)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.78, -39.07, 5.07, 2.22)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.82, -38.98, 5.08, 2.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.86, -38.89, 5.08, 2.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.88, -38.79, 5.10, 2.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.90, -38.69, 5.11, 2.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.90, -38.59, 5.12, 2.22)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.89, -38.49, 5.14, 2.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.88, -38.40, 5.15, 2.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.86, -38.30, 5.16, 2.20)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.85, -38.22, 5.17, 2.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.84, -38.14, 5.17, 2.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.83, -38.06, 5.17, 2.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.84, -38.00, 5.16, 2.26)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.85, -37.95, 5.14, 2.28)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.86, -37.90, 5.13, 2.31)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.87, -37.86, 5.11, 2.34)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.87, -37.82, 5.10, 2.36)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.86, -37.79, 5.10, 2.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.84, -37.76, 5.10, 2.37)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.80, -37.73, 5.11, 2.35)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.74, -37.70, 5.13, 2.33)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.67, -37.67, 5.15, 2.29)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.60, -37.64, 5.18, 2.25)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.52, -37.61, 5.22, 2.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.44, -37.58, 5.26, 2.17)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.38, -37.54, 5.29, 2.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.32, -37.51, 5.33, 2.09)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.27, -37.47, 5.36, 2.07)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.23, -37.44, 5.39, 2.05)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.18, -37.41, 5.41, 2.03)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.12, -37.37, 5.43, 2.02)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.03, -37.34, 5.44, 2.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.93, -37.32, 5.43, 2.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.79, -37.30, 5.42, 2.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.62, -37.28, 5.40, 2.04)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.43, -37.26, 5.38, 2.08)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.24, -37.23, 5.37, 2.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.05, -37.20, 5.39, 2.09)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.88, -37.15, 5.45, 2.00)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.75, -37.08, 5.55, 1.86)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.65, -36.99, 5.71, 1.69)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.61, -36.88, 5.93, 1.51)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.61, -36.75, 6.19, 1.35)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.65, -36.61, 6.48, 1.23)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.71, -36.46, 6.79, 1.17)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.78, -36.32, 7.07, 1.15)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.86, -36.19, 7.33, 1.17)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.93, -36.07, 7.54, 1.22)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.98, -35.98, 7.68, 1.27)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.01, -35.92, 7.76, 1.31)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.03, -35.87, 7.79, 1.32)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.04, -35.85, 7.80, 1.32)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.02, -35.84, 7.79, 1.30)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.00, -35.84, 7.78, 1.28)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.96, -35.86, 7.78, 1.25)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.91, -35.88, 7.81, 1.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.86, -35.90, 7.88, 1.18)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.81, -35.92, 7.96, 1.15)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.76, -35.93, 8.06, 1.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.73, -35.93, 8.17, 1.14)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.73, -35.91, 8.27, 1.17)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.76, -35.86, 8.35, 1.24)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.82, -35.78, 8.42, 1.31)
    addAtom(tunnelObject, "Tunnel7", tunnel, 1.93, -35.67, 8.45, 1.36)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.07, -35.54, 8.46, 1.36)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.25, -35.39, 8.46, 1.34)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.44, -35.24, 8.46, 1.32)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.65, -35.10, 8.45, 1.29)
    addAtom(tunnelObject, "Tunnel7", tunnel, 2.87, -34.96, 8.44, 1.26)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.09, -34.86, 8.45, 1.24)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.31, -34.78, 8.48, 1.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.51, -34.73, 8.53, 1.18)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.71, -34.71, 8.58, 1.15)
    addAtom(tunnelObject, "Tunnel7", tunnel, 3.89, -34.69, 8.65, 1.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.05, -34.69, 8.71, 1.07)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.19, -34.69, 8.78, 1.05)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.30, -34.68, 8.85, 1.03)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.39, -34.67, 8.90, 1.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.45, -34.64, 8.95, 1.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.49, -34.61, 8.99, 1.01)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.52, -34.57, 9.03, 1.02)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.55, -34.54, 9.06, 1.03)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.59, -34.50, 9.10, 1.04)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.63, -34.47, 9.14, 1.05)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.69, -34.44, 9.18, 1.06)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.77, -34.43, 9.23, 1.08)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.87, -34.42, 9.28, 1.10)
    addAtom(tunnelObject, "Tunnel7", tunnel, 4.97, -34.41, 9.33, 1.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.07, -34.41, 9.38, 1.15)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.17, -34.42, 9.42, 1.16)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.25, -34.43, 9.46, 1.16)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.32, -34.44, 9.49, 1.16)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.36, -34.45, 9.51, 1.15)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.39, -34.46, 9.52, 1.14)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.41, -34.47, 9.52, 1.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.43, -34.49, 9.52, 1.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.45, -34.50, 9.52, 1.12)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.47, -34.52, 9.52, 1.12)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.51, -34.53, 9.52, 1.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.56, -34.55, 9.53, 1.11)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.64, -34.57, 9.54, 1.12)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.72, -34.58, 9.56, 1.13)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.82, -34.59, 9.57, 1.15)
    addAtom(tunnelObject, "Tunnel7", tunnel, 5.92, -34.59, 9.59, 1.18)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.02, -34.59, 9.61, 1.21)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.12, -34.57, 9.63, 1.26)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.21, -34.54, 9.64, 1.33)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.30, -34.49, 9.66, 1.40)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.37, -34.44, 9.67, 1.47)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.44, -34.38, 9.68, 1.52)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.50, -34.33, 9.68, 1.53)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.55, -34.27, 9.69, 1.54)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.60, -34.23, 9.69, 1.55)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.63, -34.20, 9.69, 1.56)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.66, -34.19, 9.68, 1.58)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.68, -34.19, 9.68, 1.60)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.70, -34.20, 9.67, 1.62)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.71, -34.22, 9.66, 1.64)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.72, -34.25, 9.65, 1.66)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.73, -34.28, 9.64, 1.68)
    addAtom(tunnelObject, "Tunnel7", tunnel, 6.74, -34.32, 9.63, 1.69)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel7"
Tunnel7(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel8(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel8", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.06, -55.21, 8.64, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.09, -55.28, 8.67, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.13, -55.35, 8.71, 1.34)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.16, -55.42, 8.75, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.19, -55.48, 8.79, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.22, -55.54, 8.84, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.23, -55.60, 8.89, 1.34)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.24, -55.64, 8.95, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.23, -55.68, 9.02, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.22, -55.71, 9.09, 1.28)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.20, -55.74, 9.17, 1.27)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.17, -55.76, 9.24, 1.27)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.15, -55.78, 9.31, 1.28)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.12, -55.79, 9.37, 1.29)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.09, -55.80, 9.43, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.07, -55.81, 9.47, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.04, -55.82, 9.50, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.03, -55.83, 9.53, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.01, -55.85, 9.54, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, 1.00, -55.87, 9.55, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, .99, -55.91, 9.56, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, .98, -55.95, 9.56, 1.27)
    addAtom(tunnelObject, "Tunnel8", tunnel, .98, -56.00, 9.56, 1.24)
    addAtom(tunnelObject, "Tunnel8", tunnel, .97, -56.06, 9.56, 1.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, .96, -56.12, 9.58, 1.14)
    addAtom(tunnelObject, "Tunnel8", tunnel, .93, -56.18, 9.60, 1.11)
    addAtom(tunnelObject, "Tunnel8", tunnel, .89, -56.22, 9.65, 1.11)
    addAtom(tunnelObject, "Tunnel8", tunnel, .82, -56.24, 9.73, 1.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, .73, -56.24, 9.84, 1.36)
    addAtom(tunnelObject, "Tunnel8", tunnel, .61, -56.22, 9.99, 1.56)
    addAtom(tunnelObject, "Tunnel8", tunnel, .45, -56.16, 10.16, 1.73)
    addAtom(tunnelObject, "Tunnel8", tunnel, .28, -56.09, 10.36, 1.83)
    addAtom(tunnelObject, "Tunnel8", tunnel, .09, -56.00, 10.57, 1.86)
    addAtom(tunnelObject, "Tunnel8", tunnel, -.10, -55.91, 10.78, 1.88)
    addAtom(tunnelObject, "Tunnel8", tunnel, -.29, -55.82, 10.98, 1.91)
    addAtom(tunnelObject, "Tunnel8", tunnel, -.47, -55.75, 11.16, 1.97)
    addAtom(tunnelObject, "Tunnel8", tunnel, -.64, -55.69, 11.30, 2.05)
    addAtom(tunnelObject, "Tunnel8", tunnel, -.78, -55.64, 11.42, 2.12)
    addAtom(tunnelObject, "Tunnel8", tunnel, -.91, -55.62, 11.50, 2.17)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.02, -55.60, 11.56, 2.21)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.11, -55.60, 11.60, 2.25)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.18, -55.60, 11.62, 2.28)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.23, -55.60, 11.63, 2.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.26, -55.61, 11.62, 2.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.28, -55.62, 11.62, 2.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.28, -55.62, 11.61, 2.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.28, -55.62, 11.60, 2.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.27, -55.62, 11.60, 2.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.26, -55.61, 11.60, 2.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.25, -55.60, 11.62, 2.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.26, -55.59, 11.65, 2.34)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.27, -55.57, 11.70, 2.27)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.29, -55.54, 11.77, 2.16)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.31, -55.52, 11.86, 2.03)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.34, -55.51, 11.97, 1.92)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.37, -55.50, 12.10, 1.85)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.40, -55.50, 12.26, 1.79)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.43, -55.51, 12.43, 1.74)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.45, -55.54, 12.63, 1.69)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.47, -55.57, 12.83, 1.65)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.48, -55.60, 13.03, 1.65)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.47, -55.63, 13.21, 1.70)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.46, -55.65, 13.36, 1.78)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.43, -55.65, 13.48, 1.84)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.39, -55.64, 13.54, 1.86)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.33, -55.60, 13.56, 1.81)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.28, -55.56, 13.55, 1.74)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.24, -55.52, 13.53, 1.71)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.22, -55.48, 13.52, 1.75)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.24, -55.47, 13.54, 1.82)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.30, -55.49, 13.60, 1.84)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.43, -55.55, 13.74, 1.76)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.62, -55.64, 13.94, 1.58)
    addAtom(tunnelObject, "Tunnel8", tunnel, -1.84, -55.76, 14.19, 1.40)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.09, -55.87, 14.47, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.34, -55.95, 14.76, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.58, -56.00, 15.04, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.78, -55.98, 15.28, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.92, -55.87, 15.47, 1.25)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.99, -55.68, 15.59, 1.09)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.01, -55.41, 15.66, .96)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.00, -55.11, 15.69, .94)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.95, -54.79, 15.70, 1.05)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.89, -54.47, 15.69, 1.18)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.82, -54.19, 15.68, 1.27)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.77, -53.97, 15.68, 1.25)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.73, -53.81, 15.70, 1.17)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.71, -53.72, 15.73, 1.08)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.71, -53.67, 15.78, 1.02)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.71, -53.66, 15.83, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.72, -53.68, 15.88, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.74, -53.70, 15.94, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.76, -53.72, 15.98, 1.01)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.77, -53.73, 16.01, 1.01)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.79, -53.72, 16.03, 1.01)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.79, -53.72, 16.04, 1.01)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.80, -53.71, 16.04, 1.01)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.79, -53.70, 16.03, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.78, -53.70, 16.02, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.75, -53.71, 16.00, .99)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.71, -53.73, 15.97, .98)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.67, -53.75, 15.95, .97)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.64, -53.78, 15.93, .95)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.62, -53.79, 15.92, .95)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.63, -53.78, 15.93, .96)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.67, -53.75, 15.97, .98)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.77, -53.69, 16.03, 1.01)
    addAtom(tunnelObject, "Tunnel8", tunnel, -2.91, -53.59, 16.12, 1.04)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.09, -53.46, 16.24, 1.04)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.30, -53.31, 16.37, 1.03)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.51, -53.16, 16.51, 1.04)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.72, -53.00, 16.65, 1.07)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.90, -52.85, 16.78, 1.14)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.05, -52.71, 16.90, 1.22)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.14, -52.61, 17.00, 1.29)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.20, -52.53, 17.07, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.21, -52.46, 17.14, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.19, -52.41, 17.19, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.14, -52.36, 17.24, 1.28)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.08, -52.32, 17.30, 1.28)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.00, -52.27, 17.36, 1.28)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.93, -52.21, 17.44, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.85, -52.15, 17.52, 1.36)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.77, -52.08, 17.61, 1.42)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.70, -52.01, 17.70, 1.48)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.63, -51.95, 17.77, 1.53)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.57, -51.89, 17.83, 1.56)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.51, -51.83, 17.87, 1.58)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.47, -51.80, 17.88, 1.56)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.44, -51.77, 17.87, 1.53)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.42, -51.75, 17.85, 1.51)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.41, -51.75, 17.84, 1.52)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.42, -51.76, 17.85, 1.56)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.45, -51.78, 17.87, 1.60)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.49, -51.81, 17.94, 1.58)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.54, -51.85, 18.05, 1.49)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.62, -51.89, 18.21, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.71, -51.95, 18.39, 1.22)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.81, -52.02, 18.59, 1.17)
    addAtom(tunnelObject, "Tunnel8", tunnel, -3.92, -52.09, 18.79, 1.20)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.03, -52.18, 18.98, 1.26)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.15, -52.27, 19.15, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.28, -52.36, 19.28, 1.29)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.41, -52.46, 19.38, 1.23)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.53, -52.56, 19.46, 1.17)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.65, -52.66, 19.51, 1.12)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.77, -52.76, 19.55, 1.08)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.88, -52.84, 19.58, 1.07)
    addAtom(tunnelObject, "Tunnel8", tunnel, -4.98, -52.91, 19.60, 1.06)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.07, -52.97, 19.63, 1.07)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.15, -53.01, 19.66, 1.08)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.21, -53.04, 19.70, 1.11)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.27, -53.06, 19.74, 1.14)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.32, -53.07, 19.78, 1.17)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.37, -53.08, 19.82, 1.20)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.40, -53.10, 19.86, 1.23)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.44, -53.11, 19.90, 1.26)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.47, -53.14, 19.93, 1.27)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.50, -53.16, 19.96, 1.29)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.52, -53.18, 19.99, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.54, -53.21, 20.01, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.55, -53.23, 20.04, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.56, -53.25, 20.06, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.56, -53.26, 20.07, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.56, -53.27, 20.09, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.55, -53.27, 20.10, 1.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.55, -53.27, 20.11, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.55, -53.28, 20.11, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.56, -53.28, 20.11, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.58, -53.29, 20.10, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.62, -53.31, 20.08, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.67, -53.33, 20.06, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.73, -53.36, 20.03, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.79, -53.41, 19.99, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.85, -53.46, 19.95, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.90, -53.52, 19.91, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.94, -53.59, 19.86, 1.27)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.97, -53.67, 19.80, 1.22)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.98, -53.77, 19.75, 1.16)
    addAtom(tunnelObject, "Tunnel8", tunnel, -5.99, -53.88, 19.70, 1.09)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.00, -54.00, 19.65, 1.02)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.02, -54.14, 19.61, .98)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.07, -54.29, 19.59, .98)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.16, -54.46, 19.58, .99)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.29, -54.65, 19.60, .99)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.46, -54.86, 19.64, .93)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.66, -55.07, 19.69, .84)
    addAtom(tunnelObject, "Tunnel8", tunnel, -6.87, -55.28, 19.76, .79)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.09, -55.47, 19.83, .85)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.30, -55.65, 19.89, 1.05)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.47, -55.79, 19.95, 1.30)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.60, -55.89, 20.00, 1.51)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.69, -55.95, 20.03, 1.61)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.72, -55.97, 20.05, 1.60)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.73, -55.97, 20.05, 1.51)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.71, -55.95, 20.05, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.67, -55.93, 20.04, 1.25)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.63, -55.91, 20.03, 1.10)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.58, -55.90, 20.02, .97)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.54, -55.92, 20.01, .87)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.52, -55.96, 20.01, .83)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.52, -56.01, 20.02, .86)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.55, -56.09, 20.05, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.61, -56.17, 20.10, 1.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.71, -56.28, 20.17, 1.36)
    addAtom(tunnelObject, "Tunnel8", tunnel, -7.86, -56.39, 20.27, 1.44)
    addAtom(tunnelObject, "Tunnel8", tunnel, -8.05, -56.51, 20.40, 1.41)
    addAtom(tunnelObject, "Tunnel8", tunnel, -8.28, -56.64, 20.55, 1.33)
    addAtom(tunnelObject, "Tunnel8", tunnel, -8.52, -56.77, 20.70, 1.24)
    addAtom(tunnelObject, "Tunnel8", tunnel, -8.77, -56.89, 20.86, 1.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.00, -57.00, 21.01, 1.16)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.19, -57.09, 21.14, 1.13)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.34, -57.15, 21.23, 1.09)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.42, -57.19, 21.30, 1.03)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.46, -57.21, 21.33, .98)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.46, -57.21, 21.33, .95)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.43, -57.19, 21.32, .96)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.39, -57.18, 21.29, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.36, -57.16, 21.26, 1.03)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.33, -57.15, 21.23, 1.06)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.33, -57.14, 21.21, 1.07)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.36, -57.15, 21.19, 1.08)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.39, -57.16, 21.18, 1.08)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.43, -57.18, 21.18, 1.07)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.47, -57.20, 21.18, 1.06)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.50, -57.21, 21.19, 1.04)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.51, -57.23, 21.20, 1.03)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.51, -57.23, 21.22, 1.01)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.49, -57.24, 21.23, 1.00)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.47, -57.25, 21.24, .98)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.45, -57.26, 21.23, .97)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.45, -57.30, 21.21, .97)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.48, -57.35, 21.15, .97)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.53, -57.42, 21.07, .99)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.63, -57.52, 20.95, 1.02)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.76, -57.64, 20.81, 1.08)
    addAtom(tunnelObject, "Tunnel8", tunnel, -9.92, -57.76, 20.64, 1.14)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.08, -57.89, 20.48, 1.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.23, -58.01, 20.32, 1.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.37, -58.10, 20.18, 1.14)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.49, -58.16, 20.07, 1.06)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.56, -58.18, 20.00, .96)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.59, -58.17, 19.97, .90)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.60, -58.15, 19.95, .88)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.59, -58.13, 19.94, .88)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.57, -58.13, 19.93, .87)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.56, -58.16, 19.89, .85)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.55, -58.25, 19.81, .83)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.57, -58.41, 19.69, .81)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.60, -58.62, 19.53, .81)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.65, -58.87, 19.35, .83)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.70, -59.13, 19.15, .88)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.76, -59.40, 18.96, .97)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.81, -59.64, 18.78, 1.10)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.85, -59.84, 18.64, 1.23)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.87, -59.98, 18.55, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.88, -60.06, 18.49, 1.42)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.88, -60.10, 18.48, 1.45)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.87, -60.11, 18.49, 1.46)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.86, -60.09, 18.52, 1.44)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.86, -60.08, 18.56, 1.42)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.86, -60.07, 18.60, 1.42)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.88, -60.09, 18.62, 1.48)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.91, -60.13, 18.63, 1.58)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.95, -60.19, 18.63, 1.68)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.01, -60.25, 18.62, 1.75)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.07, -60.31, 18.59, 1.75)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.13, -60.36, 18.55, 1.70)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.20, -60.39, 18.50, 1.64)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.27, -60.40, 18.43, 1.58)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.34, -60.38, 18.36, 1.54)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.41, -60.35, 18.29, 1.51)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.48, -60.33, 18.24, 1.50)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.54, -60.32, 18.21, 1.49)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.60, -60.33, 18.21, 1.50)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.65, -60.38, 18.26, 1.52)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.68, -60.48, 18.36, 1.56)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.71, -60.63, 18.50, 1.61)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.73, -60.81, 18.68, 1.64)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.74, -61.01, 18.88, 1.65)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.75, -61.21, 19.08, 1.62)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.75, -61.40, 19.27, 1.58)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.74, -61.57, 19.44, 1.53)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.73, -61.69, 19.56, 1.49)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.72, -61.76, 19.64, 1.45)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.71, -61.80, 19.69, 1.42)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.69, -61.80, 19.70, 1.40)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.68, -61.79, 19.69, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.66, -61.76, 19.67, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.65, -61.72, 19.64, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.70, 19.61, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.68, 19.59, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.67, 19.58, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.66, 19.59, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.67, 19.61, 1.39)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.69, 19.65, 1.38)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.72, 19.71, 1.38)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.64, -61.76, 19.79, 1.37)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.63, -61.81, 19.90, 1.36)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.62, -61.87, 20.02, 1.35)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.61, -61.97, 20.14, 1.34)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.59, -62.09, 20.25, 1.32)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.57, -62.25, 20.34, 1.29)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.54, -62.46, 20.41, 1.25)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.51, -62.72, 20.43, 1.21)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.47, -63.03, 20.41, 1.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.42, -63.37, 20.36, 1.21)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.38, -63.73, 20.29, 1.26)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.34, -64.10, 20.22, 1.36)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.31, -64.45, 20.15, 1.50)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.29, -64.77, 20.11, 1.68)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.29, -65.04, 20.10, 1.86)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.30, -65.26, 20.13, 2.04)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.33, -65.42, 20.19, 2.19)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.38, -65.53, 20.26, 2.31)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.42, -65.60, 20.34, 2.41)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.47, -65.64, 20.40, 2.48)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.51, -65.66, 20.44, 2.52)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.54, -65.66, 20.44, 2.54)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.56, -65.64, 20.40, 2.52)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.56, -65.63, 20.31, 2.49)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.56, -65.61, 20.20, 2.45)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.54, -65.61, 20.07, 2.45)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.51, -65.63, 19.94, 2.48)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.48, -65.67, 19.81, 2.53)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.43, -65.75, 19.69, 2.57)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.38, -65.87, 19.59, 2.58)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.32, -66.02, 19.51, 2.56)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.26, -66.20, 19.44, 2.55)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.18, -66.41, 19.39, 2.57)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.11, -66.63, 19.35, 2.64)
    addAtom(tunnelObject, "Tunnel8", tunnel, -11.03, -66.87, 19.32, 2.74)
    addAtom(tunnelObject, "Tunnel8", tunnel, -10.96, -67.11, 19.29, 2.87)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel8"
Tunnel8(tunnelObject)
chimera.openModels.add([tunnelObject])

def Tunnel9(tunnelObject):
    tunnel = tunnelObject.newResidue("Tunnel9", " ", 1, " ")
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.06, -55.21, 8.64, 1.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.09, -55.27, 8.67, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.12, -55.34, 8.70, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.16, -55.40, 8.74, 1.34)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.18, -55.46, 8.78, 1.35)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.21, -55.51, 8.82, 1.36)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.22, -55.57, 8.86, 1.36)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.23, -55.61, 8.91, 1.35)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.24, -55.65, 8.97, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.23, -55.69, 9.03, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.22, -55.71, 9.10, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.20, -55.74, 9.16, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.18, -55.76, 9.23, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.15, -55.77, 9.29, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.13, -55.78, 9.35, 1.29)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.10, -55.79, 9.41, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.08, -55.80, 9.45, 1.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.06, -55.81, 9.49, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.04, -55.82, 9.51, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.02, -55.84, 9.53, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.01, -55.85, 9.54, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, 1.00, -55.88, 9.55, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, .99, -55.90, 9.56, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, .98, -55.94, 9.56, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, .98, -55.99, 9.56, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, .97, -56.04, 9.56, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, .96, -56.09, 9.57, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, .95, -56.15, 9.59, 1.14)
    addAtom(tunnelObject, "Tunnel9", tunnel, .92, -56.19, 9.62, 1.13)
    addAtom(tunnelObject, "Tunnel9", tunnel, .87, -56.23, 9.67, 1.15)
    addAtom(tunnelObject, "Tunnel9", tunnel, .81, -56.25, 9.75, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, .72, -56.24, 9.85, 1.29)
    addAtom(tunnelObject, "Tunnel9", tunnel, .61, -56.22, 9.99, 1.42)
    addAtom(tunnelObject, "Tunnel9", tunnel, .47, -56.17, 10.15, 1.56)
    addAtom(tunnelObject, "Tunnel9", tunnel, .31, -56.10, 10.32, 1.69)
    addAtom(tunnelObject, "Tunnel9", tunnel, .15, -56.03, 10.51, 1.79)
    addAtom(tunnelObject, "Tunnel9", tunnel, -.03, -55.95, 10.70, 1.84)
    addAtom(tunnelObject, "Tunnel9", tunnel, -.20, -55.86, 10.89, 1.86)
    addAtom(tunnelObject, "Tunnel9", tunnel, -.37, -55.79, 11.06, 1.90)
    addAtom(tunnelObject, "Tunnel9", tunnel, -.53, -55.72, 11.21, 1.95)
    addAtom(tunnelObject, "Tunnel9", tunnel, -.67, -55.67, 11.33, 2.02)
    addAtom(tunnelObject, "Tunnel9", tunnel, -.80, -55.64, 11.43, 2.10)
    addAtom(tunnelObject, "Tunnel9", tunnel, -.92, -55.62, 11.50, 2.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.02, -55.60, 11.56, 2.21)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.10, -55.60, 11.59, 2.25)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.16, -55.60, 11.61, 2.28)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.22, -55.60, 11.62, 2.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.25, -55.61, 11.63, 2.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.27, -55.61, 11.62, 2.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.28, -55.62, 11.61, 2.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.28, -55.62, 11.60, 2.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.27, -55.62, 11.60, 2.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.27, -55.62, 11.60, 2.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.26, -55.61, 11.60, 2.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.25, -55.60, 11.62, 2.35)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.26, -55.59, 11.65, 2.34)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.27, -55.57, 11.69, 2.29)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.28, -55.55, 11.75, 2.19)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.30, -55.53, 11.82, 2.07)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.33, -55.52, 11.91, 1.96)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.35, -55.50, 12.02, 1.89)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.38, -55.50, 12.14, 1.83)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.41, -55.50, 12.29, 1.79)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.43, -55.51, 12.45, 1.74)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.45, -55.54, 12.63, 1.69)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.47, -55.56, 12.81, 1.65)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.47, -55.59, 12.99, 1.66)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.48, -55.62, 13.16, 1.72)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.47, -55.64, 13.31, 1.79)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.45, -55.65, 13.43, 1.84)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.42, -55.65, 13.51, 1.85)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.37, -55.63, 13.55, 1.83)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.32, -55.59, 13.56, 1.78)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.27, -55.55, 13.55, 1.74)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.24, -55.51, 13.53, 1.72)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.22, -55.49, 13.52, 1.72)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.23, -55.47, 13.53, 1.72)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.28, -55.48, 13.58, 1.71)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.38, -55.53, 13.69, 1.69)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.53, -55.60, 13.85, 1.64)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.72, -55.70, 14.06, 1.54)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.94, -55.80, 14.30, 1.42)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.17, -55.90, 14.56, 1.29)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.39, -55.97, 14.82, 1.21)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.60, -56.00, 15.07, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.78, -55.98, 15.28, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.91, -55.88, 15.45, 1.28)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.98, -55.71, 15.57, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.01, -55.49, 15.65, 1.14)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.01, -55.22, 15.69, 1.04)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.97, -54.93, 15.70, 1.01)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.92, -54.64, 15.69, 1.08)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.86, -54.36, 15.68, 1.23)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.81, -54.12, 15.67, 1.35)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.76, -53.93, 15.68, 1.38)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.73, -53.80, 15.70, 1.29)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.71, -53.72, 15.73, 1.16)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.71, -53.68, 15.77, 1.04)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.71, -53.66, 15.82, .98)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.72, -53.67, 15.87, .97)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.73, -53.69, 15.92, .99)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.75, -53.71, 15.96, 1.01)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.76, -53.72, 15.99, 1.02)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.78, -53.73, 16.02, 1.02)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.79, -53.72, 16.03, 1.01)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.80, -53.72, 16.04, 1.01)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.80, -53.71, 16.04, 1.01)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.79, -53.70, 16.03, 1.00)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.78, -53.70, 16.02, 1.00)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.76, -53.71, 16.00, .99)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.72, -53.72, 15.98, .98)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.69, -53.74, 15.96, .97)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.65, -53.76, 15.94, .96)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.63, -53.78, 15.93, .96)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.62, -53.79, 15.93, .96)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.63, -53.78, 15.94, .96)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.68, -53.75, 15.97, .97)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.77, -53.69, 16.03, .99)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.90, -53.60, 16.11, 1.01)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.06, -53.49, 16.21, 1.04)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.24, -53.35, 16.33, 1.07)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.43, -53.21, 16.46, 1.12)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.63, -53.07, 16.59, 1.19)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.80, -52.93, 16.71, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.96, -52.80, 16.83, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.08, -52.68, 16.93, 1.36)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.16, -52.59, 17.01, 1.35)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.20, -52.52, 17.08, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.21, -52.46, 17.14, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.19, -52.41, 17.19, 1.22)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.15, -52.37, 17.23, 1.18)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.10, -52.33, 17.28, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.03, -52.29, 17.34, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.96, -52.24, 17.40, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.89, -52.19, 17.47, 1.36)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.82, -52.13, 17.55, 1.44)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.75, -52.06, 17.63, 1.49)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.69, -52.00, 17.71, 1.52)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.63, -51.94, 17.77, 1.53)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.57, -51.89, 17.83, 1.53)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.52, -51.84, 17.86, 1.53)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.48, -51.80, 17.88, 1.53)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.45, -51.78, 17.87, 1.54)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.43, -51.76, 17.86, 1.55)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.41, -51.75, 17.85, 1.55)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.41, -51.75, 17.84, 1.53)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.43, -51.76, 17.85, 1.49)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.45, -51.78, 17.88, 1.42)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.49, -51.81, 17.95, 1.34)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.55, -51.85, 18.06, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.61, -51.89, 18.19, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.69, -51.94, 18.36, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.78, -52.00, 18.53, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.87, -52.07, 18.72, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.98, -52.14, 18.89, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.09, -52.22, 19.06, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.20, -52.30, 19.20, 1.34)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.31, -52.39, 19.31, 1.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.43, -52.48, 19.40, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.54, -52.57, 19.46, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.65, -52.66, 19.51, 1.12)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.76, -52.75, 19.55, 1.08)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.86, -52.82, 19.57, 1.07)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.95, -52.89, 19.59, 1.06)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.04, -52.95, 19.62, 1.06)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.11, -52.99, 19.65, 1.07)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.17, -53.02, 19.68, 1.09)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.23, -53.05, 19.71, 1.11)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.28, -53.07, 19.75, 1.14)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.33, -53.08, 19.78, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.37, -53.09, 19.82, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.40, -53.10, 19.86, 1.23)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.43, -53.11, 19.90, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.47, -53.12, 19.93, 1.28)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.49, -53.14, 19.97, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.52, -53.16, 20.00, 1.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.54, -53.18, 20.02, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.55, -53.20, 20.04, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.56, -53.23, 20.06, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.56, -53.25, 20.06, 1.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.56, -53.27, 20.06, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.55, -53.29, 20.06, 1.28)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.53, -53.31, 20.05, 1.25)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.53, -53.32, 20.04, 1.23)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.52, -53.33, 20.03, 1.23)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.53, -53.33, 20.04, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.56, -53.32, 20.05, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.60, -53.30, 20.09, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.66, -53.27, 20.13, 1.37)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.74, -53.23, 20.20, 1.42)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.83, -53.19, 20.27, 1.44)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.92, -53.15, 20.34, 1.42)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.01, -53.12, 20.41, 1.37)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.09, -53.10, 20.47, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.16, -53.09, 20.51, 1.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.21, -53.10, 20.53, 1.38)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.23, -53.14, 20.53, 1.49)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.24, -53.18, 20.51, 1.60)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.25, -53.24, 20.49, 1.66)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.26, -53.29, 20.45, 1.67)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.29, -53.32, 20.43, 1.64)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.36, -53.34, 20.41, 1.59)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.46, -53.33, 20.42, 1.53)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.62, -53.27, 20.45, 1.46)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.82, -53.18, 20.51, 1.39)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.07, -53.06, 20.59, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.34, -52.91, 20.69, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.63, -52.76, 20.79, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.90, -52.60, 20.90, 1.28)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.16, -52.46, 21.00, 1.38)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.38, -52.33, 21.09, 1.51)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.55, -52.24, 21.16, 1.63)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.67, -52.18, 21.21, 1.69)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.75, -52.15, 21.24, 1.70)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.79, -52.13, 21.25, 1.69)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.81, -52.13, 21.25, 1.71)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.81, -52.13, 21.23, 1.75)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.81, -52.12, 21.20, 1.79)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.81, -52.11, 21.17, 1.79)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.82, -52.09, 21.12, 1.69)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.85, -52.04, 21.08, 1.56)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.89, -51.99, 21.04, 1.45)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.94, -51.93, 21.02, 1.45)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.99, -51.87, 21.01, 1.58)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.05, -51.80, 21.03, 1.74)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.12, -51.74, 21.08, 1.83)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.18, -51.69, 21.17, 1.76)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.25, -51.65, 21.31, 1.57)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.31, -51.63, 21.48, 1.38)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.37, -51.61, 21.67, 1.29)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.43, -51.60, 21.88, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.48, -51.59, 22.08, 1.44)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.52, -51.58, 22.27, 1.55)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.56, -51.57, 22.44, 1.57)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.58, -51.57, 22.57, 1.53)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.60, -51.55, 22.65, 1.47)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.61, -51.53, 22.70, 1.42)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.60, -51.51, 22.74, 1.40)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.59, -51.49, 22.77, 1.40)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.57, -51.46, 22.82, 1.40)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.54, -51.42, 22.90, 1.38)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.50, -51.38, 23.01, 1.34)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.45, -51.34, 23.18, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.40, -51.29, 23.41, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.34, -51.24, 23.68, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.27, -51.18, 23.98, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.21, -51.12, 24.28, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.14, -51.06, 24.57, 1.42)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.08, -51.00, 24.84, 1.56)
    addAtom(tunnelObject, "Tunnel9", tunnel, -9.02, -50.94, 25.05, 1.66)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.98, -50.87, 25.21, 1.69)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.94, -50.81, 25.30, 1.64)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.90, -50.75, 25.33, 1.56)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.88, -50.69, 25.33, 1.50)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.85, -50.64, 25.30, 1.51)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.83, -50.60, 25.26, 1.56)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.80, -50.56, 25.21, 1.62)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.77, -50.54, 25.19, 1.66)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.74, -50.54, 25.18, 1.66)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.70, -50.54, 25.20, 1.65)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.66, -50.56, 25.24, 1.64)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.61, -50.58, 25.29, 1.63)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.54, -50.60, 25.35, 1.62)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.46, -50.61, 25.41, 1.62)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.37, -50.63, 25.47, 1.61)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.27, -50.63, 25.52, 1.59)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.14, -50.62, 25.56, 1.57)
    addAtom(tunnelObject, "Tunnel9", tunnel, -8.00, -50.61, 25.58, 1.55)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.86, -50.58, 25.60, 1.52)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.70, -50.56, 25.61, 1.50)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.55, -50.53, 25.61, 1.47)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.40, -50.50, 25.62, 1.45)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.25, -50.48, 25.62, 1.43)
    addAtom(tunnelObject, "Tunnel9", tunnel, -7.11, -50.47, 25.63, 1.41)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.98, -50.46, 25.65, 1.40)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.87, -50.47, 25.66, 1.41)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.77, -50.48, 25.68, 1.43)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.68, -50.50, 25.69, 1.47)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.61, -50.53, 25.69, 1.54)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.55, -50.57, 25.69, 1.60)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.50, -50.61, 25.66, 1.62)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.47, -50.65, 25.62, 1.56)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.44, -50.70, 25.57, 1.44)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.43, -50.76, 25.50, 1.29)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.41, -50.83, 25.45, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.39, -50.92, 25.40, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.36, -51.03, 25.38, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.32, -51.16, 25.40, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.25, -51.32, 25.46, 1.32)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.16, -51.51, 25.57, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -6.05, -51.72, 25.73, 1.13)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.92, -51.95, 25.93, 1.04)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.79, -52.19, 26.15, 1.00)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.65, -52.42, 26.38, 1.01)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.53, -52.63, 26.60, 1.05)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.42, -52.82, 26.80, 1.10)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.34, -52.97, 26.95, 1.14)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.28, -53.08, 27.06, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.26, -53.14, 27.12, 1.19)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.26, -53.16, 27.14, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.27, -53.16, 27.13, 1.19)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.29, -53.13, 27.11, 1.19)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.31, -53.09, 27.07, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.32, -53.05, 27.05, 1.22)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.31, -53.01, 27.03, 1.23)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.28, -52.99, 27.04, 1.22)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.24, -52.97, 27.06, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.18, -52.98, 27.11, 1.17)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.11, -52.99, 27.16, 1.16)
    addAtom(tunnelObject, "Tunnel9", tunnel, -5.03, -53.03, 27.22, 1.19)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.96, -53.08, 27.29, 1.25)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.89, -53.15, 27.35, 1.31)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.83, -53.24, 27.41, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.78, -53.35, 27.46, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.74, -53.48, 27.51, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.71, -53.60, 27.57, 1.20)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.69, -53.73, 27.64, 1.19)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.67, -53.84, 27.72, 1.22)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.66, -53.93, 27.83, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.65, -54.00, 27.97, 1.28)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.65, -54.03, 28.14, 1.27)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.64, -54.03, 28.35, 1.25)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.64, -53.99, 28.59, 1.24)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.62, -53.94, 28.84, 1.26)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.60, -53.87, 29.11, 1.30)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.57, -53.80, 29.37, 1.35)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.52, -53.73, 29.62, 1.38)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.45, -53.67, 29.86, 1.38)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.36, -53.63, 30.06, 1.36)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.25, -53.61, 30.23, 1.34)
    addAtom(tunnelObject, "Tunnel9", tunnel, -4.12, -53.61, 30.38, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.97, -53.63, 30.50, 1.33)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.79, -53.65, 30.60, 1.34)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.60, -53.69, 30.68, 1.35)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.40, -53.74, 30.75, 1.37)
    addAtom(tunnelObject, "Tunnel9", tunnel, -3.17, -53.80, 30.81, 1.39)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.93, -53.85, 30.86, 1.43)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.68, -53.92, 30.90, 1.48)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.42, -53.98, 30.94, 1.55)
    addAtom(tunnelObject, "Tunnel9", tunnel, -2.15, -54.05, 30.97, 1.65)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.87, -54.12, 31.00, 1.78)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.58, -54.19, 31.03, 1.94)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.29, -54.26, 31.06, 2.12)
    addAtom(tunnelObject, "Tunnel9", tunnel, -1.00, -54.34, 31.08, 2.32)
tunnelObject = chimera.Molecule()
tunnelObject.name = "Tunnel9"
Tunnel9(tunnelObject)
chimera.openModels.add([tunnelObject])

chimera.runCommand('color orange red #1')
chimera.runCommand('repr cpk : 1')
chimera.runCommand('color orange #2')
chimera.runCommand('repr cpk : 2')
chimera.runCommand('color yellow #3')
chimera.runCommand('repr cpk : 3')
chimera.runCommand('color green #4')
chimera.runCommand('repr cpk : 4')
chimera.runCommand('color forest green #5')
chimera.runCommand('repr cpk : 5')
chimera.runCommand('color cyan #6')
chimera.runCommand('repr cpk : 6')
chimera.runCommand('color light sea green #7')
chimera.runCommand('repr cpk : 7')
chimera.runCommand('color blue #8')
chimera.runCommand('repr cpk : 8')
chimera.runCommand('color cornflower blue #9')
chimera.runCommand('repr cpk : 9')
Interior1 = _surface.SurfaceModel()
Interior1V = []
Interior1V.append((6.75,-27.01,-17.04))
Interior1V.append((6.48,-27.28,-18.76))
Interior1V.append((9.12,-20.34,-18.30))
Interior1V.append((6.75,-27.01,-17.04))
Interior1V.append((9.12,-20.34,-18.30))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((7.30,-29.13,-16.42))
Interior1V.append((6.75,-27.01,-17.04))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((7.30,-29.13,-16.42))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((6.36,-26.38,-13.93))
Interior1V.append((9.94,-25.02,-12.13))
Interior1V.append((6.36,-26.38,-13.93))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((9.94,-25.02,-12.13))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((10.18,-27.53,-13.62))
Interior1V.append((10.18,-27.53,-13.62))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((7.30,-29.13,-16.42))
Interior1V.append((6.36,-26.38,-13.93))
Interior1V.append((7.46,-30.36,-13.56))
Interior1V.append((7.30,-29.13,-16.42))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((3.98,-29.86,-11.96))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((1.12,-26.68,-10.13))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((3.98,-29.86,-11.96))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((7.11,-31.33,-11.07))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((7.11,-31.33,-11.07))
Interior1V.append((7.11,-31.33,-11.07))
Interior1V.append((9.24,-32.95,-11.64))
Interior1V.append((7.46,-30.36,-13.56))
Interior1V.append((7.11,-31.33,-11.07))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((9.24,-32.95,-11.64))
Interior1V.append((7.46,-30.36,-13.56))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((7.11,-31.33,-11.07))
Interior1V.append((9.66,-27.83,-10.90))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((9.66,-27.83,-10.90))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((9.66,-27.83,-10.90))
Interior1V.append((10.18,-27.53,-13.62))
Interior1V.append((9.66,-27.83,-10.90))
Interior1V.append((9.94,-25.02,-12.13))
Interior1V.append((10.18,-27.53,-13.62))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((10.18,-27.53,-13.62))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((8.81,-32.34,-15.87))
Interior1V.append((7.30,-29.13,-16.42))
Interior1V.append((7.46,-30.36,-13.56))
Interior1V.append((8.81,-32.34,-15.87))
Interior1V.append((7.46,-30.36,-13.56))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((7.46,-30.36,-13.56))
Interior1V.append((9.24,-32.95,-11.64))
Interior1V.append((9.24,-32.95,-11.64))
Interior1V.append((9.45,-34.96,-13.30))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((9.24,-32.95,-11.64))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((9.45,-34.96,-13.30))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((9.45,-34.96,-13.30))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((9.45,-34.96,-13.30))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((14.77,-29.24,-11.00))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((9.24,-32.95,-11.64))
Interior1V.append((14.77,-29.24,-11.00))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((12.63,-27.55,-11.78))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((14.77,-29.24,-11.00))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((12.63,-27.55,-11.78))
Interior1V.append((12.63,-27.55,-11.78))
Interior1V.append((14.77,-29.24,-11.00))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((14.77,-29.24,-11.00))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((14.77,-29.24,-11.00))
Interior1V.append((18.02,-31.80,-5.90))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((18.02,-31.80,-5.90))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((18.02,-31.80,-5.90))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((19.73,-33.35,-6.43))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((18.02,-31.80,-5.90))
Interior1V.append((19.73,-33.35,-6.43))
Interior1V.append((18.02,-31.80,-5.90))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((19.73,-33.35,-6.43))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((11.26,-35.44,-20.40))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((11.26,-35.44,-20.40))
Interior1V.append((9.82,-35.00,-18.08))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((11.26,-35.44,-20.40))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((9.82,-35.00,-18.08))
Interior1V.append((16.03,-26.93,-13.96))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((14.80,-28.47,-13.37))
Interior1V.append((16.03,-26.93,-13.96))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((10.83,-31.40,-5.11))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((12.47,-29.85,-5.35))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((12.47,-29.85,-5.35))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((6.31,-31.19,-3.21))
Interior1V.append((3.90,-30.83,-2.88))
Interior1V.append((3.83,-31.72,-4.35))
Interior1V.append((1.70,-32.42,-2.86))
Interior1V.append((3.83,-31.72,-4.35))
Interior1V.append((3.90,-30.83,-2.88))
Interior1V.append((1.70,-32.42,-2.86))
Interior1V.append((3.90,-30.83,-2.88))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((1.70,-32.42,-2.86))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((-.07,-29.09,-2.13))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((-.07,-29.09,-2.13))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((1.37,-29.98,-2.74))
Interior1V.append((-.02,-29.77,-3.71))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((1.37,-29.98,-2.74))
Interior1V.append((-1.22,-27.86,-3.97))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((-.02,-29.77,-3.71))
Interior1V.append((-.66,-27.87,-6.53))
Interior1V.append((-1.22,-27.86,-3.97))
Interior1V.append((-.02,-29.77,-3.71))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((2.08,-25.66,-5.58))
Interior1V.append((-.66,-27.87,-6.53))
Interior1V.append((-.19,-25.73,-5.99))
Interior1V.append((-.66,-27.87,-6.53))
Interior1V.append((2.08,-25.66,-5.58))
Interior1V.append((-.19,-25.73,-5.99))
Interior1V.append((-1.22,-27.86,-3.97))
Interior1V.append((-.66,-27.87,-6.53))
Interior1V.append((.36,-24.96,-2.39))
Interior1V.append((-1.22,-27.86,-3.97))
Interior1V.append((-.19,-25.73,-5.99))
Interior1V.append((.36,-24.96,-2.39))
Interior1V.append((-.19,-25.73,-5.99))
Interior1V.append((2.08,-25.66,-5.58))
Interior1V.append((-4.40,-25.01,-9.96))
Interior1V.append((-3.68,-24.66,-13.10))
Interior1V.append((-1.27,-24.16,-10.77))
Interior1V.append((-4.40,-25.01,-9.96))
Interior1V.append((-1.27,-24.16,-10.77))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((-.77,-23.62,-12.44))
Interior1V.append((.42,-23.76,-11.12))
Interior1V.append((-.77,-23.62,-12.44))
Interior1V.append((-1.27,-24.16,-10.77))
Interior1V.append((-3.68,-24.66,-13.10))
Interior1V.append((-.77,-23.62,-12.44))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((-1.27,-24.16,-10.77))
Interior1V.append((-2.42,-30.50,-13.34))
Interior1V.append((-4.14,-27.66,-12.67))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((-2.42,-30.50,-13.34))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((-4.14,-27.66,-12.67))
Interior1V.append((-2.62,-26.14,-15.59))
Interior1V.append((-3.68,-24.66,-13.10))
Interior1V.append((-3.88,-28.62,-14.96))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((-2.62,-26.14,-15.59))
Interior1V.append((-3.88,-28.62,-14.96))
Interior1V.append((-2.62,-26.14,-15.59))
Interior1V.append((-4.14,-27.66,-12.67))
Interior1V.append((-3.88,-28.62,-14.96))
Interior1V.append((-4.14,-27.66,-12.67))
Interior1V.append((-2.42,-30.50,-13.34))
Interior1V.append((-3.88,-28.62,-14.96))
Interior1V.append((-2.42,-30.50,-13.34))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((2.86,-39.87,-14.67))
Interior1V.append((3.70,-42.99,-11.52))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((5.12,-41.24,-15.34))
Interior1V.append((2.86,-39.87,-14.67))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((3.70,-42.99,-11.52))
Interior1V.append((2.86,-39.87,-14.67))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((2.86,-39.87,-14.67))
Interior1V.append((5.12,-41.24,-15.34))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((3.70,-42.99,-11.52))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((3.70,-42.99,-11.52))
Interior1V.append((4.46,-42.78,-16.89))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((5.12,-41.24,-15.34))
Interior1V.append((4.46,-42.78,-16.89))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((1.03,-42.70,-17.90))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((2.18,-43.10,-17.98))
Interior1V.append((1.03,-42.70,-17.90))
Interior1V.append((.81,-41.59,-17.22))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((1.03,-42.70,-17.90))
Interior1V.append((2.18,-43.10,-17.98))
Interior1V.append((.81,-41.59,-17.22))
Interior1V.append((4.44,-47.62,-8.64))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((4.44,-47.34,-9.60))
Interior1V.append((4.44,-47.62,-8.64))
Interior1V.append((4.44,-47.34,-9.60))
Interior1V.append((6.64,-44.22,-9.52))
Interior1V.append((8.00,-46.35,-9.85))
Interior1V.append((4.44,-47.34,-9.60))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((8.00,-46.35,-9.85))
Interior1V.append((6.64,-44.22,-9.52))
Interior1V.append((4.44,-47.34,-9.60))
Interior1V.append((5.26,-43.79,-7.40))
Interior1V.append((4.44,-47.62,-8.64))
Interior1V.append((6.64,-44.22,-9.52))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((4.44,-47.62,-8.64))
Interior1V.append((5.26,-43.79,-7.40))
Interior1V.append((3.43,-47.68,-7.88))
Interior1V.append((4.44,-47.62,-8.64))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((3.43,-47.68,-7.88))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((4.44,-47.62,-8.64))
Interior1V.append((2.60,-45.78,-3.76))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((2.60,-45.78,-3.76))
Interior1V.append((2.64,-44.54,-3.41))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((2.60,-45.78,-3.76))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((2.64,-44.54,-3.41))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((2.64,-44.54,-3.41))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((1.95,-44.90,2.16))
Interior1V.append((-1.12,-47.53,-1.24))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((-1.12,-47.53,-1.24))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((4.11,-49.16,-1.22))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((.60,-49.67,-.50))
Interior1V.append((4.11,-49.16,-1.22))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((1.18,-50.49,.42))
Interior1V.append((4.11,-49.16,-1.22))
Interior1V.append((.60,-49.67,-.50))
Interior1V.append((-.52,-49.03,.25))
Interior1V.append((.60,-49.67,-.50))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((-.52,-49.03,.25))
Interior1V.append((1.18,-50.49,.42))
Interior1V.append((.60,-49.67,-.50))
Interior1V.append((-1.11,-47.90,-.21))
Interior1V.append((-.52,-49.03,.25))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((-1.11,-47.90,-.21))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((-.52,-49.03,.25))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-11.74,-54.10,13.43))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-13.65,-53.71,14.26))
Interior1V.append((-11.74,-54.10,13.43))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-10.01,-52.07,12.10))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-10.01,-52.07,12.10))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-10.01,-52.07,12.10))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-10.01,-52.07,12.10))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-10.01,-52.07,12.10))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-10.01,-52.07,12.10))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-10.91,-54.00,10.60))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-10.91,-54.00,10.60))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-10.91,-54.00,10.60))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-10.91,-54.00,10.60))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-14.26,-54.78,9.87))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-14.26,-54.78,9.87))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-14.26,-54.78,9.87))
Interior1V.append((-11.69,-56.63,9.67))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-14.26,-54.78,9.87))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-11.69,-56.63,9.67))
Interior1V.append((-15.74,-57.30,9.99))
Interior1V.append((-14.26,-54.78,9.87))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-15.74,-57.30,9.99))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-16.24,-57.96,7.82))
Interior1V.append((-15.81,-54.37,10.75))
Interior1V.append((-14.26,-54.78,9.87))
Interior1V.append((-15.74,-57.30,9.99))
Interior1V.append((-15.81,-54.37,10.75))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-14.26,-54.78,9.87))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-14.18,-49.90,12.94))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((-14.88,-48.37,11.03))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-14.18,-49.90,12.94))
Interior1V.append((-14.88,-48.37,11.03))
Interior1V.append((-14.18,-49.90,12.94))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-16.68,-51.27,13.39))
Interior1V.append((-14.88,-48.37,11.03))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-16.68,-51.27,13.39))
Interior1V.append((-17.39,-50.02,9.89))
Interior1V.append((-14.88,-48.37,11.03))
Interior1V.append((-16.68,-51.27,13.39))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-17.39,-50.02,9.89))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-14.88,-48.37,11.03))
Interior1V.append((-17.39,-50.02,9.89))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-17.39,-50.02,9.89))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-17.39,-50.02,9.89))
Interior1V.append((-12.74,-47.50,10.19))
Interior1V.append((-14.88,-48.37,11.03))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-16.43,-48.17,5.59))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-16.51,-52.06,8.25))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-16.51,-52.06,8.25))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-16.51,-52.06,8.25))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-16.51,-52.06,8.25))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-12.62,-51.76,5.65))
Interior1V.append((-12.62,-51.76,5.65))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-11.14,-49.37,7.20))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-11.14,-49.37,7.20))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-9.68,-51.11,6.54))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-9.68,-51.11,6.54))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-8.54,-53.20,8.27))
Interior1V.append((-9.68,-51.11,6.54))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-8.54,-53.20,8.27))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-9.68,-51.11,6.54))
Interior1V.append((-10.88,-47.34,9.04))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-6.18,-51.98,7.31))
Interior1V.append((-6.18,-51.98,7.31))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-8.54,-53.20,8.27))
Interior1V.append((-7.47,-53.39,9.09))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-6.18,-51.98,7.31))
Interior1V.append((-7.47,-53.39,9.09))
Interior1V.append((-6.18,-51.98,7.31))
Interior1V.append((-8.54,-53.20,8.27))
Interior1V.append((-7.47,-53.39,9.09))
Interior1V.append((-8.54,-53.20,8.27))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-7.64,-53.30,10.31))
Interior1V.append((-7.47,-53.39,9.09))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-7.64,-53.30,10.31))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-7.47,-53.39,9.09))
Interior1V.append((-7.64,-53.30,10.31))
Interior1V.append((-9.96,-52.11,9.26))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-7.64,-53.30,10.31))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-7.87,-50.51,13.63))
Interior1V.append((-9.01,-46.87,14.16))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-7.87,-50.51,13.63))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-9.01,-46.87,14.16))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-9.01,-46.87,14.16))
Interior1V.append((-10.72,-47.19,16.12))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-9.01,-46.87,14.16))
Interior1V.append((-13.42,-48.42,13.74))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-12.36,-47.31,15.44))
Interior1V.append((-13.42,-48.42,13.74))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-13.42,-48.42,13.74))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-13.42,-48.42,13.74))
Interior1V.append((-14.18,-49.90,12.94))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-13.48,-50.70,15.72))
Interior1V.append((-14.18,-49.90,12.94))
Interior1V.append((-13.42,-48.42,13.74))
Interior1V.append((-13.65,-53.71,14.26))
Interior1V.append((-14.18,-49.90,12.94))
Interior1V.append((-13.48,-50.70,15.72))
Interior1V.append((-12.56,-49.28,16.21))
Interior1V.append((-13.48,-50.70,15.72))
Interior1V.append((-13.42,-48.42,13.74))
Interior1V.append((-12.56,-49.28,16.21))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-13.48,-50.70,15.72))
Interior1V.append((-12.56,-49.28,16.21))
Interior1V.append((-13.42,-48.42,13.74))
Interior1V.append((-12.36,-47.31,15.44))
Interior1V.append((-20.08,-42.23,14.87))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-20.08,-42.23,14.87))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-20.08,-42.23,14.87))
Interior1V.append((-22.99,-41.26,13.12))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-20.08,-42.23,14.87))
Interior1V.append((-22.99,-41.26,13.12))
Interior1V.append((-20.08,-42.23,14.87))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-19.46,-44.45,15.15))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-19.46,-44.45,15.15))
Interior1V.append((-22.21,-43.70,17.85))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-20.84,-44.44,18.57))
Interior1V.append((-22.21,-43.70,17.85))
Interior1V.append((-20.84,-44.44,18.57))
Interior1V.append((-19.46,-44.45,15.15))
Interior1V.append((-22.21,-43.70,17.85))
Interior1V.append((-19.46,-44.45,15.15))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-19.70,-47.84,9.83))
Interior1V.append((-22.13,-47.25,8.56))
Interior1V.append((-19.63,-46.03,8.84))
Interior1V.append((-19.70,-47.84,9.83))
Interior1V.append((-21.30,-49.50,6.96))
Interior1V.append((-22.13,-47.25,8.56))
Interior1V.append((-10.85,-53.53,14.28))
Interior1V.append((-13.65,-53.71,14.26))
Interior1V.append((-13.48,-50.70,15.72))
Interior1V.append((-10.85,-53.53,14.28))
Interior1V.append((-13.48,-50.70,15.72))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-11.74,-42.51,15.30))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-11.74,-42.51,15.30))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-11.74,-42.51,15.30))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-12.79,-43.21,17.65))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-12.79,-43.21,17.65))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-14.68,-44.88,16.72))
Interior1V.append((-14.78,-41.88,19.12))
Interior1V.append((-12.79,-43.21,17.65))
Interior1V.append((-14.68,-44.88,16.72))
Interior1V.append((-14.78,-41.88,19.12))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-12.79,-43.21,17.65))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-14.78,-41.88,19.12))
Interior1V.append((-13.17,-40.50,18.02))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-14.11,-38.59,18.55))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-14.11,-38.59,18.55))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-13.04,-37.99,18.86))
Interior1V.append((-13.17,-40.50,18.02))
Interior1V.append((-14.11,-38.59,18.55))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-13.17,-40.50,18.02))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-12.46,-37.50,14.43))
Interior1V.append((-10.46,-38.62,15.37))
Interior1V.append((-12.46,-37.50,14.43))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-9.45,-40.63,16.36))
Interior1V.append((-10.46,-38.62,15.37))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-11.74,-42.51,15.30))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-13.17,-40.50,18.02))
Interior1V.append((-11.74,-42.51,15.30))
Interior1V.append((-13.17,-40.50,18.02))
Interior1V.append((-9.45,-40.63,16.36))
Interior1V.append((-11.74,-42.51,15.30))
Interior1V.append((-9.45,-40.63,16.36))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-11.22,-41.53,18.82))
Interior1V.append((-9.45,-40.63,16.36))
Interior1V.append((-13.17,-40.50,18.02))
Interior1V.append((-9.62,-38.17,14.86))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-10.46,-38.62,15.37))
Interior1V.append((-9.62,-38.17,14.86))
Interior1V.append((-10.46,-38.62,15.37))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-10.46,-38.62,15.37))
Interior1V.append((-9.45,-40.63,16.36))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-11.22,-41.53,18.82))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-9.45,-40.63,16.36))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-12.46,-37.50,14.43))
Interior1V.append((-10.46,-38.62,15.37))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-12.46,-37.50,14.43))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-9.18,-36.85,15.06))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-9.62,-38.17,14.86))
Interior1V.append((-9.18,-36.85,15.06))
Interior1V.append((-9.62,-38.17,14.86))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-9.18,-36.85,15.06))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-9.18,-36.85,15.06))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-8.12,-36.28,14.28))
Interior1V.append((-9.18,-36.85,15.06))
Interior1V.append((-8.12,-36.28,14.28))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-9.18,-36.85,15.06))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-7.14,-36.28,19.33))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-7.14,-36.28,19.33))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-6.44,-39.91,23.04))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-9.53,-40.60,21.88))
Interior1V.append((-6.95,-41.38,22.03))
Interior1V.append((-8.80,-41.16,18.98))
Interior1V.append((-7.30,-39.49,17.43))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-8.80,-41.16,18.98))
Interior1V.append((-7.30,-39.49,17.43))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-4.23,-39.66,19.78))
Interior1V.append((-7.30,-39.49,17.43))
Interior1V.append((-8.80,-41.16,18.98))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-7.30,-39.49,17.43))
Interior1V.append((-4.23,-39.66,19.78))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-7.30,-39.49,17.43))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-2.40,-37.44,19.29))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-5.14,-35.57,20.67))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-5.14,-35.57,20.67))
Interior1V.append((-2.40,-37.44,19.29))
Interior1V.append((-4.22,-38.54,16.25))
Interior1V.append((-4.09,-35.95,16.44))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-4.22,-38.54,16.25))
Interior1V.append((-2.40,-37.44,19.29))
Interior1V.append((-4.09,-35.95,16.44))
Interior1V.append((-4.22,-38.54,16.25))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-2.40,-37.44,19.29))
Interior1V.append((-1.56,-40.64,22.97))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-1.19,-42.73,24.82))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((-1.19,-42.73,24.82))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-1.99,-45.56,24.19))
Interior1V.append((-1.19,-42.73,24.82))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-1.99,-45.56,24.19))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-1.19,-42.73,24.82))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-15.81,-54.37,10.75))
Interior1V.append((-18.60,-57.03,10.84))
Interior1V.append((-18.60,-57.03,10.84))
Interior1V.append((-20.49,-52.87,11.42))
Interior1V.append((-18.92,-55.20,12.30))
Interior1V.append((-18.60,-57.03,10.84))
Interior1V.append((-18.92,-55.20,12.30))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-18.85,-52.34,13.10))
Interior1V.append((-18.92,-55.20,12.30))
Interior1V.append((-20.49,-52.87,11.42))
Interior1V.append((-20.47,-56.77,11.21))
Interior1V.append((-20.49,-52.87,11.42))
Interior1V.append((-18.60,-57.03,10.84))
Interior1V.append((-20.47,-56.77,11.21))
Interior1V.append((-18.60,-57.03,10.84))
Interior1V.append((-18.35,-57.20,8.22))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-20.47,-56.77,11.21))
Interior1V.append((-18.35,-57.20,8.22))
Interior1V.append((-21.37,-53.75,11.56))
Interior1V.append((-20.49,-52.87,11.42))
Interior1V.append((-20.47,-56.77,11.21))
Interior1V.append((-18.65,-51.92,9.09))
Interior1V.append((-18.85,-52.34,13.10))
Interior1V.append((-20.49,-52.87,11.42))
Interior1V.append((-22.22,-52.31,9.41))
Interior1V.append((-18.65,-51.92,9.09))
Interior1V.append((-20.49,-52.87,11.42))
Interior1V.append((-22.09,-51.89,7.49))
Interior1V.append((-18.65,-51.92,9.09))
Interior1V.append((-22.22,-52.31,9.41))
Interior1V.append((-22.22,-52.31,9.41))
Interior1V.append((-20.49,-52.87,11.42))
Interior1V.append((-21.37,-53.75,11.56))
Interior1V.append((-22.54,-53.57,10.99))
Interior1V.append((-21.37,-53.75,11.56))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-22.54,-53.57,10.99))
Interior1V.append((-22.22,-52.31,9.41))
Interior1V.append((-21.37,-53.75,11.56))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-12.82,-64.79,-1.03))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-12.82,-64.79,-1.03))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-19.14,-58.39,6.21))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-22.65,-62.12,7.31))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-19.42,-59.87,7.16))
Interior1V.append((-22.65,-62.12,7.31))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-22.65,-62.12,7.31))
Interior1V.append((-19.42,-59.87,7.16))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-19.42,-59.87,7.16))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-19.14,-58.39,6.21))
Interior1V.append((-19.42,-59.87,7.16))
Interior1V.append((-19.14,-58.39,6.21))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-10.93,-57.70,8.02))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-11.69,-56.63,9.67))
Interior1V.append((-9.71,-55.48,8.16))
Interior1V.append((-11.69,-56.63,9.67))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-9.71,-55.48,8.16))
Interior1V.append((-10.93,-57.70,8.02))
Interior1V.append((-11.69,-56.63,9.67))
Interior1V.append((-10.36,-53.68,6.70))
Interior1V.append((-9.71,-55.48,8.16))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((-1.57,-22.60,2.22))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((-.34,-24.08,6.14))
Interior1V.append((-1.57,-22.60,2.22))
Interior1V.append((-.91,-22.41,6.38))
Interior1V.append((-.34,-24.08,6.14))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((-1.57,-22.60,2.22))
Interior1V.append((-.70,-19.56,3.29))
Interior1V.append((-.91,-22.41,6.38))
Interior1V.append((-1.57,-22.60,2.22))
Interior1V.append((-.70,-19.56,3.29))
Interior1V.append((-1.57,-22.60,2.22))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((-1.09,-19.68,5.08))
Interior1V.append((-.91,-22.41,6.38))
Interior1V.append((-.70,-19.56,3.29))
Interior1V.append((-1.09,-19.68,5.08))
Interior1V.append((-.70,-19.56,3.29))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((-1.09,-19.68,5.08))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-.91,-22.41,6.38))
Interior1V.append((-1.09,-19.68,5.08))
Interior1V.append((-1.73,-17.48,5.34))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-1.09,-19.68,5.08))
Interior1V.append((-1.73,-17.48,5.34))
Interior1V.append((-1.09,-19.68,5.08))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((.95,-17.81,4.03))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((.95,-17.81,4.03))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((8.33,-21.93,5.92))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((7.60,-16.32,.33))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((.95,-17.81,4.03))
Interior1V.append((7.60,-16.32,.33))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((7.60,-16.32,.33))
Interior1V.append((.95,-17.81,4.03))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((4.53,-22.32,12.32))
Interior1V.append((8.33,-21.93,5.92))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((4.53,-22.32,12.32))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((8.33,-21.93,5.92))
Interior1V.append((4.53,-22.32,12.32))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-1.73,-17.48,5.34))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((-1.73,-17.48,5.34))
Interior1V.append((.86,-18.48,5.62))
Interior1V.append((2.68,-23.26,9.95))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((-.91,-22.41,6.38))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((-1.01,-24.53,8.55))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((-.34,-24.08,6.14))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((-1.01,-24.53,8.55))
Interior1V.append((-1.04,-27.00,7.44))
Interior1V.append((-2.30,-25.88,6.28))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-1.04,-27.00,7.44))
Interior1V.append((-2.30,-25.88,6.28))
Interior1V.append((-1.04,-27.00,7.44))
Interior1V.append((-1.01,-24.53,8.55))
Interior1V.append((.68,-28.29,6.68))
Interior1V.append((3.19,-27.91,5.84))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((3.19,-27.91,5.84))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((-.41,-28.04,7.51))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((.78,-28.75,9.74))
Interior1V.append((.78,-28.75,9.74))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((3.19,-27.91,5.84))
Interior1V.append((.68,-28.29,6.68))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((.68,-28.29,6.68))
Interior1V.append((.78,-28.75,9.74))
Interior1V.append((3.19,-27.91,5.84))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((4.70,-27.88,10.33))
Interior1V.append((5.72,-26.68,9.25))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((4.70,-27.88,10.33))
Interior1V.append((5.72,-26.68,9.25))
Interior1V.append((4.70,-27.88,10.33))
Interior1V.append((3.85,-24.93,9.21))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((3.19,-27.91,5.84))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((5.72,-26.68,9.25))
Interior1V.append((5.72,-26.68,9.25))
Interior1V.append((3.85,-24.93,9.21))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((3.19,-27.91,5.84))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((3.19,-27.91,5.84))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((6.08,-28.89,4.52))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((6.08,-28.89,4.52))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((8.71,-25.44,5.94))
Interior1V.append((6.08,-28.89,4.52))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((6.08,-28.89,4.52))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((7.72,-24.17,1.34))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((6.68,-27.17,-1.37))
Interior1V.append((10.40,-28.40,-1.37))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((6.68,-27.17,-1.37))
Interior1V.append((8.46,-29.68,-2.15))
Interior1V.append((10.40,-28.40,-1.37))
Interior1V.append((6.68,-27.17,-1.37))
Interior1V.append((8.46,-29.68,-2.15))
Interior1V.append((6.68,-27.17,-1.37))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((9.86,-31.13,-1.37))
Interior1V.append((10.40,-28.40,-1.37))
Interior1V.append((8.46,-29.68,-2.15))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((10.40,-28.40,-1.37))
Interior1V.append((9.86,-31.13,-1.37))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((9.86,-31.13,-1.37))
Interior1V.append((8.46,-29.68,-2.15))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((8.46,-29.68,-2.15))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((4.00,-25.52,-8.97))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((4.00,-25.52,-8.97))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((3.56,-24.21,-9.30))
Interior1V.append((4.00,-25.52,-8.97))
Interior1V.append((3.56,-24.21,-9.30))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((4.50,-24.07,-13.37))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((2.72,-23.94,-9.93))
Interior1V.append((2.72,-23.94,-9.93))
Interior1V.append((3.56,-24.21,-9.30))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((2.72,-23.94,-9.93))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((3.56,-24.21,-9.30))
Interior1V.append((2.72,-23.94,-9.93))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((1.12,-26.68,-10.13))
Interior1V.append((-3.88,-27.90,-10.10))
Interior1V.append((-4.40,-25.01,-9.96))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((-3.88,-27.90,-10.10))
Interior1V.append((-4.14,-27.66,-12.67))
Interior1V.append((-4.40,-25.01,-9.96))
Interior1V.append((-4.14,-27.66,-12.67))
Interior1V.append((-3.68,-24.66,-13.10))
Interior1V.append((-4.40,-25.01,-9.96))
Interior1V.append((-2.73,-23.01,-14.57))
Interior1V.append((-3.68,-24.66,-13.10))
Interior1V.append((-2.62,-26.14,-15.59))
Interior1V.append((-2.73,-23.01,-14.57))
Interior1V.append((-.77,-23.62,-12.44))
Interior1V.append((-3.68,-24.66,-13.10))
Interior1V.append((-1.56,-25.07,-16.53))
Interior1V.append((-2.73,-23.01,-14.57))
Interior1V.append((-2.62,-26.14,-15.59))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((-2.73,-23.01,-14.57))
Interior1V.append((-1.56,-25.07,-16.53))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((-.77,-23.62,-12.44))
Interior1V.append((-2.73,-23.01,-14.57))
Interior1V.append((-1.56,-25.07,-16.53))
Interior1V.append((-2.62,-26.14,-15.59))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((.42,-23.76,-11.12))
Interior1V.append((-.77,-23.62,-12.44))
Interior1V.append((.88,-26.79,-15.92))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((.88,-26.79,-15.92))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((.88,-26.79,-15.92))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((-1.56,-25.07,-16.53))
Interior1V.append((4.50,-24.07,-13.37))
Interior1V.append((3.02,-22.01,-11.10))
Interior1V.append((2.87,-22.08,-15.00))
Interior1V.append((4.50,-24.07,-13.37))
Interior1V.append((2.87,-22.08,-15.00))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((2.17,-24.21,-15.58))
Interior1V.append((4.58,-26.48,-14.20))
Interior1V.append((4.50,-24.07,-13.37))
Interior1V.append((2.17,-24.21,-15.58))
Interior1V.append((4.50,-24.07,-13.37))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((4.58,-26.48,-14.20))
Interior1V.append((2.17,-24.21,-15.58))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((2.17,-24.21,-15.58))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((3.04,-28.83,-14.59))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((4.58,-26.48,-14.20))
Interior1V.append((3.04,-28.83,-14.59))
Interior1V.append((4.58,-26.48,-14.20))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((4.50,-24.07,-13.37))
Interior1V.append((4.58,-26.48,-14.20))
Interior1V.append((.74,-28.86,-11.76))
Interior1V.append((3.04,-28.83,-14.59))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((3.98,-29.86,-11.96))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((3.04,-28.83,-14.59))
Interior1V.append((3.98,-29.86,-11.96))
Interior1V.append((3.04,-28.83,-14.59))
Interior1V.append((.74,-28.86,-11.76))
Interior1V.append((-1.59,-28.19,2.41))
Interior1V.append((-.58,-27.17,-1.11))
Interior1V.append((-1.52,-25.53,1.45))
Interior1V.append((-1.59,-28.19,2.41))
Interior1V.append((-1.52,-25.53,1.45))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((-1.59,-28.19,2.41))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((-.58,-27.17,-1.11))
Interior1V.append((-.58,-27.17,-1.11))
Interior1V.append((-.07,-29.09,-2.13))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((-.58,-27.17,-1.11))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((-.07,-29.09,-2.13))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((-.07,-29.09,-2.13))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((-3.11,-30.15,2.72))
Interior1V.append((-5.94,-32.09,3.36))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-3.11,-30.15,2.72))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((9.75,-33.60,-22.16))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((9.75,-33.60,-22.16))
Interior1V.append((9.19,-33.37,-18.43))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((7.28,-32.10,-18.38))
Interior1V.append((9.19,-33.37,-18.43))
Interior1V.append((9.75,-33.60,-22.16))
Interior1V.append((8.81,-32.34,-15.87))
Interior1V.append((7.28,-32.10,-18.38))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((8.81,-32.34,-15.87))
Interior1V.append((9.19,-33.37,-18.43))
Interior1V.append((7.28,-32.10,-18.38))
Interior1V.append((6.05,-31.45,-22.32))
Interior1V.append((7.28,-32.10,-18.38))
Interior1V.append((9.75,-33.60,-22.16))
Interior1V.append((6.05,-31.45,-22.32))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((7.28,-32.10,-18.38))
Interior1V.append((6.05,-31.45,-22.32))
Interior1V.append((9.75,-33.60,-22.16))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((9.19,-33.37,-18.43))
Interior1V.append((8.81,-32.34,-15.87))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((9.82,-35.00,-18.08))
Interior1V.append((9.19,-33.37,-18.43))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((9.82,-35.00,-18.08))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((9.19,-33.37,-18.43))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((9.82,-35.00,-18.08))
Interior1V.append((14.80,-28.47,-13.37))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((14.80,-28.47,-13.37))
Interior1V.append((16.60,-30.43,-12.66))
Interior1V.append((10.01,-33.51,-14.01))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((16.03,-26.93,-13.96))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((16.03,-26.93,-13.96))
Interior1V.append((14.80,-28.47,-13.37))
Interior1V.append((17.91,-26.79,-5.02))
Interior1V.append((19.55,-24.10,-4.37))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((19.82,-24.64,-6.40))
Interior1V.append((19.55,-24.10,-4.37))
Interior1V.append((17.91,-26.79,-5.02))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((9.94,-25.02,-12.13))
Interior1V.append((9.66,-27.83,-10.90))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((6.74,-24.11,-12.16))
Interior1V.append((9.94,-25.02,-12.13))
Interior1V.append((6.74,-24.11,-12.16))
Interior1V.append((6.36,-26.38,-13.93))
Interior1V.append((9.94,-25.02,-12.13))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((6.36,-26.38,-13.93))
Interior1V.append((6.74,-24.11,-12.16))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((6.74,-24.11,-12.16))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((9.66,-27.83,-10.90))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((6.36,-26.38,-13.93))
Interior1V.append((5.13,-26.17,-12.46))
Interior1V.append((6.68,-29.11,-12.68))
Interior1V.append((7.12,-29.28,-7.36))
Interior1V.append((6.21,-28.81,-6.48))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((3.78,-28.90,-6.31))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((6.21,-28.81,-6.48))
Interior1V.append((5.05,-30.54,-6.52))
Interior1V.append((3.78,-28.90,-6.31))
Interior1V.append((6.21,-28.81,-6.48))
Interior1V.append((2.86,-29.57,-7.12))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((3.78,-28.90,-6.31))
Interior1V.append((3.13,-30.47,-7.43))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((2.86,-29.57,-7.12))
Interior1V.append((3.13,-30.47,-7.43))
Interior1V.append((2.86,-29.57,-7.12))
Interior1V.append((3.78,-28.90,-6.31))
Interior1V.append((2.86,-29.57,-7.12))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((2.86,-29.57,-7.12))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((2.86,-29.57,-7.12))
Interior1V.append((1.62,-28.99,-7.52))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((.45,-29.63,-6.80))
Interior1V.append((1.62,-28.99,-7.52))
Interior1V.append((.45,-29.63,-6.80))
Interior1V.append((2.98,-30.16,-4.33))
Interior1V.append((1.62,-28.99,-7.52))
Interior1V.append((2.98,-30.16,-4.33))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((2.98,-30.16,-4.33))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((2.08,-25.66,-5.58))
Interior1V.append((-.02,-29.77,-3.71))
Interior1V.append((2.98,-30.16,-4.33))
Interior1V.append((.45,-29.63,-6.80))
Interior1V.append((2.98,-30.16,-4.33))
Interior1V.append((-.02,-29.77,-3.71))
Interior1V.append((1.37,-29.98,-2.74))
Interior1V.append((2.98,-30.16,-4.33))
Interior1V.append((1.37,-29.98,-2.74))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((-.59,-28.85,-6.32))
Interior1V.append((-.02,-29.77,-3.71))
Interior1V.append((.45,-29.63,-6.80))
Interior1V.append((-.59,-28.85,-6.32))
Interior1V.append((.45,-29.63,-6.80))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((-.11,-29.29,-14.50))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((-.11,-29.29,-14.50))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((-.54,-27.06,-14.83))
Interior1V.append((-.11,-29.29,-14.50))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((11.21,-55.15,-11.38))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((11.21,-55.15,-11.38))
Interior1V.append((14.72,-55.26,-6.24))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((22.33,-53.88,-8.86))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((22.33,-53.88,-8.86))
Interior1V.append((20.89,-54.57,-6.97))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((22.33,-53.88,-8.86))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((20.89,-54.57,-6.97))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((14.26,-53.78,-4.47))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((14.72,-55.26,-6.24))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((14.26,-53.78,-4.47))
Interior1V.append((14.72,-55.26,-6.24))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((11.21,-55.15,-11.38))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((14.72,-55.26,-6.24))
Interior1V.append((11.21,-55.15,-11.38))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((10.65,-49.37,-3.58))
Interior1V.append((11.09,-53.62,-4.02))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((11.09,-53.62,-4.02))
Interior1V.append((14.26,-53.78,-4.47))
Interior1V.append((10.65,-51.99,-1.99))
Interior1V.append((11.09,-53.62,-4.02))
Interior1V.append((10.65,-49.37,-3.58))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((10.65,-49.37,-3.58))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((10.65,-49.37,-3.58))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((9.30,-50.66,-7.82))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((9.30,-50.66,-7.82))
Interior1V.append((12.73,-54.35,-5.74))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((9.30,-50.66,-7.82))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((9.30,-50.66,-7.82))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((15.15,-46.11,-4.38))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((15.15,-46.11,-4.38))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((9.99,-46.46,-10.59))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((9.99,-46.46,-10.59))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((10.60,-46.37,-4.11))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((9.99,-46.46,-10.59))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((8.99,-47.62,-9.06))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((8.99,-47.62,-9.06))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((8.00,-46.35,-9.85))
Interior1V.append((8.99,-47.62,-9.06))
Interior1V.append((8.00,-46.35,-9.85))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((8.00,-46.35,-9.85))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((8.00,-46.35,-9.85))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((6.64,-44.22,-9.52))
Interior1V.append((8.00,-46.35,-9.85))
Interior1V.append((8.92,-39.40,-10.13))
Interior1V.append((11.46,-41.58,-8.04))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((8.92,-39.40,-10.13))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((11.46,-41.58,-8.04))
Interior1V.append((9.64,-41.03,-5.75))
Interior1V.append((11.46,-41.58,-8.04))
Interior1V.append((11.39,-42.64,-4.45))
Interior1V.append((9.64,-41.03,-5.75))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((11.46,-41.58,-8.04))
Interior1V.append((13.20,-43.03,-5.73))
Interior1V.append((11.39,-42.64,-4.45))
Interior1V.append((11.46,-41.58,-8.04))
Interior1V.append((15.25,-46.10,-2.57))
Interior1V.append((15.15,-46.11,-4.38))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((10.65,-49.37,-3.58))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((11.30,-49.56,-1.00))
Interior1V.append((10.65,-49.37,-3.58))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((10.65,-51.99,-1.99))
Interior1V.append((10.65,-49.37,-3.58))
Interior1V.append((11.30,-49.56,-1.00))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((10.60,-46.37,-4.11))
Interior1V.append((6.22,-43.11,-5.07))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((8.49,-47.27,-4.35))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((10.60,-46.37,-4.11))
Interior1V.append((5.20,-41.72,-4.56))
Interior1V.append((6.22,-43.11,-5.07))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((5.20,-41.72,-4.56))
Interior1V.append((4.77,-44.51,-3.19))
Interior1V.append((6.22,-43.11,-5.07))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((6.22,-43.11,-5.07))
Interior1V.append((4.77,-44.51,-3.19))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((8.49,-47.27,-4.35))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((4.77,-44.51,-3.19))
Interior1V.append((6.44,-48.43,-3.51))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((6.44,-48.43,-3.51))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((1.77,-44.04,-3.33))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((2.64,-44.54,-3.41))
Interior1V.append((1.77,-44.04,-3.33))
Interior1V.append((2.64,-44.54,-3.41))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((4.77,-44.51,-3.19))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((2.64,-44.54,-3.41))
Interior1V.append((4.77,-44.51,-3.19))
Interior1V.append((2.64,-44.54,-3.41))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((5.84,-48.60,.29))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((4.11,-49.16,-1.22))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((1.95,-44.90,2.16))
Interior1V.append((4.45,-44.59,4.70))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((4.45,-44.59,4.70))
Interior1V.append((5.20,-46.32,5.44))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((5.20,-46.32,5.44))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((1.95,-44.90,2.16))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((4.11,-49.16,-1.22))
Interior1V.append((3.09,-51.12,1.10))
Interior1V.append((5.84,-48.60,.29))
Interior1V.append((3.09,-51.12,1.10))
Interior1V.append((4.11,-49.16,-1.22))
Interior1V.append((1.18,-50.49,.42))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((3.09,-51.12,1.10))
Interior1V.append((1.18,-50.49,.42))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((1.18,-50.49,.42))
Interior1V.append((-.52,-49.03,.25))
Interior1V.append((1.42,-51.86,2.62))
Interior1V.append((3.09,-51.12,1.10))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((-.14,-47.62,3.83))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((-.14,-47.62,3.83))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((.16,-46.84,4.56))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((-.14,-47.62,3.83))
Interior1V.append((.16,-46.84,4.56))
Interior1V.append((-.14,-47.62,3.83))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((.16,-46.84,4.56))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((-4.46,-43.99,1.46))
Interior1V.append((-2.94,-43.15,.70))
Interior1V.append((-4.18,-42.26,-1.35))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-2.94,-43.15,.70))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((-2.94,-43.15,.70))
Interior1V.append((-3.10,-43.51,2.49))
Interior1V.append((-.65,-39.28,1.33))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((-6.03,-38.45,1.78))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-1.93,-42.93,4.86))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((-3.10,-43.51,2.49))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-6.03,-38.45,1.78))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-6.03,-38.45,1.78))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-.65,-39.28,1.33))
Interior1V.append((.02,-36.69,1.42))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((-.65,-39.28,1.33))
Interior1V.append((-4.97,-38.53,-.93))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-4.97,-38.53,-.93))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((-4.65,-35.26,.47))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-4.97,-38.53,-.93))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-4.65,-35.26,.47))
Interior1V.append((-4.97,-38.53,-.93))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-4.97,-38.53,-.93))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((-5.02,-34.61,3.32))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-4.65,-35.26,.47))
Interior1V.append((-9.42,-35.69,-4.34))
Interior1V.append((-12.17,-34.60,-2.12))
Interior1V.append((-12.13,-36.20,-2.97))
Interior1V.append((-9.42,-35.69,-4.34))
Interior1V.append((-8.71,-33.71,-2.23))
Interior1V.append((-12.17,-34.60,-2.12))
Interior1V.append((-12.18,-35.08,.11))
Interior1V.append((-12.13,-36.20,-2.97))
Interior1V.append((-12.17,-34.60,-2.12))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-9.42,-35.69,-4.34))
Interior1V.append((-12.13,-36.20,-2.97))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-12.13,-36.20,-2.97))
Interior1V.append((-12.18,-35.08,.11))
Interior1V.append((-12.34,-37.21,-.08))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-12.18,-35.08,.11))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-13.24,-39.99,.33))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-13.24,-39.99,.33))
Interior1V.append((-13.88,-38.11,.97))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-13.88,-38.11,.97))
Interior1V.append((-14.44,-39.43,2.89))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-14.41,-37.49,1.86))
Interior1V.append((-13.88,-38.11,.97))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-14.41,-37.49,1.86))
Interior1V.append((-14.44,-39.43,2.89))
Interior1V.append((-13.88,-38.11,.97))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-10.70,-36.36,2.46))
Interior1V.append((-14.41,-37.49,1.86))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-10.70,-36.36,2.46))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-14.41,-37.49,1.86))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-10.10,-37.76,4.01))
Interior1V.append((-10.70,-36.36,2.46))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-10.57,-36.46,3.78))
Interior1V.append((-14.41,-37.49,1.86))
Interior1V.append((-10.70,-36.36,2.46))
Interior1V.append((-10.57,-36.46,3.78))
Interior1V.append((-10.70,-36.36,2.46))
Interior1V.append((-10.10,-37.76,4.01))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-10.97,-35.57,1.76))
Interior1V.append((-9.34,-33.69,.32))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-12.34,-37.21,-.08))
Interior1V.append((-10.97,-35.57,1.76))
Interior1V.append((-10.97,-35.57,1.76))
Interior1V.append((-12.18,-35.08,.11))
Interior1V.append((-9.34,-33.69,.32))
Interior1V.append((-10.97,-35.57,1.76))
Interior1V.append((-12.34,-37.21,-.08))
Interior1V.append((-12.18,-35.08,.11))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-12.34,-37.21,-.08))
Interior1V.append((-7.50,-34.97,.76))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-9.34,-33.69,.32))
Interior1V.append((-7.50,-34.97,.76))
Interior1V.append((-9.34,-33.69,.32))
Interior1V.append((-8.71,-33.71,-2.23))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-7.50,-34.97,.76))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-10.17,-37.53,1.85))
Interior1V.append((-13.24,-39.99,.33))
Interior1V.append((-6.03,-38.45,1.78))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-8.21,-42.22,3.97))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((-3.10,-43.51,2.49))
Interior1V.append((-4.46,-43.99,1.46))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-8.21,-42.22,3.97))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((-4.46,-43.99,1.46))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((-1.93,-42.93,4.86))
Interior1V.append((-3.10,-43.51,2.49))
Interior1V.append((-7.00,-39.40,5.26))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-7.71,-44.13,5.77))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((-8.21,-42.22,3.97))
Interior1V.append((-7.71,-44.13,5.77))
Interior1V.append((-8.21,-42.22,3.97))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((-7.71,-44.13,5.77))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-1.93,-42.93,4.86))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-1.93,-42.93,4.86))
Interior1V.append((-6.43,-44.26,3.90))
Interior1V.append((.03,-44.18,7.21))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-.61,-46.03,4.53))
Interior1V.append((-3.95,-46.94,5.74))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((-.61,-46.03,4.53))
Interior1V.append((-3.95,-46.94,5.74))
Interior1V.append((-.61,-46.03,4.53))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-3.82,-48.06,6.46))
Interior1V.append((-3.95,-46.94,5.74))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((-2.81,-43.70,9.20))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((.03,-44.18,7.21))
Interior1V.append((-2.81,-43.70,9.20))
Interior1V.append((.03,-44.18,7.21))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-2.81,-43.70,9.20))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-2.81,-43.70,9.20))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-2.81,-43.70,9.20))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-6.56,-48.51,11.59))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-6.56,-48.51,11.59))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-6.56,-48.51,11.59))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-6.56,-48.51,11.59))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-3.66,-45.68,10.89))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((.55,-43.37,11.15))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((3.85,-43.82,10.24))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((.55,-43.37,11.15))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((-.34,-45.94,10.03))
Interior1V.append((.03,-44.18,7.21))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((3.85,-43.82,10.24))
Interior1V.append((.55,-43.37,11.15))
Interior1V.append((3.95,-44.73,7.81))
Interior1V.append((3.85,-43.82,10.24))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((3.95,-44.73,7.81))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((3.85,-43.82,10.24))
Interior1V.append((3.87,-43.73,7.79))
Interior1V.append((2.56,-42.26,10.88))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((3.43,-41.29,12.20))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((3.14,-43.07,13.80))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((3.14,-43.07,13.80))
Interior1V.append((3.43,-41.29,12.20))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((3.76,-44.61,21.58))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((3.76,-44.61,21.58))
Interior1V.append((4.11,-46.33,21.99))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((3.76,-44.61,21.58))
Interior1V.append((4.11,-46.33,21.99))
Interior1V.append((3.76,-44.61,21.58))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((8.10,-48.34,17.94))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((8.10,-48.34,17.94))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((3.14,-43.07,13.80))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((1.55,-43.67,14.35))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((-1.43,-43.56,15.36))
Interior1V.append((1.55,-43.67,14.35))
Interior1V.append((-.13,-46.72,15.21))
Interior1V.append((1.55,-43.67,14.35))
Interior1V.append((-1.43,-43.56,15.36))
Interior1V.append((-.13,-46.72,15.21))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((1.55,-43.67,14.35))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((-.13,-46.72,15.21))
Interior1V.append((-1.43,-43.56,15.36))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((-.13,-46.72,15.21))
Interior1V.append((-.49,-41.39,16.79))
Interior1V.append((-1.43,-43.56,15.36))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((-1.73,-41.05,18.50))
Interior1V.append((-.49,-41.39,16.79))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-.49,-41.39,16.79))
Interior1V.append((-1.73,-41.05,18.50))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-1.43,-43.56,15.36))
Interior1V.append((-.49,-41.39,16.79))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((-1.43,-43.56,15.36))
Interior1V.append((-5.63,-42.17,10.80))
Interior1V.append((-4.78,-42.37,12.34))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-5.63,-42.17,10.80))
Interior1V.append((-6.55,-44.20,12.58))
Interior1V.append((-4.78,-42.37,12.34))
Interior1V.append((-6.86,-41.88,15.11))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-4.78,-42.37,12.34))
Interior1V.append((-6.86,-41.88,15.11))
Interior1V.append((-4.78,-42.37,12.34))
Interior1V.append((-6.55,-44.20,12.58))
Interior1V.append((-7.00,-44.24,14.64))
Interior1V.append((-6.86,-41.88,15.11))
Interior1V.append((-6.55,-44.20,12.58))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-1.65,-37.86,10.24))
Interior1V.append((-.87,-40.66,9.00))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((-1.65,-37.86,10.24))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-1.65,-37.86,10.24))
Interior1V.append((-.45,-37.37,12.54))
Interior1V.append((-1.65,-37.86,10.24))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-.41,-33.56,8.79))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((-.01,-39.03,11.52))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((-.01,-39.03,11.52))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((-1.65,-37.86,10.24))
Interior1V.append((4.52,-37.13,8.65))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((-.87,-40.66,9.00))
Interior1V.append((-1.65,-37.86,10.24))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((-.87,-40.66,9.00))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-.87,-40.66,9.00))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((-.65,-39.28,1.33))
Interior1V.append((-.81,-42.55,5.32))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((.22,-42.39,4.45))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((-.81,-42.55,5.32))
Interior1V.append((.22,-42.39,4.45))
Interior1V.append((-.81,-42.55,5.32))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((-.81,-42.55,5.32))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((-1.93,-42.93,4.86))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((-.61,-46.03,4.53))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((.03,-44.18,7.21))
Interior1V.append((-.61,-46.03,4.53))
Interior1V.append((-.29,-41.73,2.19))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((-.29,-41.73,2.19))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((-.29,-41.73,2.19))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((-1.50,-41.55,2.20))
Interior1V.append((.22,-42.39,4.45))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((.22,-42.39,4.45))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((2.34,-38.68,1.02))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((2.34,-38.68,1.02))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((.30,-35.02,2.67))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((.30,-35.02,2.67))
Interior1V.append((.02,-36.69,1.42))
Interior1V.append((.02,-36.69,1.42))
Interior1V.append((-.65,-39.28,1.33))
Interior1V.append((1.30,-38.38,2.52))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((.02,-36.69,1.42))
Interior1V.append((-1.16,-43.09,-.75))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((-.48,-44.21,1.67))
Interior1V.append((-1.16,-43.09,-.75))
Interior1V.append((-.48,-44.21,1.67))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((1.95,-44.90,2.16))
Interior1V.append((-.48,-44.21,1.67))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((1.95,-44.90,2.16))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((-.48,-44.21,1.67))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((-1.16,-43.09,-.75))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((-1.16,-43.09,-.75))
Interior1V.append((.35,-43.12,-3.08))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((1.21,-39.51,-3.50))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((.35,-43.12,-3.08))
Interior1V.append((.35,-43.12,-3.08))
Interior1V.append((-.02,-44.55,-1.07))
Interior1V.append((1.77,-44.04,-3.33))
Interior1V.append((.35,-43.12,-3.08))
Interior1V.append((1.77,-44.04,-3.33))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((-3.88,-27.90,-10.10))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((-4.14,-27.66,-12.67))
Interior1V.append((-3.88,-27.90,-10.10))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((1.12,-26.68,-10.13))
Interior1V.append((.74,-28.86,-11.76))
Interior1V.append((1.12,-26.68,-10.13))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((.42,-23.76,-11.12))
Interior1V.append((.74,-28.86,-11.76))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((-.72,-26.49,-10.07))
Interior1V.append((.74,-28.86,-11.76))
Interior1V.append((1.06,-27.29,-14.18))
Interior1V.append((-1.09,-28.68,-11.43))
Interior1V.append((.42,-23.76,-11.12))
Interior1V.append((2.72,-23.94,-9.93))
Interior1V.append((1.12,-26.68,-10.13))
Interior1V.append((3.02,-22.01,-11.10))
Interior1V.append((2.72,-23.94,-9.93))
Interior1V.append((.42,-23.76,-11.12))
Interior1V.append((3.02,-22.01,-11.10))
Interior1V.append((4.50,-24.07,-13.37))
Interior1V.append((2.72,-23.94,-9.93))
Interior1V.append((3.02,-22.01,-11.10))
Interior1V.append((.42,-23.76,-11.12))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((.80,-21.49,-13.78))
Interior1V.append((2.87,-22.08,-15.00))
Interior1V.append((3.02,-22.01,-11.10))
Interior1V.append((.80,-21.49,-13.78))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((2.87,-22.08,-15.00))
Interior1V.append((.80,-21.49,-13.78))
Interior1V.append((3.02,-22.01,-11.10))
Interior1V.append((1.05,-23.67,-14.25))
Interior1V.append((2.76,-41.19,-16.86))
Interior1V.append((4.46,-42.78,-16.89))
Interior1V.append((5.12,-41.24,-15.34))
Interior1V.append((2.76,-41.19,-16.86))
Interior1V.append((5.12,-41.24,-15.34))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((2.18,-43.10,-17.98))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((4.46,-42.78,-16.89))
Interior1V.append((2.18,-43.10,-17.98))
Interior1V.append((4.46,-42.78,-16.89))
Interior1V.append((2.76,-41.19,-16.86))
Interior1V.append((8.24,-47.93,-15.00))
Interior1V.append((6.99,-43.96,-15.48))
Interior1V.append((7.28,-44.77,-12.68))
Interior1V.append((8.24,-47.93,-15.00))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((6.99,-43.96,-15.48))
Interior1V.append((8.24,-47.93,-15.00))
Interior1V.append((7.28,-44.77,-12.68))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((8.24,-47.93,-15.00))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((9.99,-46.46,-10.59))
Interior1V.append((8.24,-47.93,-15.00))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((8.24,-47.93,-15.00))
Interior1V.append((9.99,-46.46,-10.59))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((6.52,-49.17,-7.86))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((6.52,-49.17,-7.86))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((6.52,-49.17,-7.86))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((4.44,-48.84,-6.74))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((4.55,-46.43,-3.77))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((4.55,-46.43,-3.77))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((4.44,-48.84,-6.74))
Interior1V.append((3.59,-48.32,-6.77))
Interior1V.append((4.55,-46.43,-3.77))
Interior1V.append((4.44,-48.84,-6.74))
Interior1V.append((3.59,-48.32,-6.77))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((4.55,-46.43,-3.77))
Interior1V.append((1.48,-46.60,-6.41))
Interior1V.append((3.43,-47.68,-7.88))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((1.48,-46.60,-6.41))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((3.59,-48.32,-6.77))
Interior1V.append((1.48,-46.60,-6.41))
Interior1V.append((3.59,-48.32,-6.77))
Interior1V.append((3.43,-47.68,-7.88))
Interior1V.append((3.59,-48.32,-6.77))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((3.43,-47.68,-7.88))
Interior1V.append((3.59,-48.32,-6.77))
Interior1V.append((4.44,-48.84,-6.74))
Interior1V.append((5.24,-48.08,-8.26))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((19.87,-62.23,3.10))
Interior1V.append((24.27,-60.45,6.37))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((19.87,-62.23,3.10))
Interior1V.append((21.79,-57.99,6.84))
Interior1V.append((24.27,-60.45,6.37))
Interior1V.append((19.87,-62.23,3.10))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((24.27,-60.45,6.37))
Interior1V.append((18.08,-58.39,-1.72))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((21.79,-57.99,6.84))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((24.27,-60.45,6.37))
Interior1V.append((21.79,-57.99,6.84))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((21.79,-57.99,6.84))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((24.27,-60.45,6.37))
Interior1V.append((27.65,-54.01,9.08))
Interior1V.append((24.27,-60.45,6.37))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((27.65,-54.01,9.08))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((24.27,-60.45,6.37))
Interior1V.append((26.72,-53.69,8.92))
Interior1V.append((27.65,-54.01,9.08))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((23.46,-46.83,3.93))
Interior1V.append((22.43,-45.36,5.39))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((23.46,-46.83,3.93))
Interior1V.append((24.34,-48.73,2.89))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((24.34,-48.73,2.89))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((24.34,-48.73,2.89))
Interior1V.append((24.25,-51.25,6.76))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((24.25,-51.25,6.76))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((26.74,-49.54,2.16))
Interior1V.append((24.25,-51.25,6.76))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((26.74,-49.54,2.16))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((24.25,-51.25,6.76))
Interior1V.append((26.74,-49.54,2.16))
Interior1V.append((26.72,-53.69,8.92))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((19.95,-23.66,1.26))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((19.95,-23.66,1.26))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((18.89,-24.70,.25))
Interior1V.append((15.50,-31.51,1.66))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((15.50,-31.51,1.66))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((15.50,-31.51,1.66))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((15.77,-32.34,4.03))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((15.77,-32.34,4.03))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((11.22,-30.35,6.80))
Interior1V.append((13.44,-28.06,4.44))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((13.44,-28.06,4.44))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((11.39,-31.91,5.89))
Interior1V.append((11.22,-30.35,6.80))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((7.88,-33.97,6.51))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((5.54,-33.78,6.91))
Interior1V.append((7.88,-33.97,6.51))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((8.94,-36.08,10.71))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((4.72,-36.53,11.20))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((5.54,-33.78,6.91))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((5.54,-33.78,6.91))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((4.27,-32.64,7.47))
Interior1V.append((5.54,-33.78,6.91))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((4.72,-36.53,11.20))
Interior1V.append((4.52,-37.13,8.65))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((4.72,-36.53,11.20))
Interior1V.append((5.31,-37.54,10.47))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((4.52,-37.13,8.65))
Interior1V.append((5.31,-37.54,10.47))
Interior1V.append((4.72,-36.53,11.20))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((5.31,-37.54,10.47))
Interior1V.append((4.52,-37.13,8.65))
Interior1V.append((4.72,-36.53,11.20))
Interior1V.append((4.72,-36.53,11.20))
Interior1V.append((8.94,-36.08,10.71))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((4.72,-36.53,11.20))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((8.94,-36.08,10.71))
Interior1V.append((7.73,-37.70,9.17))
Interior1V.append((4.52,-37.13,8.65))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((4.52,-37.13,8.65))
Interior1V.append((7.73,-37.70,9.17))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((4.52,-37.13,8.65))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((3.38,-38.87,9.39))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((6.19,-37.95,10.67))
Interior1V.append((6.19,-37.95,10.67))
Interior1V.append((7.54,-38.22,11.96))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((3.29,-39.65,10.49))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((3.38,-38.87,9.39))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((3.29,-39.65,10.49))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((2.56,-42.26,10.88))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((2.56,-42.26,10.88))
Interior1V.append((3.29,-39.65,10.49))
Interior1V.append((3.29,-39.65,10.49))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((3.38,-38.87,9.39))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((3.29,-39.65,10.49))
Interior1V.append((2.56,-42.26,10.88))
Interior1V.append((1.34,-40.51,10.29))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((2.56,-42.26,10.88))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((1.34,-40.51,10.29))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((2.56,-42.26,10.88))
Interior1V.append((3.87,-43.73,7.79))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((1.34,-40.51,10.29))
Interior1V.append((2.56,-42.26,10.88))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((2.50,-38.85,8.50))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((-.02,-41.23,6.85))
Interior1V.append((3.95,-44.73,7.81))
Interior1V.append((.64,-42.94,8.47))
Interior1V.append((.03,-44.18,7.21))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((3.95,-44.73,7.81))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((3.95,-44.73,7.81))
Interior1V.append((.03,-44.18,7.21))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((3.95,-44.73,7.81))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((3.95,-44.73,7.81))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((3.85,-43.82,10.24))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((3.85,-43.82,10.24))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((.93,-48.30,12.74))
Interior1V.append((3.29,-48.29,13.45))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((3.29,-48.29,13.45))
Interior1V.append((5.16,-49.96,12.35))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((1.88,-50.27,8.45))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((1.88,-50.27,8.45))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((1.88,-50.27,8.45))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((1.88,-50.27,8.45))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((-3.15,-48.99,5.52))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((-2.82,-50.31,5.83))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((-2.82,-50.31,5.83))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((-3.15,-48.99,5.52))
Interior1V.append((-2.82,-50.31,5.83))
Interior1V.append((-3.15,-48.99,5.52))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((-3.82,-48.06,6.46))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((-3.15,-48.99,5.52))
Interior1V.append((-.51,-49.32,9.93))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((-.51,-49.32,9.93))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((-.51,-49.32,9.93))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((-.51,-49.32,9.93))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((-.48,-49.14,10.87))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((-.48,-49.14,10.87))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((.75,-49.85,8.58))
Interior1V.append((-.48,-49.14,10.87))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((.93,-48.30,12.74))
Interior1V.append((-.48,-49.14,10.87))
Interior1V.append((.93,-48.30,12.74))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((5.10,-51.94,9.90))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((5.10,-51.94,9.90))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((5.16,-49.96,12.35))
Interior1V.append((6.80,-48.70,13.43))
Interior1V.append((5.16,-49.96,12.35))
Interior1V.append((3.29,-48.29,13.45))
Interior1V.append((3.29,-48.29,13.45))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((4.74,-47.58,15.78))
Interior1V.append((3.29,-48.29,13.45))
Interior1V.append((4.74,-47.58,15.78))
Interior1V.append((6.80,-48.70,13.43))
Interior1V.append((6.80,-48.70,13.43))
Interior1V.append((4.74,-47.58,15.78))
Interior1V.append((7.84,-48.04,15.37))
Interior1V.append((6.80,-48.70,13.43))
Interior1V.append((7.84,-48.04,15.37))
Interior1V.append((7.85,-46.78,13.00))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((7.85,-46.78,13.00))
Interior1V.append((7.84,-48.04,15.37))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((7.84,-48.04,15.37))
Interior1V.append((4.74,-47.58,15.78))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((4.74,-47.58,15.78))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((8.67,-44.72,13.88))
Interior1V.append((7.85,-46.78,13.00))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((8.67,-44.72,13.88))
Interior1V.append((6.78,-44.87,11.97))
Interior1V.append((7.85,-46.78,13.00))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((4.64,-45.80,17.04))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((1.11,-46.44,21.44))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((1.11,-46.44,21.44))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((4.11,-46.33,21.99))
Interior1V.append((1.11,-46.44,21.44))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((8.10,-48.34,17.94))
Interior1V.append((4.45,-45.76,18.28))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((8.86,-51.10,19.29))
Interior1V.append((8.10,-48.34,17.94))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((11.10,-50.17,18.64))
Interior1V.append((10.48,-51.06,21.12))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((4.11,-46.33,21.99))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((10.48,-51.06,21.12))
Interior1V.append((8.86,-51.10,19.29))
Interior1V.append((10.48,-51.06,21.12))
Interior1V.append((11.10,-50.17,18.64))
Interior1V.append((8.86,-51.10,19.29))
Interior1V.append((11.10,-50.17,18.64))
Interior1V.append((8.10,-48.34,17.94))
Interior1V.append((8.31,-52.38,21.75))
Interior1V.append((10.48,-51.06,21.12))
Interior1V.append((8.86,-51.10,19.29))
Interior1V.append((10.26,-52.30,23.30))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((10.48,-51.06,21.12))
Interior1V.append((10.26,-52.30,23.30))
Interior1V.append((10.48,-51.06,21.12))
Interior1V.append((8.31,-52.38,21.75))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((10.26,-52.30,23.30))
Interior1V.append((5.11,-36.38,25.76))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((5.11,-36.38,25.76))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((5.11,-36.38,25.76))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((3.76,-44.61,21.58))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((3.76,-44.61,21.58))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-1.73,-41.05,18.50))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((-1.56,-40.64,22.97))
Interior1V.append((3.47,-40.81,16.27))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((2.23,-36.86,18.19))
Interior1V.append((3.47,-40.81,16.27))
Interior1V.append((2.23,-36.86,18.19))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((3.47,-40.81,16.27))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((2.23,-36.86,18.19))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((2.23,-36.86,18.19))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((5.51,-37.10,13.02))
Interior1V.append((7.54,-38.22,11.96))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((3.73,-36.57,16.81))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((5.51,-37.10,13.02))
Interior1V.append((3.73,-36.57,16.81))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((3.73,-36.57,16.81))
Interior1V.append((5.51,-37.10,13.02))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((3.73,-36.57,16.81))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((5.51,-37.10,13.02))
Interior1V.append((3.64,-39.91,15.87))
Interior1V.append((3.43,-41.29,12.20))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((5.51,-37.10,13.02))
Interior1V.append((4.08,-39.86,11.05))
Interior1V.append((7.54,-38.22,11.96))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((3.43,-41.29,12.20))
Interior1V.append((3.14,-43.07,13.80))
Interior1V.append((8.67,-44.72,13.88))
Interior1V.append((8.71,-42.23,10.94))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((8.67,-44.72,13.88))
Interior1V.append((10.18,-43.00,13.97))
Interior1V.append((8.71,-42.23,10.94))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((12.76,-42.11,8.76))
Interior1V.append((12.94,-38.13,9.96))
Interior1V.append((10.45,-41.37,9.29))
Interior1V.append((12.76,-42.11,8.76))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((10.45,-41.37,9.29))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((10.90,-45.09,12.55))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((10.45,-41.37,9.29))
Interior1V.append((10.90,-45.09,12.55))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((10.45,-41.37,9.29))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((12.76,-42.11,8.76))
Interior1V.append((10.45,-41.37,9.29))
Interior1V.append((8.27,-42.87,10.02))
Interior1V.append((8.71,-42.23,10.94))
Interior1V.append((8.97,-40.04,8.43))
Interior1V.append((8.27,-42.87,10.02))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((8.71,-42.23,10.94))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((12.76,-42.11,8.76))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((12.76,-42.11,8.76))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((14.46,-39.97,6.87))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((14.23,-40.88,5.80))
Interior1V.append((14.46,-39.97,6.87))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((14.23,-40.88,5.80))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((14.23,-40.88,5.80))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((18.32,-38.93,7.20))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((17.27,-44.51,5.02))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((18.54,-42.04,3.70))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((17.27,-44.51,5.02))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((17.27,-44.51,5.02))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((15.18,-43.08,2.29))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((15.18,-43.08,2.29))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((15.18,-43.08,2.29))
Interior1V.append((10.85,-48.09,-.07))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((10.85,-48.09,-.07))
Interior1V.append((16.95,-45.63,.12))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((15.25,-46.10,-2.57))
Interior1V.append((15.56,-46.49,2.42))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((16.95,-45.63,.12))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((15.25,-46.10,-2.57))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((16.64,-47.67,-1.26))
Interior1V.append((15.25,-46.10,-2.57))
Interior1V.append((16.64,-47.67,-1.26))
Interior1V.append((15.56,-46.49,2.42))
Interior1V.append((16.95,-45.63,.12))
Interior1V.append((16.64,-47.67,-1.26))
Interior1V.append((16.95,-45.63,.12))
Interior1V.append((15.25,-46.10,-2.57))
Interior1V.append((15.56,-46.49,2.42))
Interior1V.append((16.64,-47.67,-1.26))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((16.64,-47.67,-1.26))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((19.40,-48.89,3.71))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((17.24,-54.24,3.51))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((16.21,-53.20,1.92))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((16.21,-53.20,1.92))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((19.40,-48.89,3.71))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((16.21,-53.20,1.92))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((10.28,-43.82,5.66))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((10.28,-43.82,5.66))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((13.73,-45.98,7.13))
Interior1V.append((13.10,-45.10,7.14))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((13.10,-45.10,7.14))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((13.73,-45.98,7.13))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((15.25,-49.45,8.70))
Interior1V.append((13.73,-45.98,7.13))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((12.76,-50.26,10.29))
Interior1V.append((15.25,-49.45,8.70))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((13.73,-45.98,7.13))
Interior1V.append((15.25,-49.45,8.70))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((15.25,-49.45,8.70))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((15.25,-49.45,8.70))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((13.73,-45.98,7.13))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((17.27,-44.51,5.02))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((19.41,-45.90,5.07))
Interior1V.append((17.27,-44.51,5.02))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((19.25,-49.40,8.57))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((19.41,-45.90,5.07))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((19.41,-45.90,5.07))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((19.25,-49.40,8.57))
Interior1V.append((16.41,-45.99,7.00))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((19.25,-49.40,8.57))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((16.49,-50.20,15.43))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((15.07,-50.36,13.30))
Interior1V.append((16.49,-50.20,15.43))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((15.07,-50.36,13.30))
Interior1V.append((15.24,-50.78,6.35))
Interior1V.append((17.34,-49.24,6.89))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((15.24,-50.78,6.35))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((17.34,-49.24,6.89))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((16.54,-53.37,9.45))
Interior1V.append((15.86,-51.10,8.82))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((15.86,-51.10,8.82))
Interior1V.append((15.24,-50.78,6.35))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((15.86,-51.10,8.82))
Interior1V.append((16.54,-53.37,9.45))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((15.24,-50.78,6.35))
Interior1V.append((15.86,-51.10,8.82))
Interior1V.append((23.62,-53.37,11.17))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((25.48,-50.76,8.66))
Interior1V.append((23.62,-53.37,11.17))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((23.62,-53.37,11.17))
Interior1V.append((25.48,-50.76,8.66))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((19.95,-59.55,5.98))
Interior1V.append((21.79,-57.99,6.84))
Interior1V.append((19.87,-62.23,3.10))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((19.87,-62.23,3.10))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((19.95,-59.55,5.98))
Interior1V.append((19.87,-62.23,3.10))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((21.79,-57.99,6.84))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((21.79,-57.99,6.84))
Interior1V.append((19.95,-59.55,5.98))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((19.95,-59.55,5.98))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((18.08,-58.39,-1.72))
Interior1V.append((15.20,-58.43,3.92))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((17.89,-61.67,1.60))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((17.89,-61.67,1.60))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((18.98,-61.12,.17))
Interior1V.append((17.89,-61.67,1.60))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((15.20,-58.43,3.92))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((15.34,-58.56,.47))
Interior1V.append((15.35,-60.75,3.17))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((15.20,-58.43,3.92))
Interior1V.append((15.35,-60.75,3.17))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((15.35,-60.75,3.17))
Interior1V.append((15.20,-58.43,3.92))
Interior1V.append((18.12,-60.66,3.89))
Interior1V.append((14.63,-55.19,9.08))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((16.54,-53.37,9.45))
Interior1V.append((14.63,-55.19,9.08))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((17.91,-54.82,7.31))
Interior1V.append((17.40,-55.65,7.50))
Interior1V.append((16.54,-53.37,9.45))
Interior1V.append((17.91,-54.82,7.31))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((17.40,-55.65,7.50))
Interior1V.append((17.40,-55.65,7.50))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((14.63,-55.19,9.08))
Interior1V.append((17.40,-55.65,7.50))
Interior1V.append((14.63,-55.19,9.08))
Interior1V.append((16.54,-53.37,9.45))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((17.91,-54.82,7.31))
Interior1V.append((17.91,-54.82,7.31))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((17.91,-54.82,7.31))
Interior1V.append((16.54,-53.37,9.45))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((15.24,-50.78,6.35))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((13.43,-52.87,5.45))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((13.43,-52.87,5.45))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((12.19,-53.16,3.95))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((13.43,-52.87,5.45))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((13.43,-52.87,5.45))
Interior1V.append((12.19,-53.16,3.95))
Interior1V.append((13.43,-52.87,5.45))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((13.43,-52.87,5.45))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((13.43,-52.87,5.45))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((16.21,-53.20,1.92))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((16.21,-53.20,1.92))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((10.59,-52.71,4.10))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((10.59,-52.71,4.10))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((11.23,-52.97,6.85))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((10.59,-52.71,4.10))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((9.03,-48.85,-1.61))
Interior1V.append((10.85,-48.09,-.07))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((6.16,-49.03,-.51))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((5.84,-48.60,.29))
Interior1V.append((6.16,-49.03,-.51))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((6.44,-48.43,-3.51))
Interior1V.append((6.16,-49.03,-.51))
Interior1V.append((6.44,-48.43,-3.51))
Interior1V.append((5.07,-47.63,-1.49))
Interior1V.append((6.16,-49.03,-.51))
Interior1V.append((9.03,-48.85,-1.61))
Interior1V.append((9.42,-47.17,-1.79))
Interior1V.append((6.16,-49.03,-.51))
Interior1V.append((5.84,-48.60,.29))
Interior1V.append((9.03,-48.85,-1.61))
Interior1V.append((10.83,-53.43,-1.00))
Interior1V.append((11.09,-53.62,-4.02))
Interior1V.append((10.65,-51.99,-1.99))
Interior1V.append((11.30,-49.56,-1.00))
Interior1V.append((12.61,-52.59,1.53))
Interior1V.append((10.65,-51.99,-1.99))
Interior1V.append((11.30,-49.56,-1.00))
Interior1V.append((14.09,-51.70,1.03))
Interior1V.append((12.61,-52.59,1.53))
Interior1V.append((10.83,-53.43,-1.00))
Interior1V.append((10.65,-51.99,-1.99))
Interior1V.append((12.61,-52.59,1.53))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((12.61,-52.59,1.53))
Interior1V.append((14.09,-51.70,1.03))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((10.83,-53.43,-1.00))
Interior1V.append((12.61,-52.59,1.53))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((14.09,-51.70,1.03))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((10.91,-54.20,3.08))
Interior1V.append((12.19,-53.16,3.95))
Interior1V.append((11.55,-55.41,5.06))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((11.55,-55.41,5.06))
Interior1V.append((12.19,-53.16,3.95))
Interior1V.append((11.60,-55.72,1.23))
Interior1V.append((12.19,-53.16,3.95))
Interior1V.append((10.91,-54.20,3.08))
Interior1V.append((11.60,-55.72,1.23))
Interior1V.append((10.91,-54.20,3.08))
Interior1V.append((11.55,-55.41,5.06))
Interior1V.append((11.60,-55.72,1.23))
Interior1V.append((11.55,-55.41,5.06))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((11.12,-55.64,-1.25))
Interior1V.append((10.83,-53.43,-1.00))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((11.12,-55.64,-1.25))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((15.25,-54.80,-2.90))
Interior1V.append((15.25,-54.80,-2.90))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((13.27,-55.47,-4.15))
Interior1V.append((10.83,-53.43,-1.00))
Interior1V.append((11.12,-55.64,-1.25))
Interior1V.append((13.27,-55.47,-4.15))
Interior1V.append((11.12,-55.64,-1.25))
Interior1V.append((15.25,-54.80,-2.90))
Interior1V.append((14.26,-53.78,-4.47))
Interior1V.append((13.27,-55.47,-4.15))
Interior1V.append((15.25,-54.80,-2.90))
Interior1V.append((11.60,-57.77,1.23))
Interior1V.append((11.60,-55.72,1.23))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((11.60,-57.77,1.23))
Interior1V.append((12.53,-56.81,-1.01))
Interior1V.append((11.60,-55.72,1.23))
Interior1V.append((12.01,-58.36,.54))
Interior1V.append((11.60,-57.77,1.23))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((12.01,-58.36,.54))
Interior1V.append((12.53,-56.81,-1.01))
Interior1V.append((11.60,-57.77,1.23))
Interior1V.append((15.34,-58.56,.47))
Interior1V.append((12.01,-58.36,.54))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((15.34,-58.56,.47))
Interior1V.append((12.53,-56.81,-1.01))
Interior1V.append((12.01,-58.36,.54))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((15.20,-58.43,3.92))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((15.20,-58.43,3.92))
Interior1V.append((15.34,-58.56,.47))
Interior1V.append((12.61,-56.67,7.10))
Interior1V.append((11.55,-55.41,5.06))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((12.61,-56.67,7.10))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((11.55,-55.41,5.06))
Interior1V.append((13.60,-58.46,4.72))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((12.61,-56.67,7.10))
Interior1V.append((16.28,-56.68,6.16))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((16.28,-56.68,6.16))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((13.60,-58.46,4.72))
Interior1V.append((16.28,-56.68,6.16))
Interior1V.append((12.61,-56.67,7.10))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((16.28,-56.68,6.16))
Interior1V.append((13.60,-58.46,4.72))
Interior1V.append((12.61,-56.67,7.10))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((17.24,-54.24,3.51))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((17.24,-54.24,3.51))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((20.49,-52.81,6.18))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((20.49,-52.81,6.18))
Interior1V.append((22.72,-53.26,6.01))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((20.49,-52.81,6.18))
Interior1V.append((19.40,-48.89,3.71))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((19.40,-48.89,3.71))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((20.99,-50.69,7.89))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((22.23,-51.55,5.75))
Interior1V.append((20.99,-50.69,7.89))
Interior1V.append((24.94,-44.92,5.52))
Interior1V.append((23.46,-46.83,3.93))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((24.94,-44.92,5.52))
Interior1V.append((22.43,-45.36,5.39))
Interior1V.append((23.46,-46.83,3.93))
Interior1V.append((25.48,-50.76,8.66))
Interior1V.append((24.94,-44.92,5.52))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((22.43,-45.36,5.39))
Interior1V.append((24.94,-44.92,5.52))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((24.94,-44.92,5.52))
Interior1V.append((25.48,-50.76,8.66))
Interior1V.append((19.25,-49.40,8.57))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((19.25,-49.40,8.57))
Interior1V.append((22.99,-50.95,8.06))
Interior1V.append((20.99,-50.69,7.89))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((22.43,-45.36,5.39))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((19.41,-45.90,5.07))
Interior1V.append((22.43,-45.36,5.39))
Interior1V.append((22.43,-45.36,5.39))
Interior1V.append((19.41,-45.90,5.07))
Interior1V.append((21.43,-47.26,4.11))
Interior1V.append((23.47,-45.39,-1.63))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((23.47,-45.39,-1.63))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((23.47,-45.39,-1.63))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((25.51,-46.88,-2.03))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((23.89,-45.60,-4.44))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((25.51,-46.88,-2.03))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((21.11,-49.26,-3.61))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((26.53,-48.51,-1.24))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((25.51,-46.88,-2.03))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((24.50,-51.41,-6.03))
Interior1V.append((21.11,-49.26,-3.61))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((21.11,-49.26,-3.61))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((24.50,-51.41,-6.03))
Interior1V.append((26.53,-48.51,-1.24))
Interior1V.append((25.51,-46.88,-2.03))
Interior1V.append((28.13,-49.15,-1.72))
Interior1V.append((24.50,-51.41,-6.03))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((28.13,-49.15,-1.72))
Interior1V.append((26.53,-48.51,-1.24))
Interior1V.append((24.50,-51.41,-6.03))
Interior1V.append((27.97,-46.12,-5.31))
Interior1V.append((23.89,-45.60,-4.44))
Interior1V.append((24.22,-52.40,-8.41))
Interior1V.append((27.97,-46.12,-5.31))
Interior1V.append((24.22,-52.40,-8.41))
Interior1V.append((24.50,-51.41,-6.03))
Interior1V.append((21.11,-49.26,-3.61))
Interior1V.append((24.22,-52.40,-8.41))
Interior1V.append((23.89,-45.60,-4.44))
Interior1V.append((21.11,-49.26,-3.61))
Interior1V.append((24.50,-51.41,-6.03))
Interior1V.append((24.22,-52.40,-8.41))
Interior1V.append((27.97,-46.12,-5.31))
Interior1V.append((24.50,-51.41,-6.03))
Interior1V.append((25.51,-46.88,-2.03))
Interior1V.append((27.97,-46.12,-5.31))
Interior1V.append((25.51,-46.88,-2.03))
Interior1V.append((23.89,-45.60,-4.44))
Interior1V.append((24.78,-29.29,-4.51))
Interior1V.append((19.82,-24.64,-6.40))
Interior1V.append((20.04,-31.17,-4.95))
Interior1V.append((24.78,-29.29,-4.51))
Interior1V.append((20.04,-31.17,-4.95))
Interior1V.append((23.15,-28.85,-2.21))
Interior1V.append((17.91,-26.79,-5.02))
Interior1V.append((20.04,-31.17,-4.95))
Interior1V.append((19.82,-24.64,-6.40))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((19.82,-24.64,-6.40))
Interior1V.append((24.78,-29.29,-4.51))
Interior1V.append((26.41,-29.80,-2.79))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((24.78,-29.29,-4.51))
Interior1V.append((26.41,-29.80,-2.79))
Interior1V.append((24.78,-29.29,-4.51))
Interior1V.append((23.15,-28.85,-2.21))
Interior1V.append((26.41,-29.80,-2.79))
Interior1V.append((23.15,-28.85,-2.21))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((21.54,-40.66,4.57))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((21.54,-40.66,4.57))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((21.54,-40.66,4.57))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((25.13,-42.54,4.88))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((25.00,-39.00,3.00))
Interior1V.append((25.13,-42.54,4.88))
Interior1V.append((22.59,-40.79,4.36))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((25.13,-42.54,4.88))
Interior1V.append((25.00,-39.00,3.00))
Interior1V.append((22.59,-40.79,4.36))
Interior1V.append((19.50,-46.27,2.09))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((19.50,-46.27,2.09))
Interior1V.append((20.52,-44.40,-.61))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((20.52,-44.40,-.61))
Interior1V.append((20.52,-44.40,-.61))
Interior1V.append((19.75,-47.76,-2.90))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((18.80,-46.00,-2.32))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((19.75,-47.76,-2.90))
Interior1V.append((18.80,-46.00,-2.32))
Interior1V.append((19.75,-47.76,-2.90))
Interior1V.append((20.52,-44.40,-.61))
Interior1V.append((18.09,-46.29,-1.68))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((18.80,-46.00,-2.32))
Interior1V.append((18.09,-46.29,-1.68))
Interior1V.append((18.80,-46.00,-2.32))
Interior1V.append((20.52,-44.40,-.61))
Interior1V.append((18.09,-46.29,-1.68))
Interior1V.append((19.50,-46.27,2.09))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((18.09,-46.29,-1.68))
Interior1V.append((20.52,-44.40,-.61))
Interior1V.append((19.50,-46.27,2.09))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((15.67,-41.28,.58))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((18.54,-42.04,3.70))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((16.60,-44.09,1.96))
Interior1V.append((16.95,-45.63,.12))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((16.60,-44.09,1.96))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((16.95,-45.63,.12))
Interior1V.append((16.60,-44.09,1.96))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((15.18,-43.08,2.29))
Interior1V.append((16.60,-44.09,1.96))
Interior1V.append((15.18,-43.08,2.29))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((15.18,-43.08,2.29))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((11.39,-42.64,-4.45))
Interior1V.append((13.20,-43.03,-5.73))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((11.39,-42.64,-4.45))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((15.15,-46.11,-4.38))
Interior1V.append((15.25,-46.10,-2.57))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((15.15,-46.11,-4.38))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((15.62,-43.54,-1.43))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((15.15,-46.11,-4.38))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((20.14,-46.21,-3.67))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((20.14,-46.21,-3.67))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((21.76,-44.25,-4.76))
Interior1V.append((21.76,-44.25,-4.76))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((21.76,-44.25,-4.76))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((20.14,-46.21,-3.67))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((20.14,-46.21,-3.67))
Interior1V.append((21.76,-44.25,-4.76))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((17.42,-47.40,-4.27))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((11.08,-47.05,-10.68))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((11.46,-41.58,-8.04))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((11.46,-41.58,-8.04))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((13.20,-43.03,-5.73))
Interior1V.append((11.88,-40.78,-3.55))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((11.39,-42.64,-4.45))
Interior1V.append((11.88,-40.78,-3.55))
Interior1V.append((11.39,-42.64,-4.45))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((7.97,-38.48,-4.64))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((11.88,-40.78,-3.55))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((7.97,-38.48,-4.64))
Interior1V.append((11.88,-40.78,-3.55))
Interior1V.append((6.97,-40.43,3.99))
Interior1V.append((8.97,-40.95,3.88))
Interior1V.append((8.66,-41.93,3.54))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((8.66,-41.93,3.54))
Interior1V.append((8.97,-40.95,3.88))
Interior1V.append((11.88,-40.78,-3.55))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((11.88,-40.78,-3.55))
Interior1V.append((10.33,-40.48,4.03))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((15.67,-41.28,.58))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((15.67,-41.28,.58))
Interior1V.append((14.31,-38.96,4.22))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((14.31,-38.96,4.22))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((14.17,-40.32,4.48))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((14.17,-40.32,4.48))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((14.31,-38.96,4.22))
Interior1V.append((14.58,-38.66,6.58))
Interior1V.append((14.17,-40.32,4.48))
Interior1V.append((14.31,-38.96,4.22))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((14.17,-40.32,4.48))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((14.23,-40.88,5.80))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((14.17,-40.32,4.48))
Interior1V.append((14.23,-40.88,5.80))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((13.99,-40.94,3.61))
Interior1V.append((16.77,-43.10,3.31))
Interior1V.append((15.67,-41.28,.58))
Interior1V.append((14.17,-40.32,4.48))
Interior1V.append((14.46,-39.97,6.87))
Interior1V.append((14.23,-40.88,5.80))
Interior1V.append((14.51,-38.10,5.29))
Interior1V.append((14.58,-38.66,6.58))
Interior1V.append((14.31,-38.96,4.22))
Interior1V.append((17.13,-36.64,5.62))
Interior1V.append((14.58,-38.66,6.58))
Interior1V.append((14.51,-38.10,5.29))
Interior1V.append((17.13,-36.64,5.62))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((14.58,-38.66,6.58))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((14.51,-38.10,5.29))
Interior1V.append((14.31,-38.96,4.22))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((17.13,-36.64,5.62))
Interior1V.append((14.51,-38.10,5.29))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((14.31,-38.96,4.22))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((18.54,-42.04,3.70))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((18.23,-38.90,.18))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((18.23,-38.90,.18))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((18.54,-42.04,3.70))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((20.59,-41.44,3.89))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((20.59,-41.44,3.89))
Interior1V.append((20.36,-42.02,.93))
Interior1V.append((18.23,-38.90,.18))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((20.36,-42.02,.93))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((20.59,-41.44,3.89))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((18.54,-42.04,3.70))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((20.36,-42.02,.93))
Interior1V.append((20.59,-41.44,3.89))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((22.37,-38.81,.85))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((22.37,-38.81,.85))
Interior1V.append((20.36,-42.02,.93))
Interior1V.append((20.41,-42.00,-.77))
Interior1V.append((20.36,-42.02,.93))
Interior1V.append((22.37,-38.81,.85))
Interior1V.append((18.44,-40.89,-.26))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((18.23,-38.90,.18))
Interior1V.append((18.44,-40.89,-.26))
Interior1V.append((18.23,-38.90,.18))
Interior1V.append((20.36,-42.02,.93))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((18.23,-38.90,.18))
Interior1V.append((20.97,-36.87,1.20))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((20.97,-36.87,1.20))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((23.17,-38.28,2.32))
Interior1V.append((20.97,-36.87,1.20))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((23.17,-38.28,2.32))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((20.97,-36.87,1.20))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((18.62,-37.05,1.97))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((22.22,-39.85,2.36))
Interior1V.append((20.59,-41.44,3.89))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((22.59,-40.79,4.36))
Interior1V.append((23.17,-38.28,2.32))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((22.59,-40.79,4.36))
Interior1V.append((23.17,-38.28,2.32))
Interior1V.append((22.59,-40.79,4.36))
Interior1V.append((25.00,-39.00,3.00))
Interior1V.append((20.31,-36.77,6.16))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((20.31,-36.77,6.16))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((21.10,-34.61,4.51))
Interior1V.append((20.31,-36.77,6.16))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((21.10,-34.61,4.51))
Interior1V.append((18.91,-36.36,4.28))
Interior1V.append((20.97,-36.87,1.20))
Interior1V.append((21.68,-32.88,5.38))
Interior1V.append((20.31,-36.77,6.16))
Interior1V.append((21.10,-34.61,4.51))
Interior1V.append((21.68,-32.88,5.38))
Interior1V.append((21.10,-34.61,4.51))
Interior1V.append((24.03,-35.84,2.70))
Interior1V.append((24.03,-35.84,2.70))
Interior1V.append((20.97,-36.87,1.20))
Interior1V.append((23.17,-38.28,2.32))
Interior1V.append((24.03,-35.84,2.70))
Interior1V.append((21.10,-34.61,4.51))
Interior1V.append((20.97,-36.87,1.20))
Interior1V.append((20.03,-40.84,-2.28))
Interior1V.append((18.44,-40.89,-.26))
Interior1V.append((20.41,-42.00,-.77))
Interior1V.append((20.03,-40.84,-2.28))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((18.44,-40.89,-.26))
Interior1V.append((20.03,-40.84,-2.28))
Interior1V.append((20.41,-42.00,-.77))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((21.17,-35.96,-5.02))
Interior1V.append((22.40,-39.11,-6.24))
Interior1V.append((18.65,-37.13,-4.76))
Interior1V.append((21.17,-35.96,-5.02))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((22.40,-39.11,-6.24))
Interior1V.append((21.17,-35.96,-5.02))
Interior1V.append((18.65,-37.13,-4.76))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((20.59,-38.88,-4.54))
Interior1V.append((22.40,-39.11,-6.24))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((20.59,-38.88,-4.54))
Interior1V.append((18.65,-37.13,-4.76))
Interior1V.append((22.40,-39.11,-6.24))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((22.40,-39.11,-6.24))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((20.59,-38.88,-4.54))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((18.65,-37.13,-4.76))
Interior1V.append((20.59,-38.88,-4.54))
Interior1V.append((17.80,-36.85,-3.20))
Interior1V.append((18.65,-37.13,-4.76))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((13.33,-39.94,-6.26))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((18.65,-37.13,-4.76))
Interior1V.append((17.80,-36.85,-3.20))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((11.60,-39.90,-7.63))
Interior1V.append((13.33,-39.94,-6.26))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((11.60,-39.90,-7.63))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((13.33,-39.94,-6.26))
Interior1V.append((9.27,-37.31,-10.60))
Interior1V.append((11.60,-39.90,-7.63))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((9.27,-37.31,-10.60))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((9.27,-37.31,-10.60))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((11.60,-39.90,-7.63))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((13.20,-43.03,-5.73))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((18.72,-40.43,-3.47))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((20.22,-41.00,-4.03))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((18.72,-40.43,-3.47))
Interior1V.append((20.22,-41.00,-4.03))
Interior1V.append((18.72,-40.43,-3.47))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((20.22,-41.00,-4.03))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((20.22,-41.00,-4.03))
Interior1V.append((13.91,-41.16,-7.44))
Interior1V.append((21.76,-44.25,-4.76))
Interior1V.append((20.22,-41.00,-4.03))
Interior1V.append((21.76,-44.25,-4.76))
Interior1V.append((16.46,-45.21,-3.53))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((24.34,-48.73,2.89))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((24.34,-48.73,2.89))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((26.53,-48.51,-1.24))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((20.97,-52.22,-2.75))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((20.97,-52.22,-2.75))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((18.38,-52.46,-1.93))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((20.97,-52.22,-2.75))
Interior1V.append((18.38,-52.46,-1.93))
Interior1V.append((20.97,-52.22,-2.75))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((16.08,-57.03,-.29))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((15.34,-58.56,.47))
Interior1V.append((16.08,-57.03,-.29))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((12.53,-56.81,-1.01))
Interior1V.append((15.34,-58.56,.47))
Interior1V.append((16.08,-57.03,-.29))
Interior1V.append((15.34,-58.56,.47))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((16.08,-57.03,-.29))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((-2.81,-56.59,-3.78))
Interior1V.append((-4.38,-59.22,-4.41))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-2.81,-56.59,-3.78))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-4.36,-58.84,-6.84))
Interior1V.append((-2.81,-56.59,-3.78))
Interior1V.append((-4.36,-58.84,-6.84))
Interior1V.append((-4.38,-59.22,-4.41))
Interior1V.append((-6.17,-60.13,2.32))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-6.68,-59.45,3.22))
Interior1V.append((-6.17,-60.13,2.32))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-6.17,-60.13,2.32))
Interior1V.append((-6.68,-59.45,3.22))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-9.09,-56.87,2.58))
Interior1V.append((-6.68,-59.45,3.22))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-7.08,-56.52,4.41))
Interior1V.append((-6.68,-59.45,3.22))
Interior1V.append((-9.09,-56.87,2.58))
Interior1V.append((-7.08,-56.52,4.41))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-6.68,-59.45,3.22))
Interior1V.append((-7.96,-54.76,2.60))
Interior1V.append((-7.08,-56.52,4.41))
Interior1V.append((-9.09,-56.87,2.58))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-7.96,-54.76,2.60))
Interior1V.append((-9.09,-56.87,2.58))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-9.09,-56.87,2.58))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-9.09,-56.87,2.58))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-14.63,-52.00,1.82))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-13.51,-53.03,2.70))
Interior1V.append((-15.47,-58.77,6.33))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-16.66,-57.45,6.22))
Interior1V.append((-13.30,-53.09,.81))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-14.63,-52.00,1.82))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-13.30,-53.09,.81))
Interior1V.append((-14.63,-52.00,1.82))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-14.63,-52.00,1.82))
Interior1V.append((-21.15,-49.92,.40))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-21.15,-49.92,.40))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-21.04,-47.73,1.51))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-21.15,-49.92,.40))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-21.04,-47.73,1.51))
Interior1V.append((-21.15,-49.92,.40))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-21.15,-49.92,.40))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-13.92,-44.12,-2.76))
Interior1V.append((-15.66,-44.62,-2.50))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-17.30,-43.21,-4.02))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-17.30,-43.21,-4.02))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-15.66,-44.62,-2.50))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-17.30,-43.21,-4.02))
Interior1V.append((-15.66,-44.62,-2.50))
Interior1V.append((-23.75,-46.19,-1.98))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-17.30,-43.21,-4.02))
Interior1V.append((-13.92,-44.12,-2.76))
Interior1V.append((-15.63,-42.75,-.95))
Interior1V.append((-15.66,-44.62,-2.50))
Interior1V.append((-13.92,-44.12,-2.76))
Interior1V.append((-12.35,-44.05,.17))
Interior1V.append((-15.63,-42.75,-.95))
Interior1V.append((-8.36,-45.28,-2.24))
Interior1V.append((-12.35,-44.05,.17))
Interior1V.append((-13.92,-44.12,-2.76))
Interior1V.append((-8.36,-45.28,-2.24))
Interior1V.append((-11.68,-45.76,1.49))
Interior1V.append((-12.35,-44.05,.17))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-11.68,-45.76,1.49))
Interior1V.append((-8.36,-45.28,-2.24))
Interior1V.append((-10.21,-47.86,3.13))
Interior1V.append((-11.68,-45.76,1.49))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-10.69,-45.44,3.60))
Interior1V.append((-11.68,-45.76,1.49))
Interior1V.append((-10.21,-47.86,3.13))
Interior1V.append((-10.21,-47.86,3.13))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-10.47,-48.53,5.50))
Interior1V.append((-10.21,-47.86,3.13))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-10.47,-48.53,5.50))
Interior1V.append((-10.69,-45.44,3.60))
Interior1V.append((-10.21,-47.86,3.13))
Interior1V.append((-10.47,-48.53,5.50))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-11.14,-49.37,7.20))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-10.47,-48.53,5.50))
Interior1V.append((-11.14,-49.37,7.20))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-11.14,-49.37,7.20))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-10.44,-46.55,7.47))
Interior1V.append((-10.88,-47.34,9.04))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-10.44,-46.55,7.47))
Interior1V.append((-9.12,-46.01,9.98))
Interior1V.append((-10.88,-47.34,9.04))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-9.12,-46.01,9.98))
Interior1V.append((-10.44,-46.55,7.47))
Interior1V.append((-9.20,-45.97,5.15))
Interior1V.append((-10.44,-46.55,7.47))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-9.20,-45.97,5.15))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-10.44,-46.55,7.47))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-9.12,-46.01,9.98))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-9.12,-46.01,9.98))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-7.71,-44.13,5.77))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-9.20,-45.97,5.15))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-7.71,-44.13,5.77))
Interior1V.append((-9.20,-45.97,5.15))
Interior1V.append((-7.11,-48.71,5.04))
Interior1V.append((-9.20,-45.97,5.15))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-7.11,-48.71,5.04))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-7.11,-48.71,5.04))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-7.11,-48.71,5.04))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-6.92,-48.11,3.80))
Interior1V.append((-7.11,-48.71,5.04))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-7.11,-48.71,5.04))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-6.92,-48.11,3.80))
Interior1V.append((2.09,-50.60,5.68))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((7.04,-51.99,3.94))
Interior1V.append((4.88,-51.76,2.21))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((1.42,-51.86,2.62))
Interior1V.append((2.09,-50.60,5.68))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((4.31,-53.46,2.31))
Interior1V.append((4.88,-51.76,2.21))
Interior1V.append((1.42,-51.86,2.62))
Interior1V.append((4.31,-53.46,2.31))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((4.88,-51.76,2.21))
Interior1V.append((4.31,-53.46,2.31))
Interior1V.append((1.42,-51.86,2.62))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((1.42,-51.86,2.62))
Interior1V.append((4.88,-51.76,2.21))
Interior1V.append((3.09,-51.12,1.10))
Interior1V.append((.48,-51.30,2.64))
Interior1V.append((2.09,-50.60,5.68))
Interior1V.append((1.42,-51.86,2.62))
Interior1V.append((.48,-51.30,2.64))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((2.09,-50.60,5.68))
Interior1V.append((.48,-51.30,2.64))
Interior1V.append((1.42,-51.86,2.62))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((.48,-51.30,2.64))
Interior1V.append((-.14,-47.62,3.83))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((.48,-51.30,2.64))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((-.14,-47.62,3.83))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((7.04,-51.99,3.94))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((4.15,-51.25,7.08))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((4.15,-51.25,7.08))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((4.15,-51.25,7.08))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((4.96,-52.57,5.20))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((5.20,-46.32,5.44))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((2.78,-48.92,5.50))
Interior1V.append((5.13,-46.92,7.08))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((5.20,-46.32,5.44))
Interior1V.append((7.45,-50.37,1.95))
Interior1V.append((4.88,-51.76,2.21))
Interior1V.append((7.04,-51.99,3.94))
Interior1V.append((5.84,-48.60,.29))
Interior1V.append((4.88,-51.76,2.21))
Interior1V.append((7.45,-50.37,1.95))
Interior1V.append((4.88,-51.76,2.21))
Interior1V.append((5.84,-48.60,.29))
Interior1V.append((3.09,-51.12,1.10))
Interior1V.append((8.73,-51.43,2.67))
Interior1V.append((7.45,-50.37,1.95))
Interior1V.append((7.04,-51.99,3.94))
Interior1V.append((8.73,-51.43,2.67))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((7.45,-50.37,1.95))
Interior1V.append((9.01,-50.83,1.03))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((10.85,-48.09,-.07))
Interior1V.append((9.01,-50.83,1.03))
Interior1V.append((7.45,-50.37,1.95))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((8.73,-51.43,2.67))
Interior1V.append((7.04,-51.99,3.94))
Interior1V.append((10.59,-52.71,4.10))
Interior1V.append((8.73,-51.43,2.67))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((11.23,-52.97,6.85))
Interior1V.append((10.59,-52.71,4.10))
Interior1V.append((8.73,-51.43,2.67))
Interior1V.append((10.59,-52.71,4.10))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((12.49,-49.67,3.02))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((12.49,-49.67,3.02))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((10.85,-48.09,-.07))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((11.48,-49.15,3.84))
Interior1V.append((10.51,-48.86,3.45))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((14.54,-46.83,3.89))
Interior1V.append((12.49,-49.67,3.02))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((14.54,-46.83,3.89))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((12.49,-49.67,3.02))
Interior1V.append((14.54,-46.83,3.89))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((16.44,-47.81,4.47))
Interior1V.append((14.54,-46.83,3.89))
Interior1V.append((15.56,-46.49,2.42))
Interior1V.append((16.44,-47.81,4.47))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((14.54,-46.83,3.89))
Interior1V.append((14.54,-46.83,3.89))
Interior1V.append((14.02,-45.68,2.64))
Interior1V.append((15.56,-46.49,2.42))
Interior1V.append((16.44,-47.81,4.47))
Interior1V.append((15.56,-46.49,2.42))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((16.44,-47.81,4.47))
Interior1V.append((17.83,-48.49,1.82))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((18.54,-42.04,3.70))
Interior1V.append((17.27,-44.51,5.02))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((18.54,-42.04,3.70))
Interior1V.append((19.41,-45.90,5.07))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((17.27,-44.51,5.02))
Interior1V.append((19.41,-45.90,5.07))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((18.32,-38.93,7.20))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((18.32,-38.93,7.20))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((15.28,-37.73,9.31))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((18.32,-38.93,7.20))
Interior1V.append((15.28,-37.73,9.31))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((18.65,-36.93,8.51))
Interior1V.append((15.28,-37.73,9.31))
Interior1V.append((18.32,-38.93,7.20))
Interior1V.append((18.65,-36.93,8.51))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((15.28,-37.73,9.31))
Interior1V.append((13.77,-32.96,9.52))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((13.77,-32.96,9.52))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((13.30,-33.87,8.85))
Interior1V.append((13.77,-32.96,9.52))
Interior1V.append((13.30,-33.87,8.85))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((10.36,-37.20,10.82))
Interior1V.append((13.30,-33.87,8.85))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((10.36,-37.20,10.82))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((13.30,-33.87,8.85))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((10.18,-43.00,13.97))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((10.18,-43.00,13.97))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((10.18,-43.00,13.97))
Interior1V.append((8.67,-44.72,13.88))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((8.67,-44.72,13.88))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((10.90,-45.09,12.55))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((13.47,-49.04,15.00))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((16.49,-50.20,15.43))
Interior1V.append((13.47,-49.04,15.00))
Interior1V.append((16.49,-50.20,15.43))
Interior1V.append((15.07,-50.36,13.30))
Interior1V.append((19.25,-53.20,-4.91))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((19.25,-53.20,-4.91))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((19.25,-53.20,-4.91))
Interior1V.append((19.26,-50.72,-4.90))
Interior1V.append((20.89,-54.57,-6.97))
Interior1V.append((19.25,-53.20,-4.91))
Interior1V.append((20.89,-54.57,-6.97))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((18.28,-53.43,-2.12))
Interior1V.append((20.97,-52.22,-2.75))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((18.28,-53.43,-2.12))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((20.97,-52.22,-2.75))
Interior1V.append((18.28,-53.43,-2.12))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((18.88,-54.10,-3.16))
Interior1V.append((17.25,-54.93,-1.19))
Interior1V.append((18.61,-55.32,-3.43))
Interior1V.append((18.88,-54.10,-3.16))
Interior1V.append((18.61,-55.32,-3.43))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((18.88,-54.10,-3.16))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((17.25,-54.93,-1.19))
Interior1V.append((18.08,-58.39,-1.72))
Interior1V.append((18.61,-55.32,-3.43))
Interior1V.append((17.25,-54.93,-1.19))
Interior1V.append((20.81,-55.26,-4.77))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((18.61,-55.32,-3.43))
Interior1V.append((17.37,-58.85,-3.20))
Interior1V.append((18.61,-55.32,-3.43))
Interior1V.append((18.08,-58.39,-1.72))
Interior1V.append((20.81,-55.26,-4.77))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((17.37,-58.85,-3.20))
Interior1V.append((18.08,-58.39,-1.72))
Interior1V.append((17.53,-59.08,-6.11))
Interior1V.append((17.37,-58.85,-3.20))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((17.53,-59.08,-6.11))
Interior1V.append((19.72,-61.58,-1.30))
Interior1V.append((20.81,-55.26,-4.77))
Interior1V.append((17.53,-59.08,-6.11))
Interior1V.append((18.61,-55.32,-3.43))
Interior1V.append((17.37,-58.85,-3.20))
Interior1V.append((17.53,-59.08,-6.11))
Interior1V.append((20.81,-55.26,-4.77))
Interior1V.append((18.61,-55.32,-3.43))
Interior1V.append((-18.95,-66.40,7.13))
Interior1V.append((-15.37,-65.01,6.92))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-18.95,-66.40,7.13))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-15.37,-65.01,6.92))
Interior1V.append((-18.95,-66.40,7.13))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-13.35,-62.81,5.33))
Interior1V.append((-16.39,-60.48,5.16))
Interior1V.append((-15.47,-58.77,6.33))
Interior1V.append((-11.82,-61.65,6.21))
Interior1V.append((-13.09,-62.29,4.02))
Interior1V.append((-13.35,-62.81,5.33))
Interior1V.append((-11.82,-61.65,6.21))
Interior1V.append((-13.35,-62.81,5.33))
Interior1V.append((-15.47,-58.77,6.33))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-13.35,-62.81,5.33))
Interior1V.append((-13.09,-62.29,4.02))
Interior1V.append((-14.34,-63.80,5.55))
Interior1V.append((-13.35,-62.81,5.33))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-14.34,-63.80,5.55))
Interior1V.append((-16.39,-60.48,5.16))
Interior1V.append((-13.35,-62.81,5.33))
Interior1V.append((-13.38,-62.93,3.36))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-13.09,-62.29,4.02))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-13.38,-62.93,3.36))
Interior1V.append((-13.09,-62.29,4.02))
Interior1V.append((-16.39,-60.48,5.16))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-13.38,-62.93,3.36))
Interior1V.append((-12.82,-64.79,-1.03))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-13.38,-62.93,3.36))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-12.82,-64.79,-1.03))
Interior1V.append((-12.60,-64.63,-.11))
Interior1V.append((-13.38,-62.93,3.36))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-12.60,-64.63,-.11))
Interior1V.append((-12.82,-64.79,-1.03))
Interior1V.append((-13.38,-62.93,3.36))
Interior1V.append((-12.60,-64.63,-.11))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-12.82,-64.79,-1.03))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((.70,-53.25,15.72))
Interior1V.append((2.94,-54.44,14.79))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((2.94,-54.44,14.79))
Interior1V.append((4.80,-51.83,15.64))
Interior1V.append((1.68,-48.54,15.87))
Interior1V.append((-.68,-48.73,17.85))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((-1.86,-48.85,15.82))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((-.68,-48.73,17.85))
Interior1V.append((-1.86,-48.85,15.82))
Interior1V.append((-.68,-48.73,17.85))
Interior1V.append((-.84,-52.51,16.92))
Interior1V.append((-1.86,-48.85,15.82))
Interior1V.append((-.84,-52.51,16.92))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((-.84,-52.51,16.92))
Interior1V.append((-.68,-48.73,17.85))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((-.84,-52.51,16.92))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((2.03,-49.70,27.15))
Interior1V.append((9.32,-53.73,23.48))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((-1.15,-52.02,27.65))
Interior1V.append((-.51,-52.75,25.34))
Interior1V.append((2.03,-49.70,27.15))
Interior1V.append((-1.15,-52.02,27.65))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((-.51,-52.75,25.34))
Interior1V.append((-1.15,-52.02,27.65))
Interior1V.append((2.03,-49.70,27.15))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((10.45,-47.75,13.16))
Interior1V.append((10.90,-45.09,12.55))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((11.20,-49.16,10.90))
Interior1V.append((10.45,-47.75,13.16))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((10.90,-45.09,12.55))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((15.07,-50.36,13.30))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((18.72,-49.51,10.85))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((16.60,-48.60,10.51))
Interior1V.append((16.49,-50.20,15.43))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((13.66,-37.35,10.62))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((13.66,-37.35,10.62))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((12.94,-38.13,9.96))
Interior1V.append((14.66,-40.41,7.83))
Interior1V.append((12.94,-38.13,9.96))
Interior1V.append((12.76,-42.11,8.76))
Interior1V.append((11.74,-38.94,4.42))
Interior1V.append((14.04,-36.27,4.41))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((11.74,-38.94,4.42))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((14.04,-36.27,4.41))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((11.74,-38.94,4.42))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((11.74,-38.94,4.42))
Interior1V.append((9.15,-34.07,-3.21))
Interior1V.append((10.03,-34.43,-3.54))
Interior1V.append((9.18,-33.23,-2.67))
Interior1V.append((7.05,-33.76,-1.87))
Interior1V.append((9.18,-33.23,-2.67))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((9.18,-33.23,-2.67))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((13.21,-30.99,.75))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((11.54,-35.39,6.33))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((11.54,-35.39,6.33))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((11.54,-35.39,6.33))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((11.39,-31.91,5.89))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((14.04,-36.27,4.41))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((16.19,-34.90,4.09))
Interior1V.append((14.04,-36.27,4.41))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((16.07,-34.54,2.92))
Interior1V.append((15.77,-32.34,4.03))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((16.07,-34.54,2.92))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((14.04,-36.27,4.41))
Interior1V.append((16.07,-34.54,2.92))
Interior1V.append((16.19,-34.90,4.09))
Interior1V.append((15.77,-32.34,4.03))
Interior1V.append((16.07,-34.54,2.92))
Interior1V.append((14.04,-36.27,4.41))
Interior1V.append((16.19,-34.90,4.09))
Interior1V.append((16.43,-33.99,5.07))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((15.77,-32.34,4.03))
Interior1V.append((16.43,-33.99,5.07))
Interior1V.append((16.19,-34.90,4.09))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((16.43,-33.99,5.07))
Interior1V.append((15.77,-32.34,4.03))
Interior1V.append((16.19,-34.90,4.09))
Interior1V.append((14.89,-30.89,8.76))
Interior1V.append((11.48,-31.84,9.04))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((14.89,-30.89,8.76))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((9.36,-30.38,8.73))
Interior1V.append((14.89,-30.89,8.76))
Interior1V.append((9.36,-30.38,8.73))
Interior1V.append((11.48,-31.84,9.04))
Interior1V.append((5.43,-26.77,11.96))
Interior1V.append((5.47,-26.82,13.22))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((5.43,-26.77,11.96))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((5.47,-26.82,13.22))
Interior1V.append((5.43,-26.77,11.96))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((5.47,-26.82,13.22))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((4.70,-27.88,10.33))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((3.85,-24.93,9.21))
Interior1V.append((4.70,-27.88,10.33))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((3.59,-30.93,8.22))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((3.59,-30.93,8.22))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((2.87,-29.96,8.10))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((3.59,-30.93,8.22))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((1.48,-32.91,7.54))
Interior1V.append((4.27,-32.64,7.47))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((.29,-30.87,8.56))
Interior1V.append((-.41,-33.56,8.79))
Interior1V.append((1.48,-32.91,7.54))
Interior1V.append((.29,-30.87,8.56))
Interior1V.append((1.48,-32.91,7.54))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((1.48,-32.91,7.54))
Interior1V.append((-.41,-33.56,8.79))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((2.40,-33.42,13.26))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((2.16,-30.11,11.04))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((2.40,-33.42,13.26))
Interior1V.append((1.22,-35.10,14.56))
Interior1V.append((2.40,-33.42,13.26))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((1.22,-35.10,14.56))
Interior1V.append((-.45,-37.37,12.54))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((1.22,-35.10,14.56))
Interior1V.append((.84,-32.53,13.90))
Interior1V.append((2.40,-33.42,13.26))
Interior1V.append((-1.41,-34.10,14.93))
Interior1V.append((1.22,-35.10,14.56))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-1.41,-34.10,14.93))
Interior1V.append((.84,-32.53,13.90))
Interior1V.append((1.22,-35.10,14.56))
Interior1V.append((-2.78,-33.67,13.20))
Interior1V.append((-1.41,-34.10,14.93))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-2.78,-33.67,13.20))
Interior1V.append((.84,-32.53,13.90))
Interior1V.append((-1.41,-34.10,14.93))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((-2.78,-33.67,13.20))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((.84,-32.53,13.90))
Interior1V.append((-2.78,-33.67,13.20))
Interior1V.append((-4.85,-35.80,14.88))
Interior1V.append((-4.09,-35.95,16.44))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-4.85,-35.80,14.88))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-7.81,-35.26,14.43))
Interior1V.append((-2.40,-37.44,19.29))
Interior1V.append((-5.14,-35.57,20.67))
Interior1V.append((-2.72,-34.72,19.68))
Interior1V.append((-2.40,-37.44,19.29))
Interior1V.append((-2.72,-34.72,19.68))
Interior1V.append((-4.09,-35.95,16.44))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-4.07,-31.77,19.38))
Interior1V.append((-2.74,-32.29,17.69))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-2.74,-32.29,17.69))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-2.74,-32.29,17.69))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-2.74,-32.29,17.69))
Interior1V.append((-4.07,-31.77,19.38))
Interior1V.append((-4.01,-32.55,13.68))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-2.86,-33.53,19.31))
Interior1V.append((-6.04,-32.45,19.94))
Interior1V.append((-4.07,-31.77,19.38))
Interior1V.append((-2.86,-33.53,19.31))
Interior1V.append((-4.07,-31.77,19.38))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-13.07,-31.95,15.12))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-4.07,-31.77,19.38))
Interior1V.append((-6.04,-32.45,19.94))
Interior1V.append((-7.30,-29.33,22.30))
Interior1V.append((-4.07,-31.77,19.38))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-13.10,-26.69,13.11))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-7.30,-29.33,22.30))
Interior1V.append((-13.10,-26.69,13.11))
Interior1V.append((-7.30,-29.33,22.30))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-4.07,-31.77,19.38))
Interior1V.append((-7.30,-29.33,22.30))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-7.30,-29.33,22.30))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-1.78,-29.89,13.66))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-1.78,-29.89,13.66))
Interior1V.append((-2.36,-27.43,21.39))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-2.36,-27.43,21.39))
Interior1V.append((-1.78,-29.89,13.66))
Interior1V.append((-3.37,-29.73,20.62))
Interior1V.append((.35,-26.33,13.52))
Interior1V.append((-2.36,-27.43,21.39))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((.35,-26.33,13.52))
Interior1V.append((-1.78,-29.89,13.66))
Interior1V.append((-2.36,-27.43,21.39))
Interior1V.append((.35,-26.33,13.52))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-1.78,-29.89,13.66))
Interior1V.append((-.51,-22.90,14.17))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((-.51,-22.90,14.17))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-.51,-22.90,14.17))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-8.23,-27.24,23.24))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-13.10,-26.69,13.11))
Interior1V.append((-8.23,-27.24,23.24))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-8.23,-27.24,23.24))
Interior1V.append((-13.10,-26.69,13.11))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-11.64,-34.92,29.04))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-15.55,-38.09,29.32))
Interior1V.append((-15.15,-37.24,26.29))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-11.64,-34.92,29.04))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-14.37,-38.56,25.34))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-15.15,-37.24,26.29))
Interior1V.append((-14.24,-38.78,28.29))
Interior1V.append((-14.37,-38.56,25.34))
Interior1V.append((-15.15,-37.24,26.29))
Interior1V.append((-12.79,-37.79,29.98))
Interior1V.append((-11.64,-34.92,29.04))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-12.79,-37.79,29.98))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-14.24,-38.78,28.29))
Interior1V.append((-15.55,-38.09,29.32))
Interior1V.append((-12.79,-37.79,29.98))
Interior1V.append((-14.24,-38.78,28.29))
Interior1V.append((-15.55,-38.09,29.32))
Interior1V.append((-14.24,-38.78,28.29))
Interior1V.append((-15.15,-37.24,26.29))
Interior1V.append((-14.15,-38.03,31.26))
Interior1V.append((-11.64,-34.92,29.04))
Interior1V.append((-12.79,-37.79,29.98))
Interior1V.append((-14.15,-38.03,31.26))
Interior1V.append((-12.79,-37.79,29.98))
Interior1V.append((-15.55,-38.09,29.32))
Interior1V.append((-14.15,-38.03,31.26))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-11.64,-34.92,29.04))
Interior1V.append((-14.15,-38.03,31.26))
Interior1V.append((-15.55,-38.09,29.32))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-10.91,-40.64,26.94))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-11.59,-41.27,23.61))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-11.59,-41.27,23.61))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-10.91,-40.64,26.94))
Interior1V.append((-13.94,-41.85,25.59))
Interior1V.append((-10.91,-40.64,26.94))
Interior1V.append((-11.59,-41.27,23.61))
Interior1V.append((-14.24,-38.78,28.29))
Interior1V.append((-13.94,-41.85,25.59))
Interior1V.append((-14.37,-38.56,25.34))
Interior1V.append((-14.24,-38.78,28.29))
Interior1V.append((-10.91,-40.64,26.94))
Interior1V.append((-13.94,-41.85,25.59))
Interior1V.append((-13.74,-40.16,23.14))
Interior1V.append((-14.37,-38.56,25.34))
Interior1V.append((-13.94,-41.85,25.59))
Interior1V.append((-13.74,-40.16,23.14))
Interior1V.append((-13.94,-41.85,25.59))
Interior1V.append((-11.59,-41.27,23.61))
Interior1V.append((-13.74,-40.16,23.14))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-14.37,-38.56,25.34))
Interior1V.append((-13.74,-40.16,23.14))
Interior1V.append((-11.59,-41.27,23.61))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((-.32,-50.24,21.78))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((-.32,-50.24,21.78))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((-.24,-50.91,21.05))
Interior1V.append((-.32,-50.24,21.78))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((-.24,-50.91,21.05))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((-.32,-50.24,21.78))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((1.11,-46.44,21.44))
Interior1V.append((4.11,-46.33,21.99))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((1.11,-46.44,21.44))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((1.11,-46.44,21.44))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((-.24,-50.91,21.05))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((-.24,-50.91,21.05))
Interior1V.append((-.68,-48.73,17.85))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((1.68,-48.54,15.87))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((-.68,-48.73,17.85))
Interior1V.append((1.68,-48.54,15.87))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((-.03,-47.43,19.38))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((1.27,-44.60,21.45))
Interior1V.append((-1.20,-47.03,21.95))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((-4.31,-45.35,19.99))
Interior1V.append((-1.20,-47.03,21.95))
Interior1V.append((-4.31,-45.35,19.99))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-1.20,-47.03,21.95))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((-3.85,-46.07,18.45))
Interior1V.append((-4.31,-45.35,19.99))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-4.31,-45.35,19.99))
Interior1V.append((-3.85,-46.07,18.45))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-4.31,-45.35,19.99))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-4.31,-45.35,19.99))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-4.31,-45.35,19.99))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-1.56,-40.64,22.97))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-11.30,-32.45,25.23))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-12.29,-32.14,26.76))
Interior1V.append((-11.30,-32.45,25.23))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-12.29,-32.14,26.76))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-10.74,-34.38,26.77))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-7.77,-35.21,22.26))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-8.41,-32.68,22.13))
Interior1V.append((-7.77,-35.21,22.26))
Interior1V.append((-6.04,-32.45,19.94))
Interior1V.append((-7.61,-34.58,20.64))
Interior1V.append((-8.41,-32.68,22.13))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-7.61,-34.58,20.64))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-7.61,-34.58,20.64))
Interior1V.append((-7.14,-36.28,19.33))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-7.77,-35.21,22.26))
Interior1V.append((-7.61,-34.58,20.64))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-7.77,-35.21,22.26))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-7.61,-34.58,20.64))
Interior1V.append((-7.77,-35.21,22.26))
Interior1V.append((-8.41,-32.68,22.13))
Interior1V.append((-14.37,-34.02,15.32))
Interior1V.append((-13.07,-31.95,15.12))
Interior1V.append((-15.06,-32.32,16.70))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-14.37,-34.02,15.32))
Interior1V.append((-15.06,-32.32,16.70))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-14.37,-34.02,15.32))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-14.37,-34.02,15.32))
Interior1V.append((-14.11,-38.59,18.55))
Interior1V.append((-15.23,-38.04,18.74))
Interior1V.append((-13.04,-37.99,18.86))
Interior1V.append((-14.11,-38.59,18.55))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-15.23,-38.04,18.74))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-15.23,-38.04,18.74))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-19.25,-36.76,19.52))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-19.25,-36.76,19.52))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-18.24,-31.91,17.51))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-18.24,-31.91,17.51))
Interior1V.append((-19.25,-36.76,19.52))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-18.14,-37.44,19.74))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-18.14,-37.44,19.74))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-18.14,-37.44,19.74))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-18.14,-37.44,19.74))
Interior1V.append((-18.18,-38.95,15.76))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-22.53,-37.60,13.78))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-21.58,-35.18,12.46))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-22.53,-37.60,13.78))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-22.53,-37.60,13.78))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-22.48,-40.47,13.65))
Interior1V.append((-22.99,-41.26,13.12))
Interior1V.append((-6.10,-34.78,-2.60))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-7.50,-34.97,.76))
Interior1V.append((-6.10,-34.78,-2.60))
Interior1V.append((-7.50,-34.97,.76))
Interior1V.append((-8.71,-33.71,-2.23))
Interior1V.append((-5.66,-36.36,-1.86))
Interior1V.append((-6.10,-34.78,-2.60))
Interior1V.append((-8.71,-33.71,-2.23))
Interior1V.append((-5.66,-36.36,-1.86))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-6.10,-34.78,-2.60))
Interior1V.append((-6.63,-36.29,-3.40))
Interior1V.append((-5.66,-36.36,-1.86))
Interior1V.append((-8.71,-33.71,-2.23))
Interior1V.append((-6.63,-36.29,-3.40))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-5.66,-36.36,-1.86))
Interior1V.append((-6.63,-36.29,-3.40))
Interior1V.append((-8.71,-33.71,-2.23))
Interior1V.append((-9.42,-35.69,-4.34))
Interior1V.append((-5.65,-39.57,-2.28))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-6.63,-36.29,-3.40))
Interior1V.append((-9.18,-37.57,-5.41))
Interior1V.append((-9.42,-35.69,-4.34))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-9.18,-37.57,-5.41))
Interior1V.append((-6.63,-36.29,-3.40))
Interior1V.append((-9.42,-35.69,-4.34))
Interior1V.append((-6.34,-39.37,-5.02))
Interior1V.append((-6.63,-36.29,-3.40))
Interior1V.append((-9.18,-37.57,-5.41))
Interior1V.append((-6.34,-39.37,-5.02))
Interior1V.append((-5.65,-39.57,-2.28))
Interior1V.append((-6.63,-36.29,-3.40))
Interior1V.append((-10.26,-40.44,-5.46))
Interior1V.append((-9.18,-37.57,-5.41))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-10.26,-40.44,-5.46))
Interior1V.append((-6.34,-39.37,-5.02))
Interior1V.append((-9.18,-37.57,-5.41))
Interior1V.append((-11.83,-40.73,-3.08))
Interior1V.append((-10.26,-40.44,-5.46))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-11.83,-40.73,-3.08))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-10.26,-40.44,-5.46))
Interior1V.append((-11.83,-40.73,-3.08))
Interior1V.append((-10.55,-42.11,-.23))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-11.83,-40.73,-3.08))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-10.55,-42.11,-.23))
Interior1V.append((-12.49,-41.56,.75))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-13.24,-39.99,.33))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-12.49,-41.56,.75))
Interior1V.append((-13.24,-39.99,.33))
Interior1V.append((-12.49,-41.56,.75))
Interior1V.append((-10.55,-42.11,-.23))
Interior1V.append((-11.22,-38.77,-1.50))
Interior1V.append((-12.49,-41.56,.75))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-10.55,-42.11,-.23))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-12.49,-41.56,.75))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-12.49,-41.56,.75))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-12.41,-43.68,2.70))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-15.56,-41.35,.85))
Interior1V.append((-14.04,-39.97,5.73))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-14.44,-39.43,2.89))
Interior1V.append((-14.04,-39.97,5.73))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-17.07,-42.73,2.50))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-12.41,-43.68,2.70))
Interior1V.append((-17.07,-42.73,2.50))
Interior1V.append((-15.56,-41.35,.85))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-17.15,-43.08,1.48))
Interior1V.append((-15.56,-41.35,.85))
Interior1V.append((-17.07,-42.73,2.50))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-17.15,-43.08,1.48))
Interior1V.append((-17.07,-42.73,2.50))
Interior1V.append((-12.35,-44.05,.17))
Interior1V.append((-12.41,-43.68,2.70))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-12.41,-43.68,2.70))
Interior1V.append((-12.35,-44.05,.17))
Interior1V.append((-11.68,-45.76,1.49))
Interior1V.append((-15.56,-41.35,.85))
Interior1V.append((-17.15,-43.08,1.48))
Interior1V.append((-15.63,-42.75,-.95))
Interior1V.append((-13.40,-41.66,-.89))
Interior1V.append((-15.63,-42.75,-.95))
Interior1V.append((-12.35,-44.05,.17))
Interior1V.append((-13.40,-41.66,-.89))
Interior1V.append((-15.56,-41.35,.85))
Interior1V.append((-15.63,-42.75,-.95))
Interior1V.append((-20.15,-43.74,1.51))
Interior1V.append((-17.15,-43.08,1.48))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-20.15,-43.74,1.51))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-17.15,-43.08,1.48))
Interior1V.append((-21.04,-47.73,1.51))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-20.15,-43.74,1.51))
Interior1V.append((-21.54,-46.22,3.25))
Interior1V.append((-21.04,-47.73,1.51))
Interior1V.append((-20.15,-43.74,1.51))
Interior1V.append((-21.54,-46.22,3.25))
Interior1V.append((-20.15,-43.74,1.51))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-21.54,-46.22,3.25))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-20.59,-45.24,7.42))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-20.59,-45.24,7.42))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-19.63,-46.03,8.84))
Interior1V.append((-20.59,-45.24,7.42))
Interior1V.append((-19.63,-46.03,8.84))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-16.43,-48.17,5.59))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-21.54,-46.22,3.25))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-21.54,-46.22,3.25))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-21.30,-49.50,6.96))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-22.48,-49.44,4.61))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-22.48,-49.44,4.61))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-22.48,-49.44,4.61))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-21.04,-47.73,1.51))
Interior1V.append((-21.54,-46.22,3.25))
Interior1V.append((-22.80,-51.12,2.77))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-21.15,-49.92,.40))
Interior1V.append((-22.80,-51.12,2.77))
Interior1V.append((-21.15,-49.92,.40))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-21.57,-52.88,5.29))
Interior1V.append((-22.80,-51.12,2.77))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-22.80,-51.12,2.77))
Interior1V.append((-26.07,-53.93,6.94))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-22.80,-51.12,2.77))
Interior1V.append((-19.14,-58.39,6.21))
Interior1V.append((-16.66,-57.45,6.22))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-19.14,-58.39,6.21))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-16.66,-57.45,6.22))
Interior1V.append((-19.14,-58.39,6.21))
Interior1V.append((-18.35,-57.20,8.22))
Interior1V.append((-16.66,-57.45,6.22))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-18.65,-51.92,9.09))
Interior1V.append((-22.09,-51.89,7.49))
Interior1V.append((-21.57,-52.88,5.29))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-22.09,-51.89,7.49))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-18.65,-51.92,9.09))
Interior1V.append((-23.73,-53.31,7.70))
Interior1V.append((-21.57,-52.88,5.29))
Interior1V.append((-22.09,-51.89,7.49))
Interior1V.append((-23.73,-53.31,7.70))
Interior1V.append((-22.09,-51.89,7.49))
Interior1V.append((-22.22,-52.31,9.41))
Interior1V.append((-23.50,-51.74,6.47))
Interior1V.append((-21.57,-52.88,5.29))
Interior1V.append((-23.73,-53.31,7.70))
Interior1V.append((-23.50,-51.74,6.47))
Interior1V.append((-23.73,-53.31,7.70))
Interior1V.append((-26.07,-53.93,6.94))
Interior1V.append((-23.87,-54.56,8.93))
Interior1V.append((-23.73,-53.31,7.70))
Interior1V.append((-22.22,-52.31,9.41))
Interior1V.append((-23.87,-54.56,8.93))
Interior1V.append((-22.54,-53.57,10.99))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-23.87,-54.56,8.93))
Interior1V.append((-22.22,-52.31,9.41))
Interior1V.append((-22.54,-53.57,10.99))
Interior1V.append((-23.03,-57.41,8.84))
Interior1V.append((-23.73,-53.31,7.70))
Interior1V.append((-23.87,-54.56,8.93))
Interior1V.append((-23.03,-57.41,8.84))
Interior1V.append((-23.87,-54.56,8.93))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-23.03,-57.41,8.84))
Interior1V.append((-26.07,-53.93,6.94))
Interior1V.append((-23.73,-53.31,7.70))
Interior1V.append((-23.03,-57.41,8.84))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-24.90,-58.94,8.58))
Interior1V.append((-26.07,-53.93,6.94))
Interior1V.append((-23.03,-57.41,8.84))
Interior1V.append((-24.90,-58.94,8.58))
Interior1V.append((-23.03,-57.41,8.84))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((1.17,-53.02,17.39))
Interior1V.append((2.94,-54.44,14.79))
Interior1V.append((.70,-53.25,15.72))
Interior1V.append((1.17,-53.02,17.39))
Interior1V.append((.70,-53.25,15.72))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((4.20,-53.67,17.93))
Interior1V.append((4.80,-51.83,15.64))
Interior1V.append((2.94,-54.44,14.79))
Interior1V.append((4.20,-53.67,17.93))
Interior1V.append((2.94,-54.44,14.79))
Interior1V.append((1.17,-53.02,17.39))
Interior1V.append((2.12,-53.20,19.65))
Interior1V.append((4.20,-53.67,17.93))
Interior1V.append((1.17,-53.02,17.39))
Interior1V.append((2.12,-53.20,19.65))
Interior1V.append((1.17,-53.02,17.39))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((1.17,-53.02,17.39))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((6.17,-51.20,17.66))
Interior1V.append((4.80,-51.83,15.64))
Interior1V.append((4.20,-53.67,17.93))
Interior1V.append((4.85,-52.73,19.95))
Interior1V.append((6.17,-51.20,17.66))
Interior1V.append((4.20,-53.67,17.93))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((1.68,-48.54,15.87))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((6.78,-44.87,11.97))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((3.14,-43.07,13.80))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((6.78,-44.87,11.97))
Interior1V.append((8.67,-44.72,13.88))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((3.14,-43.07,13.80))
Interior1V.append((3.14,-43.07,13.80))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((3.29,-48.29,13.45))
Interior1V.append((.93,-48.30,12.74))
Interior1V.append((.28,-47.68,13.18))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((.28,-47.68,13.18))
Interior1V.append((3.02,-46.22,14.46))
Interior1V.append((.93,-48.30,12.74))
Interior1V.append((.28,-47.68,13.18))
Interior1V.append((.93,-48.30,12.74))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((-.94,-46.25,12.57))
Interior1V.append((.28,-47.68,13.18))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((-.94,-46.25,12.57))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((.57,-47.39,14.47))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((.28,-47.68,13.18))
Interior1V.append((.57,-47.39,14.47))
Interior1V.append((.28,-47.68,13.18))
Interior1V.append((-.94,-46.25,12.57))
Interior1V.append((.57,-47.39,14.47))
Interior1V.append((-.94,-46.25,12.57))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((-3.16,-46.52,17.56))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-3.85,-46.07,18.45))
Interior1V.append((-3.16,-46.52,17.56))
Interior1V.append((-3.85,-46.07,18.45))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-3.16,-46.52,17.56))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((-3.16,-46.52,17.56))
Interior1V.append((-.99,-47.46,19.44))
Interior1V.append((-1.80,-42.05,7.52))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-.81,-42.55,5.32))
Interior1V.append((-1.80,-42.05,7.52))
Interior1V.append((-.81,-42.55,5.32))
Interior1V.append((-1.93,-42.93,4.86))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-1.80,-42.05,7.52))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-1.80,-42.05,7.52))
Interior1V.append((-1.93,-42.93,4.86))
Interior1V.append((-4.68,-39.83,7.75))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-4.68,-39.83,7.75))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-4.68,-39.83,7.75))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-10.35,-40.96,7.75))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-10.35,-40.96,7.75))
Interior1V.append((-7.00,-39.40,5.26))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-7.00,-39.40,5.26))
Interior1V.append((-10.35,-40.96,7.75))
Interior1V.append((-9.87,-38.21,4.87))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-9.87,-38.21,4.87))
Interior1V.append((-10.35,-40.96,7.75))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-7.00,-39.40,5.26))
Interior1V.append((-9.87,-38.21,4.87))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-10.35,-40.96,7.75))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-8.21,-42.22,3.97))
Interior1V.append((-10.55,-42.66,2.69))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-7.71,-44.13,5.77))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-5.09,-41.71,8.61))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-10.88,-47.34,9.04))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-10.88,-47.34,9.04))
Interior1V.append((-9.12,-46.01,9.98))
Interior1V.append((-6.56,-48.51,11.59))
Interior1V.append((-9.12,-46.01,9.98))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-6.56,-48.51,11.59))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-6.56,-48.51,11.59))
Interior1V.append((-8.74,-49.67,11.48))
Interior1V.append((-9.12,-46.01,9.98))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-11.25,-45.27,10.11))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-12.53,-43.50,13.02))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-12.17,-42.42,10.37))
Interior1V.append((-11.25,-45.27,10.11))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-12.17,-42.42,10.37))
Interior1V.append((-12.53,-43.50,13.02))
Interior1V.append((-11.25,-45.27,10.11))
Interior1V.append((-10.84,-42.06,13.68))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-12.53,-43.50,13.02))
Interior1V.append((-10.84,-42.06,13.68))
Interior1V.append((-12.53,-43.50,13.02))
Interior1V.append((-12.17,-42.42,10.37))
Interior1V.append((-6.55,-44.20,12.58))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-7.00,-44.24,14.64))
Interior1V.append((-6.55,-44.20,12.58))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-6.55,-44.20,12.58))
Interior1V.append((-5.63,-42.17,10.80))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-6.55,-44.20,12.58))
Interior1V.append((-9.62,-39.82,13.57))
Interior1V.append((-6.86,-41.88,15.11))
Interior1V.append((-8.89,-42.32,16.13))
Interior1V.append((-9.62,-39.82,13.57))
Interior1V.append((-8.89,-42.32,16.13))
Interior1V.append((-10.84,-42.06,13.68))
Interior1V.append((-6.95,-41.38,22.03))
Interior1V.append((-5.51,-43.05,21.05))
Interior1V.append((-7.97,-43.00,18.58))
Interior1V.append((-6.95,-41.38,22.03))
Interior1V.append((-7.97,-43.00,18.58))
Interior1V.append((-8.80,-41.16,18.98))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-8.80,-41.16,18.98))
Interior1V.append((-7.97,-43.00,18.58))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-7.97,-43.00,18.58))
Interior1V.append((-5.51,-43.05,21.05))
Interior1V.append((-5.51,-43.05,21.05))
Interior1V.append((-4.23,-39.66,19.78))
Interior1V.append((-5.33,-43.43,19.37))
Interior1V.append((-5.51,-43.05,21.05))
Interior1V.append((-6.95,-41.38,22.03))
Interior1V.append((-4.23,-39.66,19.78))
Interior1V.append((-8.12,-36.28,14.28))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-4.85,-35.80,14.88))
Interior1V.append((-8.12,-36.28,14.28))
Interior1V.append((-4.85,-35.80,14.88))
Interior1V.append((-7.81,-35.26,14.43))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-4.09,-35.95,16.44))
Interior1V.append((-4.85,-35.80,14.88))
Interior1V.append((-11.14,-36.06,12.61))
Interior1V.append((-8.12,-36.28,14.28))
Interior1V.append((-7.81,-35.26,14.43))
Interior1V.append((-11.14,-36.06,12.61))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-8.12,-36.28,14.28))
Interior1V.append((-11.14,-36.06,12.61))
Interior1V.append((-7.81,-35.26,14.43))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-13.75,-38.29,5.89))
Interior1V.append((-10.57,-36.46,3.78))
Interior1V.append((-10.10,-37.76,4.01))
Interior1V.append((5.09,-21.10,1.19))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((2.82,-21.48,1.49))
Interior1V.append((5.09,-21.10,1.19))
Interior1V.append((2.82,-21.48,1.49))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((-.34,-24.08,6.14))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((-.91,-22.41,6.38))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((-.34,-24.08,6.14))
Interior1V.append((2.91,-22.48,10.99))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((2.68,-23.26,9.95))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((2.91,-22.48,10.99))
Interior1V.append((2.91,-22.48,10.99))
Interior1V.append((2.68,-23.26,9.95))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((3.85,-24.93,9.21))
Interior1V.append((3.71,-24.18,9.97))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((3.71,-24.18,9.97))
Interior1V.append((2.68,-23.26,9.95))
Interior1V.append((9.87,-30.77,5.73))
Interior1V.append((11.39,-31.91,5.89))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((9.87,-30.77,5.73))
Interior1V.append((11.22,-30.35,6.80))
Interior1V.append((11.39,-31.91,5.89))
Interior1V.append((9.75,-27.96,5.40))
Interior1V.append((11.22,-30.35,6.80))
Interior1V.append((9.87,-30.77,5.73))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((9.75,-27.96,5.40))
Interior1V.append((9.87,-30.77,5.73))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((9.75,-27.96,5.40))
Interior1V.append((9.75,-27.96,5.40))
Interior1V.append((13.44,-28.06,4.44))
Interior1V.append((11.22,-30.35,6.80))
Interior1V.append((9.75,-27.96,5.40))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((13.44,-28.06,4.44))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((9.36,-30.38,8.73))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((4.70,-27.88,10.33))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((4.70,-27.88,10.33))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((7.58,-28.15,8.19))
Interior1V.append((9.36,-30.38,8.73))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((7.44,-26.12,11.55))
Interior1V.append((11.48,-31.84,9.04))
Interior1V.append((11.48,-31.84,9.04))
Interior1V.append((9.36,-30.38,8.73))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((11.48,-31.84,9.04))
Interior1V.append((8.38,-31.85,9.03))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((11.48,-31.84,9.04))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((11.48,-31.84,9.04))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((-.57,-27.75,10.14))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((.35,-26.33,13.52))
Interior1V.append((.54,-25.44,11.92))
Interior1V.append((-.57,-27.75,10.14))
Interior1V.append((.35,-26.33,13.52))
Interior1V.append((.54,-25.44,11.92))
Interior1V.append((.35,-26.33,13.52))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-4.08,-28.22,7.44))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-4.08,-28.22,7.44))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-.57,-27.75,10.14))
Interior1V.append((-1.04,-27.00,7.44))
Interior1V.append((-4.08,-28.22,7.44))
Interior1V.append((-.57,-27.75,10.14))
Interior1V.append((-1.04,-27.00,7.44))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-4.08,-28.22,7.44))
Interior1V.append((.54,-25.44,11.92))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((-.57,-27.75,10.14))
Interior1V.append((2.68,-23.26,9.95))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((.54,-25.44,11.92))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((2.68,-23.26,9.95))
Interior1V.append((.54,-25.44,11.92))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((3.71,-24.18,9.97))
Interior1V.append((3.85,-24.93,9.21))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((2.68,-23.26,9.95))
Interior1V.append((3.71,-24.18,9.97))
Interior1V.append((3.75,-29.68,15.64))
Interior1V.append((5.47,-26.82,13.22))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((3.75,-29.68,15.64))
Interior1V.append((4.02,-28.82,12.92))
Interior1V.append((5.47,-26.82,13.22))
Interior1V.append((3.75,-29.68,15.64))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((4.02,-28.82,12.92))
Interior1V.append((3.80,-31.39,13.18))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((4.02,-28.82,12.92))
Interior1V.append((3.80,-31.39,13.18))
Interior1V.append((4.02,-28.82,12.92))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((4.02,-28.82,12.92))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((5.47,-26.82,13.22))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((5.20,-29.71,10.61))
Interior1V.append((3.80,-31.39,13.18))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((3.80,-31.39,13.18))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((5.51,-37.10,13.02))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((5.51,-37.10,13.02))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((4.73,-35.20,13.35))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((4.73,-35.20,13.35))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((4.63,-35.45,14.32))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((4.34,-33.98,12.94))
Interior1V.append((4.73,-35.20,13.35))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((4.34,-33.98,12.94))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((4.73,-35.20,13.35))
Interior1V.append((4.34,-33.98,12.94))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((4.34,-33.98,12.94))
Interior1V.append((4.71,-33.42,11.87))
Interior1V.append((4.57,-31.77,14.66))
Interior1V.append((1.37,-35.58,19.84))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((2.23,-36.86,18.19))
Interior1V.append((1.37,-35.58,19.84))
Interior1V.append((2.23,-36.86,18.19))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((1.37,-35.58,19.84))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((2.23,-36.86,18.19))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((1.41,-37.93,23.85))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((1.41,-37.93,23.85))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((4.25,-41.36,16.56))
Interior1V.append((3.45,-33.71,22.22))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((3.45,-33.71,22.22))
Interior1V.append((2.48,-36.45,22.08))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((5.21,-34.57,24.00))
Interior1V.append((3.45,-33.71,22.22))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((5.21,-34.57,24.00))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((3.45,-33.71,22.22))
Interior1V.append((5.21,-34.57,24.00))
Interior1V.append((4.22,-36.25,17.57))
Interior1V.append((5.31,-36.13,23.62))
Interior1V.append((9.32,-53.73,23.48))
Interior1V.append((6.33,-52.86,20.94))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((9.32,-53.73,23.48))
Interior1V.append((8.31,-52.38,21.75))
Interior1V.append((6.33,-52.86,20.94))
Interior1V.append((6.33,-52.86,20.94))
Interior1V.append((8.31,-52.38,21.75))
Interior1V.append((8.86,-51.10,19.29))
Interior1V.append((6.17,-51.20,17.66))
Interior1V.append((8.86,-51.10,19.29))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((6.17,-51.20,17.66))
Interior1V.append((6.33,-52.86,20.94))
Interior1V.append((8.86,-51.10,19.29))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((9.32,-53.73,23.48))
Interior1V.append((2.03,-49.70,27.15))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((2.03,-49.70,27.15))
Interior1V.append((2.19,-49.04,24.81))
Interior1V.append((9.32,-53.73,23.48))
Interior1V.append((10.26,-52.30,23.30))
Interior1V.append((8.31,-52.38,21.75))
Interior1V.append((9.32,-53.73,23.48))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((10.26,-52.30,23.30))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((2.19,-49.04,24.81))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((4.11,-46.33,21.99))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((4.11,-46.33,21.99))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((2.19,-49.04,24.81))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((5.08,-45.56,24.13))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((5.11,-36.38,25.76))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((5.11,-36.38,25.76))
Interior1V.append((2.94,-37.39,25.16))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((5.11,-36.38,25.76))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((2.94,-37.39,25.16))
Interior1V.append((2.94,-37.39,25.16))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((2.94,-37.39,25.16))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((4.43,-43.94,23.71))
Interior1V.append((-4.25,-45.17,26.12))
Interior1V.append((-1.99,-45.56,24.19))
Interior1V.append((-5.06,-45.58,23.61))
Interior1V.append((-4.25,-45.17,26.12))
Interior1V.append((-5.06,-45.58,23.61))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-4.25,-45.17,26.12))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-1.99,-45.56,24.19))
Interior1V.append((-5.06,-45.58,23.61))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-3.61,-41.92,23.61))
Interior1V.append((-5.06,-45.58,23.61))
Interior1V.append((-1.99,-45.56,24.19))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-6.04,-32.45,19.94))
Interior1V.append((-7.14,-36.28,19.33))
Interior1V.append((-7.61,-34.58,20.64))
Interior1V.append((-7.14,-36.28,19.33))
Interior1V.append((-6.04,-32.45,19.94))
Interior1V.append((-5.14,-35.57,20.67))
Interior1V.append((-2.86,-33.53,19.31))
Interior1V.append((-5.14,-35.57,20.67))
Interior1V.append((-6.04,-32.45,19.94))
Interior1V.append((-4.09,-35.95,16.44))
Interior1V.append((-2.86,-33.53,19.31))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-2.86,-33.53,19.31))
Interior1V.append((-4.09,-35.95,16.44))
Interior1V.append((-2.72,-34.72,19.68))
Interior1V.append((-2.86,-33.53,19.31))
Interior1V.append((-2.72,-34.72,19.68))
Interior1V.append((-5.14,-35.57,20.67))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((17.71,-27.64,1.64))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((17.71,-27.64,1.64))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((14.97,-29.43,2.02))
Interior1V.append((17.71,-27.64,1.64))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((14.35,-30.10,-.14))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((14.35,-30.10,-.14))
Interior1V.append((14.97,-29.43,2.02))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((17.71,-27.64,1.64))
Interior1V.append((14.97,-29.43,2.02))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((17.71,-27.64,1.64))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((14.97,-29.43,2.02))
Interior1V.append((14.35,-30.10,-.14))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((14.35,-30.10,-.14))
Interior1V.append((13.21,-30.99,.75))
Interior1V.append((14.35,-30.10,-.14))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((13.21,-30.99,.75))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((14.35,-30.10,-.14))
Interior1V.append((14.76,-30.07,3.63))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((13.21,-30.99,.75))
Interior1V.append((14.76,-30.07,3.63))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((14.76,-30.07,3.63))
Interior1V.append((13.21,-30.99,.75))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((14.76,-30.07,3.63))
Interior1V.append((11.39,-31.91,5.89))
Interior1V.append((13.88,-31.66,5.24))
Interior1V.append((12.23,-34.95,5.40))
Interior1V.append((8.86,-36.53,5.44))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((7.88,-33.97,6.51))
Interior1V.append((8.86,-36.53,5.44))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((8.86,-36.53,5.44))
Interior1V.append((7.88,-33.97,6.51))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((7.88,-33.97,6.51))
Interior1V.append((5.54,-33.78,6.91))
Interior1V.append((7.30,-33.57,5.70))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((8.86,-36.53,5.44))
Interior1V.append((7.30,-33.57,5.70))
Interior1V.append((8.86,-36.53,5.44))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((5.54,-33.78,6.91))
Interior1V.append((5.04,-33.15,4.94))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((5.54,-33.78,6.91))
Interior1V.append((4.27,-32.64,7.47))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((4.27,-32.64,7.47))
Interior1V.append((1.48,-32.91,7.54))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((1.48,-32.91,7.54))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((.30,-35.02,2.67))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((5.04,-33.15,4.94))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((5.04,-33.15,4.94))
Interior1V.append((3.18,-33.89,5.90))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((.30,-35.02,2.67))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((3.70,-42.99,-11.52))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((7.19,-40.05,-9.99))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((7.83,-39.47,-11.61))
Interior1V.append((7.19,-40.05,-9.99))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((7.28,-44.77,-12.68))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((8.92,-39.40,-10.13))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((5.38,-38.49,-15.77))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((5.38,-38.49,-15.77))
Interior1V.append((7.83,-39.47,-11.61))
Interior1V.append((7.27,-39.16,-16.41))
Interior1V.append((5.38,-38.49,-15.77))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((7.27,-39.16,-16.41))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((7.83,-39.47,-11.61))
Interior1V.append((7.27,-39.16,-16.41))
Interior1V.append((7.83,-39.47,-11.61))
Interior1V.append((5.38,-38.49,-15.77))
Interior1V.append((5.12,-41.24,-15.34))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((5.12,-39.09,-12.03))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((5.12,-41.24,-15.34))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((7.28,-44.77,-12.68))
Interior1V.append((6.99,-43.96,-15.48))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((6.99,-43.96,-15.48))
Interior1V.append((5.24,-44.04,-14.86))
Interior1V.append((7.28,-44.77,-12.68))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((4.01,-37.81,-8.91))
Interior1V.append((3.61,-39.57,-7.79))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((7.48,-37.61,-6.13))
Interior1V.append((4.01,-37.81,-8.91))
Interior1V.append((2.40,-38.04,-6.94))
Interior1V.append((3.61,-39.57,-7.79))
Interior1V.append((4.01,-37.81,-8.91))
Interior1V.append((2.26,-38.62,-5.73))
Interior1V.append((3.61,-39.57,-7.79))
Interior1V.append((2.40,-38.04,-6.94))
Interior1V.append((2.26,-38.62,-5.73))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((3.61,-39.57,-7.79))
Interior1V.append((2.67,-39.74,-5.45))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((2.26,-38.62,-5.73))
Interior1V.append((2.67,-39.74,-5.45))
Interior1V.append((2.26,-38.62,-5.73))
Interior1V.append((3.74,-38.50,-3.20))
Interior1V.append((5.20,-41.72,-4.56))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((2.67,-39.74,-5.45))
Interior1V.append((2.67,-39.74,-5.45))
Interior1V.append((1.31,-41.33,-5.67))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((2.67,-39.74,-5.45))
Interior1V.append((1.21,-39.51,-3.50))
Interior1V.append((1.31,-41.33,-5.67))
Interior1V.append((.32,-42.21,-4.49))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((1.31,-41.33,-5.67))
Interior1V.append((.32,-42.21,-4.49))
Interior1V.append((1.31,-41.33,-5.67))
Interior1V.append((1.21,-39.51,-3.50))
Interior1V.append((.32,-42.21,-4.49))
Interior1V.append((.35,-43.12,-3.08))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((.32,-42.21,-4.49))
Interior1V.append((1.21,-39.51,-3.50))
Interior1V.append((.35,-43.12,-3.08))
Interior1V.append((-1.20,-37.53,-3.91))
Interior1V.append((-.83,-39.33,-1.05))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((-1.20,-37.53,-3.91))
Interior1V.append((-3.03,-38.20,-2.08))
Interior1V.append((-.83,-39.33,-1.05))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((-.83,-39.33,-1.05))
Interior1V.append((-3.03,-38.20,-2.08))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((-.83,-39.33,-1.05))
Interior1V.append((-1.97,-35.75,-3.62))
Interior1V.append((-3.03,-38.20,-2.08))
Interior1V.append((-1.20,-37.53,-3.91))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-3.03,-38.20,-2.08))
Interior1V.append((-1.97,-35.75,-3.62))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((-1.97,-35.75,-3.62))
Interior1V.append((-1.20,-37.53,-3.91))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-1.97,-35.75,-3.62))
Interior1V.append((1.70,-36.09,-3.41))
Interior1V.append((-1.20,-37.53,-3.91))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((1.70,-36.09,-3.41))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((-1.20,-37.53,-3.91))
Interior1V.append((1.70,-36.09,-3.41))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((2.34,-38.68,1.02))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((1.32,-42.70,2.86))
Interior1V.append((1.95,-44.90,2.16))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((1.32,-42.70,2.86))
Interior1V.append((4.45,-44.59,4.70))
Interior1V.append((1.95,-44.90,2.16))
Interior1V.append((1.32,-42.70,2.86))
Interior1V.append((1.59,-41.11,1.71))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((1.32,-42.70,2.86))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((3.80,-43.31,5.74))
Interior1V.append((3.80,-43.31,5.74))
Interior1V.append((4.45,-44.59,4.70))
Interior1V.append((1.32,-42.70,2.86))
Interior1V.append((4.22,-44.21,5.60))
Interior1V.append((4.45,-44.59,4.70))
Interior1V.append((3.80,-43.31,5.74))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((4.22,-44.21,5.60))
Interior1V.append((3.80,-43.31,5.74))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((6.97,-40.43,3.99))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((7.73,-37.70,9.17))
Interior1V.append((9.25,-36.93,8.11))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((9.25,-36.93,8.11))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((7.73,-37.70,9.17))
Interior1V.append((9.25,-36.93,8.11))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((9.25,-36.93,8.11))
Interior1V.append((7.73,-37.70,9.17))
Interior1V.append((8.65,-35.93,7.74))
Interior1V.append((8.94,-36.08,10.71))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((10.36,-37.20,10.82))
Interior1V.append((8.94,-36.08,10.71))
Interior1V.append((10.36,-37.20,10.82))
Interior1V.append((10.41,-33.24,9.18))
Interior1V.append((8.94,-36.08,10.71))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((13.29,-36.96,11.72))
Interior1V.append((8.94,-36.08,10.71))
Interior1V.append((6.34,-35.67,12.31))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((8.97,-40.04,8.43))
Interior1V.append((8.71,-42.23,10.94))
Interior1V.append((7.54,-38.22,11.96))
Interior1V.append((8.97,-40.04,8.43))
Interior1V.append((7.54,-38.22,11.96))
Interior1V.append((6.19,-37.95,10.67))
Interior1V.append((8.97,-40.04,8.43))
Interior1V.append((6.19,-37.95,10.67))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((7.54,-38.22,11.96))
Interior1V.append((8.71,-42.23,10.94))
Interior1V.append((9.52,-38.22,12.72))
Interior1V.append((8.71,-42.23,10.94))
Interior1V.append((10.18,-43.00,13.97))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((8.27,-38.74,4.48))
Interior1V.append((7.96,-40.02,4.14))
Interior1V.append((9.71,-41.83,6.39))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((6.97,-40.43,3.99))
Interior1V.append((9.71,-41.83,6.39))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((7.96,-40.02,4.14))
Interior1V.append((8.97,-40.95,3.88))
Interior1V.append((6.97,-40.43,3.99))
Interior1V.append((10.33,-40.48,4.03))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((8.97,-40.95,3.88))
Interior1V.append((11.36,-42.83,7.21))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((11.36,-42.83,7.21))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((11.36,-42.83,7.21))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((14.15,-41.95,5.99))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((14.91,-44.26,4.60))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((13.10,-45.10,7.14))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((13.37,-44.04,8.00))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((13.10,-45.10,7.14))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((13.10,-45.10,7.14))
Interior1V.append((11.36,-42.83,7.21))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((11.36,-42.83,7.21))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((11.36,-42.83,7.21))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((11.36,-42.83,7.21))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((7.53,-44.94,11.31))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((7.53,-44.94,11.31))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((7.85,-46.78,13.00))
Interior1V.append((7.53,-44.94,11.31))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((6.78,-44.87,11.97))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((7.53,-44.94,11.31))
Interior1V.append((6.78,-44.87,11.97))
Interior1V.append((7.53,-44.94,11.31))
Interior1V.append((7.85,-46.78,13.00))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((6.78,-44.87,11.97))
Interior1V.append((6.80,-48.70,13.43))
Interior1V.append((7.85,-46.78,13.00))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((5.16,-49.96,12.35))
Interior1V.append((6.80,-48.70,13.43))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((11.20,-49.16,10.90))
Interior1V.append((9.53,-50.68,10.01))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((11.20,-49.16,10.90))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((10.45,-47.75,13.16))
Interior1V.append((11.20,-49.16,10.90))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((10.90,-45.09,12.55))
Interior1V.append((10.45,-47.75,13.16))
Interior1V.append((12.76,-50.26,10.29))
Interior1V.append((11.20,-49.16,10.90))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((13.37,-44.04,8.00))
Interior1V.append((13.73,-45.98,7.13))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((13.37,-44.04,8.00))
Interior1V.append((13.10,-45.10,7.14))
Interior1V.append((13.73,-45.98,7.13))
Interior1V.append((13.37,-44.04,8.00))
Interior1V.append((14.23,-44.00,8.66))
Interior1V.append((12.54,-42.92,8.09))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((15.25,-49.45,8.70))
Interior1V.append((12.76,-50.26,10.29))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((10.33,-52.72,8.90))
Interior1V.append((9.53,-50.68,10.01))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((11.23,-52.97,6.85))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((12.99,-49.32,5.77))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((12.99,-49.32,5.77))
Interior1V.append((11.23,-52.97,6.85))
Interior1V.append((13.75,-52.95,7.07))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((12.99,-49.32,5.77))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((11.23,-52.97,6.85))
Interior1V.append((12.99,-49.32,5.77))
Interior1V.append((10.33,-52.72,8.90))
Interior1V.append((11.23,-52.97,6.85))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((5.10,-51.94,9.90))
Interior1V.append((5.74,-52.61,9.05))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((5.10,-51.94,9.90))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((5.74,-52.61,9.05))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((5.74,-52.61,9.05))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((10.33,-52.72,8.90))
Interior1V.append((5.74,-52.61,9.05))
Interior1V.append((9.53,-50.68,10.01))
Interior1V.append((10.33,-52.72,8.90))
Interior1V.append((8.29,-53.01,6.16))
Interior1V.append((5.74,-52.61,9.05))
Interior1V.append((9.53,-50.68,10.01))
Interior1V.append((5.74,-52.61,9.05))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((5.13,-46.92,7.08))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((5.13,-46.92,7.08))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((5.03,-46.18,6.41))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((5.13,-46.92,7.08))
Interior1V.append((5.03,-46.18,6.41))
Interior1V.append((5.13,-46.92,7.08))
Interior1V.append((5.20,-46.32,5.44))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((5.03,-46.18,6.41))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((10.28,-43.82,5.66))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((10.28,-43.82,5.66))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((7.56,-44.73,9.25))
Interior1V.append((11.12,-43.88,6.34))
Interior1V.append((9.56,-45.63,10.62))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((11.87,-45.79,5.56))
Interior1V.append((12.02,-44.96,6.23))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((13.10,-45.10,7.14))
Interior1V.append((4.22,-44.21,5.60))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((5.03,-46.18,6.41))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((4.22,-44.21,5.60))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((4.22,-44.21,5.60))
Interior1V.append((5.03,-46.18,6.41))
Interior1V.append((5.20,-46.32,5.44))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((4.37,-45.06,6.60))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((1.72,-46.00,4.20))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-4.81,-45.72,7.19))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-5.09,-41.71,8.61))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-4.40,-41.01,8.51))
Interior1V.append((-5.09,-41.71,8.61))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-4.40,-41.01,8.51))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-5.09,-41.71,8.61))
Interior1V.append((-4.40,-41.01,8.51))
Interior1V.append((-4.68,-39.83,7.75))
Interior1V.append((-2.58,-42.52,7.11))
Interior1V.append((-4.40,-41.01,8.51))
Interior1V.append((-6.38,-40.60,7.05))
Interior1V.append((-4.68,-39.83,7.75))
Interior1V.append((-5.68,-35.48,8.30))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-5.68,-35.48,8.30))
Interior1V.append((-2.79,-35.82,9.62))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-2.79,-35.82,9.62))
Interior1V.append((-5.50,-34.41,8.35))
Interior1V.append((-2.79,-35.82,9.62))
Interior1V.append((-5.68,-35.48,8.30))
Interior1V.append((-5.50,-34.41,8.35))
Interior1V.append((-5.68,-35.48,8.30))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-5.12,-33.60,7.27))
Interior1V.append((-2.79,-35.82,9.62))
Interior1V.append((-5.50,-34.41,8.35))
Interior1V.append((-5.12,-33.60,7.27))
Interior1V.append((-5.50,-34.41,8.35))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-5.12,-33.60,7.27))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-5.12,-33.60,7.27))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-2.79,-35.82,9.62))
Interior1V.append((-5.07,-31.67,8.74))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-5.07,-31.67,8.74))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-5.46,-32.49,9.81))
Interior1V.append((-5.07,-31.67,8.74))
Interior1V.append((-5.46,-32.49,9.81))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-2.38,-30.55,4.29))
Interior1V.append((-4.11,-33.72,5.38))
Interior1V.append((-5.94,-32.09,3.36))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-2.99,-23.50,9.55))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((-2.99,-23.50,9.55))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-2.99,-23.50,9.55))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-2.25,-22.85,8.77))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-2.25,-22.85,8.77))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((-2.53,-21.71,8.45))
Interior1V.append((-2.25,-22.85,8.77))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((-.50,-30.47,8.10))
Interior1V.append((-1.91,-29.02,8.48))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-.50,-30.47,8.10))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((-1.91,-29.02,8.48))
Interior1V.append((-1.13,-31.18,7.19))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-1.13,-31.18,7.19))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-.50,-30.47,8.10))
Interior1V.append((-1.13,-31.18,7.19))
Interior1V.append((-.50,-30.47,8.10))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((-.50,-30.47,8.10))
Interior1V.append((1.01,-30.97,5.22))
Interior1V.append((2.41,-28.71,4.49))
Interior1V.append((3.46,-30.94,5.47))
Interior1V.append((1.01,-30.97,5.22))
Interior1V.append((3.46,-30.94,5.47))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((.97,-30.83,13.36))
Interior1V.append((.84,-32.53,13.90))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((.97,-30.83,13.36))
Interior1V.append((2.40,-33.42,13.26))
Interior1V.append((.84,-32.53,13.90))
Interior1V.append((-.63,-38.37,23.90))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((1.41,-37.93,23.85))
Interior1V.append((-.63,-38.37,23.90))
Interior1V.append((1.41,-37.93,23.85))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((-.63,-38.37,23.90))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((2.16,-30.11,11.04))
Interior1V.append((.97,-30.83,13.36))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((2.16,-30.11,11.04))
Interior1V.append((2.40,-33.42,13.26))
Interior1V.append((.97,-30.83,13.36))
Interior1V.append((-.41,-28.04,7.51))
Interior1V.append((.68,-28.29,6.68))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((-.41,-28.04,7.51))
Interior1V.append((.78,-28.75,9.74))
Interior1V.append((.68,-28.29,6.68))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((2.41,-28.71,4.49))
Interior1V.append((1.01,-30.97,5.22))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((1.01,-30.97,5.22))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((2.41,-28.71,4.49))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((3.46,-30.94,5.47))
Interior1V.append((2.41,-28.71,4.49))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((3.46,-30.94,5.47))
Interior1V.append((5.12,-29.10,4.08))
Interior1V.append((3.46,-30.94,5.47))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((5.12,-29.10,4.08))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((3.46,-30.94,5.47))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((5.12,-29.10,4.08))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((5.12,-29.10,4.08))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((5.17,-28.58,-1.07))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((5.80,-29.38,-.71))
Interior1V.append((5.17,-28.58,-1.07))
Interior1V.append((5.80,-29.38,-.71))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((5.17,-28.58,-1.07))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((3.80,-28.85,-1.12))
Interior1V.append((5.17,-28.58,-1.07))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((3.80,-28.85,-1.12))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((5.17,-28.58,-1.07))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((3.80,-28.85,-1.12))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((3.80,-28.85,-1.12))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((-.58,-27.17,-1.11))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((-.58,-27.17,-1.11))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((-1.52,-25.53,1.45))
Interior1V.append((-.58,-27.17,-1.11))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((-1.52,-25.53,1.45))
Interior1V.append((.36,-24.96,-2.39))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((-1.22,-27.86,-3.97))
Interior1V.append((.36,-24.96,-2.39))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((.36,-24.96,-2.39))
Interior1V.append((2.08,-25.66,-5.58))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((3.37,-26.59,-1.99))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((3.37,-26.59,-1.99))
Interior1V.append((1.81,-28.16,-1.67))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((2.08,-25.66,-5.58))
Interior1V.append((3.58,-27.73,-5.92))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((3.90,-30.83,-2.88))
Interior1V.append((5.80,-29.38,-.71))
Interior1V.append((3.39,-29.78,-.75))
Interior1V.append((3.90,-30.83,-2.88))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((6.31,-31.19,-3.21))
Interior1V.append((7.05,-33.76,-1.87))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((6.31,-31.19,-3.21))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((5.80,-29.38,-.71))
Interior1V.append((5.80,-29.38,-.71))
Interior1V.append((3.90,-30.83,-2.88))
Interior1V.append((6.31,-31.19,-3.21))
Interior1V.append((7.05,-33.76,-1.87))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((7.01,-34.48,-2.55))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((7.05,-33.76,-1.87))
Interior1V.append((6.31,-31.19,-3.21))
Interior1V.append((7.01,-34.48,-2.55))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((6.31,-31.19,-3.21))
Interior1V.append((7.01,-34.48,-2.55))
Interior1V.append((6.31,-31.19,-3.21))
Interior1V.append((3.83,-31.72,-4.35))
Interior1V.append((5.37,-34.53,-5.11))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((7.01,-34.48,-2.55))
Interior1V.append((5.37,-34.53,-5.11))
Interior1V.append((7.01,-34.48,-2.55))
Interior1V.append((3.83,-31.72,-4.35))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((10.27,-38.52,-6.27))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((10.27,-38.52,-6.27))
Interior1V.append((13.33,-39.94,-6.26))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((10.27,-38.52,-6.27))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((10.27,-38.52,-6.27))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((13.33,-39.94,-6.26))
Interior1V.append((10.27,-38.52,-6.27))
Interior1V.append((9.89,-33.58,-5.99))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((10.03,-34.43,-3.54))
Interior1V.append((9.89,-33.58,-5.99))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((9.89,-33.58,-5.99))
Interior1V.append((10.03,-34.43,-3.54))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((18.74,-36.24,-.95))
Interior1V.append((17.80,-36.85,-3.20))
Interior1V.append((17.13,-37.91,-.75))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((17.13,-37.91,-.75))
Interior1V.append((17.80,-36.85,-3.20))
Interior1V.append((16.33,-40.56,-.95))
Interior1V.append((17.13,-37.91,-.75))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((17.13,-37.91,-.75))
Interior1V.append((16.33,-40.56,-.95))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((16.33,-40.56,-.95))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((17.13,-37.91,-.75))
Interior1V.append((14.41,-41.33,-.94))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((15.67,-41.28,.58))
Interior1V.append((18.06,-41.92,1.24))
Interior1V.append((18.44,-40.89,-.26))
Interior1V.append((20.36,-42.02,.93))
Interior1V.append((20.41,-42.00,-.77))
Interior1V.append((19.75,-47.76,-2.90))
Interior1V.append((18.26,-47.91,.71))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((19.75,-47.76,-2.90))
Interior1V.append((16.33,-40.56,-.95))
Interior1V.append((18.72,-40.43,-3.47))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((16.33,-40.56,-.95))
Interior1V.append((17.86,-38.53,-3.87))
Interior1V.append((18.72,-40.43,-3.47))
Interior1V.append((19.41,-34.67,-3.63))
Interior1V.append((17.80,-36.85,-3.20))
Interior1V.append((18.30,-33.65,-1.55))
Interior1V.append((19.41,-34.67,-3.63))
Interior1V.append((18.30,-33.65,-1.55))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((18.30,-33.65,-1.55))
Interior1V.append((17.80,-36.85,-3.20))
Interior1V.append((18.74,-36.24,-.95))
Interior1V.append((18.28,-33.83,-.33))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((18.30,-33.65,-1.55))
Interior1V.append((18.28,-33.83,-.33))
Interior1V.append((18.30,-33.65,-1.55))
Interior1V.append((18.74,-36.24,-.95))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((18.30,-33.65,-1.55))
Interior1V.append((16.80,-30.62,-1.67))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((16.80,-30.62,-1.67))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((16.80,-30.62,-1.67))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((14.57,-29.59,-2.42))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((14.57,-29.59,-2.42))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((13.64,-31.67,-.83))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((14.57,-29.59,-2.42))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((14.57,-29.59,-2.42))
Interior1V.append((13.64,-31.67,-.83))
Interior1V.append((12.52,-29.92,-6.34))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((12.52,-29.92,-6.34))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((12.52,-29.92,-6.34))
Interior1V.append((15.06,-30.10,-4.54))
Interior1V.append((12.47,-29.85,-5.35))
Interior1V.append((12.52,-29.92,-6.34))
Interior1V.append((12.47,-29.85,-5.35))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((8.09,-34.88,-3.23))
Interior1V.append((10.03,-34.43,-3.54))
Interior1V.append((9.15,-34.07,-3.21))
Interior1V.append((8.09,-34.88,-3.23))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((10.03,-34.43,-3.54))
Interior1V.append((8.27,-38.74,4.48))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((8.09,-34.88,-3.23))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((8.09,-34.88,-3.23))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((7.96,-40.02,4.14))
Interior1V.append((8.27,-38.74,4.48))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((7.97,-38.48,-4.64))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((8.97,-40.95,3.88))
Interior1V.append((7.96,-40.02,4.14))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((9.84,-36.80,-4.27))
Interior1V.append((7.97,-38.48,-4.64))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((8.97,-40.95,3.88))
Interior1V.append((10.69,-39.11,4.26))
Interior1V.append((10.33,-40.48,4.03))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((8.27,-38.74,4.48))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((10.18,-36.33,4.15))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((5.53,-32.90,3.66))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((5.53,-32.90,3.66))
Interior1V.append((2.93,-36.32,.63))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((2.93,-36.32,.63))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((1.65,-34.74,.54))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((1.65,-34.74,.54))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((5.53,-32.90,3.66))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((5.53,-32.90,3.66))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((5.53,-32.90,3.66))
Interior1V.append((5.04,-33.15,4.94))
Interior1V.append((5.53,-32.90,3.66))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((5.04,-33.15,4.94))
Interior1V.append((2.93,-36.32,.63))
Interior1V.append((2.37,-35.89,2.30))
Interior1V.append((2.34,-38.68,1.02))
Interior1V.append((4.54,-36.59,-2.62))
Interior1V.append((2.93,-36.32,.63))
Interior1V.append((2.34,-38.68,1.02))
Interior1V.append((4.54,-36.59,-2.62))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((2.93,-36.32,.63))
Interior1V.append((2.75,-37.71,-1.97))
Interior1V.append((3.74,-38.50,-3.20))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((4.77,-44.51,-3.19))
Interior1V.append((5.20,-41.72,-4.56))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((7.97,-38.48,-4.64))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((7.48,-37.61,-6.13))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((7.01,-36.31,-3.99))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((4.33,-35.25,-6.46))
Interior1V.append((7.01,-36.31,-3.99))
Interior1V.append((4.33,-35.25,-6.46))
Interior1V.append((7.48,-37.61,-6.13))
Interior1V.append((7.01,-36.31,-3.99))
Interior1V.append((7.48,-37.61,-6.13))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((2.88,-36.13,-4.56))
Interior1V.append((4.33,-35.25,-6.46))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((2.88,-36.13,-4.56))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((3.74,-38.50,-3.20))
Interior1V.append((2.88,-36.13,-4.56))
Interior1V.append((3.74,-38.50,-3.20))
Interior1V.append((2.26,-38.62,-5.73))
Interior1V.append((2.88,-36.13,-4.56))
Interior1V.append((2.26,-38.62,-5.73))
Interior1V.append((4.33,-35.25,-6.46))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((2.93,-36.32,.63))
Interior1V.append((2.75,-37.71,-1.97))
Interior1V.append((5.66,-36.96,-3.06))
Interior1V.append((4.54,-36.59,-2.62))
Interior1V.append((2.75,-37.71,-1.97))
Interior1V.append((4.54,-36.59,-2.62))
Interior1V.append((2.34,-38.68,1.02))
Interior1V.append((4.33,-35.25,-6.46))
Interior1V.append((4.01,-37.81,-8.91))
Interior1V.append((7.48,-37.61,-6.13))
Interior1V.append((4.33,-35.25,-6.46))
Interior1V.append((2.40,-38.04,-6.94))
Interior1V.append((4.01,-37.81,-8.91))
Interior1V.append((-7.62,-40.39,-5.93))
Interior1V.append((-10.26,-40.44,-5.46))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-7.62,-40.39,-5.93))
Interior1V.append((-6.34,-39.37,-5.02))
Interior1V.append((-10.26,-40.44,-5.46))
Interior1V.append((-6.23,-41.09,-5.07))
Interior1V.append((-6.34,-39.37,-5.02))
Interior1V.append((-7.62,-40.39,-5.93))
Interior1V.append((-6.23,-41.09,-5.07))
Interior1V.append((-7.62,-40.39,-5.93))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-6.23,-41.09,-5.07))
Interior1V.append((-5.65,-39.57,-2.28))
Interior1V.append((-6.34,-39.37,-5.02))
Interior1V.append((-6.69,-43.15,-1.62))
Interior1V.append((-5.65,-39.57,-2.28))
Interior1V.append((-6.23,-41.09,-5.07))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-5.65,-39.57,-2.28))
Interior1V.append((-6.69,-43.15,-1.62))
Interior1V.append((-9.36,-43.16,.35))
Interior1V.append((-6.69,-43.15,-1.62))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-9.36,-43.16,.35))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-10.55,-42.11,-.23))
Interior1V.append((-9.36,-43.16,.35))
Interior1V.append((-10.55,-42.11,-.23))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-6.69,-43.15,-1.62))
Interior1V.append((-9.36,-43.16,.35))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-6.69,-43.15,-1.62))
Interior1V.append((-9.36,-43.16,.35))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-6.92,-48.11,3.80))
Interior1V.append((-5.35,-45.39,5.49))
Interior1V.append((-9.20,-45.97,5.15))
Interior1V.append((-6.92,-48.11,3.80))
Interior1V.append((-9.20,-45.97,5.15))
Interior1V.append((-7.11,-48.71,5.04))
Interior1V.append((-4.20,-53.70,-1.71))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-4.28,-51.61,-4.91))
Interior1V.append((-4.20,-53.70,-1.71))
Interior1V.append((-4.28,-51.61,-4.91))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-4.43,-52.44,-6.40))
Interior1V.append((-4.28,-51.61,-4.91))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-4.43,-52.44,-6.40))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-4.28,-51.61,-4.91))
Interior1V.append((-5.43,-51.75,-1.59))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-4.20,-53.70,-1.71))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-5.43,-51.75,-1.59))
Interior1V.append((-4.20,-53.70,-1.71))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-5.43,-51.75,-1.59))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-8.44,-60.29,-2.05))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((-8.44,-60.29,-2.05))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-8.44,-60.29,-2.05))
Interior1V.append((-4.36,-58.84,-6.84))
Interior1V.append((-8.44,-60.29,-2.05))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-2.75,-59.25,-2.37))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-4.38,-59.22,-4.41))
Interior1V.append((-5.71,-60.87,-3.29))
Interior1V.append((-8.44,-60.29,-2.05))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-5.71,-60.87,-3.29))
Interior1V.append((-2.75,-59.25,-2.37))
Interior1V.append((-4.38,-59.22,-4.41))
Interior1V.append((-5.11,-60.69,-6.52))
Interior1V.append((-8.44,-60.29,-2.05))
Interior1V.append((-5.71,-60.87,-3.29))
Interior1V.append((-5.11,-60.69,-6.52))
Interior1V.append((-5.71,-60.87,-3.29))
Interior1V.append((-4.38,-59.22,-4.41))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-27.70,-38.10,10.60))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-29.35,-43.58,7.94))
Interior1V.append((-27.70,-38.10,10.60))
Interior1V.append((-29.35,-43.58,7.94))
Interior1V.append((-29.74,-43.34,4.16))
Interior1V.append((-27.70,-38.10,10.60))
Interior1V.append((-29.74,-43.34,4.16))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-29.74,-43.34,4.16))
Interior1V.append((-29.35,-43.58,7.94))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-29.35,-43.58,7.94))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-22.71,-42.13,1.97))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-29.74,-43.34,4.16))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-22.71,-42.13,1.97))
Interior1V.append((-20.79,-40.70,1.93))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-22.71,-42.13,1.97))
Interior1V.append((-27.64,-44.57,3.03))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-22.71,-42.13,1.97))
Interior1V.append((-27.64,-44.57,3.03))
Interior1V.append((-22.71,-42.13,1.97))
Interior1V.append((-29.74,-43.34,4.16))
Interior1V.append((-27.68,-44.68,4.82))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-27.64,-44.57,3.03))
Interior1V.append((-27.68,-44.68,4.82))
Interior1V.append((-27.64,-44.57,3.03))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-26.18,-43.32,7.65))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-27.68,-44.68,4.82))
Interior1V.append((-26.18,-43.32,7.65))
Interior1V.append((-27.68,-44.68,4.82))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-26.18,-43.32,7.65))
Interior1V.append((-21.53,-44.15,6.32))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-26.18,-43.32,7.65))
Interior1V.append((-23.58,-42.69,8.89))
Interior1V.append((-21.53,-44.15,6.32))
Interior1V.append((-23.58,-42.69,8.89))
Interior1V.append((-26.18,-43.32,7.65))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-23.58,-42.69,8.89))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-21.00,-42.42,3.88))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-25.61,-41.23,8.20))
Interior1V.append((-27.64,-44.57,3.03))
Interior1V.append((-29.74,-43.34,4.16))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-19.63,-46.03,8.84))
Interior1V.append((-22.13,-47.25,8.56))
Interior1V.append((-21.86,-47.19,6.06))
Interior1V.append((-22.13,-47.25,8.56))
Interior1V.append((-21.30,-49.50,6.96))
Interior1V.append((-18.57,-48.43,9.50))
Interior1V.append((-19.63,-46.03,8.84))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-18.57,-48.43,9.50))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-18.57,-48.43,9.50))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-21.30,-49.50,6.96))
Interior1V.append((-18.57,-48.43,9.50))
Interior1V.append((-19.70,-47.84,9.83))
Interior1V.append((-19.63,-46.03,8.84))
Interior1V.append((-18.57,-48.43,9.50))
Interior1V.append((-21.30,-49.50,6.96))
Interior1V.append((-19.70,-47.84,9.83))
Interior1V.append((-16.43,-48.17,5.59))
Interior1V.append((-15.86,-46.82,6.89))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-18.93,-50.31,11.17))
Interior1V.append((-16.68,-51.27,13.39))
Interior1V.append((-18.85,-52.34,13.10))
Interior1V.append((-16.75,-53.45,13.21))
Interior1V.append((-18.85,-52.34,13.10))
Interior1V.append((-16.68,-51.27,13.39))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-16.68,-51.27,13.39))
Interior1V.append((-18.93,-50.31,11.17))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-18.93,-50.31,11.17))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-18.93,-50.31,11.17))
Interior1V.append((-18.65,-51.92,9.09))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-18.93,-50.31,11.17))
Interior1V.append((-18.85,-52.34,13.10))
Interior1V.append((-18.65,-51.92,9.09))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-23.58,-42.69,8.89))
Interior1V.append((-21.42,-45.02,10.59))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-21.42,-45.02,10.59))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-21.53,-44.15,6.32))
Interior1V.append((-23.58,-42.69,8.89))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-21.53,-44.15,6.32))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-21.00,-42.42,3.88))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-21.00,-42.42,3.88))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-17.75,-43.48,3.47))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-16.74,-47.30,5.98))
Interior1V.append((-17.68,-46.96,5.90))
Interior1V.append((-16.74,-47.30,5.98))
Interior1V.append((-16.43,-48.17,5.59))
Interior1V.append((-16.74,-47.30,5.98))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-16.43,-48.17,5.59))
Interior1V.append((-16.74,-47.30,5.98))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-15.86,-46.82,6.89))
Interior1V.append((-16.43,-48.17,5.59))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-12.41,-43.68,2.70))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-15.86,-46.82,6.89))
Interior1V.append((-14.27,-45.15,8.06))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-14.67,-42.77,8.18))
Interior1V.append((-14.27,-45.15,8.06))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-12.49,-44.17,8.24))
Interior1V.append((-14.27,-45.15,8.06))
Interior1V.append((-14.67,-42.77,8.18))
Interior1V.append((-13.43,-41.35,8.00))
Interior1V.append((-12.49,-44.17,8.24))
Interior1V.append((-14.67,-42.77,8.18))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-14.27,-45.15,8.06))
Interior1V.append((-12.49,-44.17,8.24))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-14.27,-45.15,8.06))
Interior1V.append((-10.26,-45.14,6.33))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-12.49,-44.17,8.24))
Interior1V.append((-10.26,-45.14,6.33))
Interior1V.append((-12.49,-44.17,8.24))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-10.47,-48.53,5.50))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-10.26,-45.14,6.33))
Interior1V.append((-10.69,-45.44,3.60))
Interior1V.append((-10.47,-48.53,5.50))
Interior1V.append((-10.26,-45.14,6.33))
Interior1V.append((-10.69,-45.44,3.60))
Interior1V.append((-10.26,-45.14,6.33))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-11.34,-41.42,8.22))
Interior1V.append((-10.35,-40.96,7.75))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-11.34,-41.42,8.22))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-10.35,-40.96,7.75))
Interior1V.append((-12.53,-40.94,7.85))
Interior1V.append((-11.34,-41.42,8.22))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-12.53,-40.94,7.85))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-11.34,-41.42,8.22))
Interior1V.append((-12.53,-40.94,7.85))
Interior1V.append((-10.94,-43.80,7.48))
Interior1V.append((-13.43,-41.35,8.00))
Interior1V.append((-12.53,-40.94,7.85))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-10.94,-43.80,7.48))
Interior1V.append((-10.94,-43.80,7.48))
Interior1V.append((-12.49,-44.17,8.24))
Interior1V.append((-13.43,-41.35,8.00))
Interior1V.append((-10.94,-43.80,7.48))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-12.49,-44.17,8.24))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-12.53,-40.94,7.85))
Interior1V.append((-13.43,-41.35,8.00))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-12.53,-40.94,7.85))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-13.43,-41.35,8.00))
Interior1V.append((-14.67,-42.77,8.18))
Interior1V.append((14.15,-24.82,.44))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((12.50,-25.18,1.58))
Interior1V.append((14.15,-24.82,.44))
Interior1V.append((12.50,-25.18,1.58))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((14.15,-24.82,.44))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((11.70,-25.35,2.14))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((12.50,-25.18,1.58))
Interior1V.append((11.70,-25.35,2.14))
Interior1V.append((12.50,-25.18,1.58))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((14.35,-30.10,-.14))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((17.39,-29.07,-5.42))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((17.39,-29.07,-5.42))
Interior1V.append((17.91,-26.79,-5.02))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((19.99,-28.94,-2.06))
Interior1V.append((17.39,-29.07,-5.42))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((13.64,-31.67,-.83))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((10.40,-28.40,-1.37))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((13.21,-30.99,.75))
Interior1V.append((11.39,-27.02,3.15))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((11.39,-27.02,3.15))
Interior1V.append((11.70,-25.35,2.14))
Interior1V.append((13.71,-26.91,1.73))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((8.71,-25.44,5.94))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((8.71,-25.44,5.94))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((7.72,-24.17,1.34))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((7.72,-24.17,1.34))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((5.80,-29.38,-.71))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((5.80,-29.38,-.71))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((6.85,-29.24,2.17))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((7.43,-28.75,1.59))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((10.47,-24.81,2.05))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((9.68,-25.02,2.95))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((10.47,-24.81,2.05))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((7.45,-32.87,2.48))
Interior1V.append((9.87,-30.77,5.73))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((9.87,-30.77,5.73))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((8.71,-25.44,5.94))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((6.08,-28.89,4.52))
Interior1V.append((8.71,-25.44,5.94))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((6.08,-28.89,4.52))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((8.87,-33.33,4.28))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((8.45,-28.62,3.89))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((5.53,-32.90,3.66))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((6.91,-32.96,3.42))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((7.30,-33.57,5.70))
Interior1V.append((7.81,-33.34,4.45))
Interior1V.append((7.30,-33.57,5.70))
Interior1V.append((5.90,-33.59,5.91))
Interior1V.append((3.75,-31.82,7.26))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((3.75,-31.82,7.26))
Interior1V.append((5.62,-28.50,6.59))
Interior1V.append((3.59,-30.93,8.22))
Interior1V.append((3.75,-31.82,7.26))
Interior1V.append((3.59,-30.93,8.22))
Interior1V.append((5.36,-31.29,9.03))
Interior1V.append((8.03,-25.07,6.57))
Interior1V.append((8.71,-25.44,5.94))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((8.03,-25.07,6.57))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((8.71,-25.44,5.94))
Interior1V.append((8.03,-25.07,6.57))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((7.68,-23.78,6.48))
Interior1V.append((8.03,-25.07,6.57))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((7.68,-23.78,6.48))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((8.03,-25.07,6.57))
Interior1V.append((7.68,-23.78,6.48))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((7.68,-23.78,6.48))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((8.33,-21.93,5.92))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((8.33,-21.93,5.92))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((2.29,-21.66,11.38))
Interior1V.append((8.33,-21.93,5.92))
Interior1V.append((19.75,-22.41,-3.73))
Interior1V.append((19.55,-24.10,-4.37))
Interior1V.append((19.82,-24.64,-6.40))
Interior1V.append((19.75,-22.41,-3.73))
Interior1V.append((19.82,-24.64,-6.40))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((19.55,-24.10,-4.37))
Interior1V.append((19.75,-22.41,-3.73))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((19.75,-22.41,-3.73))
Interior1V.append((18.89,-24.70,.25))
Interior1V.append((19.75,-22.41,-3.73))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((19.95,-23.66,1.26))
Interior1V.append((19.75,-22.41,-3.73))
Interior1V.append((19.95,-23.66,1.26))
Interior1V.append((18.89,-24.70,.25))
Interior1V.append((19.55,-24.10,-4.37))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((18.89,-24.70,.25))
Interior1V.append((19.99,-28.94,-2.06))
Interior1V.append((19.55,-24.10,-4.37))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((19.99,-28.94,-2.06))
Interior1V.append((23.93,-26.83,-.94))
Interior1V.append((23.15,-28.85,-2.21))
Interior1V.append((21.93,-39.36,-1.84))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((20.41,-42.00,-.77))
Interior1V.append((21.93,-39.36,-1.84))
Interior1V.append((22.37,-38.81,.85))
Interior1V.append((20.56,-37.85,-.19))
Interior1V.append((21.93,-39.36,-1.84))
Interior1V.append((20.41,-42.00,-.77))
Interior1V.append((22.37,-38.81,.85))
Interior1V.append((24.03,-35.84,2.70))
Interior1V.append((25.00,-39.00,3.00))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((24.03,-35.84,2.70))
Interior1V.append((23.17,-38.28,2.32))
Interior1V.append((25.00,-39.00,3.00))
Interior1V.append((28.65,-49.90,.65))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((27.65,-54.01,9.08))
Interior1V.append((28.65,-49.90,.65))
Interior1V.append((26.74,-49.54,2.16))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((28.65,-49.90,.65))
Interior1V.append((27.65,-54.01,9.08))
Interior1V.append((26.74,-49.54,2.16))
Interior1V.append((28.65,-49.90,.65))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((28.65,-49.90,.65))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((28.13,-49.15,-1.72))
Interior1V.append((28.65,-49.90,.65))
Interior1V.append((28.13,-49.15,-1.72))
Interior1V.append((23.09,-52.27,-4.22))
Interior1V.append((27.40,-48.98,-1.07))
Interior1V.append((28.13,-49.15,-1.72))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((-10.32,-60.30,4.68))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-8.80,-60.10,2.14))
Interior1V.append((-10.32,-60.30,4.68))
Interior1V.append((-8.80,-60.10,2.14))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-10.04,-59.24,.32))
Interior1V.append((-8.80,-60.10,2.14))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-10.04,-59.24,.32))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-8.80,-60.10,2.14))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-10.04,-59.24,.32))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-10.04,-59.24,.32))
Interior1V.append((-13.09,-62.29,4.02))
Interior1V.append((-10.32,-60.30,4.68))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-12.35,-59.16,7.55))
Interior1V.append((-10.32,-60.30,4.68))
Interior1V.append((-13.09,-62.29,4.02))
Interior1V.append((-12.35,-59.16,7.55))
Interior1V.append((-13.09,-62.29,4.02))
Interior1V.append((-11.82,-61.65,6.21))
Interior1V.append((-12.35,-59.16,7.55))
Interior1V.append((-11.82,-61.65,6.21))
Interior1V.append((-15.47,-58.77,6.33))
Interior1V.append((-9.73,-61.31,-1.35))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-9.73,-61.31,-1.35))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((-9.73,-61.31,-1.35))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-10.83,-61.29,1.26))
Interior1V.append((-4.49,-60.74,.18))
Interior1V.append((-5.71,-60.87,-3.29))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-4.49,-60.74,.18))
Interior1V.append((-2.75,-59.25,-2.37))
Interior1V.append((-5.71,-60.87,-3.29))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-4.49,-60.74,.18))
Interior1V.append((-8.07,-59.01,-.10))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-2.75,-59.25,-2.37))
Interior1V.append((-4.49,-60.74,.18))
Interior1V.append((-2.75,-59.25,-2.37))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-2.75,-59.25,-2.37))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-3.89,-55.54,2.44))
Interior1V.append((-7.96,-54.76,2.60))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-3.89,-55.54,2.44))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-3.89,-55.54,2.44))
Interior1V.append((-4.64,-58.09,1.59))
Interior1V.append((-7.08,-56.52,4.41))
Interior1V.append((-3.89,-55.54,2.44))
Interior1V.append((-7.08,-56.52,4.41))
Interior1V.append((-7.96,-54.76,2.60))
Interior1V.append((-9.64,-56.19,6.27))
Interior1V.append((-10.02,-59.44,6.30))
Interior1V.append((-10.93,-57.70,8.02))
Interior1V.append((-9.64,-56.19,6.27))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-10.02,-59.44,6.30))
Interior1V.append((-9.67,-49.28,16.81))
Interior1V.append((-10.72,-47.19,16.12))
Interior1V.append((-9.01,-46.87,14.16))
Interior1V.append((-9.13,-38.89,13.81))
Interior1V.append((-9.62,-39.82,13.57))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-9.13,-38.89,13.81))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-6.86,-41.88,15.11))
Interior1V.append((-9.13,-38.89,13.81))
Interior1V.append((-6.86,-41.88,15.11))
Interior1V.append((-9.62,-39.82,13.57))
Interior1V.append((-8.89,-42.32,16.13))
Interior1V.append((-7.00,-44.24,14.64))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-8.89,-42.32,16.13))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-10.84,-42.06,13.68))
Interior1V.append((-8.89,-42.32,16.13))
Interior1V.append((-6.86,-41.88,15.11))
Interior1V.append((-7.00,-44.24,14.64))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-14.05,-46.10,12.86))
Interior1V.append((-12.53,-43.50,13.02))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-14.05,-46.10,12.86))
Interior1V.append((-13.48,-44.82,10.66))
Interior1V.append((-12.53,-43.50,13.02))
Interior1V.append((-14.05,-46.10,12.86))
Interior1V.append((-13.48,-44.82,10.66))
Interior1V.append((-14.05,-46.10,12.86))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-11.25,-45.27,10.11))
Interior1V.append((-12.53,-43.50,13.02))
Interior1V.append((-13.48,-44.82,10.66))
Interior1V.append((-11.25,-45.27,10.11))
Interior1V.append((-13.48,-44.82,10.66))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-11.93,-47.55,11.82))
Interior1V.append((-9.09,-45.27,13.49))
Interior1V.append((-11.25,-45.27,10.11))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-14.68,-44.88,16.72))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-14.72,-43.23,13.67))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-14.98,-42.58,12.15))
Interior1V.append((-14.72,-43.23,13.67))
Interior1V.append((-14.98,-42.58,12.15))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-14.72,-43.23,13.67))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-11.96,-40.96,14.58))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-14.98,-42.58,12.15))
Interior1V.append((-14.09,-42.73,14.19))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-14.98,-42.58,12.15))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-10.30,-42.44,9.65))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-10.30,-42.44,9.65))
Interior1V.append((-10.30,-42.44,9.65))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-10.84,-42.06,13.68))
Interior1V.append((-5.63,-42.17,10.80))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-8.59,-33.91,12.49))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-8.59,-33.91,12.49))
Interior1V.append((-4.01,-32.55,13.68))
Interior1V.append((-7.81,-35.26,14.43))
Interior1V.append((-4.01,-32.55,13.68))
Interior1V.append((-8.59,-33.91,12.49))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-4.01,-32.55,13.68))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-4.01,-32.55,13.68))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-3.20,-30.77,13.33))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-5.63,-30.97,11.07))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-5.46,-32.49,9.81))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((-3.24,-34.77,10.95))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((-3.24,-34.77,10.95))
Interior1V.append((-5.46,-32.49,9.81))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-7.81,-35.26,14.43))
Interior1V.append((-4.33,-33.54,15.68))
Interior1V.append((-4.01,-32.55,13.68))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-3.24,-34.77,10.95))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((-.41,-33.56,8.79))
Interior1V.append((-3.24,-34.77,10.95))
Interior1V.append((-1.56,-35.29,10.96))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((.84,-32.53,13.90))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-.41,-33.56,8.79))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-3.24,-34.77,10.95))
Interior1V.append((-.41,-33.56,8.79))
Interior1V.append((-3.24,-34.77,10.95))
Interior1V.append((-2.09,-33.35,8.23))
Interior1V.append((-5.46,-32.49,9.81))
Interior1V.append((-13.26,-34.54,13.06))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-13.26,-34.54,13.06))
Interior1V.append((-13.07,-31.95,15.12))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-13.26,-34.54,13.06))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-13.07,-31.95,15.12))
Interior1V.append((-13.07,-31.95,15.12))
Interior1V.append((-14.37,-34.02,15.32))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-11.14,-36.06,12.61))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-11.14,-36.06,12.61))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-11.14,-36.06,12.61))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-7.81,-35.26,14.43))
Interior1V.append((-8.59,-33.91,12.49))
Interior1V.append((-9.52,-36.17,15.83))
Interior1V.append((-8.59,-33.91,12.49))
Interior1V.append((-9.54,-31.85,12.84))
Interior1V.append((-6.16,-37.77,17.73))
Interior1V.append((-7.14,-36.28,19.33))
Interior1V.append((-5.14,-35.57,20.67))
Interior1V.append((-16.78,-30.92,17.81))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-15.06,-32.32,16.70))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-9.72,-27.98,23.66))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-17.81,-28.70,18.24))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-9.72,-27.98,23.66))
Interior1V.append((-17.81,-28.70,18.24))
Interior1V.append((-16.78,-30.92,17.81))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-17.81,-28.70,18.24))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-16.78,-30.92,17.81))
Interior1V.append((-17.81,-28.70,18.24))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-17.81,-28.70,18.24))
Interior1V.append((-11.30,-30.86,26.23))
Interior1V.append((-11.30,-30.86,26.23))
Interior1V.append((-17.81,-28.70,18.24))
Interior1V.append((-9.72,-27.98,23.66))
Interior1V.append((-12.29,-32.14,26.76))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-11.30,-30.86,26.23))
Interior1V.append((-12.29,-32.14,26.76))
Interior1V.append((-11.30,-30.86,26.23))
Interior1V.append((-11.30,-32.45,25.23))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-12.29,-32.14,26.76))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-24.96,-36.76,10.77))
Interior1V.append((-26.06,-36.54,9.33))
Interior1V.append((-23.10,-33.75,11.57))
Interior1V.append((-26.26,-34.53,10.73))
Interior1V.append((-22.49,-32.51,8.61))
Interior1V.append((-23.10,-33.75,11.57))
Interior1V.append((-26.26,-34.53,10.73))
Interior1V.append((-23.10,-33.75,11.57))
Interior1V.append((-26.06,-36.54,9.33))
Interior1V.append((-23.05,-31.02,7.25))
Interior1V.append((-22.49,-32.51,8.61))
Interior1V.append((-26.26,-34.53,10.73))
Interior1V.append((-23.05,-31.02,7.25))
Interior1V.append((-26.26,-34.53,10.73))
Interior1V.append((-26.06,-36.54,9.33))
Interior1V.append((-22.38,-31.14,6.58))
Interior1V.append((-23.05,-31.02,7.25))
Interior1V.append((-26.06,-36.54,9.33))
Interior1V.append((-22.38,-31.14,6.58))
Interior1V.append((-22.49,-32.51,8.61))
Interior1V.append((-23.05,-31.02,7.25))
Interior1V.append((6.26,-32.17,-9.20))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((3.13,-30.47,-7.43))
Interior1V.append((6.26,-32.17,-9.20))
Interior1V.append((3.13,-30.47,-7.43))
Interior1V.append((5.05,-30.54,-6.52))
Interior1V.append((3.13,-30.47,-7.43))
Interior1V.append((3.78,-28.90,-6.31))
Interior1V.append((5.05,-30.54,-6.52))
Interior1V.append((7.06,-30.46,-7.72))
Interior1V.append((6.26,-32.17,-9.20))
Interior1V.append((5.05,-30.54,-6.52))
Interior1V.append((7.06,-30.46,-7.72))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((6.26,-32.17,-9.20))
Interior1V.append((7.12,-29.28,-7.36))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((7.06,-30.46,-7.72))
Interior1V.append((7.12,-29.28,-7.36))
Interior1V.append((7.06,-30.46,-7.72))
Interior1V.append((5.05,-30.54,-6.52))
Interior1V.append((5.05,-30.54,-6.52))
Interior1V.append((6.21,-28.81,-6.48))
Interior1V.append((7.12,-29.28,-7.36))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((5.32,-29.81,-10.70))
Interior1V.append((7.12,-29.28,-7.36))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((7.12,-29.28,-7.36))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((7.46,-28.72,-9.95))
Interior1V.append((7.33,-27.11,-9.43))
Interior1V.append((5.20,-26.82,-7.66))
Interior1V.append((3.40,-26.30,-9.43))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((3.37,-26.59,-1.99))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((3.37,-26.59,-1.99))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((3.31,-23.06,1.03))
Interior1V.append((3.37,-26.59,-1.99))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((4.44,-24.24,-2.14))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((3.37,-26.59,-1.99))
Interior1V.append((4.44,-24.24,-2.14))
Interior1V.append((3.37,-26.59,-1.99))
Interior1V.append((3.31,-23.06,1.03))
Interior1V.append((2.78,-22.74,-1.35))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((4.44,-24.24,-2.14))
Interior1V.append((2.78,-22.74,-1.35))
Interior1V.append((4.44,-24.24,-2.14))
Interior1V.append((3.31,-23.06,1.03))
Interior1V.append((2.78,-22.74,-1.35))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((2.68,-25.90,-2.44))
Interior1V.append((2.78,-22.74,-1.35))
Interior1V.append((3.31,-23.06,1.03))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((7.43,-25.68,9.01))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((3.85,-24.93,9.21))
Interior1V.append((7.43,-25.68,9.01))
Interior1V.append((3.85,-24.93,9.21))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((7.43,-25.68,9.01))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((6.76,-23.36,7.24))
Interior1V.append((2.95,-25.09,5.64))
Interior1V.append((6.37,-26.17,7.19))
Interior1V.append((10.75,-25.04,-.69))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((10.40,-28.40,-1.37))
Interior1V.append((10.75,-25.04,-.69))
Interior1V.append((10.47,-24.81,2.05))
Interior1V.append((8.37,-25.09,.01))
Interior1V.append((11.70,-25.35,2.14))
Interior1V.append((11.39,-27.02,3.15))
Interior1V.append((10.47,-24.81,2.05))
Interior1V.append((11.70,-25.35,2.14))
Interior1V.append((10.47,-24.81,2.05))
Interior1V.append((10.75,-25.04,-.69))
Interior1V.append((11.39,-27.02,3.15))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((10.47,-24.81,2.05))
Interior1V.append((9.16,-28.58,3.07))
Interior1V.append((11.39,-27.02,3.15))
Interior1V.append((12.71,-28.78,3.00))
Interior1V.append((10.75,-25.04,-.69))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((11.70,-25.35,2.14))
Interior1V.append((10.75,-25.04,-.69))
Interior1V.append((10.40,-28.40,-1.37))
Interior1V.append((12.59,-27.64,-1.54))
Interior1V.append((14.07,-23.82,-1.60))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((14.07,-23.82,-1.60))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((14.29,-27.10,-4.35))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((14.29,-27.10,-4.35))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((17.91,-26.79,-5.02))
Interior1V.append((14.29,-27.10,-4.35))
Interior1V.append((17.91,-26.79,-5.02))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((14.73,-24.29,-.53))
Interior1V.append((14.07,-23.82,-1.60))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((12.48,-25.05,-1.57))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((14.07,-23.82,-1.60))
Interior1V.append((12.48,-25.05,-1.57))
Interior1V.append((14.07,-23.82,-1.60))
Interior1V.append((14.73,-24.29,-.53))
Interior1V.append((14.15,-24.82,.44))
Interior1V.append((14.73,-24.29,-.53))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((14.15,-24.82,.44))
Interior1V.append((16.59,-25.02,-.48))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((19.99,-28.94,-2.06))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((18.15,-28.63,-.49))
Interior1V.append((17.66,-25.03,-2.75))
Interior1V.append((19.73,-26.81,.38))
Interior1V.append((19.55,-24.10,-4.37))
Interior1V.append((19.99,-28.94,-2.06))
Interior1V.append((8.92,-39.40,-10.13))
Interior1V.append((7.83,-39.47,-11.61))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((7.83,-39.47,-11.61))
Interior1V.append((6.90,-41.44,-15.64))
Interior1V.append((6.99,-43.96,-15.48))
Interior1V.append((9.91,-45.20,-10.83))
Interior1V.append((8.92,-39.40,-10.13))
Interior1V.append((7.19,-40.05,-9.99))
Interior1V.append((7.83,-39.47,-11.61))
Interior1V.append((8.92,-39.40,-10.13))
Interior1V.append((6.34,-43.27,-11.00))
Interior1V.append((7.19,-40.05,-9.99))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((19.41,-34.67,-3.63))
Interior1V.append((17.48,-32.78,-4.49))
Interior1V.append((18.42,-34.48,-6.01))
Interior1V.append((17.80,-36.85,-3.20))
Interior1V.append((19.41,-34.67,-3.63))
Interior1V.append((19.99,-28.94,-2.06))
Interior1V.append((23.15,-28.85,-2.21))
Interior1V.append((20.04,-31.17,-4.95))
Interior1V.append((20.04,-31.17,-4.95))
Interior1V.append((17.39,-29.07,-5.42))
Interior1V.append((19.99,-28.94,-2.06))
Interior1V.append((20.04,-31.17,-4.95))
Interior1V.append((17.91,-26.79,-5.02))
Interior1V.append((17.39,-29.07,-5.42))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((17.13,-37.91,-.75))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((17.29,-33.30,.41))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((17.29,-33.30,.41))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((16.07,-34.54,2.92))
Interior1V.append((15.02,-33.53,1.73))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((18.28,-33.83,-.33))
Interior1V.append((18.74,-36.24,-.95))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((18.74,-36.24,-.95))
Interior1V.append((17.13,-37.91,-.75))
Interior1V.append((18.28,-33.83,-.33))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((17.29,-33.30,.41))
Interior1V.append((18.28,-33.83,-.33))
Interior1V.append((17.29,-33.30,.41))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((16.07,-34.54,2.92))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((16.07,-34.54,2.92))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((17.28,-36.18,1.28))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((16.67,-38.26,1.02))
Interior1V.append((14.22,-38.50,3.24))
Interior1V.append((14.44,-33.16,1.07))
Interior1V.append((13.64,-31.67,-.83))
Interior1V.append((15.85,-32.76,-1.01))
Interior1V.append((18.42,-36.73,5.37))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((18.42,-36.73,5.37))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((17.13,-36.64,5.62))
Interior1V.append((18.42,-36.73,5.37))
Interior1V.append((17.13,-36.64,5.62))
Interior1V.append((16.35,-36.92,3.76))
Interior1V.append((18.65,-36.93,8.51))
Interior1V.append((18.32,-38.93,7.20))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((17.23,-35.83,11.61))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((18.65,-36.93,8.51))
Interior1V.append((17.23,-35.83,11.61))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((20.14,-35.36,10.50))
Interior1V.append((18.65,-36.93,8.51))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((20.14,-35.36,10.50))
Interior1V.append((19.99,-38.88,7.67))
Interior1V.append((17.23,-35.83,11.61))
Interior1V.append((20.14,-35.36,10.50))
Interior1V.append((17.23,-35.83,11.61))
Interior1V.append((18.65,-36.93,8.51))
Interior1V.append((14.46,-39.97,6.87))
Interior1V.append((14.17,-40.32,4.48))
Interior1V.append((14.58,-38.66,6.58))
Interior1V.append((14.46,-39.97,6.87))
Interior1V.append((14.58,-38.66,6.58))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((14.15,-24.82,.44))
Interior1V.append((14.85,-27.90,-1.91))
Interior1V.append((12.48,-25.05,-1.57))
Interior1V.append((14.15,-24.82,.44))
Interior1V.append((12.48,-25.05,-1.57))
Interior1V.append((14.73,-24.29,-.53))
Interior1V.append((11.77,-25.15,-14.59))
Interior1V.append((9.12,-20.34,-18.30))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((11.77,-25.15,-14.59))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((11.77,-25.15,-14.59))
Interior1V.append((9.72,-26.34,-14.92))
Interior1V.append((9.12,-20.34,-18.30))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((9.12,-20.34,-18.30))
Interior1V.append((6.48,-27.28,-18.76))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((6.48,-27.28,-18.76))
Interior1V.append((6.75,-27.01,-17.04))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((6.48,-27.28,-18.76))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((6.75,-27.01,-17.04))
Interior1V.append((7.30,-29.13,-16.42))
Interior1V.append((7.72,-29.25,-18.17))
Interior1V.append((7.30,-29.13,-16.42))
Interior1V.append((8.81,-32.34,-15.87))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((.58,-24.19,1.65))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((3.06,-26.69,4.20))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((3.06,-26.69,4.20))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((3.06,-26.69,4.20))
Interior1V.append((3.06,-26.69,4.20))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((3.06,-26.69,4.20))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((3.28,-25.35,4.64))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((4.57,-24.83,2.64))
Interior1V.append((3.96,-24.38,3.85))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((2.82,-21.48,1.49))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((2.82,-21.48,1.49))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((-.01,-27.25,4.57))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((-.01,-27.25,4.57))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((-.01,-27.25,4.57))
Interior1V.append((-1.59,-28.19,2.41))
Interior1V.append((.35,-24.83,2.79))
Interior1V.append((-.58,-28.43,4.22))
Interior1V.append((-1.59,-28.19,2.41))
Interior1V.append((-.01,-27.25,4.57))
Interior1V.append((-.58,-28.43,4.22))
Interior1V.append((-.01,-27.25,4.57))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((-.58,-28.43,4.22))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((-1.59,-28.19,2.41))
Interior1V.append((-.58,-28.43,4.22))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((-.33,-30.46,1.76))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-5.94,-34.59,3.70))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-5.94,-34.59,3.70))
Interior1V.append((-5.02,-34.61,3.32))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-5.02,-34.61,3.32))
Interior1V.append((-5.94,-34.59,3.70))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-5.94,-34.59,3.70))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-3.76,-39.00,7.58))
Interior1V.append((-4.11,-33.72,5.38))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-5.02,-34.61,3.32))
Interior1V.append((-4.11,-33.72,5.38))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-4.70,-35.28,5.87))
Interior1V.append((-5.02,-34.61,3.32))
Interior1V.append((-5.94,-32.09,3.36))
Interior1V.append((-4.11,-33.72,5.38))
Interior1V.append((-5.02,-34.61,3.32))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-5.94,-32.09,3.36))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-4.11,-33.72,5.38))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((-.95,-35.30,7.22))
Interior1V.append((-1.83,-35.30,6.23))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((.29,-30.87,8.56))
Interior1V.append((2.16,-30.11,11.04))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((.29,-30.87,8.56))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((-.41,-33.56,8.79))
Interior1V.append((2.16,-30.11,11.04))
Interior1V.append((.29,-30.87,8.56))
Interior1V.append((4.03,-32.14,9.88))
Interior1V.append((-4.65,-35.26,.47))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-5.02,-34.61,3.32))
Interior1V.append((.02,-36.69,1.42))
Interior1V.append((.30,-35.02,2.67))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-4.65,-35.26,.47))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.02,-36.69,1.42))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((.02,-36.69,1.42))
Interior1V.append((1.65,-34.74,.54))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((1.65,-34.74,.54))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((1.65,-34.74,.54))
Interior1V.append((.90,-37.03,-.22))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((.37,-34.35,-2.80))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((-3.16,-33.19,.49))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((.28,-34.10,2.27))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((1.01,-30.97,5.22))
Interior1V.append((-.31,-33.41,2.69))
Interior1V.append((1.01,-30.97,5.22))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((4.80,-32.59,2.92))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((.75,-32.63,.57))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((1.65,-34.74,.54))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((1.65,-34.74,.54))
Interior1V.append((.91,-33.83,1.12))
Interior1V.append((2.97,-33.19,4.23))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((.25,-31.93,1.08))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((-.52,-31.61,-2.24))
Interior1V.append((1.19,-32.46,-.32))
Interior1V.append((-.07,-29.09,-2.13))
Interior1V.append((-5.65,-39.57,-2.28))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-6.75,-37.10,.10))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-4.18,-42.26,-1.35))
Interior1V.append((-2.94,-43.15,.70))
Interior1V.append((-3.21,-40.17,-.62))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-4.18,-42.26,-1.35))
Interior1V.append((-20.12,-41.20,-5.46))
Interior1V.append((-18.87,-42.34,-3.47))
Interior1V.append((-23.75,-46.19,-1.98))
Interior1V.append((-20.12,-41.20,-5.46))
Interior1V.append((-23.75,-46.19,-1.98))
Interior1V.append((-17.30,-43.21,-4.02))
Interior1V.append((-20.12,-41.20,-5.46))
Interior1V.append((-17.30,-43.21,-4.02))
Interior1V.append((-18.87,-42.34,-3.47))
Interior1V.append((-18.87,-42.34,-3.47))
Interior1V.append((-17.30,-43.21,-4.02))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-18.87,-42.34,-3.47))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-23.75,-46.19,-1.98))
Interior1V.append((-20.60,-30.38,2.64))
Interior1V.append((-18.31,-32.40,4.54))
Interior1V.append((-22.38,-31.14,6.58))
Interior1V.append((-20.60,-30.38,2.64))
Interior1V.append((-22.38,-31.14,6.58))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-20.60,-30.38,2.64))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-18.31,-32.40,4.54))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-22.38,-31.14,6.58))
Interior1V.append((-18.31,-32.40,4.54))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-18.31,-32.40,4.54))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-26.06,-36.54,9.33))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-22.38,-31.14,6.58))
Interior1V.append((-20.27,-32.06,7.33))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-20.27,-32.06,7.33))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-20.27,-32.06,7.33))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-22.49,-32.51,8.61))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-23.10,-33.75,11.57))
Interior1V.append((-22.49,-32.51,8.61))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-23.10,-33.75,11.57))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-21.58,-35.18,12.46))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-26.06,-36.54,9.33))
Interior1V.append((-24.96,-36.76,10.77))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-26.06,-36.54,9.33))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-26.17,-39.10,9.72))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-24.96,-36.76,10.77))
Interior1V.append((-26.17,-39.10,9.72))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-26.12,-38.78,8.54))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-18.30,-37.80,10.39))
Interior1V.append((-17.24,-38.28,9.01))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-17.24,-38.28,9.01))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-18.30,-37.80,10.39))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-17.24,-38.28,9.01))
Interior1V.append((-18.30,-37.80,10.39))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-18.30,-37.80,10.39))
Interior1V.append((-16.52,-37.59,8.86))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-16.52,-37.59,8.86))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-17.24,-38.28,9.01))
Interior1V.append((-16.52,-37.59,8.86))
Interior1V.append((-17.24,-38.28,9.01))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-13.75,-38.29,5.89))
Interior1V.append((-14.41,-37.49,1.86))
Interior1V.append((-10.57,-36.46,3.78))
Interior1V.append((-13.75,-38.29,5.89))
Interior1V.append((-14.44,-39.43,2.89))
Interior1V.append((-14.41,-37.49,1.86))
Interior1V.append((-20.79,-40.70,1.93))
Interior1V.append((-21.00,-42.42,3.88))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-20.79,-40.70,1.93))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-21.00,-42.42,3.88))
Interior1V.append((-20.79,-40.70,1.93))
Interior1V.append((-22.71,-42.13,1.97))
Interior1V.append((-22.69,-42.75,4.25))
Interior1V.append((-22.99,-44.39,-1.26))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-22.99,-44.39,-1.26))
Interior1V.append((-23.75,-46.19,-1.98))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-22.99,-44.39,-1.26))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-23.75,-46.19,-1.98))
Interior1V.append((-21.66,-45.00,.13))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-21.04,-47.73,1.51))
Interior1V.append((-21.66,-45.00,.13))
Interior1V.append((-21.04,-47.73,1.51))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-21.66,-45.00,.13))
Interior1V.append((-22.14,-47.81,-1.09))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-17.75,-43.48,3.47))
Interior1V.append((-17.09,-41.85,5.17))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-17.75,-43.48,3.47))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-17.09,-41.85,5.17))
Interior1V.append((-17.09,-41.85,5.17))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-14.67,-42.77,8.18))
Interior1V.append((-17.09,-41.85,5.17))
Interior1V.append((-14.67,-42.77,8.18))
Interior1V.append((-16.03,-44.76,6.52))
Interior1V.append((-17.07,-42.73,2.50))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-17.75,-43.48,3.47))
Interior1V.append((-17.07,-42.73,2.50))
Interior1V.append((-12.41,-43.68,2.70))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-17.75,-43.48,3.47))
Interior1V.append((-18.28,-44.38,3.19))
Interior1V.append((-17.07,-42.73,2.50))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-20.79,-40.70,1.93))
Interior1V.append((-19.82,-38.34,6.13))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-19.61,-33.67,3.18))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-7.00,-39.40,5.26))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-6.03,-38.45,1.78))
Interior1V.append((-5.30,-38.88,5.15))
Interior1V.append((-7.00,-39.40,5.26))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-6.03,-38.45,1.78))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-6.03,-38.45,1.78))
Interior1V.append((-6.94,-34.95,2.80))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-8.10,-34.91,3.18))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-8.10,-34.91,3.18))
Interior1V.append((-7.62,-37.21,1.58))
Interior1V.append((-6.94,-34.95,2.80))
Interior1V.append((-8.10,-34.91,3.18))
Interior1V.append((-6.94,-34.95,2.80))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-5.94,-34.59,3.70))
Interior1V.append((-6.94,-34.95,2.80))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-5.94,-34.59,3.70))
Interior1V.append((-5.55,-37.64,1.57))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-5.94,-34.59,3.70))
Interior1V.append((-7.34,-37.24,5.40))
Interior1V.append((-6.94,-34.95,2.80))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-10.10,-37.76,4.01))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-9.87,-38.21,4.87))
Interior1V.append((-10.10,-37.76,4.01))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-9.87,-38.21,4.87))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-10.10,-37.76,4.01))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-10.55,-42.66,2.69))
Interior1V.append((-10.04,-41.57,2.47))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-14.44,-39.43,2.89))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-14.44,-39.43,2.89))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-9.87,-38.30,2.84))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-13.75,-38.29,5.89))
Interior1V.append((-10.10,-37.76,4.01))
Interior1V.append((-13.75,-38.29,5.89))
Interior1V.append((-14.04,-39.97,5.73))
Interior1V.append((-14.44,-39.43,2.89))
Interior1V.append((-13.75,-38.29,5.89))
Interior1V.append((-11.79,-39.67,6.43))
Interior1V.append((-14.04,-39.97,5.73))
Interior1V.append((-13.43,-37.60,11.39))
Interior1V.append((-14.74,-39.98,10.35))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-13.43,-37.60,11.39))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-14.74,-39.98,10.35))
Interior1V.append((-13.43,-37.60,11.39))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-14.74,-39.98,10.35))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-14.57,-41.80,11.70))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-14.57,-41.80,11.70))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-15.18,-41.08,10.70))
Interior1V.append((-14.57,-41.80,11.70))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-15.18,-41.08,10.70))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-14.57,-41.80,11.70))
Interior1V.append((-15.18,-41.08,10.70))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-14.74,-39.98,10.35))
Interior1V.append((-15.18,-41.08,10.70))
Interior1V.append((-14.74,-39.98,10.35))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-10.30,-42.44,9.65))
Interior1V.append((-12.17,-42.42,10.37))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-10.30,-42.44,9.65))
Interior1V.append((-10.84,-42.06,13.68))
Interior1V.append((-12.17,-42.42,10.37))
Interior1V.append((-19.46,-44.45,15.15))
Interior1V.append((-18.23,-45.69,18.94))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-19.46,-44.45,15.15))
Interior1V.append((-20.84,-44.44,18.57))
Interior1V.append((-18.23,-45.69,18.94))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-18.23,-45.69,18.94))
Interior1V.append((-20.84,-44.44,18.57))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-20.84,-44.44,18.57))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-19.73,-40.51,21.23))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-18.18,-38.95,15.76))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-18.18,-38.95,15.76))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-18.18,-38.95,15.76))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-17.46,-40.00,15.10))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-20.83,-34.08,13.49))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-20.83,-34.08,13.49))
Interior1V.append((-21.58,-35.18,12.46))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-20.83,-34.08,13.49))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-21.58,-35.18,12.46))
Interior1V.append((-23.80,-34.77,13.70))
Interior1V.append((-22.53,-37.60,13.78))
Interior1V.append((-24.96,-36.76,10.77))
Interior1V.append((-23.80,-34.77,13.70))
Interior1V.append((-21.58,-35.18,12.46))
Interior1V.append((-22.53,-37.60,13.78))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-12.46,-37.50,14.43))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-14.11,-38.59,18.55))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-13.37,-40.45,12.82))
Interior1V.append((-12.46,-37.50,14.43))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-16.43,-39.91,14.77))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-13.43,-37.60,11.39))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-13.43,-37.60,11.39))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-16.24,-35.04,10.80))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-16.24,-35.04,10.80))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-16.24,-35.04,10.80))
Interior1V.append((-13.96,-36.86,13.60))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-16.24,-35.04,10.80))
Interior1V.append((-17.36,-37.11,13.93))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-18.24,-31.91,17.51))
Interior1V.append((-16.78,-30.92,17.81))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-16.78,-30.92,17.81))
Interior1V.append((-18.24,-31.91,17.51))
Interior1V.append((-19.25,-36.76,19.52))
Interior1V.append((-18.24,-31.91,17.51))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-19.25,-36.76,19.52))
Interior1V.append((-21.26,-37.12,20.40))
Interior1V.append((-19.25,-36.76,19.52))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-21.26,-37.12,20.40))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-19.25,-36.76,19.52))
Interior1V.append((-19.08,-37.61,24.93))
Interior1V.append((-21.26,-37.12,20.40))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-19.08,-37.61,24.93))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-21.26,-37.12,20.40))
Interior1V.append((-19.08,-37.61,24.93))
Interior1V.append((-18.87,-29.87,18.85))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-15.15,-37.24,26.29))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-12.29,-32.14,26.76))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-12.29,-32.14,26.76))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-12.33,-33.29,28.48))
Interior1V.append((-15.15,-37.24,26.29))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-15.63,-38.18,23.27))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-14.95,-38.85,23.39))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-15.63,-38.18,23.27))
Interior1V.append((-17.75,-42.93,21.57))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-19.73,-40.51,21.23))
Interior1V.append((-17.75,-42.93,21.57))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-18.34,-38.45,20.63))
Interior1V.append((-21.79,-40.72,18.92))
Interior1V.append((-19.97,-38.38,16.74))
Interior1V.append((-18.34,-38.45,20.63))
Interior1V.append((-19.73,-40.51,21.23))
Interior1V.append((-21.79,-40.72,18.92))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-19.97,-38.38,16.74))
Interior1V.append((-21.79,-40.72,18.92))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-18.34,-38.45,20.63))
Interior1V.append((-19.97,-38.38,16.74))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-18.34,-38.45,20.63))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-17.64,-39.07,20.99))
Interior1V.append((-19.73,-40.51,21.23))
Interior1V.append((-18.34,-38.45,20.63))
Interior1V.append((-17.64,-39.07,20.99))
Interior1V.append((-18.34,-38.45,20.63))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-16.98,-40.55,21.68))
Interior1V.append((-19.73,-40.51,21.23))
Interior1V.append((-17.64,-39.07,20.99))
Interior1V.append((-16.98,-40.55,21.68))
Interior1V.append((-17.64,-39.07,20.99))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-16.61,-36.78,24.35))
Interior1V.append((-15.63,-38.18,23.27))
Interior1V.append((-15.63,-38.18,23.27))
Interior1V.append((-15.23,-38.04,18.74))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-16.38,-33.53,16.86))
Interior1V.append((-16.78,-30.92,17.81))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-16.78,-30.92,17.81))
Interior1V.append((-15.06,-32.32,16.70))
Interior1V.append((-9.22,-31.22,23.56))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-8.41,-32.68,22.13))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-15.06,-32.32,16.70))
Interior1V.append((-13.07,-31.95,15.12))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-8.41,-32.68,22.13))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-6.04,-32.45,19.94))
Interior1V.append((-9.22,-31.22,23.56))
Interior1V.append((-11.30,-32.45,25.23))
Interior1V.append((-11.30,-30.86,26.23))
Interior1V.append((-9.22,-31.22,23.56))
Interior1V.append((-11.30,-30.86,26.23))
Interior1V.append((-9.72,-27.98,23.66))
Interior1V.append((-9.72,-27.98,23.66))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-9.22,-31.22,23.56))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-11.30,-32.45,25.23))
Interior1V.append((-9.22,-31.22,23.56))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-9.22,-31.22,23.56))
Interior1V.append((-8.41,-32.68,22.13))
Interior1V.append((-8.41,-32.68,22.13))
Interior1V.append((-9.22,-31.22,23.56))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-14.65,-29.12,14.74))
Interior1V.append((-15.06,-32.32,16.70))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-14.65,-29.12,14.74))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-15.06,-32.32,16.70))
Interior1V.append((-16.24,-35.04,10.80))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-16.24,-35.04,10.80))
Interior1V.append((-20.02,-32.56,10.02))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-16.24,-35.04,10.80))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-16.05,-35.62,10.00))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-16.05,-35.62,10.00))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-16.05,-35.62,10.00))
Interior1V.append((-17.56,-34.04,7.52))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-20.86,-32.84,7.14))
Interior1V.append((-22.49,-32.51,8.61))
Interior1V.append((-22.38,-31.14,6.58))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-26.17,-39.10,9.72))
Interior1V.append((-24.96,-36.76,10.77))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-26.17,-39.10,9.72))
Interior1V.append((-23.08,-40.13,11.29))
Interior1V.append((-24.96,-36.76,10.77))
Interior1V.append((-22.53,-37.60,13.78))
Interior1V.append((-23.75,-42.03,10.90))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-23.75,-43.33,11.41))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-23.75,-42.03,10.90))
Interior1V.append((-23.75,-43.33,11.41))
Interior1V.append((-23.75,-42.03,10.90))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-23.75,-42.03,10.90))
Interior1V.append((-23.58,-42.69,8.89))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-23.75,-42.03,10.90))
Interior1V.append((-21.42,-45.02,10.59))
Interior1V.append((-23.58,-42.69,8.89))
Interior1V.append((-23.75,-42.03,10.90))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-21.42,-45.02,10.59))
Interior1V.append((-21.42,-45.02,10.59))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-23.75,-43.33,11.41))
Interior1V.append((-21.42,-45.02,10.59))
Interior1V.append((-23.36,-43.64,12.74))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-21.42,-45.02,10.59))
Interior1V.append((-23.75,-43.33,11.41))
Interior1V.append((-23.36,-43.64,12.74))
Interior1V.append((-23.36,-43.64,12.74))
Interior1V.append((-23.75,-43.33,11.41))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-22.96,-42.65,13.57))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-23.36,-43.64,12.74))
Interior1V.append((-22.96,-42.65,13.57))
Interior1V.append((-23.36,-43.64,12.74))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-22.96,-42.65,13.57))
Interior1V.append((-22.99,-41.26,13.12))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-22.96,-42.65,13.57))
Interior1V.append((-23.24,-41.08,11.76))
Interior1V.append((-22.99,-41.26,13.12))
Interior1V.append((-23.50,-51.74,6.47))
Interior1V.append((-22.80,-51.12,2.77))
Interior1V.append((-21.57,-52.88,5.29))
Interior1V.append((-23.50,-51.74,6.47))
Interior1V.append((-26.07,-53.93,6.94))
Interior1V.append((-22.80,-51.12,2.77))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-21.57,-52.88,5.29))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-20.71,-50.56,2.98))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-18.49,-50.72,7.43))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-18.49,-50.72,7.43))
Interior1V.append((-20.65,-51.52,5.63))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-18.49,-50.72,7.43))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-18.49,-50.72,7.43))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-17.19,-50.71,7.35))
Interior1V.append((-19.29,-50.64,6.48))
Interior1V.append((-16.43,-48.17,5.59))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-13.51,-53.03,2.70))
Interior1V.append((-12.62,-51.76,5.65))
Interior1V.append((-12.62,-51.76,5.65))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-11.60,-51.23,1.55))
Interior1V.append((-13.51,-53.03,2.70))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-11.60,-51.23,1.55))
Interior1V.append((-14.63,-52.00,1.82))
Interior1V.append((-13.51,-53.03,2.70))
Interior1V.append((-11.60,-51.23,1.55))
Interior1V.append((-11.58,-50.46,5.01))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-13.67,-52.67,-.39))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-11.60,-51.23,1.55))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-13.67,-52.67,-.39))
Interior1V.append((-11.60,-51.23,1.55))
Interior1V.append((-13.67,-52.67,-.39))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-11.60,-51.23,1.55))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-14.63,-52.00,1.82))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-13.30,-53.09,.81))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-13.30,-53.09,.81))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-7.56,-52.27,.71))
Interior1V.append((-7.96,-54.76,2.60))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-7.56,-52.27,.71))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-7.56,-52.27,.71))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-7.96,-54.76,2.60))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-4.20,-53.70,-1.71))
Interior1V.append((-4.12,-55.52,-.10))
Interior1V.append((-4.20,-53.70,-1.71))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-2.87,-48.41,4.29))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((-3.30,-47.11,4.43))
Interior1V.append((-2.87,-48.41,4.29))
Interior1V.append((-3.15,-48.99,5.52))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((-2.87,-48.41,4.29))
Interior1V.append((-3.30,-47.11,4.43))
Interior1V.append((-3.15,-48.99,5.52))
Interior1V.append((-3.82,-48.06,6.46))
Interior1V.append((-3.15,-48.99,5.52))
Interior1V.append((-3.30,-47.11,4.43))
Interior1V.append((-3.30,-47.11,4.43))
Interior1V.append((.20,-47.26,5.58))
Interior1V.append((-3.95,-46.94,5.74))
Interior1V.append((-3.30,-47.11,4.43))
Interior1V.append((-3.95,-46.94,5.74))
Interior1V.append((-3.82,-48.06,6.46))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-3.82,-48.06,6.46))
Interior1V.append((-3.72,-44.84,6.12))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((-3.82,-48.06,6.46))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((.07,-47.35,9.16))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((-1.90,-47.63,10.55))
Interior1V.append((-3.23,-50.04,8.34))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((3.49,-50.71,11.07))
Interior1V.append((4.12,-50.31,7.42))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((2.94,-48.58,7.84))
Interior1V.append((5.32,-46.14,8.70))
Interior1V.append((4.74,-45.02,11.13))
Interior1V.append((3.59,-46.23,9.24))
Interior1V.append((4.85,-52.73,19.95))
Interior1V.append((6.33,-52.86,20.94))
Interior1V.append((6.17,-51.20,17.66))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((4.85,-52.73,19.95))
Interior1V.append((1.19,-52.45,22.49))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((6.33,-52.86,20.94))
Interior1V.append((4.85,-52.73,19.95))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((1.19,-52.45,22.49))
Interior1V.append((4.85,-52.73,19.95))
Interior1V.append((1.19,-52.45,22.49))
Interior1V.append((1.35,-51.27,24.38))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((1.35,-51.27,24.38))
Interior1V.append((1.19,-52.45,22.49))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((2.12,-53.20,19.65))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((4.85,-52.73,19.95))
Interior1V.append((2.12,-53.20,19.65))
Interior1V.append((.97,-51.01,19.24))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((4.85,-52.73,19.95))
Interior1V.append((4.20,-53.67,17.93))
Interior1V.append((2.12,-53.20,19.65))
Interior1V.append((6.27,-50.63,16.75))
Interior1V.append((6.17,-51.20,17.66))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((6.27,-50.63,16.75))
Interior1V.append((4.80,-51.83,15.64))
Interior1V.append((6.17,-51.20,17.66))
Interior1V.append((7.05,-49.52,16.65))
Interior1V.append((6.27,-50.63,16.75))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((7.05,-49.52,16.65))
Interior1V.append((7.52,-49.11,17.94))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((7.05,-49.52,16.65))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((6.27,-50.63,16.75))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((8.10,-48.34,17.94))
Interior1V.append((11.10,-50.17,18.64))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((11.10,-50.17,18.64))
Interior1V.append((5.54,-44.66,22.77))
Interior1V.append((8.10,-48.34,17.94))
Interior1V.append((10.97,-43.76,15.37))
Interior1V.append((5.47,-45.05,16.46))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((12.85,-45.87,13.81))
Interior1V.append((13.47,-49.04,15.00))
Interior1V.append((13.01,-48.57,12.43))
Interior1V.append((13.47,-49.04,15.00))
Interior1V.append((15.07,-50.36,13.30))
Interior1V.append((5.57,-51.07,15.58))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((5.57,-51.07,15.58))
Interior1V.append((2.22,-50.61,15.16))
Interior1V.append((4.80,-51.83,15.64))
Interior1V.append((5.57,-51.07,15.58))
Interior1V.append((6.27,-50.63,16.75))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((5.57,-51.07,15.58))
Interior1V.append((4.80,-51.83,15.64))
Interior1V.append((6.27,-50.63,16.75))
Interior1V.append((1.35,-51.27,24.38))
Interior1V.append((-.51,-52.75,25.34))
Interior1V.append((2.52,-53.83,24.04))
Interior1V.append((1.35,-51.27,24.38))
Interior1V.append((2.03,-49.70,27.15))
Interior1V.append((-.51,-52.75,25.34))
Interior1V.append((1.35,-51.27,24.38))
Interior1V.append((2.19,-49.04,24.81))
Interior1V.append((2.03,-49.70,27.15))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((1.35,-51.27,24.38))
Interior1V.append((1.77,-50.46,20.80))
Interior1V.append((.67,-48.52,22.55))
Interior1V.append((2.19,-49.04,24.81))
Interior1V.append((1.35,-51.27,24.38))
Interior1V.append((-1.94,-46.51,23.90))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-1.99,-45.56,24.19))
Interior1V.append((-1.94,-46.51,23.90))
Interior1V.append((-1.99,-45.56,24.19))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-1.20,-47.03,21.95))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-1.20,-47.03,21.95))
Interior1V.append((-1.94,-46.51,23.90))
Interior1V.append((-.90,-44.88,22.11))
Interior1V.append((-2.95,-47.36,24.10))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((-1.94,-46.51,23.90))
Interior1V.append((-2.95,-47.36,24.10))
Interior1V.append((-1.94,-46.51,23.90))
Interior1V.append((-1.20,-47.03,21.95))
Interior1V.append((-2.95,-47.36,24.10))
Interior1V.append((-1.20,-47.03,21.95))
Interior1V.append((-4.61,-44.88,20.77))
Interior1V.append((2.35,-47.68,27.40))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((2.35,-47.68,27.40))
Interior1V.append((3.59,-47.85,27.47))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((2.35,-47.68,27.40))
Interior1V.append((2.42,-46.36,23.77))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((-.33,-45.09,26.51))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((-.33,-45.09,26.51))
Interior1V.append((2.17,-44.64,23.80))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((-.08,-43.68,27.58))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((-.33,-45.09,26.51))
Interior1V.append((-.08,-43.68,27.58))
Interior1V.append((-.33,-45.09,26.51))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((-.08,-43.68,27.58))
Interior1V.append((1.19,-41.96,25.78))
Interior1V.append((1.87,-46.57,27.59))
Interior1V.append((-.38,-39.59,24.25))
Interior1V.append((-1.56,-40.64,22.97))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((-.38,-39.59,24.25))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((-1.56,-40.64,22.97))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((-.01,-42.24,23.55))
Interior1V.append((-1.56,-40.64,22.97))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((.69,-38.17,19.45))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((-1.73,-41.05,18.50))
Interior1V.append((1.85,-42.04,17.25))
Interior1V.append((-.38,-39.59,24.25))
Interior1V.append((-1.62,-39.70,21.09))
Interior1V.append((1.41,-37.93,23.85))
Interior1V.append((-.38,-39.59,24.25))
Interior1V.append((1.41,-37.93,23.85))
Interior1V.append((1.60,-40.40,24.31))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-16.39,-60.48,5.16))
Interior1V.append((-14.34,-63.80,5.55))
Interior1V.append((-14.34,-63.80,5.55))
Interior1V.append((-14.93,-64.03,4.67))
Interior1V.append((-15.37,-65.01,6.92))
Interior1V.append((-14.34,-63.80,5.55))
Interior1V.append((-15.37,-65.01,6.92))
Interior1V.append((-18.08,-61.19,5.49))
Interior1V.append((-16.39,-60.48,5.16))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-15.47,-58.77,6.33))
Interior1V.append((-21.30,-56.24,11.36))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-21.37,-53.75,11.56))
Interior1V.append((-21.30,-56.24,11.36))
Interior1V.append((-21.37,-53.75,11.56))
Interior1V.append((-20.47,-56.77,11.21))
Interior1V.append((-21.30,-56.24,11.36))
Interior1V.append((-20.47,-56.77,11.21))
Interior1V.append((-20.88,-56.90,7.57))
Interior1V.append((-15.97,-44.64,19.65))
Interior1V.append((-18.23,-45.69,18.94))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-14.78,-41.88,19.12))
Interior1V.append((-15.97,-44.64,19.65))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-15.89,-46.88,18.98))
Interior1V.append((-15.97,-44.64,19.65))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-15.89,-46.88,18.98))
Interior1V.append((-18.23,-45.69,18.94))
Interior1V.append((-15.97,-44.64,19.65))
Interior1V.append((-15.89,-46.88,18.98))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-18.23,-45.69,18.94))
Interior1V.append((-14.68,-44.88,16.72))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-15.97,-44.64,19.65))
Interior1V.append((-14.68,-44.88,16.72))
Interior1V.append((-15.97,-44.64,19.65))
Interior1V.append((-14.78,-41.88,19.12))
Interior1V.append((-12.56,-49.28,16.21))
Interior1V.append((-9.67,-49.28,16.81))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-12.56,-49.28,16.21))
Interior1V.append((-10.72,-47.19,16.12))
Interior1V.append((-9.67,-49.28,16.81))
Interior1V.append((-12.56,-49.28,16.21))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-10.72,-47.19,16.12))
Interior1V.append((-12.56,-49.28,16.21))
Interior1V.append((-12.36,-47.31,15.44))
Interior1V.append((-11.08,-46.66,14.40))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-11.22,-41.53,18.82))
Interior1V.append((-13.04,-37.99,18.86))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-11.22,-41.53,18.82))
Interior1V.append((-11.22,-41.53,18.82))
Interior1V.append((-13.17,-40.50,18.02))
Interior1V.append((-13.04,-37.99,18.86))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-13.04,-37.99,18.86))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-15.02,-39.39,20.83))
Interior1V.append((-13.04,-37.99,18.86))
Interior1V.append((-15.23,-38.04,18.74))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-13.04,-37.99,18.86))
Interior1V.append((-15.02,-39.39,20.83))
Interior1V.append((-15.02,-39.39,20.83))
Interior1V.append((-15.23,-38.04,18.74))
Interior1V.append((-15.63,-38.18,23.27))
Interior1V.append((-15.63,-38.18,23.27))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-15.02,-39.39,20.83))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-15.63,-38.18,23.27))
Interior1V.append((-14.95,-38.85,23.39))
Interior1V.append((-14.78,-41.88,19.12))
Interior1V.append((-18.18,-44.02,19.64))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-16.98,-40.55,21.68))
Interior1V.append((-17.75,-42.93,21.57))
Interior1V.append((-19.73,-40.51,21.23))
Interior1V.append((-16.98,-40.55,21.68))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-17.75,-42.93,21.57))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-16.75,-53.45,13.21))
Interior1V.append((-16.68,-51.27,13.39))
Interior1V.append((-15.13,-51.85,10.17))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-16.75,-53.45,13.21))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-14.37,-38.56,25.34))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-9.58,-37.35,24.20))
Interior1V.append((-6.44,-39.91,23.04))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-7.63,-37.32,20.78))
Interior1V.append((-6.44,-39.91,23.04))
Interior1V.append((-9.53,-40.60,21.88))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-9.53,-40.60,21.88))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-9.73,-38.63,23.74))
Interior1V.append((-9.53,-40.60,21.88))
Interior1V.append((-6.44,-39.91,23.04))
Interior1V.append((-6.95,-41.38,22.03))
Interior1V.append((-5.33,-40.97,22.03))
Interior1V.append((-6.95,-41.38,22.03))
Interior1V.append((-6.44,-39.91,23.04))
Interior1V.append((-5.33,-40.97,22.03))
Interior1V.append((-6.44,-39.91,23.04))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-5.33,-40.97,22.03))
Interior1V.append((-4.23,-39.66,19.78))
Interior1V.append((-6.95,-41.38,22.03))
Interior1V.append((-5.33,-40.97,22.03))
Interior1V.append((-6.11,-37.65,19.85))
Interior1V.append((-4.23,-39.66,19.78))
Interior1V.append((-9.53,-40.60,21.88))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-10.55,-38.91,22.64))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-9.53,-40.60,21.88))
Interior1V.append((-8.80,-41.16,18.98))
Interior1V.append((-10.80,-40.08,20.90))
Interior1V.append((-8.80,-41.16,18.98))
Interior1V.append((-8.05,-39.07,18.08))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-11.07,-36.55,22.49))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-10.33,-36.30,23.61))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-10.29,-34.93,24.07))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-14.95,-38.85,23.39))
Interior1V.append((-14.15,-36.88,24.71))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-14.95,-38.85,23.39))
Interior1V.append((-11.16,-37.86,22.00))
Interior1V.append((-11.72,-35.78,22.10))
Interior1V.append((-11.70,-38.10,21.10))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-14.64,-40.20,17.14))
Interior1V.append((-17.77,-42.07,14.23))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-17.34,-44.85,15.88))
Interior1V.append((-9.67,-49.28,16.81))
Interior1V.append((-9.01,-46.87,14.16))
Interior1V.append((-7.87,-50.51,13.63))
Interior1V.append((-9.67,-49.28,16.81))
Interior1V.append((-7.87,-50.51,13.63))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-16.66,-57.45,6.22))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-15.47,-58.77,6.33))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-16.66,-57.45,6.22))
Interior1V.append((-16.24,-57.96,7.82))
Interior1V.append((-16.24,-57.96,7.82))
Interior1V.append((-16.66,-57.45,6.22))
Interior1V.append((-18.35,-57.20,8.22))
Interior1V.append((-16.24,-57.96,7.82))
Interior1V.append((-18.35,-57.20,8.22))
Interior1V.append((-15.74,-57.30,9.99))
Interior1V.append((-12.35,-59.16,7.55))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-10.93,-57.70,8.02))
Interior1V.append((-12.35,-59.16,7.55))
Interior1V.append((-15.47,-58.77,6.33))
Interior1V.append((-13.65,-58.42,8.55))
Interior1V.append((-12.35,-59.16,7.55))
Interior1V.append((-10.93,-57.70,8.02))
Interior1V.append((-10.02,-59.44,6.30))
Interior1V.append((-10.02,-59.44,6.30))
Interior1V.append((-10.32,-60.30,4.68))
Interior1V.append((-12.35,-59.16,7.55))
Interior1V.append((-10.02,-59.44,6.30))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-10.32,-60.30,4.68))
Interior1V.append((-10.11,-54.63,4.48))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-9.64,-56.19,6.27))
Interior1V.append((-10.11,-54.63,4.48))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-10.60,-56.96,3.40))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-10.11,-54.63,4.48))
Interior1V.append((-9.64,-56.19,6.27))
Interior1V.append((-9.64,-56.19,6.27))
Interior1V.append((-10.36,-53.68,6.70))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-9.64,-56.19,6.27))
Interior1V.append((-10.93,-57.70,8.02))
Interior1V.append((-9.71,-55.48,8.16))
Interior1V.append((-9.64,-56.19,6.27))
Interior1V.append((-9.71,-55.48,8.16))
Interior1V.append((-10.36,-53.68,6.70))
Interior1V.append((-10.11,-54.63,4.48))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-10.36,-53.68,6.70))
Interior1V.append((-10.11,-54.63,4.48))
Interior1V.append((-10.36,-53.68,6.70))
Interior1V.append((-11.66,-53.98,2.97))
Interior1V.append((-12.62,-51.76,5.65))
Interior1V.append((-10.36,-53.68,6.70))
Interior1V.append((-11.79,-53.11,7.65))
Interior1V.append((-12.62,-51.76,5.65))
Interior1V.append((-11.66,-53.98,2.97))
Interior1V.append((-10.36,-53.68,6.70))
Interior1V.append((-11.66,-53.98,2.97))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-10.11,-54.63,4.48))
Interior1V.append((-13.51,-53.03,2.70))
Interior1V.append((-11.66,-53.98,2.97))
Interior1V.append((-12.62,-51.76,5.65))
Interior1V.append((-13.51,-53.03,2.70))
Interior1V.append((-12.50,-55.51,2.55))
Interior1V.append((-11.66,-53.98,2.97))
Interior1V.append((-15.74,-57.30,9.99))
Interior1V.append((-18.60,-57.03,10.84))
Interior1V.append((-15.81,-54.37,10.75))
Interior1V.append((-15.74,-57.30,9.99))
Interior1V.append((-18.35,-57.20,8.22))
Interior1V.append((-18.60,-57.03,10.84))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-15.95,-53.61,7.95))
Interior1V.append((-15.81,-54.37,10.75))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((-6.18,-51.98,7.31))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-3.87,-49.19,8.61))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-6.18,-51.98,7.31))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-6.20,-49.08,5.50))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-6.90,-49.26,10.01))
Interior1V.append((-4.71,-47.34,8.22))
Interior1V.append((-8.25,-48.97,6.75))
Interior1V.append((-4.12,-48.17,7.79))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-13.92,-44.12,-2.76))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-15.55,-44.12,-5.03))
Interior1V.append((-13.67,-52.67,-.39))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-13.67,-52.67,-.39))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-14.33,-51.92,-.38))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-13.67,-52.67,-.39))
Interior1V.append((-9.44,-50.72,.41))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-8.36,-45.28,-2.24))
Interior1V.append((-13.92,-44.12,-2.76))
Interior1V.append((-8.56,-49.59,-3.73))
Interior1V.append((-11.29,-49.50,1.25))
Interior1V.append((-8.36,-45.28,-2.24))
Interior1V.append((-10.55,-42.66,2.69))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-9.91,-43.49,3.54))
Interior1V.append((-9.91,-43.49,3.54))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-10.55,-42.66,2.69))
Interior1V.append((-13.25,-41.62,3.76))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-9.91,-43.49,3.54))
Interior1V.append((-9.06,-43.04,6.13))
Interior1V.append((-10.55,-42.66,2.69))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-4.46,-43.99,1.46))
Interior1V.append((-4.18,-42.26,-1.35))
Interior1V.append((-6.85,-43.84,.41))
Interior1V.append((-4.18,-42.26,-1.35))
Interior1V.append((-5.62,-40.16,-.62))
Interior1V.append((-6.99,-44.70,-3.90))
Interior1V.append((-6.23,-41.09,-5.07))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-6.99,-44.70,-3.90))
Interior1V.append((-9.09,-42.67,-3.41))
Interior1V.append((-6.69,-43.15,-1.62))
Interior1V.append((-6.99,-44.70,-3.90))
Interior1V.append((-6.69,-43.15,-1.62))
Interior1V.append((-6.23,-41.09,-5.07))
Interior1V.append((-1.11,-47.90,-.21))
Interior1V.append((-1.12,-47.53,-1.24))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((-1.11,-47.90,-.21))
Interior1V.append((1.60,-48.32,-1.92))
Interior1V.append((-1.12,-47.53,-1.24))
Interior1V.append((-.69,-49.55,1.50))
Interior1V.append((-.52,-49.03,.25))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((-.69,-49.55,1.50))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((-.52,-49.03,.25))
Interior1V.append((-.69,-49.55,1.50))
Interior1V.append((.73,-46.16,1.94))
Interior1V.append((.35,-50.42,1.62))
Interior1V.append((8.49,-47.27,-4.35))
Interior1V.append((10.60,-46.37,-4.11))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((9.24,-47.85,-6.71))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((8.49,-47.27,-4.35))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((6.22,-43.11,-5.07))
Interior1V.append((5.26,-43.79,-7.40))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((5.26,-43.79,-7.40))
Interior1V.append((6.64,-44.22,-9.52))
Interior1V.append((6.22,-43.11,-5.07))
Interior1V.append((6.29,-47.26,-3.85))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((6.22,-43.11,-5.07))
Interior1V.append((4.27,-44.49,-5.58))
Interior1V.append((5.26,-43.79,-7.40))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((5.20,-41.72,-4.56))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((6.75,-39.75,-6.07))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((7.97,-38.48,-4.64))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((9.64,-41.03,-5.75))
Interior1V.append((11.39,-42.64,-4.45))
Interior1V.append((9.15,-41.67,-4.83))
Interior1V.append((7.49,-42.33,-7.71))
Interior1V.append((9.64,-41.03,-5.75))
Interior1V.append((9.03,-48.85,-1.61))
Interior1V.append((9.01,-50.83,1.03))
Interior1V.append((10.85,-48.09,-.07))
Interior1V.append((9.03,-48.85,-1.61))
Interior1V.append((7.45,-50.37,1.95))
Interior1V.append((9.01,-50.83,1.03))
Interior1V.append((9.03,-48.85,-1.61))
Interior1V.append((5.84,-48.60,.29))
Interior1V.append((7.45,-50.37,1.95))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((11.30,-49.56,-1.00))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((14.09,-51.70,1.03))
Interior1V.append((11.30,-49.56,-1.00))
Interior1V.append((14.09,-51.70,1.03))
Interior1V.append((12.33,-49.78,1.95))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((14.09,-51.70,1.03))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((16.64,-47.67,-1.26))
Interior1V.append((16.35,-49.56,-3.34))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((16.35,-49.56,-3.34))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((16.35,-49.56,-3.34))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((16.35,-49.56,-3.34))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((14.09,-51.70,1.03))
Interior1V.append((14.51,-50.30,2.89))
Interior1V.append((16.21,-53.20,1.92))
Interior1V.append((16.16,-52.10,-.38))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((12.19,-53.16,3.95))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((13.98,-52.64,2.59))
Interior1V.append((13.92,-57.30,3.33))
Interior1V.append((13.89,-54.52,6.25))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((12.19,-53.16,3.95))
Interior1V.append((11.60,-55.72,1.23))
Interior1V.append((14.35,-54.16,.75))
Interior1V.append((11.60,-55.72,1.23))
Interior1V.append((12.53,-56.81,-1.01))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((14.91,-48.65,-2.99))
Interior1V.append((15.42,-48.78,-4.68))
Interior1V.append((14.26,-53.78,-4.47))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((16.34,-54.78,-5.61))
Interior1V.append((14.26,-53.78,-4.47))
Interior1V.append((15.25,-54.80,-2.90))
Interior1V.append((15.69,-52.54,-2.89))
Interior1V.append((-13.40,-41.66,-.89))
Interior1V.append((-12.35,-44.05,.17))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-13.40,-41.66,-.89))
Interior1V.append((-12.60,-41.90,1.68))
Interior1V.append((-15.56,-41.35,.85))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-11.68,-45.76,1.49))
Interior1V.append((-10.69,-45.44,3.60))
Interior1V.append((-11.57,-44.14,4.59))
Interior1V.append((-12.41,-43.68,2.70))
Interior1V.append((-11.68,-45.76,1.49))
Interior1V.append((-5.11,-60.69,-6.52))
Interior1V.append((-4.36,-58.84,-6.84))
Interior1V.append((-8.44,-60.29,-2.05))
Interior1V.append((-5.11,-60.69,-6.52))
Interior1V.append((-4.38,-59.22,-4.41))
Interior1V.append((-4.36,-58.84,-6.84))
Interior1V.append((-4.36,-58.84,-6.84))
Interior1V.append((-3.99,-55.68,-2.81))
Interior1V.append((-4.43,-52.44,-6.40))
Interior1V.append((-4.36,-58.84,-6.84))
Interior1V.append((-4.43,-52.44,-6.40))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-7.56,-52.27,.71))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-7.56,-52.27,.71))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-9.89,-54.75,1.23))
Interior1V.append((-7.56,-52.27,.71))
Interior1V.append((-12.18,-54.52,.01))
Interior1V.append((-8.18,-50.87,-4.81))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-17.77,-59.64,4.53))
Interior1V.append((-12.05,-62.73,-.59))
Interior1V.append((-13.52,-53.29,-1.16))
Interior1V.append((-28.84,-55.06,6.43))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-26.07,-53.93,6.94))
Interior1V.append((-28.84,-55.06,6.43))
Interior1V.append((-24.90,-58.94,8.58))
Interior1V.append((-23.33,-59.75,6.68))
Interior1V.append((-28.84,-55.06,6.43))
Interior1V.append((-26.07,-53.93,6.94))
Interior1V.append((-24.90,-58.94,8.58))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-12.74,-47.50,10.19))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-14.90,-47.43,7.32))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-12.11,-46.52,8.10))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-12.74,-47.50,10.19))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-13.10,-26.69,13.11))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-9.04,-29.55,21.93))
Interior1V.append((-14.65,-29.12,14.74))
Interior1V.append((-14.02,-26.56,15.10))
Interior1V.append((-14.65,-29.12,14.74))
Interior1V.append((-12.30,-29.57,14.23))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-16.06,-40.69,18.85))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-16.51,-37.90,16.49))
Interior1V.append((-17.15,-37.38,19.28))
Interior1V.append((-18.06,-37.28,16.94))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-21.79,-40.72,18.92))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-21.79,-40.72,18.92))
Interior1V.append((-19.73,-40.51,21.23))
Interior1V.append((-19.52,-39.17,16.16))
Interior1V.append((-20.75,-42.70,17.84))
Interior1V.append((-20.12,-40.41,15.84))
Interior1V.append((-10.91,-40.64,26.94))
Interior1V.append((-14.24,-38.78,28.29))
Interior1V.append((-10.19,-38.00,27.89))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-18.30,-37.80,10.39))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-16.72,-36.75,9.88))
Interior1V.append((-17.73,-37.02,10.65))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-18.30,-37.80,10.39))
Interior1V.append((-18.30,-37.80,10.39))
Interior1V.append((-19.07,-36.27,6.94))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-21.58,-35.18,12.46))
Interior1V.append((-18.20,-36.29,11.16))
Interior1V.append((-19.29,-39.14,10.37))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-15.80,-35.71,15.89))
Interior1V.append((-12.46,-37.50,14.43))
Interior1V.append((-12.79,-35.89,14.71))
Interior1V.append((-23.80,-34.77,13.70))
Interior1V.append((-24.96,-36.76,10.77))
Interior1V.append((-23.10,-33.75,11.57))
Interior1V.append((-23.80,-34.77,13.70))
Interior1V.append((-23.10,-33.75,11.57))
Interior1V.append((-21.58,-35.18,12.46))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-19.83,-37.24,14.01))
Interior1V.append((-18.15,-41.22,14.77))
Interior1V.append((-17.54,-40.68,11.79))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-19.53,-41.34,15.12))
Interior1V.append((-19.14,-42.22,9.54))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-19.14,-42.22,9.54))
Interior1V.append((-19.86,-41.53,11.08))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-19.14,-42.22,9.54))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-21.04,-43.63,7.97))
Interior1V.append((-19.14,-42.22,9.54))
Interior1V.append((-23.28,-40.98,9.20))
Interior1V.append((-19.13,-40.08,8.37))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-9.57,-39.34,2.82))
Interior1V.append((-13.36,-41.27,2.58))
Interior1V.append((-13.24,-39.99,.33))
Interior1V.append((-13.78,-39.45,.98))
Interior1V.append((-3.03,-38.20,-2.08))
Interior1V.append((-3.14,-35.15,-1.05))
Interior1V.append((-1.57,-39.10,-.42))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((-4.11,-33.72,5.38))
Interior1V.append((-2.38,-30.55,4.29))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((-2.38,-30.55,4.29))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((-.84,-32.81,5.89))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((-4.11,-33.72,5.38))
Interior1V.append((-2.38,-30.55,4.29))
Interior1V.append((-5.94,-32.09,3.36))
Interior1V.append((-3.11,-30.15,2.72))
Interior1V.append((-2.38,-30.55,4.29))
Interior1V.append((-3.11,-30.15,2.72))
Interior1V.append((-1.32,-32.18,2.89))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((7.13,-28.92,3.52))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((7.72,-24.17,1.34))
Interior1V.append((7.63,-23.83,3.60))
Interior1V.append((4.40,-26.12,2.28))
Interior1V.append((4.78,-26.52,1.35))
Interior1V.append((7.72,-24.17,1.34))
Interior1V.append((3.64,-27.09,3.02))
Interior1V.append((2.84,-27.86,-1.58))
Interior1V.append((3.47,-28.10,2.68))
Interior1V.append((-2.21,-30.56,12.88))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-2.21,-30.56,12.88))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-1.63,-31.49,12.74))
Interior1V.append((-2.21,-30.56,12.88))
Interior1V.append((-5.54,-31.92,11.16))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-4.69,-30.67,8.94))
Interior1V.append((-1.91,-29.02,8.48))
Interior1V.append((-2.60,-29.52,11.41))
Interior1V.append((-1.91,-29.02,8.48))
Interior1V.append((-.76,-30.79,10.61))
Interior1V.append((-5.63,-42.17,10.80))
Interior1V.append((-5.09,-41.71,8.61))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-5.63,-42.17,10.80))
Interior1V.append((-4.55,-43.79,9.56))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-5.63,-42.17,10.80))
Interior1V.append((-7.10,-40.75,9.54))
Interior1V.append((-5.09,-41.71,8.61))
Interior1V.append((-8.71,-44.87,8.61))
Interior1V.append((-9.23,-44.31,10.33))
Interior1V.append((-6.95,-45.54,11.41))
Interior1V.append((-9.62,-39.82,13.57))
Interior1V.append((-10.84,-42.06,13.68))
Interior1V.append((-8.11,-40.09,11.94))
Interior1V.append((-10.04,-59.24,.32))
Interior1V.append((-10.91,-56.23,1.07))
Interior1V.append((-10.36,-58.78,-.46))
Interior1V.append((27.40,-48.98,-1.07))
Interior1V.append((26.53,-48.51,-1.24))
Interior1V.append((28.13,-49.15,-1.72))
Interior1V.append((27.40,-48.98,-1.07))
Interior1V.append((25.77,-50.27,.88))
Interior1V.append((26.53,-48.51,-1.24))
Interior1V.append((26.74,-49.54,2.16))
Interior1V.append((27.65,-54.01,9.08))
Interior1V.append((26.72,-53.69,8.92))
Interior1V.append((21.68,-32.88,5.38))
Interior1V.append((24.03,-35.84,2.70))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((20.52,-33.57,10.27))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((20.31,-36.77,6.16))
Interior1V.append((20.52,-33.57,10.27))
Interior1V.append((20.31,-36.77,6.16))
Interior1V.append((21.68,-32.88,5.38))
Interior1V.append((20.52,-33.57,10.27))
Interior1V.append((21.68,-32.88,5.38))
Interior1V.append((21.78,-39.22,6.08))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((.54,-25.44,11.92))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-1.01,-24.53,8.55))
Interior1V.append((-.10,-22.98,8.51))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-2.99,-23.50,9.55))
Interior1V.append((-1.01,-24.53,8.55))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((.54,-25.44,11.92))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-.51,-22.90,14.17))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-.51,-22.90,14.17))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-.51,-22.90,14.17))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((-.51,-22.90,14.17))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((-.31,-22.94,12.58))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((-6.27,-23.50,9.91))
Interior1V.append((-4.64,-23.09,9.55))
Interior1V.append((-1.07,-24.26,13.28))
Interior1V.append((-5.88,-21.90,9.69))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((6.54,-22.89,4.39))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((1.34,-19.35,4.30))
Interior1V.append((5.09,-21.10,1.19))
Interior1V.append((7.89,-20.95,3.85))
Interior1V.append((5.09,-21.10,1.19))
Interior1V.append((3.99,-23.35,4.19))
Interior1V.append((8.99,-32.05,-1.16))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((9.86,-31.13,-1.37))
Interior1V.append((9.18,-33.23,-2.67))
Interior1V.append((10.83,-31.40,-5.11))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((9.18,-33.23,-2.67))
Interior1V.append((10.03,-34.43,-3.54))
Interior1V.append((10.83,-31.40,-5.11))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((9.18,-33.23,-2.67))
Interior1V.append((12.16,-29.96,-3.54))
Interior1V.append((13.64,-31.67,-.83))
Interior1V.append((10.91,-31.13,-.69))
Interior1V.append((10.03,-34.43,-3.54))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((10.83,-31.40,-5.11))
Interior1V.append((-16.75,-53.45,13.21))
Interior1V.append((-17.07,-53.35,9.15))
Interior1V.append((-18.92,-55.20,12.30))
Interior1V.append((-16.75,-53.45,13.21))
Interior1V.append((-18.92,-55.20,12.30))
Interior1V.append((-18.85,-52.34,13.10))
Interior1V.append((4.33,-35.25,-6.46))
Interior1V.append((2.26,-38.62,-5.73))
Interior1V.append((2.40,-38.04,-6.94))
Interior1V.append((2.75,-37.71,-1.97))
Interior1V.append((2.34,-38.68,1.02))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((2.75,-37.71,-1.97))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((3.74,-38.50,-3.20))
Interior1V.append((3.74,-38.50,-3.20))
Interior1V.append((1.25,-40.13,-1.19))
Interior1V.append((1.21,-39.51,-3.50))
Interior1V.append((3.74,-38.50,-3.20))
Interior1V.append((1.21,-39.51,-3.50))
Interior1V.append((2.67,-39.74,-5.45))
Interior1V.append((3.83,-42.95,-2.96))
Interior1V.append((5.20,-41.72,-4.56))
Interior1V.append((2.67,-39.74,-5.45))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((5.37,-34.53,-5.11))
Interior1V.append((3.83,-31.72,-4.35))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((5.37,-34.53,-5.11))
Interior1V.append((8.09,-34.88,-3.23))
Interior1V.append((7.01,-34.48,-2.55))
Interior1V.append((6.27,-35.14,-2.44))
Interior1V.append((8.09,-34.88,-3.23))
Interior1V.append((7.05,-33.76,-1.87))
Interior1V.append((7.01,-34.48,-2.55))
Interior1V.append((7.05,-33.76,-1.87))
Interior1V.append((8.09,-34.88,-3.23))
Interior1V.append((9.15,-34.07,-3.21))
Interior1V.append((7.05,-33.76,-1.87))
Interior1V.append((9.15,-34.07,-3.21))
Interior1V.append((9.18,-33.23,-2.67))
Interior1V.append((6.97,-40.43,3.99))
Interior1V.append((7.47,-38.03,4.65))
Interior1V.append((7.96,-40.02,4.14))
Interior1V.append((13.59,-29.53,-8.29))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((13.59,-29.53,-8.29))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((11.95,-32.47,-6.20))
Interior1V.append((13.59,-29.53,-8.29))
Interior1V.append((10.84,-33.50,-8.68))
Interior1V.append((15.91,-30.57,-6.67))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((14.16,-41.94,-1.69))
Interior1V.append((16.33,-40.56,-.95))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((11.86,-39.54,-3.68))
Interior1V.append((13.99,-41.80,-4.91))
Interior1V.append((13.33,-39.94,-6.26))
Interior1V.append((2.34,-34.31,-.04))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((1.70,-32.42,-2.86))
Interior1V.append((-.41,-28.04,7.51))
Interior1V.append((1.23,-26.34,6.14))
Interior1V.append((-1.04,-27.00,7.44))
Interior1V.append((-.41,-28.04,7.51))
Interior1V.append((-1.04,-27.00,7.44))
Interior1V.append((-.57,-27.75,10.14))
Interior1V.append((-.57,-27.75,10.14))
Interior1V.append((1.97,-27.31,11.01))
Interior1V.append((-.41,-28.04,7.51))
Interior1V.append((-2.99,-23.50,9.55))
Interior1V.append((-5.15,-26.70,7.66))
Interior1V.append((-2.30,-25.88,6.28))
Interior1V.append((-2.99,-23.50,9.55))
Interior1V.append((-2.30,-25.88,6.28))
Interior1V.append((-1.01,-24.53,8.55))
Interior1V.append((3.80,-43.31,5.74))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((3.87,-43.73,7.79))
Interior1V.append((3.80,-43.31,5.74))
Interior1V.append((1.04,-41.90,4.74))
Interior1V.append((1.41,-43.04,6.97))
Interior1V.append((3.80,-43.31,5.74))
Interior1V.append((3.87,-43.73,7.79))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((4.45,-44.59,4.70))
Interior1V.append((4.22,-44.21,5.60))
Interior1V.append((5.20,-46.32,5.44))
Interior1V.append((9.71,-41.83,6.39))
Interior1V.append((8.66,-41.93,3.54))
Interior1V.append((10.28,-43.82,5.66))
Interior1V.append((9.71,-41.83,6.39))
Interior1V.append((10.28,-43.82,5.66))
Interior1V.append((8.41,-43.00,8.04))
Interior1V.append((9.71,-41.83,6.39))
Interior1V.append((6.97,-40.43,3.99))
Interior1V.append((8.66,-41.93,3.54))
Interior1V.append((8.66,-41.93,3.54))
Interior1V.append((11.04,-41.18,3.62))
Interior1V.append((10.28,-43.82,5.66))
Interior1V.append((8.42,-48.86,11.08))
Interior1V.append((5.10,-51.94,9.90))
Interior1V.append((5.16,-49.96,12.35))
Interior1V.append((11.23,-52.97,6.85))
Interior1V.append((10.33,-52.72,8.90))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((11.73,-49.10,5.27))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((10.91,-48.85,5.93))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((12.76,-50.26,10.29))
Interior1V.append((13.06,-49.17,6.84))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((11.20,-49.16,10.90))
Interior1V.append((12.76,-50.26,10.29))
Interior1V.append((12.08,-51.05,8.79))
Interior1V.append((9.53,-50.68,10.01))
Interior1V.append((11.20,-49.16,10.90))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((17.34,-49.24,6.89))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((17.34,-49.24,6.89))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((20.49,-52.81,6.18))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((20.99,-50.69,7.89))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((19.25,-49.40,8.57))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((19.40,-48.89,3.71))
Interior1V.append((18.41,-49.12,6.23))
Interior1V.append((17.24,-54.24,3.51))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((17.24,-54.24,3.51))
Interior1V.append((16.21,-53.20,1.92))
Interior1V.append((18.87,-54.88,5.30))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((18.87,-54.88,5.30))
Interior1V.append((20.49,-52.81,6.18))
Interior1V.append((19.18,-54.48,4.49))
Interior1V.append((18.87,-54.88,5.30))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((18.87,-54.88,5.30))
Interior1V.append((18.48,-52.57,8.17))
Interior1V.append((20.49,-52.81,6.18))
Interior1V.append((16.44,-54.14,5.04))
Interior1V.append((16.15,-50.19,4.82))
Interior1V.append((15.24,-50.78,6.35))
Interior1V.append((8.27,-42.87,10.02))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((5.65,-42.74,10.72))
Interior1V.append((8.27,-42.87,10.02))
Interior1V.append((8.97,-40.04,8.43))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((8.97,-40.04,8.43))
Interior1V.append((5.32,-38.75,8.77))
Interior1V.append((8.13,-39.81,7.52))
Interior1V.append((5.82,-43.02,8.97))
Interior1V.append((8.97,-40.04,8.43))
Interior1V.append((2.76,-41.19,-16.86))
Interior1V.append((2.02,-42.87,-13.59))
Interior1V.append((.81,-41.59,-17.22))
Interior1V.append((2.76,-41.19,-16.86))
Interior1V.append((.81,-41.59,-17.22))
Interior1V.append((2.18,-43.10,-17.98))
Interior1V.append((1.65,-34.16,-4.06))
Interior1V.append((3.83,-31.72,-4.35))
Interior1V.append((1.70,-32.42,-2.86))
Interior1V.append((1.65,-34.16,-4.06))
Interior1V.append((1.70,-32.42,-2.86))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((1.65,-34.16,-4.06))
Interior1V.append((4.45,-35.51,-1.98))
Interior1V.append((3.83,-31.72,-4.35))
Interior1V.append((-.01,-39.03,11.52))
Interior1V.append((-1.65,-37.86,10.24))
Interior1V.append((-.45,-37.37,12.54))
Interior1V.append((1.26,-39.26,11.91))
Interior1V.append((-.01,-39.03,11.52))
Interior1V.append((-.45,-37.37,12.54))
Interior1V.append((1.26,-39.26,11.91))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((-.01,-39.03,11.52))
Interior1V.append((1.59,-38.71,12.94))
Interior1V.append((1.26,-39.26,11.91))
Interior1V.append((-.45,-37.37,12.54))
Interior1V.append((1.59,-38.71,12.94))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((1.26,-39.26,11.91))
Interior1V.append((1.59,-38.71,12.94))
Interior1V.append((1.22,-35.10,14.56))
Interior1V.append((3.66,-36.07,10.79))
Interior1V.append((1.59,-38.71,12.94))
Interior1V.append((-.45,-37.37,12.54))
Interior1V.append((1.22,-35.10,14.56))
Interior1V.append((-3.29,-40.49,17.65))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-1.73,-41.05,18.50))
Interior1V.append((-3.29,-40.49,17.65))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-3.21,-43.77,17.17))
Interior1V.append((-3.29,-40.49,17.65))
Interior1V.append((-1.73,-41.05,18.50))
Interior1V.append((-3.47,-41.17,20.36))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((-14.11,-52.64,8.90))
Interior1V.append((-11.00,-50.46,8.70))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-14.88,-48.37,11.03))
Interior1V.append((-12.74,-47.50,10.19))
Interior1V.append((-12.56,-49.08,10.92))
Interior1V.append((-12.74,-47.50,10.19))
Interior1V.append((-12.47,-50.43,7.66))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((1.08,-46.91,10.62))
Interior1V.append((.55,-43.37,11.15))
Interior1V.append((2.18,-44.25,12.85))
Interior1V.append((.55,-43.37,11.15))
Interior1V.append((3.85,-43.82,10.24))
Interior1V.append((1.68,-48.54,15.87))
Interior1V.append((3.56,-47.67,17.10))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((1.68,-48.54,15.87))
Interior1V.append((2.13,-45.91,16.04))
Interior1V.append((-.64,-47.01,17.45))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-15.66,-44.62,-2.50))
Interior1V.append((-15.63,-42.75,-.95))
Interior1V.append((-19.30,-43.81,-1.48))
Interior1V.append((-15.63,-42.75,-.95))
Interior1V.append((-17.15,-43.08,1.48))
Interior1V.append((13.66,-37.35,10.62))
Interior1V.append((12.01,-43.41,13.97))
Interior1V.append((12.94,-38.13,9.96))
Interior1V.append((13.66,-37.35,10.62))
Interior1V.append((12.94,-38.13,9.96))
Interior1V.append((15.73,-37.17,10.95))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((17.25,-54.93,-1.19))
Interior1V.append((21.82,-54.27,-3.51))
Interior1V.append((17.25,-54.93,-1.19))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((18.08,-58.39,-1.72))
Interior1V.append((17.25,-54.93,-1.19))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((17.08,-58.20,.39))
Interior1V.append((17.25,-54.93,-1.19))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((16.61,-54.71,1.24))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((17.76,-40.15,5.23))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((18.80,-40.34,5.04))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((19.71,-39.47,5.69))
Interior1V.append((19.26,-41.44,4.22))
Interior1V.append((22.85,-43.54,5.49))
Interior1V.append((21.07,-39.66,5.40))
Interior1V.append((18.38,-52.46,-1.93))
Interior1V.append((20.67,-50.11,-2.03))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((18.38,-52.46,-1.93))
Interior1V.append((17.82,-49.81,-1.51))
Interior1V.append((17.71,-52.61,.28))
Interior1V.append((22.02,-45.98,2.70))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((22.02,-45.98,2.70))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((21.67,-45.33,1.69))
Interior1V.append((22.02,-45.98,2.70))
Interior1V.append((24.92,-47.99,.20))
Interior1V.append((20.19,-48.94,2.10))
Interior1V.append((21.11,-49.26,-3.61))
Interior1V.append((23.89,-45.60,-4.44))
Interior1V.append((21.99,-46.97,-2.85))
Interior1V.append((16.01,-55.40,3.65))
Interior1V.append((18.23,-56.51,4.29))
Interior1V.append((15.20,-58.43,3.92))
Interior1V.append((13.27,-55.47,-4.15))
Interior1V.append((11.09,-53.62,-4.02))
Interior1V.append((10.83,-53.43,-1.00))
Interior1V.append((13.27,-55.47,-4.15))
Interior1V.append((14.26,-53.78,-4.47))
Interior1V.append((11.09,-53.62,-4.02))
Interior1V.append((11.97,-48.03,-1.36))
Interior1V.append((15.25,-46.10,-2.57))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((-3.10,-43.51,2.49))
Interior1V.append((-2.94,-43.15,.70))
Interior1V.append((-4.46,-43.99,1.46))
Interior1V.append((-9.34,-33.69,.32))
Interior1V.append((-12.18,-35.08,.11))
Interior1V.append((-12.17,-34.60,-2.12))
Interior1V.append((-9.34,-33.69,.32))
Interior1V.append((-12.17,-34.60,-2.12))
Interior1V.append((-8.71,-33.71,-2.23))
Interior1V.append((10.60,-46.37,-4.11))
Interior1V.append((11.96,-47.32,-3.38))
Interior1V.append((11.29,-47.63,-5.12))
Interior1V.append((-.59,-28.85,-6.32))
Interior1V.append((1.59,-27.93,-7.33))
Interior1V.append((-.66,-27.87,-6.53))
Interior1V.append((-.59,-28.85,-6.32))
Interior1V.append((-.66,-27.87,-6.53))
Interior1V.append((-.02,-29.77,-3.71))
Interior1V.append((11.07,-33.75,-20.18))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((11.14,-27.70,-15.50))
Interior1V.append((.74,-28.86,-11.76))
Interior1V.append((1.12,-26.68,-10.13))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((.74,-28.86,-11.76))
Interior1V.append((2.36,-28.78,-9.55))
Interior1V.append((3.98,-29.86,-11.96))
Interior1V.append((-10.85,-53.53,14.28))
Interior1V.append((-10.28,-51.01,13.50))
Interior1V.append((-11.74,-54.10,13.43))
Interior1V.append((-10.85,-53.53,14.28))
Interior1V.append((-11.74,-54.10,13.43))
Interior1V.append((-13.65,-53.71,14.26))
Interior1V.append((-14.18,-49.90,12.94))
Interior1V.append((-13.65,-53.71,14.26))
Interior1V.append((-13.07,-53.35,11.41))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((12.63,-27.55,-11.78))
Interior1V.append((11.87,-28.11,-15.04))
Interior1V.append((9.91,-29.74,-9.84))
Interior1V.append((10.18,-27.53,-13.62))

Interior1I = []
for x in range(0,3406):
    Interior1I.append((x*3, x*3+1, x*3+2))

Interior1V = array(tuple(Interior1V), floatc)
Interior1I = array(tuple(Interior1I), intc)
Interior1Piece = Interior1.addPiece(Interior1V, Interior1I, (1,0,0,.5))
Interior1Piece.display = True
Interior1Piece.displayStyle = Interior1Piece.Solid
chimera.openModels.add([Interior1])
Interior2 = _surface.SurfaceModel()
Interior2V = []
Interior2V.append((-1.05,-61.51,-10.52))
Interior2V.append((.55,-62.23,-12.25))
Interior2V.append((.83,-60.99,-9.69))
Interior2V.append((-1.05,-61.51,-10.52))
Interior2V.append((-.50,-64.76,-11.48))
Interior2V.append((.55,-62.23,-12.25))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((.55,-62.23,-12.25))
Interior2V.append((-.50,-64.76,-11.48))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((-.50,-64.76,-11.48))
Interior2V.append((-1.05,-61.51,-10.52))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((-1.05,-61.51,-10.52))
Interior2V.append((.83,-60.99,-9.69))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((.83,-60.99,-9.69))
Interior2V.append((-2.59,-64.26,-11.21))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((-1.05,-61.51,-10.52))
Interior2V.append((-1.89,-61.08,-10.69))
Interior2V.append((-1.05,-61.51,-10.52))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((-1.89,-61.08,-10.69))
Interior2V.append((-2.59,-64.26,-11.21))
Interior2V.append((-1.05,-61.51,-10.52))
Interior2V.append((-3.47,-60.83,-6.75))
Interior2V.append((-1.89,-61.08,-10.69))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((-5.11,-60.69,-6.52))
Interior2V.append((-2.59,-64.26,-11.21))
Interior2V.append((-1.89,-61.08,-10.69))
Interior2V.append((-5.11,-60.69,-6.52))
Interior2V.append((-1.89,-61.08,-10.69))
Interior2V.append((-3.47,-60.83,-6.75))
Interior2V.append((-3.03,-62.41,-5.75))
Interior2V.append((-3.47,-60.83,-6.75))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-3.47,-60.83,-6.75))
Interior2V.append((-3.03,-62.41,-5.75))
Interior2V.append((-2.59,-64.95,-5.28))
Interior2V.append((-3.03,-62.41,-5.75))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-3.03,-62.41,-5.75))
Interior2V.append((-2.59,-64.95,-5.28))
Interior2V.append((-2.54,-65.21,-11.33))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((-2.59,-64.26,-11.21))
Interior2V.append((-5.32,-64.50,-13.60))
Interior2V.append((-2.54,-65.21,-11.33))
Interior2V.append((-2.59,-64.26,-11.21))
Interior2V.append((-5.32,-64.50,-13.60))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-2.54,-65.21,-11.33))
Interior2V.append((-1.45,-67.74,-11.24))
Interior2V.append((-2.54,-65.21,-11.33))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-1.45,-67.74,-11.24))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((-2.54,-65.21,-11.33))
Interior2V.append((.12,-68.07,-9.26))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((-1.45,-67.74,-11.24))
Interior2V.append((1.11,-66.37,-6.31))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((.12,-68.07,-9.26))
Interior2V.append((-.65,-66.09,-4.61))
Interior2V.append((1.11,-66.37,-6.31))
Interior2V.append((.12,-68.07,-9.26))
Interior2V.append((3.11,-63.98,-6.18))
Interior2V.append((1.11,-66.37,-6.31))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((-.65,-66.09,-4.61))
Interior2V.append((-2.59,-64.95,-5.28))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((1.11,-66.37,-6.31))
Interior2V.append((-.65,-66.09,-4.61))
Interior2V.append((-2.22,-62.95,-4.16))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((-2.22,-62.95,-4.16))
Interior2V.append((-2.59,-64.95,-5.28))
Interior2V.append((-1.21,-61.63,-6.91))
Interior2V.append((-2.22,-62.95,-4.16))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((-2.59,-64.95,-5.28))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((1.50,-62.44,3.48))
Interior2V.append((-1.17,-63.33,1.42))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((-1.17,-63.33,1.42))
Interior2V.append((-2.69,-63.02,5.01))
Interior2V.append((.13,-60.20,3.73))
Interior2V.append((-1.17,-63.33,1.42))
Interior2V.append((1.50,-62.44,3.48))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((1.50,-62.44,3.48))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((-2.69,-63.02,5.01))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((.13,-60.20,3.73))
Interior2V.append((1.50,-62.44,3.48))
Interior2V.append((4.88,-64.54,-1.58))
Interior2V.append((5.36,-62.09,-.09))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((4.88,-64.54,-1.58))
Interior2V.append((5.22,-62.42,-3.28))
Interior2V.append((5.36,-62.09,-.09))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((10.76,-66.06,-.05))
Interior2V.append((8.96,-68.04,-.76))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((10.76,-66.06,-.05))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((9.34,-66.77,-4.41))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((8.96,-68.04,-.76))
Interior2V.append((8.53,-69.52,-1.81))
Interior2V.append((9.34,-66.77,-4.41))
Interior2V.append((8.96,-68.04,-.76))
Interior2V.append((9.82,-65.05,-4.02))
Interior2V.append((9.34,-66.77,-4.41))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((9.82,-65.05,-4.02))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((9.34,-66.77,-4.41))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((9.82,-65.05,-4.02))
Interior2V.append((11.14,-64.61,-1.04))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((13.58,-64.51,-3.45))
Interior2V.append((9.82,-65.05,-4.02))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((13.58,-64.51,-3.45))
Interior2V.append((11.14,-64.61,-1.04))
Interior2V.append((9.82,-65.05,-4.02))
Interior2V.append((13.58,-64.51,-3.45))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((11.14,-64.61,-1.04))
Interior2V.append((14.48,-65.02,-2.60))
Interior2V.append((13.58,-64.51,-3.45))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((14.48,-65.02,-2.60))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((13.58,-64.51,-3.45))
Interior2V.append((14.36,-65.75,-5.05))
Interior2V.append((15.89,-64.90,-6.56))
Interior2V.append((15.25,-65.60,-2.88))
Interior2V.append((14.36,-65.75,-5.05))
Interior2V.append((15.25,-65.60,-2.88))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((14.36,-65.75,-5.05))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((15.18,-70.33,-1.17))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((15.89,-64.90,-6.56))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((15.18,-70.33,-1.17))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((14.36,-65.75,-5.05))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((12.17,-68.13,-9.40))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((15.18,-70.33,-1.17))
Interior2V.append((12.17,-68.13,-9.40))
Interior2V.append((14.36,-65.75,-5.05))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((13.24,-72.22,-.28))
Interior2V.append((15.18,-70.33,-1.17))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((7.29,-71.44,-4.76))
Interior2V.append((13.24,-72.22,-.28))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((9.36,-67.38,-6.90))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((7.29,-71.44,-4.76))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((8.53,-69.52,-1.81))
Interior2V.append((7.29,-71.44,-4.76))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((9.34,-66.77,-4.41))
Interior2V.append((8.53,-69.52,-1.81))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((5.13,-69.80,-7.47))
Interior2V.append((5.85,-67.47,-6.62))
Interior2V.append((4.96,-69.36,-10.84))
Interior2V.append((5.85,-67.47,-6.62))
Interior2V.append((5.13,-69.80,-7.47))
Interior2V.append((9.36,-67.38,-6.90))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((5.85,-67.47,-6.62))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((5.13,-69.80,-7.47))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((4.96,-69.36,-10.84))
Interior2V.append((5.13,-69.80,-7.47))
Interior2V.append((6.41,-70.00,-5.71))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((6.41,-70.00,-5.71))
Interior2V.append((7.29,-71.44,-4.76))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((6.41,-70.00,-5.71))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((7.29,-71.44,-4.76))
Interior2V.append((11.23,-79.50,5.99))
Interior2V.append((12.56,-73.28,1.94))
Interior2V.append((9.35,-75.95,4.74))
Interior2V.append((11.23,-79.50,5.99))
Interior2V.append((9.35,-75.95,4.74))
Interior2V.append((11.55,-74.31,4.24))
Interior2V.append((11.23,-79.50,5.99))
Interior2V.append((11.55,-74.31,4.24))
Interior2V.append((12.56,-73.28,1.94))
Interior2V.append((1.99,-70.93,3.17))
Interior2V.append((2.67,-69.40,5.11))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((1.99,-70.93,3.17))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((2.67,-69.40,5.11))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((2.67,-69.40,5.11))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((2.67,-69.40,5.11))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((-.25,-75.65,9.11))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((.58,-76.12,9.02))
Interior2V.append((-.25,-75.65,9.11))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((4.14,-70.29,5.29))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((4.14,-70.29,5.29))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((4.14,-70.29,5.29))
Interior2V.append((5.76,-72.04,8.04))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((4.14,-70.29,5.29))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((.58,-76.12,9.02))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((2.81,-76.80,10.07))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((.58,-76.12,9.02))
Interior2V.append((1.08,-78.12,8.28))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((1.08,-78.12,8.28))
Interior2V.append((.58,-76.12,9.02))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((5.76,-72.04,8.04))
Interior2V.append((4.14,-70.29,5.29))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((4.14,-70.29,5.29))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((4.14,-70.29,5.29))
Interior2V.append((2.62,-79.43,7.37))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((5.73,-64.22,8.41))
Interior2V.append((3.82,-66.21,8.64))
Interior2V.append((5.18,-65.02,5.88))
Interior2V.append((5.73,-64.22,8.41))
Interior2V.append((5.18,-65.02,5.88))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((5.73,-64.22,8.41))
Interior2V.append((7.09,-64.56,6.45))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((5.73,-64.22,8.41))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((7.09,-64.56,6.45))
Interior2V.append((8.55,-62.70,5.38))
Interior2V.append((11.55,-64.13,5.57))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((8.55,-62.70,5.38))
Interior2V.append((9.72,-62.16,8.13))
Interior2V.append((11.55,-64.13,5.57))
Interior2V.append((11.55,-64.13,5.57))
Interior2V.append((9.72,-62.16,8.13))
Interior2V.append((9.59,-64.73,7.06))
Interior2V.append((9.59,-64.73,7.06))
Interior2V.append((8.10,-63.95,8.94))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((9.59,-64.73,7.06))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((8.48,-63.21,9.64))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((8.10,-63.95,8.94))
Interior2V.append((8.48,-63.21,9.64))
Interior2V.append((8.10,-63.95,8.94))
Interior2V.append((9.59,-64.73,7.06))
Interior2V.append((9.31,-62.17,9.13))
Interior2V.append((8.48,-63.21,9.64))
Interior2V.append((9.59,-64.73,7.06))
Interior2V.append((8.71,-62.48,11.94))
Interior2V.append((8.48,-63.21,9.64))
Interior2V.append((9.31,-62.17,9.13))
Interior2V.append((9.72,-62.16,8.13))
Interior2V.append((9.31,-62.17,9.13))
Interior2V.append((9.59,-64.73,7.06))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((9.31,-62.17,9.13))
Interior2V.append((9.72,-62.16,8.13))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((11.55,-64.13,5.57))
Interior2V.append((9.59,-64.73,7.06))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((13.57,-63.45,8.40))
Interior2V.append((11.55,-64.13,5.57))
Interior2V.append((13.57,-63.45,8.40))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((11.55,-64.13,5.57))
Interior2V.append((14.13,-61.02,8.34))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((13.57,-63.45,8.40))
Interior2V.append((14.13,-61.02,8.34))
Interior2V.append((13.57,-63.45,8.40))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((13.28,-59.28,6.49))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((14.13,-61.02,8.34))
Interior2V.append((13.28,-59.28,6.49))
Interior2V.append((14.13,-61.02,8.34))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((9.01,-59.55,6.85))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((9.72,-62.16,8.13))
Interior2V.append((9.01,-59.55,6.85))
Interior2V.append((13.28,-59.28,6.49))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((9.77,-59.54,4.92))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((13.28,-59.28,6.49))
Interior2V.append((9.77,-59.54,4.92))
Interior2V.append((9.01,-59.55,6.85))
Interior2V.append((9.72,-62.16,8.13))
Interior2V.append((9.77,-59.54,4.92))
Interior2V.append((13.28,-59.28,6.49))
Interior2V.append((9.01,-59.55,6.85))
Interior2V.append((9.77,-59.54,4.92))
Interior2V.append((9.72,-62.16,8.13))
Interior2V.append((8.55,-62.70,5.38))
Interior2V.append((11.86,-59.84,3.91))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((9.77,-59.54,4.92))
Interior2V.append((11.86,-59.84,3.91))
Interior2V.append((11.31,-63.68,3.88))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((11.31,-63.68,3.88))
Interior2V.append((8.55,-62.70,5.38))
Interior2V.append((12.45,-62.69,4.91))
Interior2V.append((9.66,-60.50,2.62))
Interior2V.append((11.86,-59.84,3.91))
Interior2V.append((9.77,-59.54,4.92))
Interior2V.append((10.51,-61.00,1.85))
Interior2V.append((11.86,-59.84,3.91))
Interior2V.append((9.66,-60.50,2.62))
Interior2V.append((10.51,-61.00,1.85))
Interior2V.append((9.66,-60.50,2.62))
Interior2V.append((11.31,-63.68,3.88))
Interior2V.append((9.66,-60.50,2.62))
Interior2V.append((9.77,-59.54,4.92))
Interior2V.append((8.55,-62.70,5.38))
Interior2V.append((9.66,-60.50,2.62))
Interior2V.append((8.55,-62.70,5.38))
Interior2V.append((11.31,-63.68,3.88))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((.17,-61.34,9.40))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((.17,-61.34,9.40))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((.17,-61.34,9.40))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((2.52,-58.27,8.83))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-1.63,-60.60,10.82))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-1.63,-60.60,10.82))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-1.63,-60.60,10.82))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-1.63,-60.60,10.82))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((-1.63,-60.60,10.82))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-1.63,-60.60,10.82))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-6.50,-55.60,11.38))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-4.62,-54.98,13.02))
Interior2V.append((-6.50,-55.60,11.38))
Interior2V.append((-7.64,-51.77,12.40))
Interior2V.append((-4.62,-54.98,13.02))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-6.50,-55.60,11.38))
Interior2V.append((-7.64,-53.30,10.31))
Interior2V.append((-7.64,-51.77,12.40))
Interior2V.append((-6.50,-55.60,11.38))
Interior2V.append((-7.64,-53.30,10.31))
Interior2V.append((-6.50,-55.60,11.38))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-5.51,-51.36,13.83))
Interior2V.append((-4.62,-54.98,13.02))
Interior2V.append((-7.64,-51.77,12.40))
Interior2V.append((-5.51,-51.36,13.83))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-4.62,-54.98,13.02))
Interior2V.append((-6.44,-50.29,11.47))
Interior2V.append((-5.51,-51.36,13.83))
Interior2V.append((-7.64,-51.77,12.40))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-10.02,-63.24,22.57))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-8.04,-67.58,22.99))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-10.02,-63.24,22.57))
Interior2V.append((-8.04,-67.58,22.99))
Interior2V.append((-10.02,-63.24,22.57))
Interior2V.append((-8.06,-64.96,20.68))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-8.04,-67.58,22.99))
Interior2V.append((-8.06,-64.96,20.68))
Interior2V.append((-15.90,-68.22,22.36))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-8.04,-67.58,22.99))
Interior2V.append((-15.90,-68.22,22.36))
Interior2V.append((-8.04,-67.58,22.99))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-15.90,-68.22,22.36))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-16.44,-67.56,20.00))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-17.08,-65.70,18.25))
Interior2V.append((-16.44,-67.56,20.00))
Interior2V.append((-17.08,-65.70,18.25))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-16.44,-67.56,20.00))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-17.08,-65.70,18.25))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-17.08,-65.70,18.25))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-16.94,-63.19,17.08))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-16.82,-63.57,14.81))
Interior2V.append((-16.94,-63.19,17.08))
Interior2V.append((-16.82,-63.57,14.81))
Interior2V.append((-19.50,-62.60,16.61))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-16.94,-63.19,17.08))
Interior2V.append((-19.50,-62.60,16.61))
Interior2V.append((-16.18,-61.23,18.87))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-16.18,-61.23,18.87))
Interior2V.append((-16.94,-63.19,17.08))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-16.18,-61.23,18.87))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-16.94,-63.19,17.08))
Interior2V.append((-15.98,-62.80,12.65))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-16.08,-64.24,14.89))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-15.98,-62.80,12.65))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-15.98,-62.80,12.65))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-18.87,-63.01,14.11))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-18.87,-63.01,14.11))
Interior2V.append((-16.82,-63.57,14.81))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-18.87,-63.01,14.11))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-19.50,-62.60,16.61))
Interior2V.append((-18.87,-63.01,14.11))
Interior2V.append((-19.50,-62.60,16.61))
Interior2V.append((-16.82,-63.57,14.81))
Interior2V.append((-20.31,-61.61,14.39))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-18.87,-63.01,14.11))
Interior2V.append((-17.42,-58.79,18.05))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-17.42,-58.79,18.05))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-17.42,-58.79,18.05))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-17.42,-58.79,18.05))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-15.37,-57.64,15.51))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-15.37,-57.64,15.51))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-16.18,-61.23,18.87))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-16.18,-61.23,18.87))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-16.18,-61.23,18.87))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-13.59,-57.40,19.83))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-13.59,-57.40,19.83))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-14.78,-58.72,21.97))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-14.78,-58.72,21.97))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-13.59,-57.40,19.83))
Interior2V.append((-14.78,-58.72,21.97))
Interior2V.append((-13.59,-57.40,19.83))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-13.59,-57.40,19.83))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-11.59,-58.26,22.06))
Interior2V.append((-11.13,-52.37,24.40))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-9.00,-53.39,26.19))
Interior2V.append((-7.42,-52.30,27.39))
Interior2V.append((-9.00,-53.39,26.19))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-11.13,-52.37,24.40))
Interior2V.append((-9.00,-53.39,26.19))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-9.00,-53.39,26.19))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-9.00,-53.39,26.19))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-7.45,-49.52,22.29))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-8.43,-49.31,22.70))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-11.13,-52.37,24.40))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-12.73,-52.73,19.94))
Interior2V.append((-11.88,-50.61,19.81))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-10.85,-47.45,20.92))
Interior2V.append((-8.43,-49.31,22.70))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-10.85,-47.45,20.92))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-11.88,-50.61,19.81))
Interior2V.append((-10.85,-47.45,20.92))
Interior2V.append((-8.08,-49.13,19.15))
Interior2V.append((-8.43,-49.31,22.70))
Interior2V.append((-12.12,-49.07,18.86))
Interior2V.append((-10.85,-47.45,20.92))
Interior2V.append((-11.88,-50.61,19.81))
Interior2V.append((-12.12,-49.07,18.86))
Interior2V.append((-11.88,-50.61,19.81))
Interior2V.append((-8.08,-49.13,19.15))
Interior2V.append((-12.12,-49.07,18.86))
Interior2V.append((-8.08,-49.13,19.15))
Interior2V.append((-10.85,-47.45,20.92))
Interior2V.append((-12.97,-58.06,15.92))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-15.37,-57.64,15.51))
Interior2V.append((-12.97,-58.06,15.92))
Interior2V.append((-15.37,-57.64,15.51))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-15.16,-57.73,17.90))
Interior2V.append((-12.97,-58.06,15.92))
Interior2V.append((-8.28,-56.19,10.47))
Interior2V.append((-9.19,-57.70,8.54))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-8.06,-59.95,7.60))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-9.19,-57.70,8.54))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-8.28,-56.19,10.47))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-9.79,-59.40,10.39))
Interior2V.append((-9.19,-57.70,8.54))
Interior2V.append((-8.28,-56.19,10.47))
Interior2V.append((-9.79,-59.40,10.39))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-8.06,-59.95,7.60))
Interior2V.append((-9.79,-59.40,10.39))
Interior2V.append((-8.06,-59.95,7.60))
Interior2V.append((-9.19,-57.70,8.54))
Interior2V.append((-8.78,-56.47,11.29))
Interior2V.append((-9.79,-59.40,10.39))
Interior2V.append((-8.28,-56.19,10.47))
Interior2V.append((-8.78,-56.47,11.29))
Interior2V.append((-8.28,-56.19,10.47))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-8.27,-57.32,12.98))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-9.79,-59.40,10.39))
Interior2V.append((-8.27,-57.32,12.98))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-8.27,-57.32,12.98))
Interior2V.append((-8.78,-56.47,11.29))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-8.27,-57.32,12.98))
Interior2V.append((-9.79,-59.40,10.39))
Interior2V.append((-8.78,-56.47,11.29))
Interior2V.append((-5.28,-63.39,14.74))
Interior2V.append((-4.20,-60.87,13.15))
Interior2V.append((-4.58,-61.63,15.42))
Interior2V.append((-5.28,-63.39,14.74))
Interior2V.append((-4.58,-61.63,15.42))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-4.58,-61.63,15.42))
Interior2V.append((-4.20,-60.87,13.15))
Interior2V.append((-4.86,-62.28,12.41))
Interior2V.append((-4.20,-60.87,13.15))
Interior2V.append((-5.28,-63.39,14.74))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((-4.20,-60.87,13.15))
Interior2V.append((-4.86,-62.28,12.41))
Interior2V.append((-5.47,-63.57,13.78))
Interior2V.append((-4.86,-62.28,12.41))
Interior2V.append((-5.28,-63.39,14.74))
Interior2V.append((-5.47,-63.57,13.78))
Interior2V.append((-5.28,-63.39,14.74))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-3.95,-65.23,13.35))
Interior2V.append((-4.86,-62.28,12.41))
Interior2V.append((-5.47,-63.57,13.78))
Interior2V.append((-3.95,-65.23,13.35))
Interior2V.append((-5.47,-63.57,13.78))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-.83,-60.66,15.62))
Interior2V.append((-4.58,-61.63,15.42))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-2.82,-62.35,17.86))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-4.58,-61.63,15.42))
Interior2V.append((-2.82,-62.35,17.86))
Interior2V.append((-.83,-60.66,15.62))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-2.82,-62.35,17.86))
Interior2V.append((-4.58,-61.63,15.42))
Interior2V.append((-.83,-60.66,15.62))
Interior2V.append((-1.20,-57.67,15.54))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((1.45,-55.85,13.57))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((-1.20,-57.67,15.54))
Interior2V.append((-3.40,-58.16,16.57))
Interior2V.append((-1.20,-57.67,15.54))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-5.64,-56.32,14.41))
Interior2V.append((-3.40,-58.16,16.57))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-5.64,-56.32,14.41))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-4.07,-54.59,13.75))
Interior2V.append((-.82,-55.12,16.45))
Interior2V.append((-1.20,-57.67,15.54))
Interior2V.append((-3.40,-58.16,16.57))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-3.40,-58.16,16.57))
Interior2V.append((-5.64,-56.32,14.41))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-5.64,-56.32,14.41))
Interior2V.append((-4.07,-54.59,13.75))
Interior2V.append((-5.61,-56.51,17.90))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-5.61,-56.51,17.90))
Interior2V.append((-3.84,-55.11,18.60))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-7.10,-52.08,17.26))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-3.84,-55.11,18.60))
Interior2V.append((-5.61,-56.51,17.90))
Interior2V.append((-5.55,-57.21,19.06))
Interior2V.append((-5.61,-56.51,17.90))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-5.55,-57.21,19.06))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-5.61,-56.51,17.90))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-5.55,-57.21,19.06))
Interior2V.append((-8.13,-54.87,17.55))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-5.55,-57.21,19.06))
Interior2V.append((-8.13,-54.87,17.55))
Interior2V.append((-5.55,-57.21,19.06))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-8.13,-54.87,17.55))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-8.13,-54.87,17.55))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-3.40,-58.16,16.57))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-.82,-55.12,16.45))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-.82,-55.12,16.45))
Interior2V.append((-3.40,-58.16,16.57))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-7.10,-52.08,17.26))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-4.71,-55.51,17.55))
Interior2V.append((-3.84,-55.11,18.60))
Interior2V.append((-3.14,-54.34,18.34))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-3.84,-55.11,18.60))
Interior2V.append((-5.48,-51.30,15.68))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-7.10,-52.08,17.26))
Interior2V.append((-5.48,-51.30,15.68))
Interior2V.append((-7.10,-52.08,17.26))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-5.48,-51.30,15.68))
Interior2V.append((-.99,-52.41,17.86))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-3.14,-54.34,18.34))
Interior2V.append((-1.45,-52.38,19.69))
Interior2V.append((-.99,-52.41,17.86))
Interior2V.append((-3.14,-54.34,18.34))
Interior2V.append((-1.45,-52.38,19.69))
Interior2V.append((-3.27,-50.12,19.90))
Interior2V.append((-.99,-52.41,17.86))
Interior2V.append((-1.45,-52.38,19.69))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-3.27,-50.12,19.90))
Interior2V.append((-1.45,-52.38,19.69))
Interior2V.append((-3.14,-54.34,18.34))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-11.11,-64.42,12.07))
Interior2V.append((-10.21,-62.98,15.60))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-10.21,-62.98,15.60))
Interior2V.append((-16.08,-64.24,14.89))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-15.02,-65.59,13.88))
Interior2V.append((-14.82,-65.34,11.37))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-15.02,-65.59,13.88))
Interior2V.append((-14.82,-65.34,11.37))
Interior2V.append((-11.11,-64.42,12.07))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-16.08,-64.24,14.89))
Interior2V.append((-15.02,-65.59,13.88))
Interior2V.append((-11.55,-63.08,11.04))
Interior2V.append((-11.11,-64.42,12.07))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-11.55,-63.08,11.04))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-11.11,-64.42,12.07))
Interior2V.append((-11.55,-63.08,11.04))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-14.55,-62.67,10.55))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-14.55,-62.67,10.55))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-15.98,-62.80,12.65))
Interior2V.append((-14.55,-62.67,10.55))
Interior2V.append((-15.98,-62.80,12.65))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-15.72,-64.01,12.47))
Interior2V.append((-15.98,-62.80,12.65))
Interior2V.append((-16.08,-64.24,14.89))
Interior2V.append((-13.21,-59.91,14.60))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-13.21,-59.91,14.60))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-13.21,-59.91,14.60))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-12.97,-58.06,15.92))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-13.21,-59.91,14.60))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-12.97,-58.06,15.92))
Interior2V.append((-13.21,-59.91,14.60))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-13.21,-59.91,14.60))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-12.97,-58.06,15.92))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-6.28,-56.74,16.21))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-9.92,-57.94,14.91))
Interior2V.append((-6.28,-56.74,16.21))
Interior2V.append((-9.92,-57.94,14.91))
Interior2V.append((-7.12,-59.81,15.27))
Interior2V.append((-6.28,-56.74,16.21))
Interior2V.append((-7.12,-59.81,15.27))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-7.12,-59.81,15.27))
Interior2V.append((-9.92,-57.94,14.91))
Interior2V.append((-10.62,-56.09,17.19))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-9.92,-57.94,14.91))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-8.99,-61.65,17.31))
Interior2V.append((-7.12,-59.81,15.27))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-6.31,-61.26,17.31))
Interior2V.append((-7.12,-59.81,15.27))
Interior2V.append((-8.99,-61.65,17.31))
Interior2V.append((-6.31,-61.26,17.31))
Interior2V.append((-8.99,-61.65,17.31))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-6.31,-61.26,17.31))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-6.31,-61.26,17.31))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-7.12,-59.81,15.27))
Interior2V.append((-6.31,-61.26,17.31))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-7.69,-63.05,11.75))
Interior2V.append((-4.95,-60.58,10.72))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-7.69,-63.05,11.75))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-4.95,-60.58,10.72))
Interior2V.append((-4.86,-62.28,12.41))
Interior2V.append((-3.95,-65.23,13.35))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-4.86,-62.28,12.41))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-1.61,-62.36,10.83))
Interior2V.append((-4.95,-60.58,10.72))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-4.20,-60.87,13.15))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((5.53,-66.83,18.43))
Interior2V.append((3.66,-66.67,16.86))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((3.66,-66.67,16.86))
Interior2V.append((5.06,-61.19,16.89))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((-.56,-64.24,19.67))
Interior2V.append((-1.14,-64.20,17.57))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((-1.14,-64.20,17.57))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-2.17,-65.99,15.77))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((1.19,-67.53,15.75))
Interior2V.append((-2.17,-65.99,15.77))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((.55,-65.02,14.99))
Interior2V.append((2.94,-67.26,12.69))
Interior2V.append((1.19,-67.53,15.75))
Interior2V.append((.55,-65.02,14.99))
Interior2V.append((1.19,-67.53,15.75))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((2.20,-64.95,12.11))
Interior2V.append((.55,-65.02,14.99))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((2.20,-64.95,12.11))
Interior2V.append((2.94,-67.26,12.69))
Interior2V.append((.55,-65.02,14.99))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((1.49,-62.79,12.21))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((1.49,-62.79,12.21))
Interior2V.append((-1.61,-62.36,10.83))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((-1.61,-62.36,10.83))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((-1.61,-62.36,10.83))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-1.61,-62.36,10.83))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-2.26,-66.71,12.11))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-3.95,-65.23,13.35))
Interior2V.append((-2.26,-66.71,12.11))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-3.95,-65.23,13.35))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-2.26,-66.71,12.11))
Interior2V.append((-3.95,-65.23,13.35))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((-2.26,-66.71,12.11))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((2.20,-64.95,12.11))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((1.99,-63.94,12.75))
Interior2V.append((2.20,-64.95,12.11))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((1.99,-63.94,12.75))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((2.20,-64.95,12.11))
Interior2V.append((1.99,-63.94,12.75))
Interior2V.append((1.49,-62.79,12.21))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((2.99,-67.46,9.75))
Interior2V.append((2.94,-67.26,12.69))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((2.99,-67.46,9.75))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((2.94,-67.26,12.69))
Interior2V.append((2.20,-64.95,12.11))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((7.09,-64.56,6.45))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((7.09,-64.56,6.45))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((6.74,-69.50,5.05))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((6.74,-69.50,5.05))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((10.81,-68.15,6.78))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((10.81,-68.15,6.78))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((12.59,-70.21,5.14))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((12.59,-70.21,5.14))
Interior2V.append((10.81,-68.15,6.78))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((9.83,-65.76,5.61))
Interior2V.append((10.81,-68.15,6.78))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((9.83,-65.76,5.61))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((10.81,-68.15,6.78))
Interior2V.append((12.07,-65.92,2.78))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((9.83,-65.76,5.61))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((4.66,-63.66,-14.38))
Interior2V.append((7.95,-64.71,-13.51))
Interior2V.append((4.66,-63.66,-14.38))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((2.52,-61.80,-12.84))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((4.66,-63.66,-14.38))
Interior2V.append((2.52,-61.80,-12.84))
Interior2V.append((4.66,-63.66,-14.38))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((4.61,-60.94,-9.82))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((5.68,-59.82,-9.05))
Interior2V.append((4.61,-60.94,-9.82))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((3.11,-63.98,-6.18))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((3.86,-66.26,-6.13))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((3.86,-66.26,-6.13))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((4.28,-64.40,-4.86))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((4.28,-64.40,-4.86))
Interior2V.append((3.86,-66.26,-6.13))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((4.28,-64.40,-4.86))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((3.86,-66.26,-6.13))
Interior2V.append((5.85,-67.47,-6.62))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((8.40,-63.76,-8.31))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((9.36,-67.38,-6.90))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((9.36,-67.38,-6.90))
Interior2V.append((5.85,-67.47,-6.62))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((5.85,-67.47,-6.62))
Interior2V.append((4.96,-69.36,-10.84))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((4.96,-69.36,-10.84))
Interior2V.append((9.16,-66.24,-11.19))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((9.16,-66.24,-11.19))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((9.16,-66.24,-11.19))
Interior2V.append((10.32,-67.86,-11.46))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((11.21,-55.15,-11.38))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((15.09,-57.61,-7.33))
Interior2V.append((11.21,-55.15,-11.38))
Interior2V.append((11.21,-55.15,-11.38))
Interior2V.append((11.82,-57.70,-6.78))
Interior2V.append((10.10,-57.67,-11.77))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((10.10,-57.67,-11.77))
Interior2V.append((11.82,-57.70,-6.78))
Interior2V.append((10.22,-56.74,-12.57))
Interior2V.append((11.21,-55.15,-11.38))
Interior2V.append((10.10,-57.67,-11.77))
Interior2V.append((10.22,-56.74,-12.57))
Interior2V.append((10.10,-57.67,-11.77))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((11.82,-57.70,-6.78))
Interior2V.append((11.21,-55.15,-11.38))
Interior2V.append((15.09,-57.61,-7.33))
Interior2V.append((15.09,-57.61,-7.33))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((11.82,-57.70,-6.78))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-3.66,-45.68,10.89))
Interior2V.append((-6.56,-48.51,11.59))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-6.56,-48.51,11.59))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-3.82,-48.82,15.57))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-3.82,-48.82,15.57))
Interior2V.append((-3.23,-48.58,18.22))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-3.82,-48.82,15.57))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-3.23,-48.58,18.22))
Interior2V.append((-5.39,-45.54,12.31))
Interior2V.append((-3.66,-45.68,10.89))
Interior2V.append((-2.99,-46.79,13.44))
Interior2V.append((-5.39,-45.54,12.31))
Interior2V.append((-6.56,-48.51,11.59))
Interior2V.append((-3.66,-45.68,10.89))
Interior2V.append((-5.39,-45.54,12.31))
Interior2V.append((-2.99,-46.79,13.44))
Interior2V.append((-6.56,-48.51,11.59))
Interior2V.append((-2.99,-46.79,13.44))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-6.56,-48.51,11.59))
Interior2V.append((-2.99,-46.79,13.44))
Interior2V.append((-3.66,-45.68,10.89))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-2.16,-47.65,13.18))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-2.99,-46.79,13.44))
Interior2V.append((-2.16,-47.65,13.18))
Interior2V.append((-2.99,-46.79,13.44))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-2.36,-48.98,13.60))
Interior2V.append((-2.16,-47.65,13.18))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-2.36,-48.98,13.60))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-2.16,-47.65,13.18))
Interior2V.append((-2.87,-51.75,13.54))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-5.51,-51.36,13.83))
Interior2V.append((-2.87,-51.75,13.54))
Interior2V.append((-5.51,-51.36,13.83))
Interior2V.append((-6.44,-50.29,11.47))
Interior2V.append((-6.44,-50.29,11.47))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-2.87,-51.75,13.54))
Interior2V.append((-6.44,-50.29,11.47))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((-2.87,-51.75,13.54))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-5.42,-51.79,8.89))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-6.44,-50.29,11.47))
Interior2V.append((-3.23,-50.04,8.34))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-5.42,-51.79,8.89))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-3.23,-50.04,8.34))
Interior2V.append((-5.42,-51.79,8.89))
Interior2V.append((-.48,-49.14,10.87))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-3.23,-50.04,8.34))
Interior2V.append((-.51,-49.32,9.93))
Interior2V.append((-.48,-49.14,10.87))
Interior2V.append((-3.23,-50.04,8.34))
Interior2V.append((-1.90,-47.63,10.55))
Interior2V.append((-.48,-49.14,10.87))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((-1.90,-47.63,10.55))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-.48,-49.14,10.87))
Interior2V.append((-2.36,-48.98,13.60))
Interior2V.append((-1.90,-47.63,10.55))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((-2.36,-48.98,13.60))
Interior2V.append((-4.12,-49.09,9.68))
Interior2V.append((-1.90,-47.63,10.55))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((-4.36,-49.30,13.61))
Interior2V.append((-2.36,-48.98,13.60))
Interior2V.append((10.34,-56.90,-13.78))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((11.21,-55.15,-11.38))
Interior2V.append((10.34,-56.90,-13.78))
Interior2V.append((11.21,-55.15,-11.38))
Interior2V.append((10.22,-56.74,-12.57))
Interior2V.append((10.34,-56.90,-13.78))
Interior2V.append((10.22,-56.74,-12.57))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((13.41,-60.86,-11.84))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((11.86,-61.43,-10.41))
Interior2V.append((13.41,-60.86,-11.84))
Interior2V.append((14.31,-63.52,-6.59))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((13.41,-60.86,-11.84))
Interior2V.append((14.31,-63.52,-6.59))
Interior2V.append((11.86,-61.43,-10.41))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((14.31,-63.52,-6.59))
Interior2V.append((13.41,-60.86,-11.84))
Interior2V.append((11.86,-61.43,-10.41))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((11.86,-61.43,-10.41))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((19.45,-64.99,-.91))
Interior2V.append((15.25,-65.60,-2.88))
Interior2V.append((15.89,-64.90,-6.56))
Interior2V.append((19.45,-64.99,-.91))
Interior2V.append((15.89,-64.90,-6.56))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((19.45,-64.99,-.91))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((15.25,-65.60,-2.88))
Interior2V.append((16.56,-52.46,18.90))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((16.56,-52.46,18.90))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((16.56,-52.46,18.90))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((-2.82,-50.31,5.83))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-2.82,-50.31,5.83))
Interior2V.append((1.20,-49.08,6.19))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((-.51,-49.32,9.93))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((-.51,-49.32,9.93))
Interior2V.append((-3.23,-50.04,8.34))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((1.88,-50.27,8.45))
Interior2V.append((2.34,-51.33,9.17))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((2.34,-51.33,9.17))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((1.88,-50.27,8.45))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((24.04,-56.48,11.90))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((24.04,-56.48,11.90))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((17.34,-51.93,16.60))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((16.56,-52.46,18.90))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((16.56,-52.46,18.90))
Interior2V.append((17.34,-51.93,16.60))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((16.56,-52.46,18.90))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((17.34,-51.93,16.60))
Interior2V.append((16.56,-52.46,18.90))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((23.40,-54.14,12.81))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((16.20,-56.02,14.14))
Interior2V.append((18.57,-59.48,11.63))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((18.57,-59.48,11.63))
Interior2V.append((24.04,-56.48,11.90))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((23.68,-61.97,10.61))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((24.04,-56.48,11.90))
Interior2V.append((23.68,-61.97,10.61))
Interior2V.append((18.57,-59.48,11.63))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((23.68,-61.97,10.61))
Interior2V.append((24.04,-56.48,11.90))
Interior2V.append((18.57,-59.48,11.63))
Interior2V.append((10.95,-62.25,-3.85))
Interior2V.append((9.82,-65.05,-4.02))
Interior2V.append((11.14,-64.61,-1.04))
Interior2V.append((10.95,-62.25,-3.85))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((9.82,-65.05,-4.02))
Interior2V.append((10.75,-61.81,-.60))
Interior2V.append((10.95,-62.25,-3.85))
Interior2V.append((11.14,-64.61,-1.04))
Interior2V.append((10.75,-61.81,-.60))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((10.95,-62.25,-3.85))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((10.75,-61.81,-.60))
Interior2V.append((11.14,-64.61,-1.04))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((10.75,-61.81,-.60))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((11.14,-64.61,-1.04))
Interior2V.append((9.68,-65.65,-1.42))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((7.43,-65.32,-2.87))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((5.22,-62.42,-3.28))
Interior2V.append((7.43,-65.32,-2.87))
Interior2V.append((12.17,-68.13,-9.40))
Interior2V.append((15.18,-70.33,-1.17))
Interior2V.append((15.89,-64.90,-6.56))
Interior2V.append((12.17,-68.13,-9.40))
Interior2V.append((15.89,-64.90,-6.56))
Interior2V.append((14.36,-65.75,-5.05))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((10.32,-67.86,-11.46))
Interior2V.append((11.31,-69.28,-10.27))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((11.31,-69.28,-10.27))
Interior2V.append((10.32,-67.86,-11.46))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((11.31,-69.28,-10.27))
Interior2V.append((11.31,-69.28,-10.27))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((11.31,-69.28,-10.27))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((14.38,-71.64,25.42))
Interior2V.append((15.83,-68.55,23.59))
Interior2V.append((13.11,-71.43,22.75))
Interior2V.append((14.38,-71.64,25.42))
Interior2V.append((13.11,-71.43,22.75))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((11.07,-70.99,27.23))
Interior2V.append((14.38,-71.64,25.42))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((17.33,-67.37,24.02))
Interior2V.append((14.38,-71.64,25.42))
Interior2V.append((11.07,-70.99,27.23))
Interior2V.append((14.15,-67.30,22.52))
Interior2V.append((17.33,-67.37,24.02))
Interior2V.append((11.07,-70.99,27.23))
Interior2V.append((14.15,-67.30,22.52))
Interior2V.append((15.83,-68.55,23.59))
Interior2V.append((17.33,-67.37,24.02))
Interior2V.append((18.22,-72.65,25.50))
Interior2V.append((15.83,-68.55,23.59))
Interior2V.append((14.38,-71.64,25.42))
Interior2V.append((16.06,-73.10,26.68))
Interior2V.append((18.22,-72.65,25.50))
Interior2V.append((14.38,-71.64,25.42))
Interior2V.append((16.06,-73.10,26.68))
Interior2V.append((17.33,-67.37,24.02))
Interior2V.append((18.22,-72.65,25.50))
Interior2V.append((16.06,-73.10,26.68))
Interior2V.append((14.38,-71.64,25.42))
Interior2V.append((17.33,-67.37,24.02))
Interior2V.append((18.86,-69.77,23.77))
Interior2V.append((17.33,-67.37,24.02))
Interior2V.append((15.83,-68.55,23.59))
Interior2V.append((18.86,-69.77,23.77))
Interior2V.append((15.83,-68.55,23.59))
Interior2V.append((18.22,-72.65,25.50))
Interior2V.append((18.86,-69.77,23.77))
Interior2V.append((18.22,-72.65,25.50))
Interior2V.append((17.33,-67.37,24.02))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((15.45,-64.51,17.60))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((19.11,-67.76,21.47))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((19.11,-67.76,21.47))
Interior2V.append((15.45,-64.51,17.60))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((15.45,-64.51,17.60))
Interior2V.append((19.11,-67.76,21.47))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((19.11,-67.76,21.47))
Interior2V.append((14.02,-65.83,18.49))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((15.45,-64.51,17.60))
Interior2V.append((14.02,-65.83,18.49))
Interior2V.append((15.45,-64.51,17.60))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((18.23,-72.51,20.44))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((13.32,-67.83,19.92))
Interior2V.append((13.32,-67.83,19.92))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((13.46,-66.58,18.13))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((13.32,-67.83,19.92))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((13.46,-66.58,18.13))
Interior2V.append((13.32,-67.83,19.92))
Interior2V.append((11.12,-68.07,20.89))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((13.32,-67.83,19.92))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((11.70,-65.84,20.64))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((11.70,-65.84,20.64))
Interior2V.append((12.43,-63.60,18.27))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((12.43,-63.60,18.27))
Interior2V.append((11.70,-65.84,20.64))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((12.43,-63.60,18.27))
Interior2V.append((10.29,-59.49,18.19))
Interior2V.append((12.43,-63.60,18.27))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((10.29,-59.49,18.19))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((12.43,-63.60,18.27))
Interior2V.append((10.29,-59.49,18.19))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((10.29,-59.49,18.19))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((10.29,-59.49,18.19))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((11.79,-60.07,15.17))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((11.79,-60.07,15.17))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((11.79,-60.07,15.17))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((11.79,-60.07,15.17))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((9.48,-60.84,14.57))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((9.48,-60.84,14.57))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((9.48,-60.84,14.57))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((5.57,-61.11,13.51))
Interior2V.append((9.39,-61.34,16.28))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((9.39,-61.34,16.28))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((9.39,-61.34,16.28))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((6.43,-62.14,15.36))
Interior2V.append((5.06,-61.19,16.89))
Interior2V.append((6.43,-62.14,15.36))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((7.18,-64.29,12.59))
Interior2V.append((6.43,-62.14,15.36))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((6.43,-62.14,15.36))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((6.43,-62.14,15.36))
Interior2V.append((7.18,-64.29,12.59))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((7.18,-64.29,12.59))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((10.23,-65.02,15.21))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((10.23,-65.02,15.21))
Interior2V.append((7.18,-64.29,12.59))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((10.00,-63.70,15.68))
Interior2V.append((10.23,-65.02,15.21))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((10.00,-63.70,15.68))
Interior2V.append((7.18,-64.29,12.59))
Interior2V.append((10.23,-65.02,15.21))
Interior2V.append((10.00,-63.70,15.68))
Interior2V.append((9.32,-63.61,16.52))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((10.00,-63.70,15.68))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((7.18,-64.29,12.59))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((15.39,-59.47,12.37))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((15.39,-59.47,12.37))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((15.39,-59.47,12.37))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((15.39,-59.47,12.37))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((18.43,-64.55,1.11))
Interior2V.append((17.03,-63.12,2.19))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((18.43,-64.55,1.11))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((17.62,-67.26,3.73))
Interior2V.append((16.85,-64.58,4.98))
Interior2V.append((18.43,-64.55,1.11))
Interior2V.append((17.62,-67.26,3.73))
Interior2V.append((16.85,-64.58,4.98))
Interior2V.append((17.03,-63.12,2.19))
Interior2V.append((18.43,-64.55,1.11))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((18.69,-63.82,9.44))
Interior2V.append((21.42,-64.39,10.39))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((18.69,-63.82,9.44))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((16.07,-60.11,17.46))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((16.07,-60.11,17.46))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((16.07,-60.11,17.46))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((16.07,-60.11,17.46))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((16.07,-60.11,17.46))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((16.30,-62.51,17.16))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((21.42,-64.39,10.39))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((19.21,-65.45,9.37))
Interior2V.append((21.42,-64.39,10.39))
Interior2V.append((18.69,-63.82,9.44))
Interior2V.append((19.21,-65.45,9.37))
Interior2V.append((18.69,-63.82,9.44))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((18.57,-59.48,11.63))
Interior2V.append((16.20,-56.02,14.14))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((16.20,-56.02,14.14))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((14.69,-55.31,10.90))
Interior2V.append((15.10,-58.61,11.78))
Interior2V.append((13.77,-56.13,13.27))
Interior2V.append((6.73,-57.37,-1.81))
Interior2V.append((3.18,-56.95,-1.57))
Interior2V.append((6.38,-56.18,-2.04))
Interior2V.append((6.73,-57.37,-1.81))
Interior2V.append((6.38,-56.18,-2.04))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((7.73,-57.99,-2.48))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((6.73,-57.37,-1.81))
Interior2V.append((7.73,-57.99,-2.48))
Interior2V.append((6.73,-57.37,-1.81))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((3.18,-56.95,-1.57))
Interior2V.append((6.73,-57.37,-1.81))
Interior2V.append((8.10,-58.86,-2.14))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((7.73,-57.99,-2.48))
Interior2V.append((2.06,-58.52,-2.89))
Interior2V.append((3.18,-56.95,-1.57))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((4.49,-56.28,-5.44))
Interior2V.append((3.18,-56.95,-1.57))
Interior2V.append((2.06,-58.52,-2.89))
Interior2V.append((4.03,-61.09,-2.99))
Interior2V.append((2.06,-58.52,-2.89))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((4.03,-61.09,-2.99))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((5.22,-62.42,-3.28))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((5.36,-62.09,-.09))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((8.10,-58.86,-2.14))
Interior2V.append((5.36,-62.09,-.09))
Interior2V.append((5.22,-62.42,-3.28))
Interior2V.append((5.59,-59.16,-1.18))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((5.22,-62.42,-3.28))
Interior2V.append((6.84,-63.47,-4.80))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((6.84,-63.47,-4.80))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((6.84,-63.47,-4.80))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((6.84,-63.47,-4.80))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((8.40,-63.76,-8.31))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((7.56,-65.54,-6.05))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((10.54,-60.69,-11.44))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((10.54,-60.69,-11.44))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((10.10,-57.67,-11.77))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((10.10,-57.67,-11.77))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((10.16,-57.75,-5.58))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((11.86,-61.43,-10.41))
Interior2V.append((10.54,-60.69,-11.44))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((11.86,-61.43,-10.41))
Interior2V.append((12.32,-59.60,-11.64))
Interior2V.append((10.54,-60.69,-11.44))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((15.09,-57.61,-7.33))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((11.86,-61.43,-10.41))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((16.17,-59.08,-8.72))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((10.42,-60.83,-1.42))
Interior2V.append((9.35,-60.22,-1.30))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((10.42,-60.83,-1.42))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((9.35,-60.22,-1.30))
Interior2V.append((10.42,-60.83,-1.42))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((9.35,-60.22,-1.30))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((8.46,-63.44,-4.12))
Interior2V.append((9.35,-60.22,-1.30))
Interior2V.append((8.10,-58.86,-2.14))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((10.16,-57.75,-5.58))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((10.16,-57.75,-5.58))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((11.05,-60.45,-7.12))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((8.10,-58.86,-2.14))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((9.85,-60.81,-4.23))
Interior2V.append((8.44,-61.84,-8.92))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((7.24,-61.83,-9.37))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((8.44,-61.84,-8.92))
Interior2V.append((7.24,-61.83,-9.37))
Interior2V.append((8.44,-61.84,-8.92))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((9.21,-60.75,-8.95))
Interior2V.append((8.44,-61.84,-8.92))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((9.21,-60.75,-8.95))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((8.44,-61.84,-8.92))
Interior2V.append((9.21,-60.75,-8.95))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((9.21,-60.75,-8.95))
Interior2V.append((9.89,-60.80,-8.21))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((7.24,-61.83,-9.37))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((5.68,-59.82,-9.05))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((5.68,-59.82,-9.05))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((7.24,-61.83,-9.37))
Interior2V.append((5.68,-59.82,-9.05))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((7.24,-61.83,-9.37))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((7.24,-61.83,-9.37))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((8.40,-63.76,-8.31))
Interior2V.append((8.29,-63.19,-5.90))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((9.39,-63.20,-12.23))
Interior2V.append((7.95,-64.71,-13.51))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((9.39,-63.20,-12.23))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((7.95,-64.71,-13.51))
Interior2V.append((9.39,-63.20,-12.23))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((7.28,-66.54,-13.79))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((7.95,-64.71,-13.51))
Interior2V.append((7.28,-66.54,-13.79))
Interior2V.append((7.95,-64.71,-13.51))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((7.28,-66.54,-13.79))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((7.28,-66.54,-13.79))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((.97,-67.91,-10.11))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((-.50,-64.76,-11.48))
Interior2V.append((.97,-67.91,-10.11))
Interior2V.append((-.50,-64.76,-11.48))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((1.11,-66.37,-6.31))
Interior2V.append((.97,-67.91,-10.11))
Interior2V.append((-1.27,-65.51,-9.95))
Interior2V.append((1.11,-66.37,-6.31))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((.97,-67.91,-10.11))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((1.11,-66.37,-6.31))
Interior2V.append((3.11,-63.98,-6.18))
Interior2V.append((4.13,-70.11,-10.36))
Interior2V.append((4.96,-69.36,-10.84))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((4.52,-71.18,-9.65))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((5.35,-67.95,-15.21))
Interior2V.append((4.52,-71.18,-9.65))
Interior2V.append((4.13,-70.11,-10.36))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((7.26,-78.02,6.06))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((2.11,-81.48,6.07))
Interior2V.append((7.26,-78.02,6.06))
Interior2V.append((2.11,-81.48,6.07))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((2.11,-81.48,6.07))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((2.11,-81.48,6.07))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((2.62,-79.43,7.37))
Interior2V.append((7.26,-78.02,6.06))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((7.26,-78.02,6.06))
Interior2V.append((8.38,-73.71,4.01))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((7.53,-71.45,4.83))
Interior2V.append((8.38,-73.71,4.01))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((4.81,-69.56,2.95))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((4.81,-69.56,2.95))
Interior2V.append((7.53,-71.45,4.83))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((4.81,-69.56,2.95))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((7.83,-69.69,.59))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((4.89,-72.62,3.55))
Interior2V.append((3.38,-72.28,1.83))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((2.62,-79.43,7.37))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((1.08,-78.12,8.28))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((-.25,-75.65,9.11))
Interior2V.append((.58,-76.12,9.02))
Interior2V.append((1.08,-78.12,8.28))
Interior2V.append((-5.75,-76.81,3.63))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((1.99,-70.93,3.17))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((1.99,-70.93,3.17))
Interior2V.append((3.38,-72.28,1.83))
Interior2V.append((2.27,-71.82,4.66))
Interior2V.append((1.99,-70.93,3.17))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((3.38,-72.28,1.83))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-3.23,-70.82,-.45))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((-3.23,-70.82,-.45))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-.29,-68.19,-4.94))
Interior2V.append((-2.59,-64.95,-5.28))
Interior2V.append((-.65,-66.09,-4.61))
Interior2V.append((-.29,-68.19,-4.94))
Interior2V.append((-.65,-66.09,-4.61))
Interior2V.append((.12,-68.07,-9.26))
Interior2V.append((-.29,-68.19,-4.94))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-2.59,-64.95,-5.28))
Interior2V.append((-4.66,-65.62,-3.44))
Interior2V.append((-1.45,-67.74,-11.24))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-4.66,-65.62,-3.44))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-.29,-68.19,-4.94))
Interior2V.append((-4.66,-65.62,-3.44))
Interior2V.append((-.29,-68.19,-4.94))
Interior2V.append((-1.45,-67.74,-11.24))
Interior2V.append((-.29,-68.19,-4.94))
Interior2V.append((.12,-68.07,-9.26))
Interior2V.append((-1.45,-67.74,-11.24))
Interior2V.append((-6.08,-63.00,-13.28))
Interior2V.append((-5.11,-60.69,-6.52))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-6.08,-63.00,-13.28))
Interior2V.append((-2.59,-64.26,-11.21))
Interior2V.append((-5.11,-60.69,-6.52))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-5.11,-60.69,-6.52))
Interior2V.append((-3.47,-60.83,-6.75))
Interior2V.append((-6.08,-63.00,-13.28))
Interior2V.append((-5.32,-64.50,-13.60))
Interior2V.append((-2.59,-64.26,-11.21))
Interior2V.append((-6.08,-63.00,-13.28))
Interior2V.append((-4.39,-64.44,-5.59))
Interior2V.append((-5.32,-64.50,-13.60))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((5.35,-67.95,-15.21))
Interior2V.append((5.51,-71.24,-9.54))
Interior2V.append((5.35,-67.95,-15.21))
Interior2V.append((7.36,-67.67,-13.37))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((3.16,-66.15,-15.08))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((5.35,-67.95,-15.21))
Interior2V.append((3.16,-66.15,-15.08))
Interior2V.append((5.35,-67.95,-15.21))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((1.20,-67.11,-12.05))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((3.16,-66.15,-15.08))
Interior2V.append((1.20,-67.11,-12.05))
Interior2V.append((3.16,-66.15,-15.08))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((2.27,-69.92,-11.50))
Interior2V.append((5.35,-67.95,-15.21))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((2.27,-69.92,-11.50))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((4.96,-69.36,-10.84))
Interior2V.append((2.27,-69.92,-11.50))
Interior2V.append((4.96,-69.36,-10.84))
Interior2V.append((4.13,-70.11,-10.36))
Interior2V.append((2.27,-69.92,-11.50))
Interior2V.append((4.52,-71.18,-9.65))
Interior2V.append((5.35,-67.95,-15.21))
Interior2V.append((2.27,-69.92,-11.50))
Interior2V.append((4.13,-70.11,-10.36))
Interior2V.append((4.52,-71.18,-9.65))
Interior2V.append((-.50,-64.76,-11.48))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((.61,-67.26,-11.26))
Interior2V.append((-.50,-64.76,-11.48))
Interior2V.append((.61,-67.26,-11.26))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((1.20,-67.11,-12.05))
Interior2V.append((5.32,-65.95,-14.07))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((1.20,-67.11,-12.05))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((.61,-67.26,-11.26))
Interior2V.append((3.92,-66.28,-8.62))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((.61,-67.26,-11.26))
Interior2V.append((3.04,-67.65,-10.36))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((.83,-60.99,-9.69))
Interior2V.append((4.61,-60.94,-9.82))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((3.11,-63.98,-6.18))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((3.11,-63.98,-6.18))
Interior2V.append((1.03,-62.58,-6.00))
Interior2V.append((.83,-60.99,-9.69))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((9.69,-66.12,1.75))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((7.07,-68.13,.70))
Interior2V.append((9.69,-66.12,1.75))
Interior2V.append((7.07,-68.13,.70))
Interior2V.append((7.83,-69.69,.59))
Interior2V.append((7.83,-69.69,.59))
Interior2V.append((8.96,-68.04,-.76))
Interior2V.append((9.69,-66.12,1.75))
Interior2V.append((9.69,-66.12,1.75))
Interior2V.append((12.07,-65.92,2.78))
Interior2V.append((9.83,-65.76,5.61))
Interior2V.append((9.69,-66.12,1.75))
Interior2V.append((9.83,-65.76,5.61))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((12.81,-70.44,3.15))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((12.81,-70.44,3.15))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((11.60,-71.85,1.46))
Interior2V.append((12.81,-70.44,3.15))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((10.76,-66.06,-.05))
Interior2V.append((12.07,-65.92,2.78))
Interior2V.append((9.69,-66.12,1.75))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((12.07,-65.92,2.78))
Interior2V.append((10.76,-66.06,-.05))
Interior2V.append((9.69,-66.12,1.75))
Interior2V.append((8.96,-68.04,-.76))
Interior2V.append((10.76,-66.06,-.05))
Interior2V.append((13.24,-72.22,-.28))
Interior2V.append((11.60,-71.85,1.46))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((8.53,-69.52,-1.81))
Interior2V.append((8.96,-68.04,-.76))
Interior2V.append((7.83,-69.69,.59))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((8.53,-69.52,-1.81))
Interior2V.append((7.83,-69.69,.59))
Interior2V.append((6.82,-71.43,-1.72))
Interior2V.append((8.53,-69.52,-1.81))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((12.81,-70.44,3.15))
Interior2V.append((11.60,-71.85,1.46))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((11.55,-74.31,4.24))
Interior2V.append((8.38,-73.71,4.01))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((11.55,-74.31,4.24))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((11.60,-71.85,1.46))
Interior2V.append((12.56,-73.28,1.94))
Interior2V.append((11.55,-74.31,4.24))
Interior2V.append((11.60,-71.85,1.46))
Interior2V.append((13.24,-72.22,-.28))
Interior2V.append((6.82,-71.43,-1.72))
Interior2V.append((12.56,-73.28,1.94))
Interior2V.append((13.24,-72.22,-.28))
Interior2V.append((12.56,-73.28,1.94))
Interior2V.append((11.60,-71.85,1.46))
Interior2V.append((6.82,-71.43,-1.72))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((9.35,-75.95,4.74))
Interior2V.append((6.82,-71.43,-1.72))
Interior2V.append((9.35,-75.95,4.74))
Interior2V.append((12.56,-73.28,1.94))
Interior2V.append((6.82,-71.43,-1.72))
Interior2V.append((7.29,-71.44,-4.76))
Interior2V.append((8.53,-69.52,-1.81))
Interior2V.append((6.82,-71.43,-1.72))
Interior2V.append((13.24,-72.22,-.28))
Interior2V.append((7.29,-71.44,-4.76))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((15.18,-70.33,-1.17))
Interior2V.append((13.24,-72.22,-.28))
Interior2V.append((15.85,-67.00,-.70))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((15.85,-67.00,-.70))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((15.85,-67.00,-.70))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((15.85,-67.00,-.70))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((15.85,-67.00,-.70))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((10.76,-66.06,-.05))
Interior2V.append((11.79,-60.66,1.96))
Interior2V.append((11.86,-59.84,3.91))
Interior2V.append((10.51,-61.00,1.85))
Interior2V.append((11.79,-60.66,1.96))
Interior2V.append((10.51,-61.00,1.85))
Interior2V.append((11.31,-63.68,3.88))
Interior2V.append((11.79,-60.66,1.96))
Interior2V.append((11.31,-63.68,3.88))
Interior2V.append((11.86,-59.84,3.91))
Interior2V.append((9.35,-60.22,-1.30))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((5.36,-62.09,-.09))
Interior2V.append((9.35,-60.22,-1.30))
Interior2V.append((5.36,-62.09,-.09))
Interior2V.append((8.10,-58.86,-2.14))
Interior2V.append((4.49,-56.28,-5.44))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((6.38,-56.18,-2.04))
Interior2V.append((4.49,-56.28,-5.44))
Interior2V.append((6.38,-56.18,-2.04))
Interior2V.append((3.18,-56.95,-1.57))
Interior2V.append((14.12,-57.73,8.85))
Interior2V.append((12.06,-58.64,10.14))
Interior2V.append((15.10,-58.61,11.78))
Interior2V.append((14.12,-57.73,8.85))
Interior2V.append((15.10,-58.61,11.78))
Interior2V.append((14.69,-55.31,10.90))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((7.94,-55.56,-6.83))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((7.94,-55.56,-6.83))
Interior2V.append((10.16,-57.75,-5.58))
Interior2V.append((6.26,-56.77,-7.90))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((6.26,-56.77,-7.90))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((6.26,-56.77,-7.90))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((4.61,-60.94,-9.82))
Interior2V.append((5.68,-59.82,-9.05))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-4.25,-57.54,6.98))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((-4.25,-57.54,6.98))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-1.79,-59.53,3.09))
Interior2V.append((-4.25,-57.54,6.98))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-1.79,-59.53,3.09))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-4.25,-57.54,6.98))
Interior2V.append((-1.79,-59.53,3.09))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((4.15,-51.25,7.08))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((4.15,-51.25,7.08))
Interior2V.append((3.39,-54.93,5.39))
Interior2V.append((4.96,-52.57,5.20))
Interior2V.append((4.15,-51.25,7.08))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((4.96,-52.57,5.20))
Interior2V.append((3.39,-54.93,5.39))
Interior2V.append((4.15,-51.25,7.08))
Interior2V.append((1.08,-53.75,3.63))
Interior2V.append((3.39,-54.93,5.39))
Interior2V.append((4.96,-52.57,5.20))
Interior2V.append((1.08,-53.75,3.63))
Interior2V.append((4.96,-52.57,5.20))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((12.44,-53.58,13.54))
Interior2V.append((12.20,-54.38,14.44))
Interior2V.append((9.76,-53.93,13.41))
Interior2V.append((12.44,-53.58,13.54))
Interior2V.append((13.77,-56.13,13.27))
Interior2V.append((12.20,-54.38,14.44))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((9.76,-53.93,13.41))
Interior2V.append((12.20,-54.38,14.44))
Interior2V.append((10.19,-53.81,10.36))
Interior2V.append((12.44,-53.58,13.54))
Interior2V.append((9.76,-53.93,13.41))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((10.19,-53.81,10.36))
Interior2V.append((9.76,-53.93,13.41))
Interior2V.append((11.69,-53.77,9.41))
Interior2V.append((12.44,-53.58,13.54))
Interior2V.append((10.19,-53.81,10.36))
Interior2V.append((14.69,-55.31,10.90))
Interior2V.append((12.44,-53.58,13.54))
Interior2V.append((11.69,-53.77,9.41))
Interior2V.append((14.69,-55.31,10.90))
Interior2V.append((13.77,-56.13,13.27))
Interior2V.append((12.44,-53.58,13.54))
Interior2V.append((11.51,-57.07,8.56))
Interior2V.append((11.69,-53.77,9.41))
Interior2V.append((10.19,-53.81,10.36))
Interior2V.append((11.51,-57.07,8.56))
Interior2V.append((10.19,-53.81,10.36))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((11.51,-57.07,8.56))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((12.06,-58.64,10.14))
Interior2V.append((6.58,-56.48,10.64))
Interior2V.append((5.27,-59.78,10.11))
Interior2V.append((8.67,-57.84,9.36))
Interior2V.append((6.58,-56.48,10.64))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((5.27,-59.78,10.11))
Interior2V.append((4.27,-57.46,11.53))
Interior2V.append((5.10,-54.47,9.77))
Interior2V.append((4.40,-57.45,8.51))
Interior2V.append((4.27,-57.46,11.53))
Interior2V.append((2.45,-55.72,12.01))
Interior2V.append((5.10,-54.47,9.77))
Interior2V.append((11.69,-53.77,9.41))
Interior2V.append((11.51,-57.07,8.56))
Interior2V.append((14.63,-55.19,9.08))
Interior2V.append((11.69,-53.77,9.41))
Interior2V.append((14.63,-55.19,9.08))
Interior2V.append((14.69,-55.31,10.90))
Interior2V.append((14.12,-57.73,8.85))
Interior2V.append((14.63,-55.19,9.08))
Interior2V.append((11.51,-57.07,8.56))
Interior2V.append((14.12,-57.73,8.85))
Interior2V.append((14.69,-55.31,10.90))
Interior2V.append((14.63,-55.19,9.08))
Interior2V.append((11.51,-57.07,8.56))
Interior2V.append((12.06,-58.64,10.14))
Interior2V.append((14.12,-57.73,8.85))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((8.82,-66.37,6.89))
Interior2V.append((7.53,-71.45,4.83))
Interior2V.append((6.74,-69.50,5.05))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((5.64,-70.37,8.06))
Interior2V.append((5.76,-72.04,8.04))
Interior2V.append((6.04,-71.18,7.63))
Interior2V.append((5.64,-70.37,8.06))
Interior2V.append((6.04,-71.18,7.63))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((6.04,-71.18,7.63))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((5.64,-70.37,8.06))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((5.64,-70.37,8.06))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((8.10,-63.95,8.94))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((8.10,-63.95,8.94))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((8.10,-63.95,8.94))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((9.80,-67.23,8.84))
Interior2V.append((8.48,-63.21,9.64))
Interior2V.append((8.16,-63.40,11.01))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((8.48,-63.21,9.64))
Interior2V.append((9.31,-62.17,9.13))
Interior2V.append((9.49,-61.09,10.11))
Interior2V.append((9.23,-61.30,11.45))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((9.23,-61.30,11.45))
Interior2V.append((9.49,-61.09,10.11))
Interior2V.append((9.49,-61.09,10.11))
Interior2V.append((9.31,-62.17,9.13))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((9.23,-61.30,11.45))
Interior2V.append((8.71,-62.48,11.94))
Interior2V.append((9.31,-62.17,9.13))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((8.71,-62.48,11.94))
Interior2V.append((9.23,-61.30,11.45))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((9.23,-61.30,11.45))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((8.16,-63.40,11.01))
Interior2V.append((8.71,-62.48,11.94))
Interior2V.append((8.16,-63.40,11.01))
Interior2V.append((8.48,-63.21,9.64))
Interior2V.append((8.71,-62.48,11.94))
Interior2V.append((11.79,-64.09,13.51))
Interior2V.append((8.71,-62.48,11.94))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((11.79,-64.09,13.51))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((8.71,-62.48,11.94))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((11.79,-64.09,13.51))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((11.79,-64.09,13.51))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((9.22,-68.47,12.28))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((9.22,-68.47,12.28))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((12.99,-65.32,16.04))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((14.85,-66.18,15.65))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((14.85,-66.18,15.65))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((18.83,-68.67,10.97))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((18.83,-68.67,10.97))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((21.42,-64.39,10.39))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((21.42,-64.39,10.39))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((19.11,-67.76,21.47))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((19.11,-67.76,21.47))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((16.73,-68.57,13.14))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((16.73,-68.57,13.14))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((15.39,-68.52,9.67))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((18.23,-72.51,20.44))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((18.23,-72.51,20.44))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((16.07,-69.26,14.01))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((18.99,-76.11,20.94))
Interior2V.append((18.23,-72.51,20.44))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((18.99,-76.11,20.94))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((18.83,-68.67,10.97))
Interior2V.append((19.21,-65.45,9.37))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((18.83,-68.67,10.97))
Interior2V.append((21.42,-64.39,10.39))
Interior2V.append((19.21,-65.45,9.37))
Interior2V.append((15.39,-68.52,9.67))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((15.39,-68.52,9.67))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((16.85,-67.29,13.24))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((15.39,-68.52,9.67))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((16.73,-68.57,13.14))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((16.73,-68.57,13.14))
Interior2V.append((15.39,-68.52,9.67))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((12.99,-68.70,7.66))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((12.99,-68.70,7.66))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((15.39,-68.52,9.67))
Interior2V.append((12.99,-68.70,7.66))
Interior2V.append((15.39,-68.52,9.67))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((14.43,-70.30,1.77))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((12.07,-65.92,2.78))
Interior2V.append((15.68,-69.18,-.01))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((14.43,-70.30,1.77))
Interior2V.append((15.70,-68.60,3.64))
Interior2V.append((14.43,-70.30,1.77))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((15.70,-68.60,3.64))
Interior2V.append((13.10,-68.00,4.39))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((14.43,-70.30,1.77))
Interior2V.append((15.70,-68.60,3.64))
Interior2V.append((17.62,-67.26,3.73))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((15.70,-68.60,3.64))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((15.68,-69.18,-.01))
Interior2V.append((14.43,-70.30,1.77))
Interior2V.append((15.68,-69.18,-.01))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((13.44,-69.64,.45))
Interior2V.append((11.91,-70.92,5.30))
Interior2V.append((12.59,-70.21,5.14))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((11.91,-70.92,5.30))
Interior2V.append((10.81,-68.15,6.78))
Interior2V.append((12.59,-70.21,5.14))
Interior2V.append((11.91,-70.92,5.30))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((10.81,-68.15,6.78))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((8.38,-73.71,4.01))
Interior2V.append((7.53,-71.45,4.83))
Interior2V.append((7.48,-73.50,6.95))
Interior2V.append((7.62,-75.54,7.25))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((7.48,-73.50,6.95))
Interior2V.append((5.76,-72.04,8.04))
Interior2V.append((7.62,-75.54,7.25))
Interior2V.append((7.62,-75.54,7.25))
Interior2V.append((5.76,-72.04,8.04))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((2.62,-79.43,7.37))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((2.81,-76.80,10.07))
Interior2V.append((2.62,-79.43,7.37))
Interior2V.append((2.81,-76.80,10.07))
Interior2V.append((7.62,-75.54,7.25))
Interior2V.append((2.81,-76.80,10.07))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((7.62,-75.54,7.25))
Interior2V.append((2.81,-76.80,10.07))
Interior2V.append((.58,-76.12,9.02))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((7.35,-78.99,9.64))
Interior2V.append((2.81,-76.80,10.07))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((7.35,-78.99,9.64))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((2.81,-76.80,10.07))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((10.35,-73.69,10.80))
Interior2V.append((6.04,-71.18,7.63))
Interior2V.append((5.76,-72.04,8.04))
Interior2V.append((7.48,-73.50,6.95))
Interior2V.append((10.43,-71.94,6.77))
Interior2V.append((7.48,-73.50,6.95))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((10.43,-71.94,6.77))
Interior2V.append((6.04,-71.18,7.63))
Interior2V.append((7.48,-73.50,6.95))
Interior2V.append((11.27,-71.07,6.50))
Interior2V.append((7.53,-71.45,4.83))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((11.27,-71.07,6.50))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((7.53,-71.45,4.83))
Interior2V.append((11.27,-71.07,6.50))
Interior2V.append((11.91,-70.92,5.30))
Interior2V.append((10.84,-71.85,3.92))
Interior2V.append((11.27,-71.07,6.50))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((11.91,-70.92,5.30))
Interior2V.append((17.78,-70.49,9.67))
Interior2V.append((15.66,-73.71,7.68))
Interior2V.append((18.14,-74.47,7.29))
Interior2V.append((17.78,-70.49,9.67))
Interior2V.append((18.14,-74.47,7.29))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((15.66,-73.71,7.68))
Interior2V.append((17.78,-70.49,9.67))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((17.78,-70.49,9.67))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((15.65,-66.27,5.10))
Interior2V.append((15.11,-67.08,4.88))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((15.65,-66.27,5.10))
Interior2V.append((17.62,-67.26,3.73))
Interior2V.append((15.11,-67.08,4.88))
Interior2V.append((15.11,-67.08,4.88))
Interior2V.append((15.70,-68.60,3.64))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((15.11,-67.08,4.88))
Interior2V.append((17.62,-67.26,3.73))
Interior2V.append((15.70,-68.60,3.64))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((16.40,-67.64,.22))
Interior2V.append((17.62,-67.26,3.73))
Interior2V.append((16.85,-64.58,4.98))
Interior2V.append((15.65,-66.27,5.10))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((15.65,-66.27,5.10))
Interior2V.append((16.85,-64.58,4.98))
Interior2V.append((17.62,-67.26,3.73))
Interior2V.append((14.15,-64.17,4.25))
Interior2V.append((16.85,-64.58,4.98))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((14.15,-64.17,4.25))
Interior2V.append((17.03,-63.12,2.19))
Interior2V.append((16.85,-64.58,4.98))
Interior2V.append((12.84,-64.52,2.06))
Interior2V.append((14.15,-64.17,4.25))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((14.15,-64.17,4.25))
Interior2V.append((13.82,-65.93,2.49))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((13.43,-63.21,.28))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((17.03,-63.12,2.19))
Interior2V.append((13.43,-63.21,.28))
Interior2V.append((12.84,-64.52,2.06))
Interior2V.append((15.80,-65.24,.54))
Interior2V.append((13.95,-61.69,2.70))
Interior2V.append((13.43,-63.21,.28))
Interior2V.append((17.03,-63.12,2.19))
Interior2V.append((13.95,-61.69,2.70))
Interior2V.append((12.84,-64.52,2.06))
Interior2V.append((13.43,-63.21,.28))
Interior2V.append((13.95,-61.69,2.70))
Interior2V.append((17.03,-63.12,2.19))
Interior2V.append((14.15,-64.17,4.25))
Interior2V.append((13.95,-61.69,2.70))
Interior2V.append((14.15,-64.17,4.25))
Interior2V.append((12.84,-64.52,2.06))
Interior2V.append((-7.92,-75.92,3.73))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-7.92,-75.92,3.73))
Interior2V.append((-12.69,-69.36,5.62))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-7.92,-75.92,3.73))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-12.69,-69.36,5.62))
Interior2V.append((-7.92,-75.92,3.73))
Interior2V.append((-7.76,-75.11,5.31))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-7.92,-75.92,3.73))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-7.76,-75.11,5.31))
Interior2V.append((-7.92,-75.92,3.73))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-7.30,-78.03,5.41))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-7.13,-76.27,7.28))
Interior2V.append((-7.30,-78.03,5.41))
Interior2V.append((-7.13,-76.27,7.28))
Interior2V.append((-7.76,-75.11,5.31))
Interior2V.append((-7.30,-78.03,5.41))
Interior2V.append((-7.76,-75.11,5.31))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-6.76,-77.92,7.78))
Interior2V.append((-7.32,-75.94,12.91))
Interior2V.append((-7.13,-76.27,7.28))
Interior2V.append((-6.76,-77.92,7.78))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-7.32,-75.94,12.91))
Interior2V.append((-6.76,-77.92,7.78))
Interior2V.append((-7.13,-76.27,7.28))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-7.13,-76.27,7.28))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-16.74,-66.61,12.47))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-16.74,-66.61,12.47))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-15.02,-65.59,13.88))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-16.74,-66.61,12.47))
Interior2V.append((-14.82,-65.34,11.37))
Interior2V.append((-16.74,-66.61,12.47))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-14.82,-65.34,11.37))
Interior2V.append((-15.02,-65.59,13.88))
Interior2V.append((-16.74,-66.61,12.47))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-15.02,-65.59,13.88))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-9.33,-66.10,14.91))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-9.33,-66.10,14.91))
Interior2V.append((-11.11,-64.42,12.07))
Interior2V.append((-10.54,-67.96,13.15))
Interior2V.append((-11.11,-64.42,12.07))
Interior2V.append((-14.82,-65.34,11.37))
Interior2V.append((-11.14,-68.56,7.31))
Interior2V.append((-12.69,-69.36,5.62))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-11.14,-68.56,7.31))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-12.69,-69.36,5.62))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-12.69,-69.36,5.62))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-11.14,-68.56,7.31))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-11.14,-68.56,7.31))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-6.41,-71.38,7.03))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-7.76,-75.11,5.31))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-7.76,-75.11,5.31))
Interior2V.append((-7.13,-76.27,7.28))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-12.52,-71.13,7.22))
Interior2V.append((-7.76,-75.11,5.31))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-5.16,-75.79,4.92))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-6.04,-68.57,.93))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-9.84,-67.80,1.21))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-7.87,-69.45,5.00))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-7.87,-69.45,5.00))
Interior2V.append((-6.04,-68.57,.93))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-7.87,-69.45,5.00))
Interior2V.append((-7.28,-73.44,3.75))
Interior2V.append((-9.84,-67.80,1.21))
Interior2V.append((-7.87,-69.45,5.00))
Interior2V.append((-9.84,-67.80,1.21))
Interior2V.append((-6.04,-68.57,.93))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-2.04,-67.29,8.37))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-4.25,-65.86,2.71))
Interior2V.append((-6.05,-67.21,3.41))
Interior2V.append((-2.44,-68.07,3.93))
Interior2V.append((-4.25,-65.86,2.71))
Interior2V.append((-2.44,-68.07,3.93))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-5.78,-65.37,5.26))
Interior2V.append((-4.25,-65.86,2.71))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-5.78,-65.37,5.26))
Interior2V.append((-6.05,-67.21,3.41))
Interior2V.append((-4.25,-65.86,2.71))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-2.69,-63.02,5.01))
Interior2V.append((-1.17,-63.33,1.42))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-1.17,-63.33,1.42))
Interior2V.append((.13,-60.20,3.73))
Interior2V.append((-6.05,-67.21,3.41))
Interior2V.append((-4.68,-68.63,2.03))
Interior2V.append((-2.44,-68.07,3.93))
Interior2V.append((-6.05,-67.21,3.41))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-4.68,-68.63,2.03))
Interior2V.append((-6.00,-67.76,5.88))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-6.05,-67.21,3.41))
Interior2V.append((-6.00,-67.76,5.88))
Interior2V.append((-2.44,-68.07,3.93))
Interior2V.append((-3.50,-69.65,6.01))
Interior2V.append((-6.00,-67.76,5.88))
Interior2V.append((-3.50,-69.65,6.01))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-6.00,-67.76,5.88))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-2.44,-68.07,3.93))
Interior2V.append((-6.00,-67.76,5.88))
Interior2V.append((-6.05,-67.21,3.41))
Interior2V.append((-5.78,-65.37,5.26))
Interior2V.append((-6.00,-67.76,5.88))
Interior2V.append((-5.78,-65.37,5.26))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-5.23,-58.29,5.33))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-5.23,-58.29,5.33))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-4.95,-60.58,10.72))
Interior2V.append((-7.30,-61.49,7.61))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-7.30,-61.49,7.61))
Interior2V.append((-5.37,-63.67,8.42))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-5.37,-63.67,8.42))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-2.69,-63.02,5.01))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((-3.62,-61.84,6.11))
Interior2V.append((-2.69,-63.02,5.01))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((.13,-60.20,3.73))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((.13,-60.20,3.73))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((.17,-61.34,9.40))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((.17,-61.34,9.40))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((.17,-61.34,9.40))
Interior2V.append((-2.73,-60.04,8.88))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((2.36,-63.51,9.03))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((2.64,-64.62,7.41))
Interior2V.append((2.36,-63.51,9.03))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((-2.41,-63.39,7.41))
Interior2V.append((2.36,-63.51,9.03))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((2.36,-63.51,9.03))
Interior2V.append((2.64,-64.62,7.41))
Interior2V.append((2.50,-65.10,6.55))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((2.50,-65.10,6.55))
Interior2V.append((2.64,-64.62,7.41))
Interior2V.append((2.00,-62.37,6.39))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((2.64,-64.62,7.41))
Interior2V.append((2.50,-65.10,6.55))
Interior2V.append((2.15,-66.33,6.52))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((2.50,-65.10,6.55))
Interior2V.append((2.15,-66.33,6.52))
Interior2V.append((2.50,-65.10,6.55))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((4.07,-68.34,8.12))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((4.07,-68.34,8.12))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((5.87,-66.51,11.52))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((5.87,-66.51,11.52))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((5.87,-66.51,11.52))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((4.60,-66.51,11.89))
Interior2V.append((5.87,-66.51,11.52))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((4.60,-66.51,11.89))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((5.87,-66.51,11.52))
Interior2V.append((4.60,-66.51,11.89))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((2.99,-67.46,9.75))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((2.99,-67.46,9.75))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((2.94,-67.26,12.69))
Interior2V.append((2.99,-67.46,9.75))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((.47,-63.49,10.53))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((-2.04,-67.29,8.37))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-1.39,-68.48,6.45))
Interior2V.append((-2.04,-67.29,8.37))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((-1.39,-68.48,6.45))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-2.04,-67.29,8.37))
Interior2V.append((-1.39,-68.48,6.45))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((-2.21,-66.10,5.28))
Interior2V.append((-.11,-67.30,4.44))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((-1.39,-68.48,6.45))
Interior2V.append((-.11,-67.30,4.44))
Interior2V.append((2.15,-66.33,6.52))
Interior2V.append((-.83,-64.89,4.93))
Interior2V.append((1.08,-68.13,7.66))
Interior2V.append((-.11,-67.30,4.44))
Interior2V.append((-1.39,-68.48,6.45))
Interior2V.append((1.08,-68.13,7.66))
Interior2V.append((-1.39,-68.48,6.45))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((1.08,-68.13,7.66))
Interior2V.append((1.22,-66.27,8.30))
Interior2V.append((2.15,-66.33,6.52))
Interior2V.append((1.08,-68.13,7.66))
Interior2V.append((2.15,-66.33,6.52))
Interior2V.append((-.11,-67.30,4.44))
Interior2V.append((3.48,-57.71,8.00))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((2.52,-58.27,8.83))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((2.52,-58.27,8.83))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((-.28,-55.10,6.04))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((-.28,-55.10,6.04))
Interior2V.append((2.52,-58.27,8.83))
Interior2V.append((1.41,-58.68,8.17))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((-.28,-55.10,6.04))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-.28,-55.10,6.04))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((2.52,-58.27,8.83))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((1.82,-58.18,12.47))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((1.82,-58.18,12.47))
Interior2V.append((2.45,-55.72,12.01))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((.87,-60.27,10.93))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((.87,-60.27,10.93))
Interior2V.append((1.82,-58.18,12.47))
Interior2V.append((.60,-59.01,8.82))
Interior2V.append((.70,-60.27,11.88))
Interior2V.append((1.82,-58.18,12.47))
Interior2V.append((.87,-60.27,10.93))
Interior2V.append((.70,-60.27,11.88))
Interior2V.append((.87,-60.27,10.93))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((1.82,-58.18,12.47))
Interior2V.append((.70,-60.27,11.88))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((.70,-60.27,11.88))
Interior2V.append((-1.31,-58.17,9.49))
Interior2V.append((1.82,-58.18,12.47))
Interior2V.append((-1.47,-58.50,13.27))
Interior2V.append((1.45,-55.85,13.57))
Interior2V.append((1.45,-55.85,13.57))
Interior2V.append((2.45,-55.72,12.01))
Interior2V.append((1.82,-58.18,12.47))
Interior2V.append((2.31,-53.64,13.47))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((2.45,-55.72,12.01))
Interior2V.append((2.31,-53.64,13.47))
Interior2V.append((2.45,-55.72,12.01))
Interior2V.append((1.45,-55.85,13.57))
Interior2V.append((2.31,-53.64,13.47))
Interior2V.append((1.45,-55.85,13.57))
Interior2V.append((.70,-53.25,15.72))
Interior2V.append((-.82,-55.12,16.45))
Interior2V.append((.70,-53.25,15.72))
Interior2V.append((1.45,-55.85,13.57))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((2.31,-53.64,13.47))
Interior2V.append((.70,-53.25,15.72))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((2.31,-53.64,13.47))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((-2.87,-51.75,13.54))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-2.87,-51.75,13.54))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-2.32,-53.51,7.22))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((3.32,-57.45,6.62))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((3.48,-57.71,8.00))
Interior2V.append((2.10,-57.88,6.04))
Interior2V.append((-.28,-55.10,6.04))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((2.10,-57.88,6.04))
Interior2V.append((3.32,-57.45,6.62))
Interior2V.append((-.28,-55.10,6.04))
Interior2V.append((2.10,-57.88,6.04))
Interior2V.append((1.13,-58.46,6.85))
Interior2V.append((3.32,-57.45,6.62))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((6.02,-61.47,11.12))
Interior2V.append((5.27,-59.78,10.11))
Interior2V.append((6.72,-61.17,9.52))
Interior2V.append((5.27,-59.78,10.11))
Interior2V.append((6.02,-61.47,11.12))
Interior2V.append((6.72,-61.17,9.52))
Interior2V.append((6.02,-61.47,11.12))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((6.02,-61.47,11.12))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((8.67,-57.84,9.36))
Interior2V.append((6.72,-61.17,9.52))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((8.67,-57.84,9.36))
Interior2V.append((5.27,-59.78,10.11))
Interior2V.append((6.72,-61.17,9.52))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((8.67,-57.84,9.36))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((6.58,-56.48,10.64))
Interior2V.append((8.67,-57.84,9.36))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((6.58,-56.48,10.64))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((6.58,-56.48,10.64))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((2.22,-50.61,15.16))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((.70,-53.25,15.72))
Interior2V.append((2.22,-50.61,15.16))
Interior2V.append((-.56,-64.24,19.67))
Interior2V.append((-.82,-63.62,20.91))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((.70,-64.78,19.40))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((-.56,-64.24,19.67))
Interior2V.append((.70,-64.78,19.40))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((.70,-64.78,19.40))
Interior2V.append((-.56,-64.24,19.67))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((2.70,-66.86,19.05))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((2.70,-66.86,19.05))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((7.17,-66.71,20.10))
Interior2V.append((-5.41,-66.25,28.09))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-5.41,-66.25,28.09))
Interior2V.append((-2.91,-62.01,26.42))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((-5.41,-66.25,28.09))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-2.91,-62.01,26.42))
Interior2V.append((-2.08,-62.00,24.77))
Interior2V.append((-2.91,-62.01,26.42))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-10.71,-55.66,22.71))
Interior2V.append((-11.59,-58.26,22.06))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-10.71,-55.66,22.71))
Interior2V.append((-9.20,-59.11,22.79))
Interior2V.append((-11.59,-58.26,22.06))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-11.59,-58.26,22.06))
Interior2V.append((-9.20,-59.11,22.79))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-10.71,-55.66,22.71))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-9.20,-59.11,22.79))
Interior2V.append((-10.71,-55.66,22.71))
Interior2V.append((-7.32,-58.64,21.01))
Interior2V.append((-9.20,-59.11,22.79))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-15.72,-63.94,18.57))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-15.72,-63.94,18.57))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-15.72,-63.94,18.57))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-14.75,-67.13,20.05))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-10.21,-62.98,15.60))
Interior2V.append((-10.80,-62.87,17.18))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-10.80,-62.87,17.18))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-14.20,-61.08,21.86))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-14.20,-61.08,21.86))
Interior2V.append((-14.38,-60.99,18.85))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-14.20,-61.08,21.86))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-10.80,-62.87,17.18))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-8.99,-61.65,17.31))
Interior2V.append((-10.80,-62.87,17.18))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-11.50,-60.88,22.44))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-10.02,-63.24,22.57))
Interior2V.append((-11.50,-60.88,22.44))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-10.02,-63.24,22.57))
Interior2V.append((-14.03,-63.24,19.71))
Interior2V.append((-11.50,-60.88,22.44))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-11.50,-60.88,22.44))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-11.50,-60.88,22.44))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-8.99,-61.65,17.31))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-12.42,-59.22,20.74))
Interior2V.append((-11.59,-58.26,22.06))
Interior2V.append((-7.32,-58.64,21.01))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-9.20,-59.11,22.79))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-8.58,-59.42,20.04))
Interior2V.append((-7.32,-58.64,21.01))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-7.32,-58.64,21.01))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-6.30,-57.97,19.22))
Interior2V.append((-7.32,-58.64,21.01))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-8.00,-55.45,22.51))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-7.28,-53.86,22.89))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-2.68,-54.32,20.83))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-2.68,-54.32,20.83))
Interior2V.append((-4.78,-54.81,24.24))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-2.68,-54.32,20.83))
Interior2V.append((-3.10,-55.73,21.74))
Interior2V.append((-4.78,-54.81,24.24))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-4.78,-54.81,24.24))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-4.78,-54.81,24.24))
Interior2V.append((-3.10,-55.73,21.74))
Interior2V.append((-3.10,-55.73,21.74))
Interior2V.append((-2.68,-54.32,20.83))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-3.78,-55.77,19.81))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-2.68,-54.32,20.83))
Interior2V.append((-3.78,-55.77,19.81))
Interior2V.append((-2.68,-54.32,20.83))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-3.14,-54.34,18.34))
Interior2V.append((-3.84,-55.11,18.60))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((.78,-54.02,24.13))
Interior2V.append((-.51,-52.75,25.34))
Interior2V.append((1.89,-55.47,24.14))
Interior2V.append((.78,-54.02,24.13))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-1.15,-52.02,27.65))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-1.15,-52.02,27.65))
Interior2V.append((2.03,-49.70,27.15))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-3.65,-51.01,32.78))
Interior2V.append((2.03,-49.70,27.15))
Interior2V.append((-1.15,-52.02,27.65))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((2.03,-49.70,27.15))
Interior2V.append((-3.65,-51.01,32.78))
Interior2V.append((-1.15,-52.02,27.65))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((11.07,-70.99,27.23))
Interior2V.append((9.31,-69.99,26.30))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((14.15,-67.30,22.52))
Interior2V.append((11.07,-70.99,27.23))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((9.31,-69.99,26.30))
Interior2V.append((14.15,-67.30,22.52))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((14.15,-67.30,22.52))
Interior2V.append((9.31,-69.99,26.30))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((9.84,-66.59,18.26))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((7.63,-68.80,17.95))
Interior2V.append((9.84,-66.59,18.26))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((9.84,-66.59,18.26))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((9.84,-66.59,18.26))
Interior2V.append((7.63,-68.80,17.95))
Interior2V.append((5.81,-67.70,18.05))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((7.63,-68.80,17.95))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((5.81,-67.70,18.05))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((5.81,-67.70,18.05))
Interior2V.append((7.63,-68.80,17.95))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((5.81,-67.70,18.05))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((9.22,-68.47,12.28))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((4.32,-67.17,14.25))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((4.32,-67.17,14.25))
Interior2V.append((4.32,-67.17,14.25))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((4.32,-67.17,14.25))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((9.22,-68.47,12.28))
Interior2V.append((6.67,-67.45,11.78))
Interior2V.append((5.76,-73.50,17.98))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((7.96,-72.29,18.28))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((5.76,-73.50,17.98))
Interior2V.append((7.96,-72.29,18.28))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((7.96,-72.29,18.28))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((10.35,-73.69,10.80))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((7.35,-78.99,9.64))
Interior2V.append((6.24,-80.34,11.35))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((7.35,-78.99,9.64))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((10.35,-73.69,10.80))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((11.74,-75.32,9.73))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((10.35,-73.69,10.80))
Interior2V.append((11.74,-75.32,9.73))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((10.52,-74.45,21.04))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((10.52,-74.45,21.04))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((10.52,-74.45,21.04))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((-2.91,-62.01,26.42))
Interior2V.append((-2.08,-62.00,24.77))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((-2.91,-62.01,26.42))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((-2.08,-62.00,24.77))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((-2.08,-62.00,24.77))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((8.47,-67.22,23.03))
Interior2V.append((10.92,-72.32,22.16))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((9.24,-68.59,22.29))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((9.24,-68.59,22.29))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((10.92,-72.32,22.16))
Interior2V.append((10.92,-72.32,22.16))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((13.11,-71.43,22.75))
Interior2V.append((13.11,-71.43,22.75))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((10.92,-72.32,22.16))
Interior2V.append((13.11,-71.43,22.75))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((16.81,-73.44,20.94))
Interior2V.append((17.34,-75.59,21.18))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((16.81,-73.44,20.94))
Interior2V.append((12.21,-74.94,20.98))
Interior2V.append((17.34,-75.59,21.18))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((16.81,-73.44,20.94))
Interior2V.append((18.23,-72.51,20.44))
Interior2V.append((17.34,-75.59,21.18))
Interior2V.append((17.34,-75.59,21.18))
Interior2V.append((18.23,-72.51,20.44))
Interior2V.append((18.99,-76.11,20.94))
Interior2V.append((17.34,-75.59,21.18))
Interior2V.append((18.99,-76.11,20.94))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((17.34,-75.59,21.18))
Interior2V.append((16.81,-73.44,20.94))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((16.81,-73.44,20.94))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((18.23,-72.51,20.44))
Interior2V.append((13.37,-79.57,9.15))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((13.37,-79.57,9.15))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((13.37,-79.57,9.15))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((15.66,-73.71,7.68))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((11.74,-75.32,9.73))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((15.62,-70.06,13.63))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((11.74,-75.32,9.73))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((12.54,-72.55,9.48))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((15.66,-73.71,7.68))
Interior2V.append((7.62,-75.54,7.25))
Interior2V.append((7.26,-78.02,6.06))
Interior2V.append((2.62,-79.43,7.37))
Interior2V.append((7.62,-75.54,7.25))
Interior2V.append((6.30,-73.76,5.62))
Interior2V.append((7.26,-78.02,6.06))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((-.25,-75.65,9.11))
Interior2V.append((1.08,-78.12,8.28))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((1.08,-78.12,8.28))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((-1.19,-78.53,10.19))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((-3.11,-75.96,9.13))
Interior2V.append((-1.19,-78.53,10.19))
Interior2V.append((-3.11,-75.96,9.13))
Interior2V.append((-.25,-75.65,9.11))
Interior2V.append((-1.19,-78.53,10.19))
Interior2V.append((-.25,-75.65,9.11))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-1.05,-71.20,11.96))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-4.57,-73.59,10.18))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-3.24,-70.80,7.32))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-2.46,-73.80,10.38))
Interior2V.append((-4.57,-73.59,10.18))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-6.41,-71.38,7.03))
Interior2V.append((-3.24,-70.80,7.32))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-6.41,-71.38,7.03))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-4.57,-73.59,10.18))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-6.41,-71.38,7.03))
Interior2V.append((-8.27,-71.64,5.83))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-5.16,-75.79,4.92))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-3.24,-70.80,7.32))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((-6.41,-71.38,7.03))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-3.24,-70.80,7.32))
Interior2V.append((-6.41,-71.38,7.03))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-5.81,-73.85,4.46))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-6.41,-71.38,7.03))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((-1.05,-71.20,11.96))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((-1.05,-71.20,11.96))
Interior2V.append((1.07,-72.32,12.19))
Interior2V.append((2.84,-68.38,14.82))
Interior2V.append((2.94,-67.26,12.69))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((1.07,-72.32,12.19))
Interior2V.append((-1.05,-71.20,11.96))
Interior2V.append((1.19,-67.53,15.75))
Interior2V.append((2.94,-67.26,12.69))
Interior2V.append((2.84,-68.38,14.82))
Interior2V.append((2.44,-69.29,17.27))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((1.19,-67.53,15.75))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((-1.05,-71.20,11.96))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-4.42,-66.43,16.03))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-4.42,-66.43,16.03))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((.00,-75.99,17.03))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((-.56,-64.24,19.67))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((2.44,-69.29,17.27))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((5.81,-67.70,18.05))
Interior2V.append((5.53,-66.83,18.43))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((5.81,-67.70,18.05))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((5.53,-66.83,18.43))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((7.17,-66.71,20.10))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((7.17,-66.71,20.10))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((8.58,-66.25,18.53))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((5.53,-66.83,18.43))
Interior2V.append((7.17,-66.71,20.10))
Interior2V.append((8.14,-65.16,18.16))
Interior2V.append((6.43,-62.14,15.36))
Interior2V.append((5.06,-61.19,16.89))
Interior2V.append((3.66,-66.67,16.86))
Interior2V.append((3.66,-66.67,16.86))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((6.43,-62.14,15.36))
Interior2V.append((3.66,-66.67,16.86))
Interior2V.append((5.53,-66.83,18.43))
Interior2V.append((5.13,-66.31,14.57))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((3.72,-56.86,14.49))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((3.72,-56.86,14.49))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((6.47,-54.71,13.97))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((6.47,-54.71,13.97))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((5.39,-57.79,12.93))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((5.35,-54.64,16.76))
Interior2V.append((3.72,-56.86,14.49))
Interior2V.append((6.47,-54.71,13.97))
Interior2V.append((3.82,-56.19,16.65))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((3.72,-56.86,14.49))
Interior2V.append((3.82,-56.19,16.65))
Interior2V.append((3.72,-56.86,14.49))
Interior2V.append((5.35,-54.64,16.76))
Interior2V.append((8.27,-55.24,15.77))
Interior2V.append((5.35,-54.64,16.76))
Interior2V.append((6.47,-54.71,13.97))
Interior2V.append((8.27,-55.24,15.77))
Interior2V.append((6.47,-54.71,13.97))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((8.27,-55.24,15.77))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-3.11,-75.96,9.13))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((-5.53,-78.30,5.41))
Interior2V.append((-5.75,-76.81,3.63))
Interior2V.append((-5.16,-75.79,4.92))
Interior2V.append((-5.53,-78.30,5.41))
Interior2V.append((-5.16,-75.79,4.92))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((-5.16,-75.79,4.92))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((-5.75,-76.81,3.63))
Interior2V.append((-5.53,-78.30,5.41))
Interior2V.append((-.81,-81.20,7.03))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((-5.53,-78.30,5.41))
Interior2V.append((-.81,-81.20,7.03))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((-.81,-81.20,7.03))
Interior2V.append((-5.53,-78.30,5.41))
Interior2V.append((-3.33,-77.97,7.20))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-5.75,-76.81,3.63))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-5.16,-75.79,4.92))
Interior2V.append((-5.75,-76.81,3.63))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((7.35,-78.99,9.64))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((6.24,-80.34,11.35))
Interior2V.append((7.35,-78.99,9.64))
Interior2V.append((4.92,-81.61,11.41))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((6.24,-80.34,11.35))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((5.76,-73.50,17.98))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((8.46,-74.53,20.94))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((8.46,-74.53,20.94))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((6.95,-73.87,21.67))
Interior2V.append((8.46,-74.53,20.94))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((6.95,-73.87,21.67))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((8.46,-74.53,20.94))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((5.88,-84.40,11.94))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((4.92,-81.61,11.41))
Interior2V.append((5.88,-84.40,11.94))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((-2.58,-84.09,11.53))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((5.88,-84.40,11.94))
Interior2V.append((-2.58,-84.09,11.53))
Interior2V.append((5.88,-84.40,11.94))
Interior2V.append((4.92,-81.61,11.41))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-2.61,-50.25,26.77))
Interior2V.append((-5.07,-49.56,30.05))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-2.61,-50.25,26.77))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-6.32,-48.09,26.12))
Interior2V.append((-3.58,-50.38,25.21))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-3.58,-50.38,25.21))
Interior2V.append((-6.32,-48.09,26.12))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-6.32,-48.09,26.12))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-3.58,-50.38,25.21))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-3.58,-50.38,25.21))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-3.58,-50.38,25.21))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-3.74,-58.45,34.63))
Interior2V.append((-2.83,-59.03,29.31))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-3.74,-58.45,34.63))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-3.74,-58.45,34.63))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-2.83,-59.03,29.31))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-3.11,-58.06,28.55))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((-2.83,-59.03,29.31))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((-3.11,-58.06,28.55))
Interior2V.append((-2.83,-59.03,29.31))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((1.89,-55.47,24.14))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((1.89,-55.47,24.14))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((-1.75,-58.62,27.14))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-3.11,-58.06,28.55))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-2.83,-59.03,29.31))
Interior2V.append((-3.11,-58.06,28.55))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((-5.37,-55.04,26.05))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-3.15,-52.95,25.50))
Interior2V.append((-5.37,-55.04,26.05))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((-3.15,-52.95,25.50))
Interior2V.append((-2.39,-57.07,26.89))
Interior2V.append((-.51,-52.75,25.34))
Interior2V.append((-3.15,-52.95,25.50))
Interior2V.append((-.51,-52.75,25.34))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-3.15,-52.95,25.50))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-3.15,-52.95,25.50))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-5.37,-55.04,26.05))
Interior2V.append((-3.15,-52.95,25.50))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-3.15,-52.95,25.50))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-7.42,-52.30,27.39))
Interior2V.append((-5.37,-55.04,26.05))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-7.42,-52.30,27.39))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-5.37,-55.04,26.05))
Interior2V.append((-7.42,-52.30,27.39))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-9.00,-53.39,26.19))
Interior2V.append((-7.42,-52.30,27.39))
Interior2V.append((-5.57,-53.37,32.26))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-5.57,-53.37,32.26))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-5.57,-53.37,32.26))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-5.57,-53.37,32.26))
Interior2V.append((-12.54,-53.63,22.78))
Interior2V.append((-12.73,-52.73,19.94))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-12.54,-53.63,22.78))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-12.73,-52.73,19.94))
Interior2V.append((-12.54,-53.63,22.78))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-10.51,-49.32,23.58))
Interior2V.append((-11.13,-52.37,24.40))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-10.51,-49.32,23.58))
Interior2V.append((-11.83,-50.34,22.82))
Interior2V.append((-8.43,-49.31,22.70))
Interior2V.append((-12.02,-49.66,24.46))
Interior2V.append((-11.13,-52.37,24.40))
Interior2V.append((-10.51,-49.32,23.58))
Interior2V.append((-12.02,-49.66,24.46))
Interior2V.append((-10.51,-49.32,23.58))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-12.02,-49.66,24.46))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-11.13,-52.37,24.40))
Interior2V.append((-10.52,-49.42,27.69))
Interior2V.append((-9.16,-47.93,28.43))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-10.52,-49.42,27.69))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-10.51,-49.32,23.58))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-10.51,-49.32,23.58))
Interior2V.append((-10.16,-48.10,28.08))
Interior2V.append((-10.52,-49.42,27.69))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-10.16,-48.10,28.08))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-9.16,-47.93,28.43))
Interior2V.append((-10.16,-48.10,28.08))
Interior2V.append((-9.16,-47.93,28.43))
Interior2V.append((-10.52,-49.42,27.69))
Interior2V.append((9.31,-69.99,26.30))
Interior2V.append((11.07,-70.99,27.23))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((8.10,-69.54,24.41))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((9.31,-69.99,26.30))
Interior2V.append((8.10,-69.54,24.41))
Interior2V.append((9.31,-69.99,26.30))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((8.10,-69.54,24.41))
Interior2V.append((11.70,-71.24,24.57))
Interior2V.append((9.24,-68.59,22.29))
Interior2V.append((8.10,-69.54,24.41))
Interior2V.append((9.24,-68.59,22.29))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((11.12,-68.07,20.89))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((9.08,-72.03,20.36))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((13.32,-67.83,19.92))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((11.12,-68.07,20.89))
Interior2V.append((13.32,-67.83,19.92))
Interior2V.append((13.46,-66.58,18.13))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((14.02,-65.83,18.49))
Interior2V.append((13.46,-66.58,18.13))
Interior2V.append((14.02,-65.83,18.49))
Interior2V.append((15.88,-68.65,20.29))
Interior2V.append((16.07,-60.11,17.46))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((10.92,-54.63,14.88))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((12.20,-54.38,14.44))
Interior2V.append((10.92,-54.63,14.88))
Interior2V.append((12.20,-54.38,14.44))
Interior2V.append((13.77,-56.13,13.27))
Interior2V.append((13.25,-57.23,14.58))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((10.92,-54.63,14.88))
Interior2V.append((13.25,-57.23,14.58))
Interior2V.append((10.92,-54.63,14.88))
Interior2V.append((13.77,-56.13,13.27))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((13.25,-57.23,14.58))
Interior2V.append((13.77,-56.13,13.27))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((13.77,-56.13,13.27))
Interior2V.append((15.10,-58.61,11.78))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((15.10,-58.61,11.78))
Interior2V.append((12.06,-58.64,10.14))
Interior2V.append((12.06,-58.64,10.14))
Interior2V.append((13.39,-59.96,9.88))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((13.39,-59.96,9.88))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((13.39,-59.96,9.88))
Interior2V.append((13.25,-57.23,14.58))
Interior2V.append((13.65,-59.29,13.60))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((13.25,-57.23,14.58))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((10.65,-58.81,16.34))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((10.65,-58.81,16.34))
Interior2V.append((10.70,-57.83,15.62))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((10.65,-58.81,16.34))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((4.59,-60.36,16.90))
Interior2V.append((5.06,-61.19,16.89))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((7.06,-58.72,20.15))
Interior2V.append((4.59,-60.36,16.90))
Interior2V.append((5.34,-56.36,18.67))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((5.34,-56.36,18.67))
Interior2V.append((6.21,-59.16,15.90))
Interior2V.append((3.82,-56.19,16.65))
Interior2V.append((5.34,-56.36,18.67))
Interior2V.append((3.82,-56.19,16.65))
Interior2V.append((5.35,-54.64,16.76))
Interior2V.append((-6.21,-49.48,28.66))
Interior2V.append((-9.16,-47.93,28.43))
Interior2V.append((-6.32,-48.09,26.12))
Interior2V.append((-6.21,-49.48,28.66))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-9.16,-47.93,28.43))
Interior2V.append((13.39,-59.96,9.88))
Interior2V.append((9.49,-61.09,10.11))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((9.49,-61.09,10.11))
Interior2V.append((13.39,-59.96,9.88))
Interior2V.append((9.96,-60.17,9.80))
Interior2V.append((13.39,-59.96,9.88))
Interior2V.append((12.06,-58.64,10.14))
Interior2V.append((9.96,-60.17,9.80))
Interior2V.append((-1.52,-50.64,3.85))
Interior2V.append((-.41,-51.49,3.64))
Interior2V.append((1.20,-49.08,6.19))
Interior2V.append((-1.52,-50.64,3.85))
Interior2V.append((-2.00,-51.04,5.07))
Interior2V.append((-.41,-51.49,3.64))
Interior2V.append((-1.52,-50.64,3.85))
Interior2V.append((1.20,-49.08,6.19))
Interior2V.append((-2.00,-51.04,5.07))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((-.41,-51.49,3.64))
Interior2V.append((-2.00,-51.04,5.07))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((1.20,-49.08,6.19))
Interior2V.append((-.41,-51.49,3.64))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((-2.00,-51.04,5.07))
Interior2V.append((-.41,-51.49,3.64))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((-.37,-52.53,4.68))
Interior2V.append((-.41,-51.49,3.64))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((-.41,-51.49,3.64))
Interior2V.append((-.37,-52.53,4.68))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((-.37,-52.53,4.68))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((.43,-53.69,4.52))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((-.37,-52.53,4.68))
Interior2V.append((.43,-53.69,4.52))
Interior2V.append((-.37,-52.53,4.68))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((9.22,-68.47,12.28))
Interior2V.append((9.24,-69.27,9.95))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((7.96,-72.29,18.28))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((7.63,-68.80,17.95))
Interior2V.append((8.27,-70.43,19.52))
Interior2V.append((7.63,-68.80,17.95))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((8.27,-70.43,19.52))
Interior2V.append((7.96,-72.29,18.28))
Interior2V.append((7.63,-68.80,17.95))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((7.96,-72.29,18.28))
Interior2V.append((8.27,-70.43,19.52))
Interior2V.append((9.08,-72.03,20.36))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((8.27,-70.43,19.52))
Interior2V.append((9.08,-72.03,20.36))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((6.95,-73.87,21.67))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((6.14,-71.37,23.34))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((6.14,-71.37,23.34))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((6.14,-71.37,23.34))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((1.92,-68.40,19.48))
Interior2V.append((2.44,-69.29,17.27))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((.00,-75.99,17.03))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((.00,-75.99,17.03))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((1.58,-75.01,13.24))
Interior2V.append((2.66,-74.45,15.86))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((1.58,-75.01,13.24))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((1.58,-75.01,13.24))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((1.60,-73.54,14.29))
Interior2V.append((1.58,-75.01,13.24))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((1.60,-73.54,14.29))
Interior2V.append((2.66,-74.45,15.86))
Interior2V.append((1.58,-75.01,13.24))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((1.07,-72.32,12.19))
Interior2V.append((1.60,-73.54,14.29))
Interior2V.append((2.32,-75.45,11.06))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((1.07,-72.32,12.19))
Interior2V.append((5.76,-72.04,8.04))
Interior2V.append((5.64,-70.37,8.06))
Interior2V.append((4.30,-69.32,8.90))
Interior2V.append((4.62,-68.21,7.00))
Interior2V.append((5.18,-65.02,5.88))
Interior2V.append((3.82,-66.21,8.64))
Interior2V.append((4.62,-68.21,7.00))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((5.18,-65.02,5.88))
Interior2V.append((4.62,-68.21,7.00))
Interior2V.append((3.82,-66.21,8.64))
Interior2V.append((5.73,-64.22,8.41))
Interior2V.append((4.62,-68.21,7.00))
Interior2V.append((5.73,-64.22,8.41))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((4.62,-68.21,7.00))
Interior2V.append((6.70,-65.84,9.85))
Interior2V.append((4.07,-68.34,8.12))
Interior2V.append((4.62,-68.21,7.00))
Interior2V.append((4.07,-68.34,8.12))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((4.62,-68.21,7.00))
Interior2V.append((6.02,-69.13,6.57))
Interior2V.append((6.79,-66.78,5.55))
Interior2V.append((-1.22,-70.38,9.38))
Interior2V.append((-3.24,-70.80,7.32))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((-3.24,-70.80,7.32))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((-3.50,-69.65,6.01))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((-3.50,-69.65,6.01))
Interior2V.append((-2.11,-70.83,5.86))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-2.44,-68.07,3.93))
Interior2V.append((-4.68,-68.63,2.03))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-3.50,-69.65,6.01))
Interior2V.append((-2.44,-68.07,3.93))
Interior2V.append((-4.68,-68.63,2.03))
Interior2V.append((-6.04,-68.57,.93))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-4.68,-68.63,2.03))
Interior2V.append((-6.15,-70.03,4.71))
Interior2V.append((-6.04,-68.57,.93))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-3.23,-70.82,-.45))
Interior2V.append((-6.20,-74.54,3.02))
Interior2V.append((-3.78,-70.69,1.11))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-3.23,-70.82,-.45))
Interior2V.append((-5.05,-69.01,-.97))
Interior2V.append((-9.84,-67.80,1.21))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-5.05,-69.01,-.97))
Interior2V.append((-4.80,-71.08,-.11))
Interior2V.append((-6.04,-68.57,.93))
Interior2V.append((-5.05,-69.01,-.97))
Interior2V.append((-6.04,-68.57,.93))
Interior2V.append((-9.84,-67.80,1.21))
Interior2V.append((-10.19,-55.74,16.37))
Interior2V.append((-10.62,-56.09,17.19))
Interior2V.append((-9.92,-57.94,14.91))
Interior2V.append((-10.19,-55.74,16.37))
Interior2V.append((-9.92,-57.94,14.91))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-10.19,-55.74,16.37))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-10.62,-56.09,17.19))
Interior2V.append((-11.99,-53.76,18.42))
Interior2V.append((-11.23,-54.59,19.10))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-11.99,-53.76,18.42))
Interior2V.append((-12.73,-52.73,19.94))
Interior2V.append((-11.23,-54.59,19.10))
Interior2V.append((-9.45,-50.67,17.97))
Interior2V.append((-11.99,-53.76,18.42))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-9.45,-50.67,17.97))
Interior2V.append((-11.88,-50.61,19.81))
Interior2V.append((-11.99,-53.76,18.42))
Interior2V.append((-9.45,-50.67,17.97))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-5.42,-51.79,8.89))
Interior2V.append((-2.32,-53.51,7.22))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-2.32,-53.51,7.22))
Interior2V.append((-5.42,-51.79,8.89))
Interior2V.append((-7.64,-53.30,10.31))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-5.42,-51.79,8.89))
Interior2V.append((-7.64,-53.30,10.31))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-7.64,-53.30,10.31))
Interior2V.append((-5.42,-51.79,8.89))
Interior2V.append((-6.44,-50.29,11.47))
Interior2V.append((-6.44,-50.29,11.47))
Interior2V.append((-7.64,-51.77,12.40))
Interior2V.append((-7.64,-53.30,10.31))
Interior2V.append((-6.50,-55.60,11.38))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-3.32,-55.57,6.83))
Interior2V.append((-2.32,-53.51,7.22))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-3.32,-55.57,6.83))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-2.32,-53.51,7.22))
Interior2V.append((-3.32,-55.57,6.83))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-3.32,-55.57,6.83))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-3.28,-56.54,7.31))
Interior2V.append((-3.32,-55.57,6.83))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-5.70,-54.32,9.27))
Interior2V.append((-6.50,-55.60,11.38))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-4.62,-54.98,13.02))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-4.62,-54.98,13.02))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-4.07,-54.59,13.75))
Interior2V.append((-4.62,-54.98,13.02))
Interior2V.append((-4.07,-54.59,13.75))
Interior2V.append((-3.04,-58.14,13.91))
Interior2V.append((-4.07,-54.59,13.75))
Interior2V.append((-4.43,-54.66,12.10))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((-.82,-55.12,16.45))
Interior2V.append((1.45,-55.85,13.57))
Interior2V.append((-1.20,-57.67,15.54))
Interior2V.append((5.35,-54.64,16.76))
Interior2V.append((8.27,-55.24,15.77))
Interior2V.append((7.94,-55.84,19.58))
Interior2V.append((5.35,-54.64,16.76))
Interior2V.append((7.94,-55.84,19.58))
Interior2V.append((5.34,-56.36,18.67))
Interior2V.append((12.71,-57.02,21.37))
Interior2V.append((15.11,-60.78,20.26))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((12.71,-57.02,21.37))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((15.11,-60.78,20.26))
Interior2V.append((12.71,-57.02,21.37))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((11.71,-55.20,22.72))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((11.71,-55.20,22.72))
Interior2V.append((12.71,-57.02,21.37))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((11.71,-55.20,22.72))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((12.71,-57.02,21.37))
Interior2V.append((12.71,-57.02,21.37))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((12.71,-57.02,21.37))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((7.99,-56.83,21.22))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((7.06,-58.72,20.15))
Interior2V.append((7.99,-56.83,21.22))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((7.99,-56.83,21.22))
Interior2V.append((7.06,-58.72,20.15))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((5.06,-61.19,16.89))
Interior2V.append((4.59,-60.36,16.90))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((4.59,-60.36,16.90))
Interior2V.append((7.06,-58.72,20.15))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((5.06,-61.19,16.89))
Interior2V.append((7.47,-60.33,16.49))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((7.06,-58.72,20.15))
Interior2V.append((7.06,-58.72,20.15))
Interior2V.append((7.79,-59.69,18.75))
Interior2V.append((9.58,-58.36,20.13))
Interior2V.append((7.17,-66.71,20.10))
Interior2V.append((8.47,-67.22,23.03))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((8.47,-67.22,23.03))
Interior2V.append((7.17,-66.71,20.10))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((5.10,-54.47,9.77))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((5.10,-54.47,9.77))
Interior2V.append((2.45,-55.72,12.01))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((4.40,-57.45,8.51))
Interior2V.append((5.10,-54.47,9.77))
Interior2V.append((2.34,-51.33,9.17))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((2.34,-51.33,9.17))
Interior2V.append((1.49,-52.01,10.20))
Interior2V.append((2.34,-51.33,9.17))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((1.49,-52.01,10.20))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((2.34,-51.33,9.17))
Interior2V.append((1.49,-52.01,10.20))
Interior2V.append((1.70,-53.07,10.26))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((2.34,-51.33,9.17))
Interior2V.append((1.88,-50.27,8.45))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((1.88,-50.27,8.45))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((-1.28,-52.20,5.63))
Interior2V.append((.75,-49.85,8.58))
Interior2V.append((1.20,-49.08,6.19))
Interior2V.append((.41,-54.80,5.23))
Interior2V.append((.43,-53.69,4.52))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((.41,-54.80,5.23))
Interior2V.append((-.59,-53.37,7.40))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((.41,-54.80,5.23))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((.43,-53.69,4.52))
Interior2V.append((.43,-53.69,4.52))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((3.39,-54.93,5.39))
Interior2V.append((.43,-53.69,4.52))
Interior2V.append((3.39,-54.93,5.39))
Interior2V.append((1.08,-53.75,3.63))
Interior2V.append((.43,-53.69,4.52))
Interior2V.append((1.08,-53.75,3.63))
Interior2V.append((2.09,-50.60,5.68))
Interior2V.append((3.32,-57.45,6.62))
Interior2V.append((3.48,-57.71,8.00))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((3.32,-57.45,6.62))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((-.28,-55.10,6.04))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((4.27,-57.46,11.53))
Interior2V.append((4.40,-57.45,8.51))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((2.45,-55.72,12.01))
Interior2V.append((4.27,-57.46,11.53))
Interior2V.append((3.48,-57.71,8.00))
Interior2V.append((4.40,-57.45,8.51))
Interior2V.append((3.46,-54.23,7.68))
Interior2V.append((3.48,-57.71,8.00))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((4.40,-57.45,8.51))
Interior2V.append((2.65,-58.27,9.90))
Interior2V.append((3.48,-57.71,8.00))
Interior2V.append((2.52,-58.27,8.83))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((8.58,-56.07,13.91))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((9.76,-53.93,13.41))
Interior2V.append((9.37,-56.50,14.26))
Interior2V.append((-1.15,-52.02,27.65))
Interior2V.append((-5.07,-49.56,30.05))
Interior2V.append((-2.61,-50.25,26.77))
Interior2V.append((-1.15,-52.02,27.65))
Interior2V.append((-2.61,-50.25,26.77))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-3.65,-51.01,32.78))
Interior2V.append((-5.07,-49.56,30.05))
Interior2V.append((-1.15,-52.02,27.65))
Interior2V.append((-3.65,-51.01,32.78))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-5.70,-51.68,31.72))
Interior2V.append((-3.65,-51.01,32.78))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-5.70,-51.68,31.72))
Interior2V.append((-5.07,-49.56,30.05))
Interior2V.append((-3.65,-51.01,32.78))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-5.70,-51.68,31.72))
Interior2V.append((-2.76,-52.59,28.25))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-5.07,-49.56,30.05))
Interior2V.append((-5.70,-51.68,31.72))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-5.07,-49.56,30.05))
Interior2V.append((2.52,-53.83,24.04))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-.51,-52.75,25.34))
Interior2V.append((2.52,-53.83,24.04))
Interior2V.append((1.89,-55.47,24.14))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((2.52,-53.83,24.04))
Interior2V.append((-.51,-52.75,25.34))
Interior2V.append((1.89,-55.47,24.14))
Interior2V.append((1.89,-55.47,24.14))
Interior2V.append((-.51,-52.75,25.34))
Interior2V.append((.78,-54.02,24.13))
Interior2V.append((-6.32,-48.09,26.12))
Interior2V.append((-9.16,-47.93,28.43))
Interior2V.append((-7.82,-48.05,25.15))
Interior2V.append((-7.42,-52.30,27.39))
Interior2V.append((-9.86,-50.27,27.60))
Interior2V.append((-6.21,-49.48,28.66))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-6.21,-49.48,28.66))
Interior2V.append((-6.32,-48.09,26.12))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-7.42,-52.30,27.39))
Interior2V.append((-6.21,-49.48,28.66))
Interior2V.append((-8.43,-49.31,22.70))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-10.51,-49.32,23.58))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-7.45,-49.52,22.29))
Interior2V.append((-6.76,-48.59,21.51))
Interior2V.append((-7.45,-49.52,22.29))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-6.76,-48.59,21.51))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-7.45,-49.52,22.29))
Interior2V.append((-6.76,-48.59,21.51))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-6.69,-50.67,22.65))
Interior2V.append((-8.08,-49.13,19.15))
Interior2V.append((-7.45,-49.52,22.29))
Interior2V.append((-8.43,-49.31,22.70))
Interior2V.append((-8.08,-49.13,19.15))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-7.45,-49.52,22.29))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-6.76,-48.59,21.51))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-5.38,-48.73,21.18))
Interior2V.append((-6.76,-48.59,21.51))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-5.38,-48.73,21.18))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-6.76,-48.59,21.51))
Interior2V.append((-5.38,-48.73,21.18))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-3.27,-50.12,19.90))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-3.27,-50.12,19.90))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-4.68,-49.87,21.51))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-4.88,-51.82,22.52))
Interior2V.append((-5.35,-50.89,22.25))
Interior2V.append((-3.84,-55.11,18.60))
Interior2V.append((-6.30,-55.27,22.14))
Interior2V.append((-3.78,-55.77,19.81))
Interior2V.append((-3.84,-55.11,18.60))
Interior2V.append((-3.78,-55.77,19.81))
Interior2V.append((-3.17,-52.27,21.43))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-7.10,-52.08,17.26))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-7.10,-52.08,17.26))
Interior2V.append((-.68,-48.73,17.85))
Interior2V.append((-.99,-52.41,17.86))
Interior2V.append((-3.27,-50.12,19.90))
Interior2V.append((-.68,-48.73,17.85))
Interior2V.append((-3.27,-50.12,19.90))
Interior2V.append((-3.23,-48.58,18.22))
Interior2V.append((-2.70,-48.61,16.30))
Interior2V.append((-.68,-48.73,17.85))
Interior2V.append((-3.23,-48.58,18.22))
Interior2V.append((-2.70,-48.61,16.30))
Interior2V.append((-3.23,-48.58,18.22))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-2.70,-48.61,16.30))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-.99,-52.41,17.86))
Interior2V.append((-1.86,-48.85,15.82))
Interior2V.append((-.99,-52.41,17.86))
Interior2V.append((-.68,-48.73,17.85))
Interior2V.append((-1.86,-48.85,15.82))
Interior2V.append((-2.70,-48.61,16.30))
Interior2V.append((-.99,-52.41,17.86))
Interior2V.append((-1.86,-48.85,15.82))
Interior2V.append((-.68,-48.73,17.85))
Interior2V.append((-2.70,-48.61,16.30))
Interior2V.append((-3.23,-48.58,18.22))
Interior2V.append((-3.27,-50.12,19.90))
Interior2V.append((-5.92,-50.93,18.09))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((9.96,-60.17,9.80))
Interior2V.append((9.04,-56.77,10.81))
Interior2V.append((9.96,-60.17,9.80))
Interior2V.append((12.06,-58.64,10.14))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((9.49,-61.09,10.11))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((9.49,-61.09,10.11))
Interior2V.append((9.96,-60.17,9.80))
Interior2V.append((6.02,-61.47,11.12))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((9.53,-60.54,12.16))
Interior2V.append((6.02,-61.47,11.12))
Interior2V.append((5.57,-61.11,13.51))
Interior2V.append((8.55,-62.58,13.01))
Interior2V.append((6.02,-61.47,11.12))
Interior2V.append((7.38,-59.92,14.73))
Interior2V.append((5.57,-61.11,13.51))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((10.23,-65.02,15.21))
Interior2V.append((11.09,-65.23,14.11))
Interior2V.append((10.23,-65.02,15.21))
Interior2V.append((8.33,-65.38,11.98))
Interior2V.append((14.24,-64.30,15.27))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((14.24,-64.30,15.27))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((14.24,-64.30,15.27))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((16.20,-62.59,14.52))
Interior2V.append((14.24,-64.30,15.27))
Interior2V.append((14.85,-66.18,15.65))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((14.24,-64.30,15.27))
Interior2V.append((16.48,-66.90,14.08))
Interior2V.append((14.85,-66.18,15.65))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((13.46,-66.58,18.13))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((16.12,-66.10,15.65))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((15.51,-68.65,14.58))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((15.93,-61.76,13.88))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((18.57,-59.48,11.63))
Interior2V.append((16.57,-60.18,12.14))
Interior2V.append((16.87,-61.35,12.89))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((18.57,-59.48,11.63))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((11.70,-65.84,20.64))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((11.70,-65.84,20.64))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((15.11,-60.78,20.26))
Interior2V.append((10.15,-65.59,22.57))
Interior2V.append((13.09,-61.34,19.32))
Interior2V.append((12.76,-65.79,22.08))
Interior2V.append((15.11,-60.78,20.26))
Interior2V.append((12.99,-65.32,16.04))
Interior2V.append((13.46,-66.58,18.13))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((12.99,-65.32,16.04))
Interior2V.append((14.33,-67.27,15.35))
Interior2V.append((13.46,-66.58,18.13))
Interior2V.append((10.22,-65.99,17.56))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((12.99,-65.32,16.04))
Interior2V.append((10.22,-65.99,17.56))
Interior2V.append((12.99,-65.32,16.04))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((10.22,-65.99,17.56))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((11.38,-66.23,13.85))
Interior2V.append((10.22,-65.99,17.56))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((9.75,-65.83,15.73))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((2.84,-68.38,14.82))
Interior2V.append((4.29,-68.47,12.71))
Interior2V.append((2.44,-69.29,17.27))
Interior2V.append((2.84,-68.38,14.82))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((2.44,-69.29,17.27))
Interior2V.append((1.19,-67.53,15.75))
Interior2V.append((2.84,-68.38,14.82))
Interior2V.append((5.62,-71.87,18.67))
Interior2V.append((2.44,-69.29,17.27))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((1.60,-73.54,14.29))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((2.66,-74.45,15.86))
Interior2V.append((1.60,-73.54,14.29))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((2.07,-74.90,16.53))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((1.60,-73.54,14.29))
Interior2V.append((.84,-75.27,16.24))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((.00,-75.99,17.03))
Interior2V.append((.33,-75.02,15.00))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((.00,-75.99,17.03))
Interior2V.append((.33,-75.02,15.00))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((.33,-75.02,15.00))
Interior2V.append((.00,-75.99,17.03))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((1.60,-73.54,14.29))
Interior2V.append((1.07,-72.32,12.19))
Interior2V.append((-.45,-71.23,10.10))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((-.45,-71.23,10.10))
Interior2V.append((.69,-71.33,9.83))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((.64,-78.58,11.15))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((-2.58,-84.09,11.53))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((-2.58,-84.09,11.53))
Interior2V.append((.64,-78.58,11.15))
Interior2V.append((.64,-78.58,11.15))
Interior2V.append((-2.58,-84.09,11.53))
Interior2V.append((4.92,-81.61,11.41))
Interior2V.append((.64,-78.58,11.15))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((.64,-78.58,11.15))
Interior2V.append((4.92,-81.61,11.41))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((12.30,-80.98,9.57))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((12.30,-80.98,9.57))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((8.02,-81.92,11.15))
Interior2V.append((12.30,-80.98,9.57))
Interior2V.append((8.02,-81.92,11.15))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((6.24,-80.34,11.35))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((8.02,-81.92,11.15))
Interior2V.append((6.24,-80.34,11.35))
Interior2V.append((8.02,-81.92,11.15))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((7.02,-82.27,12.56))
Interior2V.append((7.85,-73.98,18.87))
Interior2V.append((11.99,-79.26,10.28))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-.89,-76.33,16.76))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((4.92,-81.61,11.41))
Interior2V.append((6.24,-80.34,11.35))
Interior2V.append((2.19,-77.29,11.64))
Interior2V.append((8.38,-73.71,4.01))
Interior2V.append((11.55,-74.31,4.24))
Interior2V.append((9.35,-75.95,4.74))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((9.35,-75.95,4.74))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((8.38,-73.71,4.01))
Interior2V.append((9.35,-75.95,4.74))
Interior2V.append((5.40,-71.90,-.71))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((5.40,-71.90,-.71))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((5.40,-71.90,-.71))
Interior2V.append((7.51,-75.96,4.78))
Interior2V.append((6.94,-71.52,.04))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((18.14,-74.47,7.29))
Interior2V.append((15.66,-73.71,7.68))
Interior2V.append((13.66,-75.69,8.30))
Interior2V.append((16.94,-70.22,12.04))
Interior2V.append((18.14,-74.47,7.29))
Interior2V.append((9.86,-75.39,8.62))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((9.86,-75.39,8.62))
Interior2V.append((7.48,-73.50,6.95))
Interior2V.append((9.13,-75.83,9.49))
Interior2V.append((9.86,-75.39,8.62))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((7.48,-73.50,6.95))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-7.13,-76.27,7.28))
Interior2V.append((-7.32,-75.94,12.91))
Interior2V.append((-6.48,-75.01,12.45))
Interior2V.append((-7.32,-75.94,12.91))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-6.48,-75.01,12.45))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-7.32,-75.94,12.91))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-6.48,-75.01,12.45))
Interior2V.append((-8.35,-75.87,13.26))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-6.48,-75.01,12.45))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-4.57,-73.59,10.18))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-7.64,-68.48,13.92))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-3.04,-72.33,11.60))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-7.64,-68.48,13.92))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((-7.64,-68.48,13.92))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-9.37,-67.07,8.98))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-9.37,-67.07,8.98))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-7.69,-69.15,7.99))
Interior2V.append((-9.37,-67.07,8.98))
Interior2V.append((-9.31,-69.12,12.51))
Interior2V.append((-12.57,-70.38,8.73))
Interior2V.append((-5.54,-64.94,11.82))
Interior2V.append((-5.85,-66.22,13.64))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((-5.54,-64.94,11.82))
Interior2V.append((-4.02,-67.14,11.57))
Interior2V.append((-5.85,-66.22,13.64))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-5.85,-66.22,13.64))
Interior2V.append((-4.02,-67.14,11.57))
Interior2V.append((-6.05,-64.99,10.72))
Interior2V.append((-4.02,-67.14,11.57))
Interior2V.append((-5.54,-64.94,11.82))
Interior2V.append((-6.05,-64.99,10.72))
Interior2V.append((-5.54,-64.94,11.82))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-4.02,-67.14,11.57))
Interior2V.append((-6.05,-64.99,10.72))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-6.05,-64.99,10.72))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-4.02,-67.14,11.57))
Interior2V.append((-4.58,-66.25,10.04))
Interior2V.append((-4.02,-67.14,11.57))
Interior2V.append((-5.80,-68.48,9.48))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((-2.26,-66.71,12.11))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-1.05,-71.20,11.96))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((-2.26,-66.71,12.11))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-2.72,-68.38,11.99))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-2.17,-65.99,15.77))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((-4.42,-66.43,16.03))
Interior2V.append((-2.17,-65.99,15.77))
Interior2V.append((-4.42,-66.43,16.03))
Interior2V.append((-2.84,-67.83,14.23))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-1.14,-64.20,17.57))
Interior2V.append((-.56,-64.24,19.67))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-1.14,-64.20,17.57))
Interior2V.append((-5.66,-65.69,18.94))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-5.66,-65.69,18.94))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-5.66,-65.69,18.94))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-18.01,-67.59,14.25))
Interior2V.append((-16.74,-66.61,12.47))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-18.01,-67.59,14.25))
Interior2V.append((-16.33,-67.15,14.98))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-18.01,-67.59,14.25))
Interior2V.append((-13.89,-71.34,8.29))
Interior2V.append((-16.74,-66.61,12.47))
Interior2V.append((-10.62,-56.09,17.19))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-11.52,-57.09,17.15))
Interior2V.append((-10.62,-56.09,17.19))
Interior2V.append((-11.52,-57.09,17.15))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-11.52,-57.09,17.15))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-11.52,-57.09,17.15))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-10.62,-56.09,17.19))
Interior2V.append((-6.63,-56.89,17.09))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-11.23,-54.59,19.10))
Interior2V.append((-12.73,-52.73,19.94))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-11.23,-54.59,19.10))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-8.67,-53.79,18.96))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-10.11,-54.05,22.65))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-12.73,-52.73,19.94))
Interior2V.append((-11.88,-50.61,19.81))
Interior2V.append((-12.73,-52.73,19.94))
Interior2V.append((-11.99,-53.76,18.42))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-11.59,-58.26,22.06))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-11.59,-58.26,22.06))
Interior2V.append((-11.46,-54.81,20.25))
Interior2V.append((-11.95,-57.43,18.19))
Interior2V.append((-9.90,-56.25,18.96))
Interior2V.append((-20.31,-61.61,14.39))
Interior2V.append((-19.28,-60.54,12.36))
Interior2V.append((-19.92,-59.52,12.70))
Interior2V.append((-17.49,-58.38,12.68))
Interior2V.append((-19.92,-59.52,12.70))
Interior2V.append((-19.28,-60.54,12.36))
Interior2V.append((-17.49,-58.38,12.68))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-19.92,-59.52,12.70))
Interior2V.append((-17.49,-58.38,12.68))
Interior2V.append((-19.28,-60.54,12.36))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-18.01,-60.31,12.02))
Interior2V.append((-19.28,-60.54,12.36))
Interior2V.append((-20.31,-61.61,14.39))
Interior2V.append((-18.01,-60.31,12.02))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-19.28,-60.54,12.36))
Interior2V.append((-19.44,-57.97,16.14))
Interior2V.append((-20.31,-61.61,14.39))
Interior2V.append((-19.92,-59.52,12.70))
Interior2V.append((-19.44,-57.97,16.14))
Interior2V.append((-19.92,-59.52,12.70))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-19.44,-57.97,16.14))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-20.31,-61.61,14.39))
Interior2V.append((-19.44,-57.97,16.14))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-19.07,-60.24,17.25))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-17.02,-58.41,16.02))
Interior2V.append((-18.01,-60.31,12.02))
Interior2V.append((-18.87,-63.01,14.11))
Interior2V.append((-18.01,-60.31,12.02))
Interior2V.append((-20.31,-61.61,14.39))
Interior2V.append((-18.87,-63.01,14.11))
Interior2V.append((-15.71,-60.30,13.26))
Interior2V.append((-18.01,-60.31,12.02))
Interior2V.append((-8.06,-59.95,7.60))
Interior2V.append((-7.30,-61.49,7.61))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-8.06,-59.95,7.60))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-7.30,-61.49,7.61))
Interior2V.append((-8.06,-59.95,7.60))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-4.95,-60.58,10.72))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-6.17,-57.31,11.96))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-4.95,-60.58,10.72))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-4.54,-59.68,7.22))
Interior2V.append((-4.95,-60.58,10.72))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-5.45,-59.34,11.86))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-2.97,-59.06,8.51))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((-6.95,-56.52,8.73))
Interior2V.append((-8.35,-62.58,9.14))
Interior2V.append((-7.30,-61.49,7.61))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-8.35,-62.58,9.14))
Interior2V.append((-5.37,-63.67,8.42))
Interior2V.append((-7.30,-61.49,7.61))
Interior2V.append((-5.37,-63.67,8.42))
Interior2V.append((-7.69,-63.05,11.75))
Interior2V.append((-4.16,-63.69,9.74))
Interior2V.append((-7.69,-63.05,11.75))
Interior2V.append((-8.35,-62.58,9.14))
Interior2V.append((-6.59,-60.54,11.20))
Interior2V.append((-7.69,-63.05,11.75))
Interior2V.append((-5.37,-63.67,8.42))
Interior2V.append((-8.35,-62.58,9.14))
Interior2V.append((-7.29,-66.05,16.43))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-9.33,-66.10,14.91))
Interior2V.append((-7.29,-66.05,16.43))
Interior2V.append((-9.33,-66.10,14.91))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-6.86,-66.92,19.57))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-7.29,-66.05,16.43))
Interior2V.append((-6.86,-66.92,19.57))
Interior2V.append((-7.29,-66.05,16.43))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-6.86,-66.92,19.57))
Interior2V.append((-8.06,-64.96,20.68))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-6.86,-66.92,19.57))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-8.06,-64.96,20.68))
Interior2V.append((2.13,-60.36,21.04))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((2.13,-60.36,21.04))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((2.13,-60.36,21.04))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((1.70,-60.89,22.13))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((5.53,-66.83,18.43))
Interior2V.append((2.70,-66.86,19.05))
Interior2V.append((7.17,-66.71,20.10))
Interior2V.append((5.53,-66.83,18.43))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((2.70,-66.86,19.05))
Interior2V.append((3.37,-60.06,20.99))
Interior2V.append((1.27,-64.52,20.13))
Interior2V.append((5.06,-61.19,16.89))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((-.82,-63.62,20.91))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((-.82,-63.62,20.91))
Interior2V.append((-.56,-64.24,19.67))
Interior2V.append((-1.83,-62.62,21.02))
Interior2V.append((-.82,-63.62,20.91))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((-5.86,-66.71,23.44))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-5.86,-66.71,23.44))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((5.56,-67.88,24.93))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((-2.08,-62.00,24.77))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((-.09,-63.82,21.67))
Interior2V.append((-2.08,-62.00,24.77))
Interior2V.append((-5.75,-67.40,26.90))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-5.86,-66.71,23.44))
Interior2V.append((-5.75,-67.40,26.90))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-5.75,-67.40,26.90))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((4.30,-69.62,24.54))
Interior2V.append((-5.75,-67.40,26.90))
Interior2V.append((-5.86,-66.71,23.44))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((-4.71,-56.70,27.92))
Interior2V.append((-5.37,-55.04,26.05))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-4.71,-56.70,27.92))
Interior2V.append((-6.68,-53.04,28.82))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-4.71,-56.70,27.92))
Interior2V.append((-3.70,-55.98,29.03))
Interior2V.append((-5.37,-55.04,26.05))
Interior2V.append((-4.35,-62.08,21.85))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-1.83,-62.62,21.02))
Interior2V.append((-4.35,-62.08,21.85))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-4.35,-62.08,21.85))
Interior2V.append((-1.83,-62.62,21.02))
Interior2V.append((-3.16,-63.67,23.91))
Interior2V.append((-5.23,-63.10,19.41))
Interior2V.append((-2.25,-62.78,18.67))
Interior2V.append((-2.53,-62.25,19.92))
Interior2V.append((-5.23,-63.10,19.41))
Interior2V.append((-2.53,-62.25,19.92))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-5.23,-63.10,19.41))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-2.25,-62.78,18.67))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-2.25,-62.78,18.67))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-2.53,-62.25,19.92))
Interior2V.append((-2.25,-62.78,18.67))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-.83,-60.66,15.62))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((-.83,-60.66,15.62))
Interior2V.append((-2.37,-59.86,13.74))
Interior2V.append((-1.83,-62.62,21.02))
Interior2V.append((-2.53,-62.25,19.92))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-1.83,-62.62,21.02))
Interior2V.append((-4.63,-65.78,21.27))
Interior2V.append((-2.53,-62.25,19.92))
Interior2V.append((-1.83,-62.62,21.02))
Interior2V.append((-1.31,-63.80,18.56))
Interior2V.append((-.82,-63.62,20.91))
Interior2V.append((-8.41,-63.23,18.60))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-8.41,-63.23,18.60))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-8.06,-64.96,20.68))
Interior2V.append((-8.41,-63.23,18.60))
Interior2V.append((-8.06,-64.96,20.68))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-9.33,-66.10,14.91))
Interior2V.append((-10.21,-62.98,15.60))
Interior2V.append((-11.11,-64.42,12.07))
Interior2V.append((-9.33,-66.10,14.91))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-10.21,-62.98,15.60))
Interior2V.append((-10.80,-62.87,17.18))
Interior2V.append((-10.21,-62.98,15.60))
Interior2V.append((-9.97,-64.45,16.66))
Interior2V.append((-9.00,-62.71,19.52))
Interior2V.append((-8.06,-64.96,20.68))
Interior2V.append((-10.02,-63.24,22.57))
Interior2V.append((-7.64,-68.48,13.92))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-4.89,-67.43,20.79))
Interior2V.append((-4.17,-74.40,12.74))
Interior2V.append((-.97,-73.20,13.76))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-6.86,-66.92,19.57))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-7.70,-67.81,21.26))
Interior2V.append((-6.86,-66.92,19.57))
Interior2V.append((-8.99,-68.46,15.07))
Interior2V.append((-6.56,-74.02,12.44))
Interior2V.append((-5.85,-66.22,13.64))
Interior2V.append((-4.53,-68.02,13.77))
Interior2V.append((-7.64,-68.48,13.92))
Interior2V.append((-5.85,-66.22,13.64))
Interior2V.append((-7.64,-68.48,13.92))
Interior2V.append((-8.22,-67.17,11.34))
Interior2V.append((.32,-68.14,17.23))
Interior2V.append((-2.17,-65.99,15.77))
Interior2V.append((1.19,-67.53,15.75))
Interior2V.append((-3.91,-75.41,9.38))
Interior2V.append((-4.57,-73.59,10.18))
Interior2V.append((-2.46,-73.80,10.38))
Interior2V.append((-5.00,-75.56,8.67))
Interior2V.append((-4.57,-73.59,10.18))
Interior2V.append((-3.91,-75.41,9.38))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((-3.91,-75.41,9.38))
Interior2V.append((-2.46,-73.80,10.38))
Interior2V.append((-3.11,-75.96,9.13))
Interior2V.append((-3.91,-75.41,9.38))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((-2.46,-73.80,10.38))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-1.22,-70.38,9.38))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((-2.21,-70.44,9.51))
Interior2V.append((-3.24,-70.80,7.32))
Interior2V.append((-1.22,-70.38,9.38))
Interior2V.append((-.45,-71.23,10.10))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((-1.22,-70.38,9.38))
Interior2V.append((-.45,-71.23,10.10))
Interior2V.append((-1.22,-70.38,9.38))
Interior2V.append((-.07,-70.21,7.58))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-3.91,-75.41,9.38))
Interior2V.append((-3.11,-75.96,9.13))
Interior2V.append((-1.56,-74.39,9.80))
Interior2V.append((-.25,-75.65,9.11))
Interior2V.append((-3.11,-75.96,9.13))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-5.00,-75.56,8.67))
Interior2V.append((-3.91,-75.41,9.38))
Interior2V.append((-5.00,-75.56,8.67))
Interior2V.append((-4.61,-76.19,6.83))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-5.00,-75.56,8.67))
Interior2V.append((-5.96,-74.89,8.76))
Interior2V.append((-4.57,-73.59,10.18))
Interior2V.append((5.62,-71.87,18.67))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((2.44,-69.29,17.27))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((5.62,-71.87,18.67))
Interior2V.append((5.76,-73.50,17.98))
Interior2V.append((8.27,-70.43,19.52))
Interior2V.append((11.12,-68.07,20.89))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((8.27,-70.43,19.52))
Interior2V.append((8.91,-70.27,22.25))
Interior2V.append((9.08,-72.03,20.36))
Interior2V.append((8.27,-70.43,19.52))
Interior2V.append((10.27,-67.49,18.36))
Interior2V.append((11.12,-68.07,20.89))
Interior2V.append((5.62,-71.87,18.67))
Interior2V.append((5.53,-69.20,16.59))
Interior2V.append((5.76,-73.50,17.98))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((7.94,-55.84,19.58))
Interior2V.append((8.27,-55.24,15.77))
Interior2V.append((8.73,-57.27,17.38))
Interior2V.append((5.34,-56.36,18.67))
Interior2V.append((7.94,-55.84,19.58))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((2.22,-50.61,15.16))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((2.22,-50.61,15.16))
Interior2V.append((.70,-53.25,15.72))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((.70,-53.25,15.72))
Interior2V.append((-.82,-55.12,16.45))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((-2.87,-51.75,13.54))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((-.48,-49.14,10.87))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((.96,-51.75,12.54))
Interior2V.append((-1.67,-49.68,13.40))
Interior2V.append((-.48,-49.14,10.87))
Interior2V.append((-4.96,-52.77,14.70))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-5.48,-51.30,15.68))
Interior2V.append((-4.96,-52.77,14.70))
Interior2V.append((-5.48,-51.30,15.68))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-4.96,-52.77,14.70))
Interior2V.append((-4.96,-52.77,14.70))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-4.07,-54.59,13.75))
Interior2V.append((-4.96,-52.77,14.70))
Interior2V.append((-4.07,-54.59,13.75))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((-.82,-55.12,16.45))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-2.35,-52.46,13.92))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((-4.75,-54.94,16.64))
Interior2V.append((-3.14,-54.34,18.34))
Interior2V.append((-.84,-52.51,16.92))
Interior2V.append((-3.14,-54.34,18.34))
Interior2V.append((-2.84,-51.34,15.42))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((.17,-58.60,6.38))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-2.29,-56.68,8.22))
Interior2V.append((-1.61,-55.85,8.32))
Interior2V.append((-2.10,-57.95,8.79))
Interior2V.append((.46,-51.74,10.01))
Interior2V.append((-.48,-49.14,10.87))
Interior2V.append((-.51,-49.32,9.93))
Interior2V.append((2.83,-60.29,-5.15))
Interior2V.append((4.03,-61.09,-2.99))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((2.83,-60.29,-5.15))
Interior2V.append((2.06,-58.52,-2.89))
Interior2V.append((4.03,-61.09,-2.99))
Interior2V.append((2.83,-60.29,-5.15))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((3.79,-58.33,-6.57))
Interior2V.append((2.06,-58.52,-2.89))
Interior2V.append((2.83,-60.29,-5.15))
Interior2V.append((3.79,-58.33,-6.57))
Interior2V.append((2.83,-60.29,-5.15))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((3.79,-58.33,-6.57))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((3.79,-58.33,-6.57))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((3.79,-58.33,-6.57))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((8.10,-58.86,-2.14))
Interior2V.append((7.73,-57.99,-2.48))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((7.69,-57.65,-5.77))
Interior2V.append((8.10,-58.86,-2.14))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((4.71,-63.14,-6.09))
Interior2V.append((3.35,-61.45,-6.46))
Interior2V.append((6.32,-58.70,-6.52))
Interior2V.append((5.03,-61.06,-4.45))
Interior2V.append((3.79,-58.33,-6.57))
Interior2V.append((4.49,-56.28,-5.44))
Interior2V.append((2.06,-58.52,-2.89))
Interior2V.append((3.79,-58.33,-6.57))
Interior2V.append((6.05,-57.67,-5.08))
Interior2V.append((4.49,-56.28,-5.44))
Interior2V.append((-9.45,-50.67,17.97))
Interior2V.append((-7.49,-51.45,18.81))
Interior2V.append((-8.08,-49.13,19.15))
Interior2V.append((-9.45,-50.67,17.97))
Interior2V.append((-8.08,-49.13,19.15))
Interior2V.append((-11.88,-50.61,19.81))
Interior2V.append((7.43,-65.32,-2.87))
Interior2V.append((4.88,-64.54,-1.58))
Interior2V.append((8.55,-63.95,-.11))
Interior2V.append((7.43,-65.32,-2.87))
Interior2V.append((5.22,-62.42,-3.28))
Interior2V.append((4.88,-64.54,-1.58))
Interior2V.append((9.16,-68.14,-9.16))
Interior2V.append((11.20,-69.43,-8.51))
Interior2V.append((9.36,-67.38,-6.90))
Interior2V.append((9.34,-66.77,-4.41))
Interior2V.append((7.35,-69.25,-5.87))
Interior2V.append((9.36,-67.38,-6.90))
Interior2V.append((9.34,-66.77,-4.41))
Interior2V.append((9.36,-67.38,-6.90))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((5.40,-73.14,19.80))
Interior2V.append((6.95,-73.87,21.67))
Interior2V.append((.41,-76.54,17.77))
Interior2V.append((6.95,-73.87,21.67))
Interior2V.append((2.45,-75.08,17.44))
Interior2V.append((11.10,-72.32,19.78))
Interior2V.append((12.41,-71.23,20.37))
Interior2V.append((12.87,-72.83,19.73))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((10.35,-73.69,10.80))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((11.26,-68.07,9.27))
Interior2V.append((10.34,-67.44,11.31))
Interior2V.append((12.54,-72.55,9.48))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((12.07,-72.78,10.28))
Interior2V.append((12.54,-72.55,9.48))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((10.89,-69.02,11.83))
Interior2V.append((12.54,-72.55,9.48))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((11.40,-70.65,8.50))
Interior2V.append((12.54,-72.55,9.48))
Interior2V.append((15.66,-73.71,7.68))
Interior2V.append((15.25,-70.14,10.17))
Interior2V.append((-2.00,-51.04,5.07))
Interior2V.append((-2.82,-50.31,5.83))
Interior2V.append((-1.60,-51.96,7.73))
Interior2V.append((-2.00,-51.04,5.07))
Interior2V.append((1.20,-49.08,6.19))
Interior2V.append((-2.82,-50.31,5.83))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((13.39,-59.96,9.88))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((11.96,-59.85,8.91))
Interior2V.append((13.57,-63.45,8.40))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((13.57,-63.45,8.40))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((12.47,-64.27,12.70))
Interior2V.append((12.61,-64.43,9.56))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((16.90,-66.65,12.48))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((14.56,-65.89,9.77))
Interior2V.append((14.92,-62.78,10.16))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((14.16,-63.32,10.37))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((14.77,-61.03,14.15))
Interior2V.append((11.88,-61.95,13.43))
Interior2V.append((14.49,-59.93,13.37))
Interior2V.append((-1.72,-53.78,27.43))
Interior2V.append((-2.83,-59.03,29.31))
Interior2V.append((-3.53,-53.05,33.56))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-3.58,-50.38,25.21))
Interior2V.append((-7.15,-51.44,23.26))
Interior2V.append((-5.87,-53.72,24.93))
Interior2V.append((-4.19,-51.07,26.79))
Interior2V.append((-3.58,-50.38,25.21))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((14.41,-67.64,21.62))
Interior2V.append((14.15,-67.30,22.52))
Interior2V.append((11.87,-68.24,22.46))
Interior2V.append((13.11,-71.43,22.75))
Interior2V.append((14.41,-67.64,21.62))
Interior2V.append((15.83,-68.55,23.59))
Interior2V.append((14.15,-67.30,22.52))
Interior2V.append((14.41,-67.64,21.62))
Interior2V.append((15.83,-68.55,23.59))
Interior2V.append((14.41,-67.64,21.62))
Interior2V.append((13.11,-71.43,22.75))
Interior2V.append((-10.80,-62.87,17.18))
Interior2V.append((-8.99,-61.65,17.31))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-10.80,-62.87,17.18))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-10.21,-62.98,15.60))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-12.50,-61.19,13.54))
Interior2V.append((-11.89,-60.97,15.34))
Interior2V.append((-15.50,-64.38,16.03))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-16.08,-64.24,14.89))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-15.50,-64.38,16.03))
Interior2V.append((-15.50,-64.38,16.03))
Interior2V.append((-14.56,-65.20,16.08))
Interior2V.append((-16.08,-64.24,14.89))
Interior2V.append((-14.00,-62.26,17.09))
Interior2V.append((-16.08,-64.24,14.89))
Interior2V.append((-15.42,-61.36,16.60))
Interior2V.append((.26,-68.02,9.76))
Interior2V.append((-2.80,-65.44,8.49))
Interior2V.append((-2.26,-66.71,12.11))
Interior2V.append((-5.23,-58.29,5.33))
Interior2V.append((-4.25,-57.54,6.98))
Interior2V.append((-4.02,-58.81,7.60))
Interior2V.append((-5.23,-58.29,5.33))
Interior2V.append((-2.36,-60.20,3.72))
Interior2V.append((-4.25,-57.54,6.98))
Interior2V.append((10.43,-71.94,6.77))
Interior2V.append((10.38,-72.74,9.20))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((10.43,-71.94,6.77))
Interior2V.append((9.49,-69.34,7.16))
Interior2V.append((6.04,-71.18,7.63))
Interior2V.append((6.74,-69.50,5.05))
Interior2V.append((7.53,-71.45,4.83))
Interior2V.append((4.81,-69.56,2.95))
Interior2V.append((7.07,-68.13,.70))
Interior2V.append((4.81,-69.56,2.95))
Interior2V.append((7.83,-69.69,.59))
Interior2V.append((5.48,-66.97,2.15))
Interior2V.append((4.81,-69.56,2.95))
Interior2V.append((7.07,-68.13,.70))
Interior2V.append((5.48,-66.97,2.15))
Interior2V.append((6.74,-69.50,5.05))
Interior2V.append((4.81,-69.56,2.95))
Interior2V.append((5.33,-66.92,3.34))
Interior2V.append((5.48,-66.97,2.15))
Interior2V.append((7.07,-68.13,.70))
Interior2V.append((5.33,-66.92,3.34))
Interior2V.append((6.74,-69.50,5.05))
Interior2V.append((5.48,-66.97,2.15))
Interior2V.append((5.33,-66.92,3.34))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((6.74,-69.50,5.05))
Interior2V.append((5.33,-66.92,3.34))
Interior2V.append((7.07,-68.13,.70))
Interior2V.append((8.00,-66.43,4.26))
Interior2V.append((16.20,-56.02,14.14))
Interior2V.append((21.51,-55.45,12.29))
Interior2V.append((17.34,-51.93,16.60))
Interior2V.append((16.20,-56.02,14.14))
Interior2V.append((17.34,-51.93,16.60))
Interior2V.append((16.46,-57.98,15.62))
Interior2V.append((4.61,-60.94,-9.82))
Interior2V.append((2.52,-61.80,-12.84))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((2.52,-61.80,-12.84))
Interior2V.append((4.61,-60.94,-9.82))
Interior2V.append((.83,-60.99,-9.69))
Interior2V.append((2.52,-61.80,-12.84))
Interior2V.append((.55,-62.23,-12.25))
Interior2V.append((2.02,-64.31,-12.48))
Interior2V.append((2.52,-61.80,-12.84))
Interior2V.append((.83,-60.99,-9.69))
Interior2V.append((.55,-62.23,-12.25))
Interior2V.append((7.94,-55.56,-6.83))
Interior2V.append((8.78,-59.87,-9.14))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((7.94,-55.56,-6.83))
Interior2V.append((11.50,-58.59,-6.92))
Interior2V.append((10.16,-57.75,-5.58))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((13.44,-65.44,-.79))
Interior2V.append((14.48,-65.02,-2.60))
Interior2V.append((15.50,-67.57,-1.77))
Interior2V.append((14.48,-65.02,-2.60))
Interior2V.append((12.30,-67.06,-5.36))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((.16,-79.65,5.80))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((-.61,-72.58,-1.47))
Interior2V.append((3.80,-73.00,1.27))
Interior2V.append((3.38,-72.28,1.83))
Interior2V.append((5.69,-63.62,-15.08))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((4.66,-63.66,-14.38))
Interior2V.append((5.69,-63.62,-15.08))
Interior2V.append((4.66,-63.66,-14.38))
Interior2V.append((7.95,-64.71,-13.51))
Interior2V.append((5.69,-63.62,-15.08))
Interior2V.append((7.95,-64.71,-13.51))
Interior2V.append((6.54,-61.68,-11.43))
Interior2V.append((8.40,-63.76,-8.31))
Interior2V.append((6.73,-62.69,-9.29))
Interior2V.append((8.42,-65.52,-10.51))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((23.68,-61.97,10.61))
Interior2V.append((17.78,-61.92,12.76))
Interior2V.append((23.72,-63.57,10.96))
Interior2V.append((17.04,-60.54,18.87))
Interior2V.append((23.68,-61.97,10.61))
Interior2V.append((1.99,-63.94,12.75))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((1.49,-62.79,12.21))
Interior2V.append((1.99,-63.94,12.75))
Interior2V.append((-1.49,-66.12,14.12))
Interior2V.append((-2.09,-64.50,14.77))
Interior2V.append((-1.61,-62.36,10.83))
Interior2V.append((-.97,-61.56,12.28))
Interior2V.append((-4.86,-62.28,12.41))
Interior2V.append((-12.97,-58.06,15.92))
Interior2V.append((-10.54,-59.30,15.96))
Interior2V.append((-11.95,-57.43,18.19))

Interior2I = []
for x in range(0,1968):
    Interior2I.append((x*3, x*3+1, x*3+2))

Interior2V = array(tuple(Interior2V), floatc)
Interior2I = array(tuple(Interior2I), intc)
Interior2Piece = Interior2.addPiece(Interior2V, Interior2I, (1,0.27,0,.5))
Interior2Piece.display = True
Interior2Piece.displayStyle = Interior2Piece.Solid
chimera.openModels.add([Interior2])
Interior3 = _surface.SurfaceModel()
Interior3V = []
Interior3V.append((18.55,-29.82,-11.96))
Interior3V.append((19.32,-25.68,-14.38))
Interior3V.append((18.86,-28.79,-11.20))
Interior3V.append((18.55,-29.82,-11.96))
Interior3V.append((18.86,-28.79,-11.20))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((18.55,-29.82,-11.96))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((19.32,-25.68,-14.38))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((18.86,-28.79,-11.20))
Interior3V.append((19.32,-25.68,-14.38))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((18.86,-28.79,-11.20))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((19.32,-25.68,-14.38))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((19.32,-25.68,-14.38))
Interior3V.append((23.85,-31.04,-6.04))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((23.85,-31.04,-6.04))
Interior3V.append((24.78,-29.29,-4.51))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((24.78,-29.29,-4.51))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((19.82,-24.64,-6.40))
Interior3V.append((24.78,-29.29,-4.51))
Interior3V.append((23.85,-31.04,-6.04))
Interior3V.append((19.82,-24.64,-6.40))
Interior3V.append((23.85,-31.04,-6.04))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((17.71,-27.58,-9.92))
Interior3V.append((19.82,-24.64,-6.40))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((17.71,-27.58,-9.92))
Interior3V.append((19.90,-28.60,-10.92))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((19.82,-24.64,-6.40))
Interior3V.append((17.71,-27.58,-9.92))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((19.82,-24.64,-6.40))
Interior3V.append((12.47,-29.85,-5.35))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((14.67,-27.85,-6.43))
Interior3V.append((12.52,-29.92,-6.34))
Interior3V.append((12.47,-29.85,-5.35))
Interior3V.append((14.67,-27.85,-6.43))
Interior3V.append((9.85,-27.93,-3.32))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((9.85,-27.93,-3.32))
Interior3V.append((9.57,-28.34,-4.18))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((9.85,-27.93,-3.32))
Interior3V.append((12.47,-29.85,-5.35))
Interior3V.append((9.57,-28.34,-4.18))
Interior3V.append((9.85,-27.93,-3.32))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((12.47,-29.85,-5.35))
Interior3V.append((9.51,-29.34,-5.69))
Interior3V.append((9.57,-28.34,-4.18))
Interior3V.append((12.47,-29.85,-5.35))
Interior3V.append((9.51,-29.34,-5.69))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((9.57,-28.34,-4.18))
Interior3V.append((10.07,-29.57,-6.79))
Interior3V.append((9.51,-29.34,-5.69))
Interior3V.append((12.47,-29.85,-5.35))
Interior3V.append((10.07,-29.57,-6.79))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((9.51,-29.34,-5.69))
Interior3V.append((10.07,-29.57,-6.79))
Interior3V.append((12.47,-29.85,-5.35))
Interior3V.append((12.52,-29.92,-6.34))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((1.68,-21.39,-3.72))
Interior3V.append((.82,-22.94,-5.15))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((.82,-22.94,-5.15))
Interior3V.append((2.74,-21.71,-8.66))
Interior3V.append((2.59,-24.16,-6.62))
Interior3V.append((.82,-22.94,-5.15))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((2.59,-24.16,-6.62))
Interior3V.append((2.74,-21.71,-8.66))
Interior3V.append((.82,-22.94,-5.15))
Interior3V.append((-.02,-16.62,-11.68))
Interior3V.append((3.64,-17.12,-10.20))
Interior3V.append((3.98,-15.52,-8.86))
Interior3V.append((-.02,-16.62,-11.68))
Interior3V.append((-2.01,-17.40,-8.28))
Interior3V.append((3.64,-17.12,-10.20))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((15.09,-16.73,-2.14))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((6.84,-13.07,-8.10))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((6.84,-13.07,-8.10))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((6.84,-13.07,-8.10))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((8.39,-14.44,-.79))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((8.39,-14.44,-.79))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((8.39,-14.44,-.79))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((4.72,-13.38,-7.52))
Interior3V.append((5.20,-15.01,-6.70))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((4.72,-13.38,-7.52))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((5.97,-16.13,-11.14))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((6.93,-16.35,-8.65))
Interior3V.append((5.97,-16.13,-11.14))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((4.72,-13.38,-7.52))
Interior3V.append((3.98,-15.52,-8.86))
Interior3V.append((5.20,-15.01,-6.70))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((5.20,-15.01,-6.70))
Interior3V.append((3.98,-15.52,-8.86))
Interior3V.append((-1.96,-17.61,-4.12))
Interior3V.append((-.81,-17.01,-.52))
Interior3V.append((1.15,-18.53,-3.65))
Interior3V.append((-1.96,-17.61,-4.12))
Interior3V.append((1.15,-18.53,-3.65))
Interior3V.append((.26,-17.86,-5.70))
Interior3V.append((-.81,-17.01,-.52))
Interior3V.append((-2.32,-16.36,-6.11))
Interior3V.append((4.72,-13.38,-7.52))
Interior3V.append((-2.32,-16.36,-6.11))
Interior3V.append((-1.96,-17.61,-4.12))
Interior3V.append((.26,-17.86,-5.70))
Interior3V.append((-.81,-17.01,-.52))
Interior3V.append((4.72,-13.38,-7.52))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((-.81,-17.01,-.52))
Interior3V.append((-1.31,-16.91,3.75))
Interior3V.append((.95,-17.81,4.03))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((-1.31,-16.91,3.75))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((.95,-17.81,4.03))
Interior3V.append((-1.31,-16.91,3.75))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((.95,-17.81,4.03))
Interior3V.append((5.97,-15.45,-.52))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((.95,-17.81,4.03))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((5.97,-15.45,-.52))
Interior3V.append((5.45,-17.74,-.09))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((5.97,-15.45,-.52))
Interior3V.append((5.45,-17.74,-.09))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((5.45,-17.74,-.09))
Interior3V.append((5.97,-15.45,-.52))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((17.40,-22.63,-13.07))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((17.40,-22.63,-13.07))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((15.58,-25.22,-11.34))
Interior3V.append((17.40,-22.63,-13.07))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((15.58,-25.22,-11.34))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((17.40,-22.63,-13.07))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((15.58,-25.22,-11.34))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((17.58,-25.54,-6.14))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((19.95,-21.84,-8.36))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((19.95,-21.84,-8.36))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((17.58,-25.54,-6.14))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((17.58,-25.54,-6.14))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((17.71,-27.58,-9.92))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((15.58,-25.22,-11.34))
Interior3V.append((17.66,-25.03,-2.75))
Interior3V.append((17.58,-25.54,-6.14))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((17.66,-25.03,-2.75))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((17.58,-25.54,-6.14))
Interior3V.append((17.58,-25.54,-6.14))
Interior3V.append((14.67,-27.85,-6.43))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((13.34,-25.63,-8.31))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((13.34,-25.63,-8.31))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((13.34,-25.63,-8.31))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((13.34,-25.63,-8.31))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((13.34,-25.63,-8.31))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((8.78,-23.82,-8.47))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((8.40,-22.53,-8.30))
Interior3V.append((8.78,-23.82,-8.47))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((8.40,-22.53,-8.30))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((8.40,-22.53,-8.30))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((8.78,-23.82,-8.47))
Interior3V.append((8.40,-22.53,-8.30))
Interior3V.append((11.28,-28.71,-9.22))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((11.28,-28.71,-9.22))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((10.07,-29.57,-6.79))
Interior3V.append((11.28,-28.71,-9.22))
Interior3V.append((10.07,-29.57,-6.79))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((19.82,-24.64,-6.40))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((24.78,-29.29,-4.51))
Interior3V.append((20.00,-23.23,-8.05))
Interior3V.append((24.78,-29.29,-4.51))
Interior3V.append((19.82,-24.64,-6.40))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((18.81,-23.83,-11.75))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((18.81,-23.83,-11.75))
Interior3V.append((18.81,-23.83,-11.75))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((18.81,-23.83,-11.75))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((20.49,-24.84,-13.25))
Interior3V.append((18.81,-23.83,-11.75))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((18.81,-23.83,-11.75))
Interior3V.append((17.22,-20.63,-12.47))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((18.81,-23.83,-11.75))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((17.22,-20.63,-12.47))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((17.71,-27.58,-9.92))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((18.52,-25.71,-11.92))
Interior3V.append((20.23,-23.90,-8.87))
Interior3V.append((-2.48,-18.09,-2.00))
Interior3V.append((-2.32,-16.36,-6.11))
Interior3V.append((-.81,-17.01,-.52))
Interior3V.append((-2.48,-18.09,-2.00))
Interior3V.append((-.81,-17.01,-.52))
Interior3V.append((-1.96,-17.61,-4.12))
Interior3V.append((-2.48,-18.09,-2.00))
Interior3V.append((-1.96,-17.61,-4.12))
Interior3V.append((-2.32,-16.36,-6.11))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((1.15,-18.53,-3.65))
Interior3V.append((-.81,-17.01,-.52))
Interior3V.append((.75,-17.38,.74))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((1.15,-18.53,-3.65))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((10.07,-29.57,-6.79))
Interior3V.append((9.68,-25.59,-7.49))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((12.52,-29.92,-6.34))
Interior3V.append((14.67,-27.85,-6.43))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((10.07,-29.57,-6.79))
Interior3V.append((12.52,-29.92,-6.34))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((14.67,-27.85,-6.43))
Interior3V.append((17.58,-25.54,-6.14))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((14.67,-27.85,-6.43))
Interior3V.append((13.34,-25.63,-8.31))
Interior3V.append((13.64,-26.66,-8.12))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((13.34,-25.63,-8.31))
Interior3V.append((17.08,-27.01,-8.06))
Interior3V.append((15.58,-25.22,-11.34))
Interior3V.append((13.40,-24.96,-9.48))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((12.68,-21.71,-9.78))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((12.68,-21.71,-9.78))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((12.68,-21.71,-9.78))
Interior3V.append((8.94,-19.57,-10.64))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((8.94,-19.57,-10.64))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((10.00,-21.49,-10.26))
Interior3V.append((7.49,-20.97,-9.05))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((8.94,-19.57,-10.64))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((6.93,-16.35,-8.65))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((7.49,-20.97,-9.05))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((7.49,-20.97,-9.05))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((6.56,-17.76,-10.44))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((7.49,-20.97,-9.05))
Interior3V.append((6.56,-17.76,-10.44))
Interior3V.append((6.93,-16.35,-8.65))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((6.56,-17.76,-10.44))
Interior3V.append((7.49,-20.97,-9.05))
Interior3V.append((8.94,-19.57,-10.64))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((4.44,-19.03,-10.39))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((4.44,-19.03,-10.39))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((3.64,-17.12,-10.20))
Interior3V.append((4.44,-19.03,-10.39))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((3.64,-17.12,-10.20))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((4.44,-19.03,-10.39))
Interior3V.append((.91,-19.46,-3.93))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((1.15,-18.53,-3.65))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((.26,-17.86,-5.70))
Interior3V.append((1.15,-18.53,-3.65))
Interior3V.append((-2.01,-17.40,-8.28))
Interior3V.append((.26,-17.86,-5.70))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((3.98,-15.52,-8.86))
Interior3V.append((3.64,-17.12,-10.20))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((3.64,-17.12,-10.20))
Interior3V.append((-2.01,-17.40,-8.28))
Interior3V.append((-2.01,-17.40,-8.28))
Interior3V.append((-2.32,-16.36,-6.11))
Interior3V.append((.26,-17.86,-5.70))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((12.68,-21.71,-9.78))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((12.68,-21.71,-9.78))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((12.68,-21.71,-9.78))
Interior3V.append((19.95,-21.84,-8.36))
Interior3V.append((19.63,-20.87,-7.43))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((19.63,-20.87,-7.43))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((19.22,-21.26,-6.17))
Interior3V.append((19.63,-20.87,-7.43))
Interior3V.append((19.95,-21.84,-8.36))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((19.22,-21.26,-6.17))
Interior3V.append((19.95,-21.84,-8.36))
Interior3V.append((19.22,-21.26,-6.17))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((19.63,-20.87,-7.43))
Interior3V.append((18.71,-18.36,-2.74))
Interior3V.append((18.93,-20.63,-5.35))
Interior3V.append((18.22,-18.04,-4.37))
Interior3V.append((18.71,-18.36,-2.74))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((18.93,-20.63,-5.35))
Interior3V.append((18.71,-18.36,-2.74))
Interior3V.append((18.22,-18.04,-4.37))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((18.22,-18.04,-4.37))
Interior3V.append((18.93,-20.63,-5.35))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((18.22,-18.04,-4.37))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((18.22,-18.04,-4.37))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((18.93,-20.63,-5.35))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((18.93,-20.63,-5.35))
Interior3V.append((17.08,-21.58,-3.89))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((17.08,-21.58,-3.89))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((17.08,-21.58,-3.89))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((12.95,-24.84,-7.32))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((10.43,-24.07,-4.17))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((12.21,-23.63,-2.65))
Interior3V.append((12.57,-20.52,-1.28))
Interior3V.append((12.21,-23.63,-2.65))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((12.57,-20.52,-1.28))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((12.21,-23.63,-2.65))
Interior3V.append((12.57,-20.52,-1.28))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((14.95,-20.76,-1.59))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((14.95,-20.76,-1.59))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((14.95,-20.76,-1.59))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((14.95,-20.76,-1.59))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((5.76,-22.47,-7.30))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((5.76,-22.47,-7.30))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((8.60,-21.93,-7.00))
Interior3V.append((5.76,-22.47,-7.30))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((2.59,-24.16,-6.62))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((5.76,-22.47,-7.30))
Interior3V.append((2.59,-24.16,-6.62))
Interior3V.append((5.76,-22.47,-7.30))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((1.68,-21.39,-3.72))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((.91,-19.46,-3.93))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((1.68,-21.39,-3.72))
Interior3V.append((7.77,-21.13,-.73))
Interior3V.append((8.01,-23.47,-1.73))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((7.77,-21.13,-.73))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((10.04,-20.88,-3.69))
Interior3V.append((7.77,-21.13,-.73))
Interior3V.append((10.04,-20.88,-3.69))
Interior3V.append((8.01,-23.47,-1.73))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((8.01,-23.47,-1.73))
Interior3V.append((10.04,-20.88,-3.69))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((10.04,-20.88,-3.69))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((10.04,-20.88,-3.69))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((8.01,-23.47,-1.73))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((5.19,-22.04,-.37))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((8.01,-23.47,-1.73))
Interior3V.append((3.43,-24.19,-4.79))
Interior3V.append((.36,-24.96,-2.39))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((3.43,-24.19,-4.79))
Interior3V.append((.96,-23.90,-5.40))
Interior3V.append((.36,-24.96,-2.39))
Interior3V.append((3.43,-24.19,-4.79))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((.96,-23.90,-5.40))
Interior3V.append((.82,-22.94,-5.15))
Interior3V.append((.36,-24.96,-2.39))
Interior3V.append((.96,-23.90,-5.40))
Interior3V.append((.82,-22.94,-5.15))
Interior3V.append((.96,-23.90,-5.40))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((1.68,-21.39,-3.72))
Interior3V.append((.36,-24.96,-2.39))
Interior3V.append((.82,-22.94,-5.15))
Interior3V.append((2.78,-22.74,-1.35))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((.36,-24.96,-2.39))
Interior3V.append((2.78,-22.74,-1.35))
Interior3V.append((.36,-24.96,-2.39))
Interior3V.append((1.68,-21.39,-3.72))
Interior3V.append((2.78,-22.74,-1.35))
Interior3V.append((1.68,-21.39,-3.72))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((3.43,-24.19,-4.79))
Interior3V.append((5.76,-22.47,-7.30))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((3.43,-24.19,-4.79))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((3.43,-24.19,-4.79))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((5.76,-22.47,-7.30))
Interior3V.append((9.58,-23.94,-6.16))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((10.43,-24.07,-4.17))
Interior3V.append((10.43,-24.07,-4.17))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((10.43,-24.07,-4.17))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((6.90,-17.34,-2.38))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((6.90,-17.34,-2.38))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((5.20,-15.01,-6.70))
Interior3V.append((5.33,-17.23,-8.31))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((5.20,-15.01,-6.70))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((6.90,-17.34,-2.38))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((6.90,-17.34,-2.38))
Interior3V.append((5.97,-15.45,-.52))
Interior3V.append((6.90,-17.34,-2.38))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((5.97,-15.45,-.52))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((6.90,-17.34,-2.38))
Interior3V.append((6.16,-14.57,-.18))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((5.97,-15.45,-.52))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((5.20,-15.01,-6.70))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((15.09,-16.73,-2.14))
Interior3V.append((7.88,-15.05,-2.49))
Interior3V.append((15.09,-16.73,-2.14))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((15.83,-18.79,-2.24))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((15.83,-18.79,-2.24))
Interior3V.append((15.09,-16.73,-2.14))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((15.83,-18.79,-2.24))
Interior3V.append((15.09,-16.73,-2.14))
Interior3V.append((15.83,-18.79,-2.24))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((16.27,-19.25,-4.14))
Interior3V.append((15.09,-16.73,-2.14))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((11.73,-20.23,-3.54))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((4.44,-24.24,-2.14))
Interior3V.append((5.19,-22.04,-.37))
Interior3V.append((8.01,-23.47,-1.73))
Interior3V.append((4.44,-24.24,-2.14))
Interior3V.append((8.01,-23.47,-1.73))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((4.44,-24.24,-2.14))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((5.19,-22.04,-.37))
Interior3V.append((4.44,-24.24,-2.14))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((6.01,-20.18,-2.09))
Interior3V.append((4.44,-24.24,-2.14))
Interior3V.append((5.84,-23.86,-4.11))
Interior3V.append((3.53,-23.09,-4.24))
Interior3V.append((.91,-19.46,-3.93))
Interior3V.append((1.15,-18.53,-3.65))
Interior3V.append((2.96,-18.88,-2.62))
Interior3V.append((12.21,-23.63,-2.65))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((12.48,-25.05,-1.57))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((12.21,-23.63,-2.65))
Interior3V.append((12.48,-25.05,-1.57))
Interior3V.append((12.21,-23.63,-2.65))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((12.48,-25.05,-1.57))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((14.07,-23.82,-1.60))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((14.07,-23.82,-1.60))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((17.66,-25.03,-2.75))
Interior3V.append((14.07,-23.82,-1.60))
Interior3V.append((17.66,-25.03,-2.75))
Interior3V.append((14.29,-27.10,-4.35))
Interior3V.append((14.51,-23.32,-2.34))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((17.66,-25.03,-2.75))
Interior3V.append((10.43,-24.07,-4.17))
Interior3V.append((12.21,-23.63,-2.65))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((10.19,-24.68,-5.07))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((10.19,-24.68,-5.07))
Interior3V.append((10.43,-24.07,-4.17))
Interior3V.append((11.08,-25.24,-5.43))
Interior3V.append((10.19,-24.68,-5.07))
Interior3V.append((9.58,-23.94,-6.16))
Interior3V.append((10.43,-24.07,-4.17))
Interior3V.append((10.19,-24.68,-5.07))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((9.58,-23.94,-6.16))
Interior3V.append((9.36,-24.56,-7.39))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((9.58,-23.94,-6.16))
Interior3V.append((9.36,-24.56,-7.39))
Interior3V.append((9.58,-23.94,-6.16))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((9.36,-24.56,-7.39))
Interior3V.append((8.78,-23.82,-8.47))
Interior3V.append((9.29,-22.57,-5.98))
Interior3V.append((9.36,-24.56,-7.39))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((8.78,-23.82,-8.47))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((16.65,-16.53,-3.89))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((17.22,-20.63,-12.47))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((17.22,-20.63,-12.47))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((16.24,-20.67,-12.27))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((19.95,-21.84,-8.36))
Interior3V.append((19.41,-19.83,-7.61))
Interior3V.append((20.20,-21.66,-9.39))
Interior3V.append((18.37,-23.97,-10.91))
Interior3V.append((19.95,-21.84,-8.36))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((8.76,-17.26,-3.77))
Interior3V.append((6.93,-16.35,-8.65))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((2.74,-21.71,-8.66))
Interior3V.append((1.68,-21.39,-3.72))
Interior3V.append((.92,-19.70,-7.91))
Interior3V.append((.91,-19.46,-3.93))
Interior3V.append((4.42,-21.01,-8.45))
Interior3V.append((2.74,-21.71,-8.66))
Interior3V.append((2.59,-24.16,-6.62))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((6.56,-17.76,-10.44))
Interior3V.append((8.94,-19.57,-10.64))
Interior3V.append((6.56,-17.76,-10.44))
Interior3V.append((5.97,-16.13,-11.14))
Interior3V.append((6.93,-16.35,-8.65))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((8.94,-19.57,-10.64))
Interior3V.append((10.31,-19.06,-5.31))
Interior3V.append((7.19,-17.53,-14.88))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((5.97,-16.13,-11.14))
Interior3V.append((7.19,-17.53,-14.88))
Interior3V.append((5.97,-16.13,-11.14))
Interior3V.append((6.56,-17.76,-10.44))
Interior3V.append((7.19,-17.53,-14.88))
Interior3V.append((6.56,-17.76,-10.44))
Interior3V.append((9.72,-19.44,-12.34))
Interior3V.append((7.44,-14.58,-7.82))
Interior3V.append((6.80,-13.74,-6.51))
Interior3V.append((11.00,-18.06,-4.08))
Interior3V.append((8.14,-18.91,-3.86))
Interior3V.append((8.27,-20.92,-6.79))
Interior3V.append((9.38,-22.01,-5.06))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((12.52,-22.64,-7.32))
Interior3V.append((12.70,-23.53,-7.91))
Interior3V.append((12.95,-23.67,-9.24))
Interior3V.append((13.87,-22.65,-10.92))
Interior3V.append((16.44,-21.29,-4.60))
Interior3V.append((19.22,-21.26,-6.17))
Interior3V.append((16.96,-23.37,-4.67))
Interior3V.append((-.02,-16.62,-11.68))
Interior3V.append((4.72,-13.38,-7.52))
Interior3V.append((-2.32,-16.36,-6.11))
Interior3V.append((-.02,-16.62,-11.68))
Interior3V.append((3.98,-15.52,-8.86))
Interior3V.append((4.72,-13.38,-7.52))
Interior3V.append((-2.32,-16.36,-6.11))
Interior3V.append((-2.01,-17.40,-8.28))
Interior3V.append((-.02,-16.62,-11.68))

Interior3I = []
for x in range(0,292):
    Interior3I.append((x*3, x*3+1, x*3+2))

Interior3V = array(tuple(Interior3V), floatc)
Interior3I = array(tuple(Interior3I), intc)
Interior3Piece = Interior3.addPiece(Interior3V, Interior3I, (1,0.5,0,.5))
Interior3Piece.display = True
Interior3Piece.displayStyle = Interior3Piece.Solid
chimera.openModels.add([Interior3])
Interior4 = _surface.SurfaceModel()
Interior4V = []
Interior4V.append((-16.27,-46.30,15.18))
Interior4V.append((-14.23,-46.60,16.86))
Interior4V.append((-17.64,-46.56,16.20))
Interior4V.append((-16.27,-46.30,15.18))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-14.23,-46.60,16.86))
Interior4V.append((-15.89,-46.88,18.98))
Interior4V.append((-17.64,-46.56,16.20))
Interior4V.append((-14.23,-46.60,16.86))
Interior4V.append((-17.22,-49.92,15.60))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-16.27,-46.30,15.18))
Interior4V.append((-18.43,-47.12,14.23))
Interior4V.append((-17.22,-49.92,15.60))
Interior4V.append((-16.27,-46.30,15.18))
Interior4V.append((-18.43,-47.12,14.23))
Interior4V.append((-17.64,-46.56,16.20))
Interior4V.append((-17.22,-49.92,15.60))
Interior4V.append((-18.43,-47.12,14.23))
Interior4V.append((-16.27,-46.30,15.18))
Interior4V.append((-17.64,-46.56,16.20))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-17.22,-49.92,15.60))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-17.22,-49.92,15.60))
Interior4V.append((-17.64,-46.56,16.20))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-17.64,-46.56,16.20))
Interior4V.append((-15.89,-46.88,18.98))
Interior4V.append((-29.46,-52.63,13.35))
Interior4V.append((-29.23,-55.40,8.10))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-29.46,-52.63,13.35))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-29.23,-55.40,8.10))
Interior4V.append((-26.48,-54.41,9.02))
Interior4V.append((-29.23,-55.40,8.10))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-26.48,-54.41,9.02))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-29.23,-55.40,8.10))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-23.61,-56.17,11.29))
Interior4V.append((-23.30,-54.19,11.17))
Interior4V.append((-21.89,-55.25,13.11))
Interior4V.append((-23.30,-54.19,11.17))
Interior4V.append((-23.61,-56.17,11.29))
Interior4V.append((-21.89,-55.25,13.11))
Interior4V.append((-23.61,-56.17,11.29))
Interior4V.append((-24.19,-57.41,14.09))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-24.19,-57.41,14.09))
Interior4V.append((-23.61,-56.17,11.29))
Interior4V.append((-26.75,-51.63,14.64))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-23.30,-54.19,11.17))
Interior4V.append((-26.75,-51.63,14.64))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-24.83,-56.21,17.71))
Interior4V.append((-24.19,-57.41,14.09))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-24.19,-57.41,14.09))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-27.94,-52.62,16.24))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-27.94,-52.62,16.24))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-27.20,-56.53,17.42))
Interior4V.append((-27.94,-52.62,16.24))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-26.35,-54.36,17.78))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-26.35,-54.36,17.78))
Interior4V.append((-24.83,-56.21,17.71))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-26.35,-54.36,17.78))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-24.83,-56.21,17.71))
Interior4V.append((-14.61,-55.08,18.74))
Interior4V.append((-15.98,-55.52,16.66))
Interior4V.append((-16.42,-55.34,19.41))
Interior4V.append((-14.61,-55.08,18.74))
Interior4V.append((-16.42,-55.34,19.41))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-14.24,-55.19,17.82))
Interior4V.append((-14.61,-55.08,18.74))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-14.24,-55.19,17.82))
Interior4V.append((-15.98,-55.52,16.66))
Interior4V.append((-14.61,-55.08,18.74))
Interior4V.append((-13.91,-52.50,16.99))
Interior4V.append((-14.24,-55.19,17.82))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-13.91,-52.50,16.99))
Interior4V.append((-15.98,-55.52,16.66))
Interior4V.append((-14.24,-55.19,17.82))
Interior4V.append((-13.91,-52.50,16.99))
Interior4V.append((-17.41,-51.53,16.45))
Interior4V.append((-15.84,-53.26,14.76))
Interior4V.append((-13.91,-52.50,16.99))
Interior4V.append((-15.84,-53.26,14.76))
Interior4V.append((-15.98,-55.52,16.66))
Interior4V.append((-17.52,-53.98,14.69))
Interior4V.append((-15.98,-55.52,16.66))
Interior4V.append((-15.84,-53.26,14.76))
Interior4V.append((-17.52,-53.98,14.69))
Interior4V.append((-15.84,-53.26,14.76))
Interior4V.append((-17.41,-51.53,16.45))
Interior4V.append((-13.91,-52.50,16.99))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-17.41,-51.53,16.45))
Interior4V.append((-15.86,-51.09,15.72))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-15.86,-51.09,15.72))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-15.86,-51.09,15.72))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-17.41,-51.53,16.45))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-17.37,-51.44,20.65))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-17.37,-51.44,20.65))
Interior4V.append((-16.57,-53.05,21.61))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-17.37,-51.44,20.65))
Interior4V.append((-16.57,-53.05,21.61))
Interior4V.append((-16.42,-55.34,19.41))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-16.57,-53.05,21.61))
Interior4V.append((-17.37,-51.44,20.65))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-16.57,-53.05,21.61))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-16.42,-55.34,19.41))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-12.15,-50.65,26.80))
Interior4V.append((-12.86,-52.47,24.83))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-12.86,-52.47,24.83))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-17.01,-51.97,27.04))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-12.15,-50.65,26.80))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-16.55,-51.92,28.13))
Interior4V.append((-17.01,-51.97,27.04))
Interior4V.append((-16.90,-49.48,27.25))
Interior4V.append((-16.55,-51.92,28.13))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-17.01,-51.97,27.04))
Interior4V.append((-16.52,-50.77,28.81))
Interior4V.append((-16.90,-49.48,27.25))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-16.52,-50.77,28.81))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-16.55,-51.92,28.13))
Interior4V.append((-16.52,-50.77,28.81))
Interior4V.append((-16.55,-51.92,28.13))
Interior4V.append((-16.90,-49.48,27.25))
Interior4V.append((-14.11,-51.68,29.13))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-14.11,-51.68,29.13))
Interior4V.append((-16.52,-50.77,28.81))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-14.11,-51.68,29.13))
Interior4V.append((-14.10,-52.61,27.59))
Interior4V.append((-16.52,-50.77,28.81))
Interior4V.append((-18.62,-50.68,25.25))
Interior4V.append((-17.01,-51.97,27.04))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-18.62,-50.68,25.25))
Interior4V.append((-16.90,-49.48,27.25))
Interior4V.append((-17.01,-51.97,27.04))
Interior4V.append((-17.70,-51.07,23.58))
Interior4V.append((-18.62,-50.68,25.25))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-18.62,-50.68,25.25))
Interior4V.append((-17.70,-51.07,23.58))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-17.70,-51.07,23.58))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-16.90,-49.48,27.25))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-12.15,-50.65,26.80))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-12.12,-49.07,18.86))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-10.85,-47.45,20.92))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-10.85,-47.45,20.92))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-10.85,-47.45,20.92))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-12.08,-46.20,17.82))
Interior4V.append((-10.85,-47.45,20.92))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-15.39,-44.93,22.06))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-15.39,-44.93,22.06))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-15.39,-44.93,22.06))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-15.89,-46.88,18.98))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-15.89,-46.88,18.98))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-15.07,-51.32,22.10))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-15.07,-51.32,22.10))
Interior4V.append((-17.37,-51.44,20.65))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-15.07,-51.32,22.10))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-17.37,-51.44,20.65))
Interior4V.append((-15.07,-51.32,22.10))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-14.74,-51.78,18.29))
Interior4V.append((-18.74,-50.65,21.52))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-18.74,-48.14,19.43))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-18.74,-48.14,19.43))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-20.32,-46.75,21.94))
Interior4V.append((-18.74,-48.14,19.43))
Interior4V.append((-20.77,-48.44,20.17))
Interior4V.append((-18.74,-50.65,21.52))
Interior4V.append((-18.74,-48.14,19.43))
Interior4V.append((-20.77,-48.44,20.17))
Interior4V.append((-18.74,-48.14,19.43))
Interior4V.append((-20.32,-46.75,21.94))
Interior4V.append((-20.60,-50.37,23.12))
Interior4V.append((-18.74,-50.65,21.52))
Interior4V.append((-20.77,-48.44,20.17))
Interior4V.append((-20.60,-50.37,23.12))
Interior4V.append((-20.77,-48.44,20.17))
Interior4V.append((-20.32,-46.75,21.94))
Interior4V.append((-24.82,-50.14,13.86))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-23.63,-51.53,12.61))
Interior4V.append((-24.82,-50.14,13.86))
Interior4V.append((-23.40,-50.40,14.99))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-24.82,-50.14,13.86))
Interior4V.append((-23.63,-51.53,12.61))
Interior4V.append((-23.40,-50.40,14.99))
Interior4V.append((-21.05,-51.21,13.34))
Interior4V.append((-23.40,-50.40,14.99))
Interior4V.append((-23.63,-51.53,12.61))
Interior4V.append((-21.41,-50.73,17.25))
Interior4V.append((-23.40,-50.40,14.99))
Interior4V.append((-21.05,-51.21,13.34))
Interior4V.append((-21.89,-55.25,13.11))
Interior4V.append((-21.05,-51.21,13.34))
Interior4V.append((-23.63,-51.53,12.61))
Interior4V.append((-23.63,-51.53,12.61))
Interior4V.append((-23.30,-54.19,11.17))
Interior4V.append((-21.89,-55.25,13.11))
Interior4V.append((-19.73,-54.23,13.62))
Interior4V.append((-21.05,-51.21,13.34))
Interior4V.append((-21.89,-55.25,13.11))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-19.73,-54.23,13.62))
Interior4V.append((-21.89,-55.25,13.11))
Interior4V.append((-19.32,-52.03,14.78))
Interior4V.append((-21.05,-51.21,13.34))
Interior4V.append((-19.73,-54.23,13.62))
Interior4V.append((-19.32,-52.03,14.78))
Interior4V.append((-19.73,-54.23,13.62))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-19.32,-52.03,14.78))
Interior4V.append((-21.41,-50.73,17.25))
Interior4V.append((-21.05,-51.21,13.34))
Interior4V.append((-19.72,-50.87,16.71))
Interior4V.append((-21.41,-50.73,17.25))
Interior4V.append((-19.32,-52.03,14.78))
Interior4V.append((-17.59,-56.12,17.04))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-20.01,-55.63,18.59))
Interior4V.append((-17.59,-56.12,17.04))
Interior4V.append((-17.52,-53.98,14.69))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-15.06,-51.47,23.84))
Interior4V.append((-12.86,-52.47,24.83))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-12.86,-52.47,24.83))
Interior4V.append((-12.15,-50.65,26.80))
Interior4V.append((-7.82,-48.05,25.15))
Interior4V.append((-10.51,-49.32,23.58))
Interior4V.append((-10.16,-48.10,28.08))
Interior4V.append((-8.64,-45.23,24.86))
Interior4V.append((-7.82,-48.05,25.15))
Interior4V.append((-10.16,-48.10,28.08))
Interior4V.append((-10.10,-47.63,22.58))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-10.51,-49.32,23.58))
Interior4V.append((-10.10,-47.63,22.58))
Interior4V.append((-10.51,-49.32,23.58))
Interior4V.append((-7.82,-48.05,25.15))
Interior4V.append((-10.10,-47.63,22.58))
Interior4V.append((-8.64,-45.23,24.86))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-10.10,-47.63,22.58))
Interior4V.append((-7.82,-48.05,25.15))
Interior4V.append((-8.64,-45.23,24.86))
Interior4V.append((-27.33,-60.35,17.37))
Interior4V.append((-25.64,-60.39,15.63))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-27.33,-60.35,17.37))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-25.64,-60.39,15.63))
Interior4V.append((-27.33,-60.35,17.37))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-25.64,-60.39,15.63))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-25.64,-60.39,15.63))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-27.20,-56.53,17.42))
Interior4V.append((-25.67,-57.64,15.18))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-29.23,-55.40,8.10))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-27.94,-52.62,16.24))
Interior4V.append((-27.20,-56.53,17.42))
Interior4V.append((-27.94,-52.62,16.24))
Interior4V.append((-29.46,-52.63,13.35))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-27.94,-52.62,16.24))
Interior4V.append((-28.77,-57.35,17.19))
Interior4V.append((-29.46,-52.63,13.35))
Interior4V.append((-24.02,-52.45,17.67))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-23.46,-55.04,19.14))
Interior4V.append((-24.02,-52.45,17.67))
Interior4V.append((-23.46,-55.04,19.14))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-24.53,-55.17,18.35))
Interior4V.append((-23.46,-55.04,19.14))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-24.53,-55.17,18.35))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-23.46,-55.04,19.14))
Interior4V.append((-24.02,-52.45,17.67))
Interior4V.append((-21.41,-50.73,17.25))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-24.02,-52.45,17.67))
Interior4V.append((-23.40,-50.40,14.99))
Interior4V.append((-21.41,-50.73,17.25))
Interior4V.append((-24.02,-52.45,17.67))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-23.40,-50.40,14.99))
Interior4V.append((-10.31,-44.48,25.96))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-11.91,-43.67,26.31))
Interior4V.append((-10.31,-44.48,25.96))
Interior4V.append((-11.91,-43.67,26.31))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-12.86,-45.47,28.03))
Interior4V.append((-12.47,-47.46,27.73))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-12.86,-45.47,28.03))
Interior4V.append((-10.31,-44.48,25.96))
Interior4V.append((-12.47,-47.46,27.73))
Interior4V.append((-12.86,-45.47,28.03))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-10.31,-44.48,25.96))
Interior4V.append((-11.15,-47.11,28.15))
Interior4V.append((-12.47,-47.46,27.73))
Interior4V.append((-10.31,-44.48,25.96))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-12.47,-47.46,27.73))
Interior4V.append((-11.15,-47.11,28.15))
Interior4V.append((-8.64,-45.23,24.86))
Interior4V.append((-10.31,-44.48,25.96))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-8.64,-45.23,24.86))
Interior4V.append((-11.15,-47.11,28.15))
Interior4V.append((-10.31,-44.48,25.96))
Interior4V.append((-8.64,-45.23,24.86))
Interior4V.append((-10.16,-48.10,28.08))
Interior4V.append((-11.15,-47.11,28.15))
Interior4V.append((-12.92,-43.55,23.45))
Interior4V.append((-11.91,-43.67,26.31))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-12.92,-43.55,23.45))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-11.91,-43.67,26.31))
Interior4V.append((-12.92,-43.55,23.45))
Interior4V.append((-15.39,-44.93,22.06))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-12.92,-43.55,23.45))
Interior4V.append((-15.10,-42.72,23.82))
Interior4V.append((-15.39,-44.93,22.06))
Interior4V.append((-12.92,-43.55,23.45))
Interior4V.append((-14.19,-43.59,26.20))
Interior4V.append((-15.10,-42.72,23.82))
Interior4V.append((-15.95,-42.89,24.31))
Interior4V.append((-15.39,-44.93,22.06))
Interior4V.append((-15.10,-42.72,23.82))
Interior4V.append((-15.95,-42.89,24.31))
Interior4V.append((-15.10,-42.72,23.82))
Interior4V.append((-14.19,-43.59,26.20))
Interior4V.append((-14.19,-43.59,26.20))
Interior4V.append((-12.92,-43.55,23.45))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-15.95,-42.89,24.31))
Interior4V.append((-14.19,-43.59,26.20))
Interior4V.append((-15.95,-42.89,24.31))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-15.39,-44.93,22.06))
Interior4V.append((-15.95,-42.89,24.31))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-16.51,-43.29,26.25))
Interior4V.append((-16.02,-47.20,27.31))
Interior4V.append((-16.51,-43.29,26.25))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-16.02,-47.20,27.31))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-16.02,-47.20,27.31))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-16.51,-43.29,26.25))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-19.32,-52.03,14.78))
Interior4V.append((-17.41,-51.53,16.45))
Interior4V.append((-19.72,-50.87,16.71))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-16.90,-49.48,27.25))
Interior4V.append((-18.62,-50.68,25.25))
Interior4V.append((-18.38,-46.64,25.83))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-18.38,-46.64,25.83))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-18.38,-46.64,25.83))
Interior4V.append((-16.51,-43.29,26.25))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-19.02,-45.20,23.65))
Interior4V.append((-18.38,-46.64,25.83))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-19.02,-45.20,23.65))
Interior4V.append((-16.51,-43.29,26.25))
Interior4V.append((-18.38,-46.64,25.83))
Interior4V.append((-17.09,-43.01,23.47))
Interior4V.append((-19.02,-45.20,23.65))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-17.09,-43.01,23.47))
Interior4V.append((-16.51,-43.29,26.25))
Interior4V.append((-19.02,-45.20,23.65))
Interior4V.append((-17.09,-43.01,23.47))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-15.95,-42.89,24.31))
Interior4V.append((-17.09,-43.01,23.47))
Interior4V.append((-15.95,-42.89,24.31))
Interior4V.append((-16.51,-43.29,26.25))
Interior4V.append((-14.40,-45.58,18.34))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-14.40,-45.58,18.34))
Interior4V.append((-12.08,-46.20,17.82))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-14.23,-46.60,16.86))
Interior4V.append((-12.08,-46.20,17.82))
Interior4V.append((-14.40,-45.58,18.34))
Interior4V.append((-14.23,-46.60,16.86))
Interior4V.append((-12.12,-49.07,18.86))
Interior4V.append((-12.08,-46.20,17.82))
Interior4V.append((-15.89,-46.88,18.98))
Interior4V.append((-14.40,-45.58,18.34))
Interior4V.append((-15.33,-46.98,20.73))
Interior4V.append((-12.08,-46.20,17.82))
Interior4V.append((-12.12,-49.07,18.86))
Interior4V.append((-10.85,-47.45,20.92))
Interior4V.append((-15.89,-46.88,18.98))
Interior4V.append((-14.23,-46.60,16.86))
Interior4V.append((-14.40,-45.58,18.34))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-13.45,-49.77,19.73))
Interior4V.append((-12.12,-49.07,18.86))
Interior4V.append((-14.21,-49.53,16.85))
Interior4V.append((-12.12,-49.07,18.86))
Interior4V.append((-14.23,-46.60,16.86))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-13.01,-45.40,21.77))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-12.92,-43.55,23.45))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-12.47,-48.01,22.68))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-12.78,-48.71,27.32))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-12.47,-47.46,27.73))
Interior4V.append((-12.78,-48.71,27.32))
Interior4V.append((-12.47,-47.46,27.73))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-12.78,-48.71,27.32))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-13.85,-46.26,26.67))
Interior4V.append((-12.78,-48.71,27.32))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-13.71,-48.83,26.79))
Interior4V.append((-19.72,-50.87,16.71))
Interior4V.append((-17.41,-51.53,16.45))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-19.72,-50.87,16.71))
Interior4V.append((-17.93,-49.50,18.45))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-21.41,-50.73,17.25))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-21.41,-50.73,17.25))
Interior4V.append((-19.72,-50.87,16.71))
Interior4V.append((-20.01,-55.63,18.59))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-20.01,-55.63,18.59))
Interior4V.append((-19.32,-52.03,14.78))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-17.52,-53.98,14.69))
Interior4V.append((-22.31,-56.56,18.60))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-22.31,-56.56,18.60))
Interior4V.append((-24.53,-55.17,18.35))
Interior4V.append((-21.23,-54.21,18.83))
Interior4V.append((-24.53,-55.17,18.35))
Interior4V.append((-22.31,-56.56,18.60))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-24.83,-56.21,17.71))
Interior4V.append((-24.53,-55.17,18.35))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-24.83,-56.21,17.71))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-24.53,-55.17,18.35))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-24.19,-57.41,14.09))
Interior4V.append((-24.83,-56.21,17.71))
Interior4V.append((-20.97,-56.29,15.23))
Interior4V.append((-21.89,-55.25,13.11))
Interior4V.append((-24.19,-57.41,14.09))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-17.59,-56.12,17.04))
Interior4V.append((-20.01,-55.63,18.59))
Interior4V.append((-17.52,-53.98,14.69))
Interior4V.append((-17.41,-51.53,16.45))
Interior4V.append((-19.32,-52.03,14.78))
Interior4V.append((-17.59,-56.12,17.04))
Interior4V.append((-15.98,-55.52,16.66))
Interior4V.append((-17.52,-53.98,14.69))
Interior4V.append((-16.42,-55.34,19.41))
Interior4V.append((-15.98,-55.52,16.66))
Interior4V.append((-17.59,-56.12,17.04))
Interior4V.append((-16.42,-55.34,19.41))
Interior4V.append((-17.59,-56.12,17.04))
Interior4V.append((-19.08,-53.30,19.28))
Interior4V.append((-17.70,-51.07,23.58))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-17.70,-51.07,23.58))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-17.70,-51.07,23.58))
Interior4V.append((-18.74,-50.65,21.52))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-17.70,-51.07,23.58))
Interior4V.append((-17.16,-49.73,21.32))
Interior4V.append((-18.74,-50.65,21.52))
Interior4V.append((-18.62,-50.68,25.25))
Interior4V.append((-15.53,-49.88,23.23))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-18.62,-50.68,25.25))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-17.28,-47.25,26.01))
Interior4V.append((-20.60,-50.37,23.12))
Interior4V.append((-20.32,-46.75,21.94))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-20.60,-50.37,23.12))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-18.74,-50.65,21.52))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-16.94,-45.52,22.44))
Interior4V.append((-18.83,-47.78,24.12))
Interior4V.append((-20.32,-46.75,21.94))
Interior4V.append((-16.91,-47.51,20.42))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-10.16,-48.10,28.08))
Interior4V.append((-10.51,-49.32,23.58))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-11.15,-47.11,28.15))
Interior4V.append((-10.16,-48.10,28.08))
Interior4V.append((-11.60,-49.45,23.46))
Interior4V.append((-10.51,-49.32,23.58))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-11.60,-49.45,23.46))
Interior4V.append((-11.11,-45.76,23.47))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-11.60,-49.45,23.46))
Interior4V.append((-12.02,-49.66,24.46))
Interior4V.append((-10.51,-49.32,23.58))
Interior4V.append((-23.61,-56.17,11.29))
Interior4V.append((-26.48,-54.41,9.02))
Interior4V.append((-25.23,-58.77,13.89))
Interior4V.append((-23.61,-56.17,11.29))
Interior4V.append((-28.13,-53.31,12.57))
Interior4V.append((-26.48,-54.41,9.02))
Interior4V.append((-23.63,-51.53,12.61))
Interior4V.append((-26.75,-51.63,14.64))
Interior4V.append((-23.30,-54.19,11.17))
Interior4V.append((-23.63,-51.53,12.61))
Interior4V.append((-24.69,-53.44,16.18))
Interior4V.append((-26.75,-51.63,14.64))

Interior4I = []
for x in range(0,234):
    Interior4I.append((x*3, x*3+1, x*3+2))

Interior4V = array(tuple(Interior4V), floatc)
Interior4I = array(tuple(Interior4I), intc)
Interior4Piece = Interior4.addPiece(Interior4V, Interior4I, (1,1,0,.5))
Interior4Piece.display = True
Interior4Piece.displayStyle = Interior4Piece.Solid
chimera.openModels.add([Interior4])
Interior5 = _surface.SurfaceModel()
Interior5V = []
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-8.00,-25.09,-.61))
Interior5V.append((-6.61,-27.63,-3.17))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-6.61,-27.63,-3.17))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-8.24,-24.75,-4.10))
Interior5V.append((-6.61,-27.63,-3.17))
Interior5V.append((-8.00,-25.09,-.61))
Interior5V.append((-8.24,-24.75,-4.10))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-6.61,-27.63,-3.17))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-8.24,-24.75,-4.10))
Interior5V.append((-8.00,-25.09,-.61))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-9.74,-26.02,.06))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-8.00,-25.09,-.61))
Interior5V.append((-8.47,-25.59,.11))
Interior5V.append((-9.74,-26.02,.06))
Interior5V.append((-8.00,-25.09,-.61))
Interior5V.append((-8.47,-25.59,.11))
Interior5V.append((-8.00,-25.09,-.61))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-9.74,-26.02,.06))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-9.74,-26.02,.06))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-9.74,-26.02,.06))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-9.74,-26.02,.06))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-9.74,-26.02,.06))
Interior5V.append((-8.47,-25.59,.11))
Interior5V.append((-8.85,-26.96,1.78))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-8.85,-26.96,1.78))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-8.47,-25.59,.11))
Interior5V.append((-10.97,-33.22,-.06))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-12.17,-34.60,-2.12))
Interior5V.append((-10.97,-33.22,-.06))
Interior5V.append((-12.17,-34.60,-2.12))
Interior5V.append((-13.58,-33.97,.18))
Interior5V.append((-10.97,-33.22,-.06))
Interior5V.append((-13.58,-33.97,.18))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-13.58,-33.97,.18))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-13.58,-33.97,.18))
Interior5V.append((-12.17,-34.60,-2.12))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-12.91,-34.77,-3.77))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-19.30,-39.27,-2.89))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-21.17,-39.51,-4.53))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-18.37,-31.99,-.47))
Interior5V.append((-21.17,-39.51,-4.53))
Interior5V.append((-18.37,-31.99,-.47))
Interior5V.append((-19.30,-39.27,-2.89))
Interior5V.append((-20.12,-41.20,-5.46))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-20.12,-41.20,-5.46))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-16.62,-41.68,-4.80))
Interior5V.append((-16.28,-39.28,-10.03))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-20.12,-41.20,-5.46))
Interior5V.append((-14.41,-41.59,-7.92))
Interior5V.append((-20.12,-41.20,-5.46))
Interior5V.append((-16.62,-41.68,-4.80))
Interior5V.append((-14.41,-41.59,-7.92))
Interior5V.append((-16.28,-39.28,-10.03))
Interior5V.append((-20.12,-41.20,-5.46))
Interior5V.append((-16.28,-39.28,-10.03))
Interior5V.append((-14.78,-39.33,-8.31))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-14.78,-39.33,-8.31))
Interior5V.append((-16.28,-39.28,-10.03))
Interior5V.append((-14.41,-41.59,-7.92))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-15.40,-32.69,-11.49))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-15.40,-32.69,-11.49))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-15.40,-32.69,-11.49))
Interior5V.append((-15.93,-37.66,-10.52))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-15.40,-32.69,-11.49))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-15.93,-37.66,-10.52))
Interior5V.append((-15.40,-32.69,-11.49))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-15.93,-37.66,-10.52))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-15.93,-37.66,-10.52))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-21.17,-39.51,-4.53))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-15.40,-32.69,-11.49))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-15.40,-32.69,-11.49))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-10.34,-30.54,-2.39))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-8.41,-30.75,-4.46))
Interior5V.append((-8.89,-33.92,-4.71))
Interior5V.append((-8.78,-32.09,-3.06))
Interior5V.append((-8.41,-30.75,-4.46))
Interior5V.append((-8.78,-32.09,-3.06))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-10.34,-30.54,-2.39))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-8.78,-32.09,-3.06))
Interior5V.append((-8.89,-33.92,-4.71))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-8.78,-32.09,-3.06))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-8.89,-33.92,-4.71))
Interior5V.append((-9.76,-29.92,-5.81))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-8.89,-33.92,-4.71))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-9.76,-29.92,-5.81))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-12.91,-34.77,-3.77))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-12.17,-34.60,-2.12))
Interior5V.append((-12.17,-34.60,-2.12))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-12.91,-34.77,-3.77))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-12.17,-34.60,-2.12))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-12.17,-34.60,-2.12))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-11.37,-31.12,-1.01))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-11.37,-31.12,-1.01))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-11.37,-31.12,-1.01))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-12.77,-29.43,1.95))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-12.77,-29.43,1.95))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-12.77,-29.43,1.95))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-9.09,-21.23,-1.59))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-10.79,-24.28,-2.98))
Interior5V.append((-9.09,-21.23,-1.59))
Interior5V.append((-15.56,-25.13,.02))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-9.09,-21.23,-1.59))
Interior5V.append((-10.79,-24.28,-2.98))
Interior5V.append((-15.56,-25.13,.02))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-10.79,-24.28,-2.98))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-15.56,-25.13,.02))
Interior5V.append((-10.79,-24.28,-2.98))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-11.76,-30.01,-7.40))
Interior5V.append((-11.91,-27.94,-9.30))
Interior5V.append((-12.34,-26.77,-5.22))
Interior5V.append((-11.91,-27.94,-9.30))
Interior5V.append((-11.76,-30.01,-7.40))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-11.76,-30.01,-7.40))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-11.91,-27.94,-9.30))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-12.34,-26.77,-5.22))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-11.84,-24.01,-5.82))
Interior5V.append((-12.34,-26.77,-5.22))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-11.84,-24.01,-5.82))
Interior5V.append((-11.91,-27.94,-9.30))
Interior5V.append((-12.34,-26.77,-5.22))
Interior5V.append((-11.84,-24.01,-5.82))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-11.91,-27.94,-9.30))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-10.34,-30.54,-2.39))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-12.34,-26.77,-5.22))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-12.34,-26.77,-5.22))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-10.34,-30.54,-2.39))
Interior5V.append((-10.29,-33.09,-2.63))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-10.03,-29.83,-.85))
Interior5V.append((-10.34,-30.54,-2.39))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-15.56,-25.13,.02))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-15.91,-27.44,-.01))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-15.91,-27.44,-.01))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-15.91,-27.44,-.01))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-14.64,-31.19,-1.24))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-14.64,-31.19,-1.24))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-14.64,-31.19,-1.24))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-14.64,-31.19,-1.24))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-13.58,-31.02,-1.40))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-13.50,-33.45,-5.08))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-14.36,-30.52,-3.67))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-12.76,-37.55,-8.90))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-10.30,-36.12,-7.27))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-12.76,-37.55,-8.90))
Interior5V.append((-13.53,-40.64,-6.21))
Interior5V.append((-12.76,-37.55,-8.90))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-13.53,-40.64,-6.21))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-13.53,-40.64,-6.21))
Interior5V.append((-14.78,-39.33,-8.31))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-14.42,-40.92,-3.71))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-14.42,-40.92,-3.71))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-14.42,-40.92,-3.71))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-16.62,-41.68,-4.80))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-14.78,-39.33,-8.31))
Interior5V.append((-14.41,-41.59,-7.92))
Interior5V.append((-14.53,-40.38,-5.90))
Interior5V.append((-14.41,-41.59,-7.92))
Interior5V.append((-16.62,-41.68,-4.80))
Interior5V.append((-15.13,-37.76,-8.05))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-14.78,-39.33,-8.31))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-21.17,-39.51,-4.53))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-18.14,-39.75,-4.16))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-21.17,-39.51,-4.53))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-16.87,-37.87,-9.21))
Interior5V.append((-14.62,-34.24,-7.83))
Interior5V.append((-10.30,-36.12,-7.27))
Interior5V.append((-9.67,-38.50,-6.88))
Interior5V.append((-11.43,-38.80,-4.37))
Interior5V.append((-10.30,-36.12,-7.27))
Interior5V.append((-12.76,-37.55,-8.90))
Interior5V.append((-9.67,-38.50,-6.88))
Interior5V.append((-12.38,-40.27,-5.56))
Interior5V.append((-11.43,-38.80,-4.37))
Interior5V.append((-9.67,-38.50,-6.88))
Interior5V.append((-12.38,-40.27,-5.56))
Interior5V.append((-9.67,-38.50,-6.88))
Interior5V.append((-12.76,-37.55,-8.90))
Interior5V.append((-12.13,-36.20,-2.97))
Interior5V.append((-11.43,-38.80,-4.37))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-11.43,-38.80,-4.37))
Interior5V.append((-12.38,-40.27,-5.56))
Interior5V.append((-12.38,-40.27,-5.56))
Interior5V.append((-13.53,-40.64,-6.21))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-12.38,-40.27,-5.56))
Interior5V.append((-12.76,-37.55,-8.90))
Interior5V.append((-13.53,-40.64,-6.21))
Interior5V.append((-7.93,-26.07,1.30))
Interior5V.append((-8.85,-26.96,1.78))
Interior5V.append((-8.47,-25.59,.11))
Interior5V.append((-7.93,-26.07,1.30))
Interior5V.append((-8.47,-25.59,.11))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-7.93,-26.07,1.30))
Interior5V.append((-7.50,-28.84,-2.23))
Interior5V.append((-8.85,-26.96,1.78))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-13.94,-27.42,1.12))
Interior5V.append((-15.56,-25.13,.02))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-16.98,-31.30,-1.99))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-16.98,-31.30,-1.99))
Interior5V.append((-17.36,-31.68,-.72))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-16.98,-31.30,-1.99))
Interior5V.append((-17.36,-31.68,-.72))
Interior5V.append((-16.98,-31.30,-1.99))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-15.59,-31.09,-2.25))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-15.01,-32.95,-5.79))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-14.58,-36.50,-2.66))
Interior5V.append((-19.30,-39.27,-2.89))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-19.30,-39.27,-2.89))
Interior5V.append((-18.37,-31.99,-.47))
Interior5V.append((-18.37,-31.99,-.47))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-17.36,-31.68,-.72))
Interior5V.append((-18.37,-31.99,-.47))
Interior5V.append((-17.36,-31.68,-.72))
Interior5V.append((-14.77,-34.71,-1.97))
Interior5V.append((-17.28,-27.35,-.88))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-17.28,-27.35,-.88))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-17.28,-27.35,-.88))
Interior5V.append((-15.30,-30.59,-3.50))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-17.31,-24.90,-.54))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-17.31,-24.90,-.54))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-13.47,-25.54,-5.41))
Interior5V.append((-10.45,-25.68,-4.05))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-8.24,-24.75,-4.10))
Interior5V.append((-10.45,-25.68,-4.05))
Interior5V.append((-8.24,-24.75,-4.10))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-11.15,-32.02,-7.94))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-9.76,-29.92,-5.81))
Interior5V.append((-11.15,-32.02,-7.94))
Interior5V.append((-9.76,-29.92,-5.81))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-12.27,-32.61,-7.62))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-12.27,-32.61,-7.62))
Interior5V.append((-11.15,-32.02,-7.94))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-12.27,-32.61,-7.62))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-11.15,-32.02,-7.94))
Interior5V.append((-9.76,-29.92,-5.81))
Interior5V.append((-8.89,-33.92,-4.71))
Interior5V.append((-8.41,-30.75,-4.46))
Interior5V.append((-9.76,-29.92,-5.81))
Interior5V.append((-8.41,-30.75,-4.46))
Interior5V.append((-10.79,-29.68,-5.20))
Interior5V.append((-12.89,-31.37,-5.86))
Interior5V.append((-12.34,-26.77,-5.22))
Interior5V.append((-11.76,-30.01,-7.40))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-12.13,-36.20,-2.97))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-10.30,-36.12,-7.27))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-12.13,-36.20,-2.97))
Interior5V.append((-13.23,-38.51,-4.45))
Interior5V.append((-13.94,-35.30,-6.49))
Interior5V.append((-9.18,-37.57,-5.41))
Interior5V.append((-10.30,-36.12,-7.27))
Interior5V.append((-11.43,-38.80,-4.37))
Interior5V.append((-9.18,-37.57,-5.41))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-10.30,-36.12,-7.27))
Interior5V.append((-9.42,-35.69,-4.34))
Interior5V.append((-12.13,-36.20,-2.97))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-9.42,-35.69,-4.34))
Interior5V.append((-11.43,-38.80,-4.37))
Interior5V.append((-12.13,-36.20,-2.97))
Interior5V.append((-9.42,-35.69,-4.34))
Interior5V.append((-9.18,-37.57,-5.41))
Interior5V.append((-11.43,-38.80,-4.37))
Interior5V.append((-9.42,-35.69,-4.34))
Interior5V.append((-10.38,-34.58,-5.26))
Interior5V.append((-9.18,-37.57,-5.41))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-9.20,-28.21,-4.02))
Interior5V.append((-10.45,-25.68,-4.05))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-10.45,-25.68,-4.05))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-10.01,-26.90,1.00))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-12.39,-26.13,-2.71))
Interior5V.append((-10.31,-25.63,-.78))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-15.56,-25.13,.02))
Interior5V.append((-17.31,-24.90,-.54))
Interior5V.append((-13.17,-24.61,-3.28))
Interior5V.append((-15.56,-25.13,.02))
Interior5V.append((-15.94,-26.86,-1.65))
Interior5V.append((-17.31,-24.90,-.54))
Interior5V.append((-13.84,-26.92,-4.49))
Interior5V.append((-17.67,-31.29,-2.82))
Interior5V.append((-13.95,-31.41,-7.37))
Interior5V.append((-21.17,-39.51,-4.53))
Interior5V.append((-19.30,-39.27,-2.89))
Interior5V.append((-15.01,-32.95,-5.79))

Interior5I = []
for x in range(0,188):
    Interior5I.append((x*3, x*3+1, x*3+2))

Interior5V = array(tuple(Interior5V), floatc)
Interior5I = array(tuple(Interior5I), intc)
Interior5Piece = Interior5.addPiece(Interior5V, Interior5I, (0,1,0,.5))
Interior5Piece.display = True
Interior5Piece.displayStyle = Interior5Piece.Solid
chimera.openModels.add([Interior5])
Interior6 = _surface.SurfaceModel()
Interior6V = []
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-19.46,-44.45,15.15))
Interior6V.append((-22.21,-43.70,17.85))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-20.48,-45.61,14.14))
Interior6V.append((-19.46,-44.45,15.15))
Interior6V.append((-19.88,-45.98,15.89))
Interior6V.append((-19.46,-44.45,15.15))
Interior6V.append((-20.48,-45.61,14.14))
Interior6V.append((-19.88,-45.98,15.89))
Interior6V.append((-22.21,-43.70,17.85))
Interior6V.append((-19.46,-44.45,15.15))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-22.21,-43.70,17.85))
Interior6V.append((-19.88,-45.98,15.89))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-19.88,-45.98,15.89))
Interior6V.append((-20.48,-45.61,14.14))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-22.21,-43.70,17.85))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-20.48,-45.61,14.14))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-20.48,-45.61,14.14))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-25.52,-46.17,19.92))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-25.52,-46.17,19.92))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-25.52,-46.17,19.92))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-22.96,-42.65,13.57))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-25.04,-40.31,14.91))
Interior6V.append((-22.96,-42.65,13.57))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-27.18,-40.61,14.47))
Interior6V.append((-22.96,-42.65,13.57))
Interior6V.append((-25.04,-40.31,14.91))
Interior6V.append((-24.82,-48.98,20.14))
Interior6V.append((-23.02,-49.69,18.33))
Interior6V.append((-25.29,-49.95,19.55))
Interior6V.append((-24.82,-48.98,20.14))
Interior6V.append((-25.29,-49.95,19.55))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-23.56,-48.67,19.96))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-23.21,-47.78,20.24))
Interior6V.append((-23.56,-48.67,19.96))
Interior6V.append((-23.21,-47.78,20.24))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-25.52,-46.17,19.92))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-23.21,-47.78,20.24))
Interior6V.append((-25.52,-46.17,19.92))
Interior6V.append((-23.21,-47.78,20.24))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-25.52,-46.17,19.92))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-25.52,-46.17,19.92))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-23.56,-48.67,19.96))
Interior6V.append((-22.81,-46.25,17.10))
Interior6V.append((-23.02,-49.69,18.33))
Interior6V.append((-23.56,-48.67,19.96))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-23.56,-48.67,19.96))
Interior6V.append((-24.82,-48.98,20.14))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-23.56,-48.67,19.96))
Interior6V.append((-23.02,-49.69,18.33))
Interior6V.append((-24.82,-48.98,20.14))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-23.02,-49.69,18.33))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-25.39,-50.72,16.58))
Interior6V.append((-23.02,-49.69,18.33))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-25.39,-50.72,16.58))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-25.39,-50.72,16.58))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-25.39,-50.72,16.58))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-26.96,-51.99,15.83))
Interior6V.append((-25.39,-50.72,16.58))
Interior6V.append((-26.96,-51.99,15.83))
Interior6V.append((-26.41,-51.63,17.86))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-26.96,-51.99,15.83))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-26.96,-51.99,15.83))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-26.72,-50.53,12.27))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-26.72,-50.53,12.27))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-26.72,-50.53,12.27))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-29.46,-52.63,13.35))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-29.46,-52.63,13.35))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-23.08,-37.27,19.36))
Interior6V.append((-25.67,-39.47,24.15))
Interior6V.append((-27.55,-34.67,16.37))
Interior6V.append((-23.08,-37.27,19.36))
Interior6V.append((-27.55,-34.67,16.37))
Interior6V.append((-24.92,-37.37,17.74))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-28.78,-53.32,20.77))
Interior6V.append((-28.43,-56.45,18.70))
Interior6V.append((-26.35,-54.36,17.78))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-28.43,-56.45,18.70))
Interior6V.append((-28.78,-53.32,20.77))
Interior6V.append((-26.35,-54.36,17.78))
Interior6V.append((-28.43,-56.45,18.70))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-28.78,-53.32,20.77))
Interior6V.append((-26.35,-54.36,17.78))
Interior6V.append((-28.78,-53.32,20.77))
Interior6V.append((-26.41,-51.63,17.86))
Interior6V.append((-26.35,-54.36,17.78))
Interior6V.append((-26.41,-51.63,17.86))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-25.29,-49.95,19.55))
Interior6V.append((-25.39,-50.72,16.58))
Interior6V.append((-26.41,-51.63,17.86))
Interior6V.append((-27.43,-51.23,21.21))
Interior6V.append((-28.78,-53.32,20.77))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-27.43,-51.23,21.21))
Interior6V.append((-26.41,-51.63,17.86))
Interior6V.append((-28.78,-53.32,20.77))
Interior6V.append((-27.43,-51.23,21.21))
Interior6V.append((-25.29,-49.95,19.55))
Interior6V.append((-26.41,-51.63,17.86))
Interior6V.append((-27.61,-51.76,23.02))
Interior6V.append((-28.29,-47.08,20.87))
Interior6V.append((-27.43,-51.23,21.21))
Interior6V.append((-27.61,-51.76,23.02))
Interior6V.append((-27.43,-51.23,21.21))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-28.29,-47.08,20.87))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-28.29,-47.08,20.87))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-26.52,-48.76,21.27))
Interior6V.append((-28.29,-47.08,20.87))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-26.52,-48.76,21.27))
Interior6V.append((-27.43,-51.23,21.21))
Interior6V.append((-28.29,-47.08,20.87))
Interior6V.append((-26.52,-48.76,21.27))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-25.29,-49.95,19.55))
Interior6V.append((-26.52,-48.76,21.27))
Interior6V.append((-25.29,-49.95,19.55))
Interior6V.append((-27.43,-51.23,21.21))
Interior6V.append((-26.77,-42.12,22.94))
Interior6V.append((-28.17,-42.41,20.06))
Interior6V.append((-25.67,-39.47,24.15))
Interior6V.append((-26.77,-42.12,22.94))
Interior6V.append((-25.67,-39.47,24.15))
Interior6V.append((-25.33,-41.13,22.36))
Interior6V.append((-26.77,-42.12,22.94))
Interior6V.append((-25.33,-41.13,22.36))
Interior6V.append((-28.17,-42.41,20.06))
Interior6V.append((-30.20,-52.00,23.48))
Interior6V.append((-28.29,-47.08,20.87))
Interior6V.append((-27.61,-51.76,23.02))
Interior6V.append((-30.20,-52.00,23.48))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-28.29,-47.08,20.87))
Interior6V.append((-30.20,-52.00,23.48))
Interior6V.append((-27.61,-51.76,23.02))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-24.18,-44.09,10.77))
Interior6V.append((-26.88,-42.83,10.67))
Interior6V.append((-26.70,-46.89,9.11))
Interior6V.append((-24.18,-44.09,10.77))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-26.70,-46.89,9.11))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-27.34,-46.89,9.87))
Interior6V.append((-29.47,-45.57,7.45))
Interior6V.append((-27.34,-46.89,9.87))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-29.47,-45.57,7.45))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-27.34,-46.89,9.87))
Interior6V.append((-25.52,-48.47,11.06))
Interior6V.append((-27.34,-46.89,9.87))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-25.52,-48.47,11.06))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-21.51,-46.70,11.19))
Interior6V.append((-20.97,-48.08,13.39))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-21.51,-46.70,11.19))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-20.97,-48.08,13.39))
Interior6V.append((-24.09,-48.46,14.87))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-24.09,-48.46,14.87))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-20.97,-48.08,13.39))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-20.97,-48.08,13.39))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-23.14,-47.89,15.71))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-25.53,-46.46,15.08))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-25.53,-46.46,15.08))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-25.53,-46.46,15.08))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-23.45,-46.68,16.34))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-25.53,-46.46,15.08))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-24.70,-45.94,16.08))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-28.84,-43.22,18.75))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-28.84,-43.22,18.75))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-28.84,-43.22,18.75))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-27.18,-40.61,14.47))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-28.33,-39.48,12.38))
Interior6V.append((-26.88,-42.83,10.67))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-28.33,-39.48,12.38))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-26.88,-42.83,10.67))
Interior6V.append((-27.18,-40.61,14.47))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-26.88,-42.83,10.67))
Interior6V.append((-23.36,-43.64,12.74))
Interior6V.append((-27.18,-40.61,14.47))
Interior6V.append((-26.88,-42.83,10.67))
Interior6V.append((-23.36,-43.64,12.74))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-23.36,-43.64,12.74))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-23.36,-43.64,12.74))
Interior6V.append((-26.88,-42.83,10.67))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-26.88,-42.83,10.67))
Interior6V.append((-24.18,-44.09,10.77))
Interior6V.append((-25.33,-41.13,22.36))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-26.69,-44.35,18.43))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-26.69,-44.35,18.43))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-28.17,-42.41,20.06))
Interior6V.append((-25.33,-41.13,22.36))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-22.68,-40.90,20.40))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-22.68,-40.90,20.40))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-25.33,-41.13,22.36))
Interior6V.append((-25.04,-40.31,14.91))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-27.32,-38.60,17.11))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-24.92,-37.37,17.74))
Interior6V.append((-27.32,-38.60,17.11))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-23.08,-37.27,19.36))
Interior6V.append((-24.92,-37.37,17.74))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-25.33,-41.13,22.36))
Interior6V.append((-25.67,-39.47,24.15))
Interior6V.append((-23.08,-37.27,19.36))
Interior6V.append((-27.32,-38.60,17.11))
Interior6V.append((-24.92,-37.37,17.74))
Interior6V.append((-27.55,-34.67,16.37))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-25.67,-39.47,24.15))
Interior6V.append((-28.17,-42.41,20.06))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-27.32,-38.60,17.11))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-27.55,-34.67,16.37))
Interior6V.append((-25.67,-39.47,24.15))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-27.32,-38.60,17.11))
Interior6V.append((-27.55,-34.67,16.37))
Interior6V.append((-23.36,-39.30,15.96))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-25.04,-40.31,14.91))
Interior6V.append((-23.36,-39.30,15.96))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-23.36,-39.30,15.96))
Interior6V.append((-25.04,-40.31,14.91))
Interior6V.append((-21.15,-40.58,16.14))
Interior6V.append((-23.36,-39.30,15.96))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-21.15,-40.58,16.14))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-23.36,-39.30,15.96))
Interior6V.append((-23.08,-37.27,19.36))
Interior6V.append((-24.56,-39.16,18.01))
Interior6V.append((-22.68,-40.90,20.40))
Interior6V.append((-23.08,-37.27,19.36))
Interior6V.append((-22.68,-40.90,20.40))
Interior6V.append((-25.33,-41.13,22.36))
Interior6V.append((-29.35,-43.58,7.94))
Interior6V.append((-28.33,-39.48,12.38))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-29.35,-43.58,7.94))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-28.33,-39.48,12.38))
Interior6V.append((-29.35,-43.58,7.94))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-28.84,-43.22,18.75))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-28.84,-43.22,18.75))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-28.17,-42.41,20.06))
Interior6V.append((-28.84,-43.22,18.75))
Interior6V.append((-28.17,-42.41,20.06))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-28.17,-42.41,20.06))
Interior6V.append((-29.06,-38.86,17.04))
Interior6V.append((-27.63,-42.08,18.50))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-30.34,-45.30,7.16))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-30.34,-45.30,7.16))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-29.47,-45.57,7.45))
Interior6V.append((-30.34,-45.30,7.16))
Interior6V.append((-29.47,-45.57,7.45))
Interior6V.append((-28.03,-44.67,9.52))
Interior6V.append((-29.62,-50.60,8.18))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-30.34,-45.30,7.16))
Interior6V.append((-29.62,-50.60,8.18))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-27.83,-48.93,11.16))
Interior6V.append((-30.97,-51.00,7.08))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-29.62,-50.60,8.18))
Interior6V.append((-30.97,-51.00,7.08))
Interior6V.append((-29.62,-50.60,8.18))
Interior6V.append((-30.34,-45.30,7.16))
Interior6V.append((-30.97,-51.00,7.08))
Interior6V.append((-30.34,-45.30,7.16))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-26.41,-51.63,17.86))
Interior6V.append((-26.96,-51.99,15.83))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-26.96,-51.99,15.83))
Interior6V.append((-26.45,-47.29,18.97))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-29.46,-52.63,13.35))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-29.43,-51.66,20.94))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-29.46,-52.63,13.35))
Interior6V.append((-27.94,-52.62,16.24))
Interior6V.append((-26.96,-51.99,15.83))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-25.52,-48.47,11.06))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-23.43,-46.70,9.68))
Interior6V.append((-25.52,-48.47,11.06))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-24.18,-44.09,10.77))
Interior6V.append((-23.43,-46.70,9.68))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-23.43,-46.70,9.68))
Interior6V.append((-21.51,-46.70,11.19))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-23.43,-46.70,9.68))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-21.51,-46.70,11.19))
Interior6V.append((-27.34,-46.89,9.87))
Interior6V.append((-25.52,-48.47,11.06))
Interior6V.append((-23.43,-46.70,9.68))
Interior6V.append((-23.43,-46.70,9.68))
Interior6V.append((-24.18,-44.09,10.77))
Interior6V.append((-26.70,-46.89,9.11))
Interior6V.append((-23.43,-46.70,9.68))
Interior6V.append((-26.70,-46.89,9.11))
Interior6V.append((-27.34,-46.89,9.87))
Interior6V.append((-25.94,-48.08,13.79))
Interior6V.append((-26.34,-45.86,14.70))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-23.61,-44.64,13.07))
Interior6V.append((-24.09,-48.46,14.87))
Interior6V.append((-25.24,-47.69,14.52))
Interior6V.append((-24.09,-48.46,14.87))
Interior6V.append((-23.29,-48.73,12.30))
Interior6V.append((-29.15,-50.48,12.29))
Interior6V.append((-28.80,-41.35,16.60))
Interior6V.append((-28.62,-45.65,18.93))
Interior6V.append((-23.36,-43.64,12.74))
Interior6V.append((-22.96,-42.65,13.57))
Interior6V.append((-27.18,-40.61,14.47))
Interior6V.append((-23.36,-43.64,12.74))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-22.96,-42.65,13.57))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-22.21,-43.70,17.85))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-22.21,-43.70,17.85))
Interior6V.append((-21.15,-40.58,16.14))
Interior6V.append((-22.76,-42.86,14.61))
Interior6V.append((-22.21,-43.70,17.85))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-21.15,-40.58,16.14))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-26.69,-44.35,18.43))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-26.69,-44.35,18.43))
Interior6V.append((-23.29,-41.65,18.80))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-24.99,-44.71,16.67))
Interior6V.append((-25.87,-44.56,16.30))
Interior6V.append((-26.98,-40.86,17.74))
Interior6V.append((-27.18,-40.61,14.47))
Interior6V.append((-25.04,-40.31,14.91))
Interior6V.append((-25.39,-50.72,16.58))
Interior6V.append((-25.29,-49.95,19.55))
Interior6V.append((-23.02,-49.69,18.33))

Interior6I = []
for x in range(0,180):
    Interior6I.append((x*3, x*3+1, x*3+2))

Interior6V = array(tuple(Interior6V), floatc)
Interior6I = array(tuple(Interior6I), intc)
Interior6Piece = Interior6.addPiece(Interior6V, Interior6I, (0.13,0.54,0.13,.5))
Interior6Piece.display = True
Interior6Piece.displayStyle = Interior6Piece.Solid
chimera.openModels.add([Interior6])
Interior7 = _surface.SurfaceModel()
Interior7V = []
Interior7V.append((-19.76,-60.72,21.52))
Interior7V.append((-21.53,-60.54,19.83))
Interior7V.append((-23.14,-61.84,21.42))
Interior7V.append((-19.76,-60.72,21.52))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-21.53,-60.54,19.83))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-23.14,-61.84,21.42))
Interior7V.append((-21.53,-60.54,19.83))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-21.53,-60.54,19.83))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-19.60,-59.31,23.57))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-19.76,-60.72,21.52))
Interior7V.append((-20.68,-61.49,24.38))
Interior7V.append((-19.76,-60.72,21.52))
Interior7V.append((-23.14,-61.84,21.42))
Interior7V.append((-20.68,-61.49,24.38))
Interior7V.append((-19.60,-59.31,23.57))
Interior7V.append((-19.76,-60.72,21.52))
Interior7V.append((-22.64,-62.08,24.54))
Interior7V.append((-20.68,-61.49,24.38))
Interior7V.append((-23.14,-61.84,21.42))
Interior7V.append((-22.57,-60.20,25.88))
Interior7V.append((-19.60,-59.31,23.57))
Interior7V.append((-20.68,-61.49,24.38))
Interior7V.append((-22.57,-60.20,25.88))
Interior7V.append((-20.68,-61.49,24.38))
Interior7V.append((-22.64,-62.08,24.54))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-19.60,-59.31,23.57))
Interior7V.append((-22.57,-60.20,25.88))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-22.57,-60.20,25.88))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-22.57,-60.20,25.88))
Interior7V.append((-22.64,-62.08,24.54))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-22.64,-62.08,24.54))
Interior7V.append((-25.74,-62.37,22.30))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-22.64,-62.08,24.54))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-24.25,-58.20,26.33))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-24.25,-58.20,26.33))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-27.54,-63.91,21.95))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-25.74,-62.37,22.30))
Interior7V.append((-26.52,-59.76,20.78))
Interior7V.append((-27.54,-63.91,21.95))
Interior7V.append((-25.74,-62.37,22.30))
Interior7V.append((-26.35,-65.65,25.60))
Interior7V.append((-27.54,-63.91,21.95))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-24.56,-63.62,23.94))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-27.54,-63.91,21.95))
Interior7V.append((-24.56,-63.62,23.94))
Interior7V.append((-26.35,-65.65,25.60))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-24.56,-63.62,23.94))
Interior7V.append((-27.54,-63.91,21.95))
Interior7V.append((-26.35,-65.65,25.60))
Interior7V.append((-24.70,-47.37,27.28))
Interior7V.append((-19.17,-50.68,29.78))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-24.70,-47.37,27.28))
Interior7V.append((-21.57,-50.91,26.22))
Interior7V.append((-19.17,-50.68,29.78))
Interior7V.append((-25.94,-47.47,25.57))
Interior7V.append((-24.70,-47.37,27.28))
Interior7V.append((-30.20,-52.00,23.48))
Interior7V.append((-25.94,-47.47,25.57))
Interior7V.append((-27.61,-51.76,23.02))
Interior7V.append((-24.70,-47.37,27.28))
Interior7V.append((-25.94,-47.47,25.57))
Interior7V.append((-30.20,-52.00,23.48))
Interior7V.append((-27.61,-51.76,23.02))
Interior7V.append((-21.85,-58.17,28.12))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-19.17,-50.68,29.78))
Interior7V.append((-21.85,-58.17,28.12))
Interior7V.append((-19.17,-50.68,29.78))
Interior7V.append((-21.57,-50.91,26.22))
Interior7V.append((-18.43,-54.20,24.97))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-21.85,-58.17,28.12))
Interior7V.append((-18.43,-54.20,24.97))
Interior7V.append((-21.85,-58.17,28.12))
Interior7V.append((-21.57,-50.91,26.22))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-18.43,-54.20,24.97))
Interior7V.append((-22.60,-52.44,24.34))
Interior7V.append((-18.43,-54.20,24.97))
Interior7V.append((-21.57,-50.91,26.22))
Interior7V.append((-27.61,-51.76,23.02))
Interior7V.append((-22.60,-52.44,24.34))
Interior7V.append((-21.57,-50.91,26.22))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-24.35,-58.69,27.95))
Interior7V.append((-24.25,-58.20,26.33))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-24.35,-58.69,27.95))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-24.25,-58.20,26.33))
Interior7V.append((-24.35,-58.69,27.95))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-24.35,-58.69,27.95))
Interior7V.append((-30.14,-54.16,22.84))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-24.35,-58.69,27.95))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-30.14,-54.16,22.84))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-30.14,-54.16,22.84))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-30.20,-52.00,23.48))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-30.14,-54.16,22.84))
Interior7V.append((-27.61,-51.76,23.02))
Interior7V.append((-30.20,-52.00,23.48))
Interior7V.append((-30.14,-54.16,22.84))
Interior7V.append((-26.54,-53.80,22.50))
Interior7V.append((-30.14,-54.16,22.84))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-26.54,-53.80,22.50))
Interior7V.append((-27.61,-51.76,23.02))
Interior7V.append((-30.14,-54.16,22.84))
Interior7V.append((-26.54,-53.80,22.50))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-22.60,-52.44,24.34))
Interior7V.append((-26.54,-53.80,22.50))
Interior7V.append((-22.60,-52.44,24.34))
Interior7V.append((-27.61,-51.76,23.02))
Interior7V.append((-24.20,-56.99,21.21))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-24.20,-56.99,21.21))
Interior7V.append((-24.84,-57.31,24.06))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-24.20,-56.99,21.21))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-24.84,-57.31,24.06))
Interior7V.append((-24.84,-57.31,24.06))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-24.25,-56.07,21.59))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-24.25,-56.07,21.59))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-24.84,-57.31,24.06))
Interior7V.append((-24.25,-56.07,21.59))
Interior7V.append((-24.84,-57.31,24.06))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-24.84,-57.31,24.06))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-19.08,-56.90,24.47))
Interior7V.append((-21.46,-55.07,21.08))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-21.46,-55.07,21.08))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-28.31,-58.87,19.15))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-27.54,-63.91,21.95))
Interior7V.append((-28.31,-58.87,19.15))
Interior7V.append((-27.54,-63.91,21.95))
Interior7V.append((-26.52,-59.76,20.78))
Interior7V.append((-28.31,-58.87,19.15))
Interior7V.append((-26.52,-59.76,20.78))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-19.08,-56.90,24.47))
Interior7V.append((-18.43,-54.20,24.97))
Interior7V.append((-22.60,-52.44,24.34))
Interior7V.append((-19.08,-56.90,24.47))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-18.43,-54.20,24.97))
Interior7V.append((-19.60,-59.31,23.57))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-19.08,-56.90,24.47))
Interior7V.append((-19.60,-59.31,23.57))
Interior7V.append((-19.08,-56.90,24.47))
Interior7V.append((-21.01,-57.64,21.40))
Interior7V.append((-22.02,-57.90,26.23))
Interior7V.append((-24.43,-58.34,24.62))
Interior7V.append((-24.84,-57.31,24.06))
Interior7V.append((-25.74,-62.37,22.30))
Interior7V.append((-23.14,-61.84,21.42))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-25.74,-62.37,22.30))
Interior7V.append((-22.64,-62.08,24.54))
Interior7V.append((-23.14,-61.84,21.42))
Interior7V.append((-26.52,-59.76,20.78))
Interior7V.append((-25.74,-62.37,22.30))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-26.52,-59.76,20.78))
Interior7V.append((-24.57,-58.89,21.99))
Interior7V.append((-26.71,-58.08,23.31))
Interior7V.append((-21.46,-55.07,21.08))
Interior7V.append((-19.08,-56.90,24.47))
Interior7V.append((-22.60,-52.44,24.34))
Interior7V.append((-21.46,-55.07,21.08))
Interior7V.append((-22.60,-52.44,24.34))
Interior7V.append((-24.55,-56.22,24.51))
Interior7V.append((-23.77,-57.22,27.59))
Interior7V.append((-30.20,-52.00,23.48))
Interior7V.append((-24.70,-47.37,27.28))
Interior7V.append((-27.61,-51.76,23.02))
Interior7V.append((-21.57,-50.91,26.22))
Interior7V.append((-24.70,-47.37,27.28))
Interior7V.append((-24.35,-58.69,27.95))
Interior7V.append((-25.12,-62.85,24.21))
Interior7V.append((-26.35,-65.65,25.60))
Interior7V.append((-24.35,-58.69,27.95))
Interior7V.append((-26.35,-65.65,25.60))
Interior7V.append((-26.71,-58.08,23.31))

Interior7I = []
for x in range(0,78):
    Interior7I.append((x*3, x*3+1, x*3+2))

Interior7V = array(tuple(Interior7V), floatc)
Interior7I = array(tuple(Interior7I), intc)
Interior7Piece = Interior7.addPiece(Interior7V, Interior7I, (0,1,1,.5))
Interior7Piece.display = True
Interior7Piece.displayStyle = Interior7Piece.Solid
chimera.openModels.add([Interior7])
Interior8 = _surface.SurfaceModel()
Interior8V = []
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-4.03,-49.97,-11.00))
Interior8V.append((-4.88,-50.10,-14.86))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-4.88,-50.10,-14.86))
Interior8V.append((-3.03,-48.88,-15.89))
Interior8V.append((-3.42,-48.21,-10.88))
Interior8V.append((-4.03,-49.97,-11.00))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-1.07,-49.10,-10.81))
Interior8V.append((-4.03,-49.97,-11.00))
Interior8V.append((-3.42,-48.21,-10.88))
Interior8V.append((-1.07,-49.10,-10.81))
Interior8V.append((.69,-49.41,-12.45))
Interior8V.append((-4.03,-49.97,-11.00))
Interior8V.append((.45,-53.90,-13.47))
Interior8V.append((-4.88,-50.10,-14.86))
Interior8V.append((-4.03,-49.97,-11.00))
Interior8V.append((.45,-53.90,-13.47))
Interior8V.append((-4.03,-49.97,-11.00))
Interior8V.append((.69,-49.41,-12.45))
Interior8V.append((-.13,-49.53,-10.52))
Interior8V.append((-.48,-47.12,-8.77))
Interior8V.append((2.17,-46.73,-9.14))
Interior8V.append((-.13,-49.53,-10.52))
Interior8V.append((2.17,-46.73,-9.14))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((2.12,-45.28,-10.08))
Interior8V.append((2.17,-46.73,-9.14))
Interior8V.append((-.48,-47.12,-8.77))
Interior8V.append((2.12,-45.28,-10.08))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((2.17,-46.73,-9.14))
Interior8V.append((-1.07,-49.10,-10.81))
Interior8V.append((-.48,-47.12,-8.77))
Interior8V.append((-.13,-49.53,-10.52))
Interior8V.append((-1.07,-49.10,-10.81))
Interior8V.append((-.13,-49.53,-10.52))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((.81,-44.95,-12.17))
Interior8V.append((.81,-44.95,-12.17))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((2.12,-45.28,-10.08))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-.48,-47.12,-8.77))
Interior8V.append((-1.07,-49.10,-10.81))
Interior8V.append((-1.24,-44.41,-11.12))
Interior8V.append((-.48,-47.12,-8.77))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-1.24,-44.41,-11.12))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((.81,-44.95,-12.17))
Interior8V.append((-1.24,-44.41,-11.12))
Interior8V.append((2.12,-45.28,-10.08))
Interior8V.append((-.48,-47.12,-8.77))
Interior8V.append((-1.24,-44.41,-11.12))
Interior8V.append((.81,-44.95,-12.17))
Interior8V.append((2.12,-45.28,-10.08))
Interior8V.append((1.05,-45.17,-14.41))
Interior8V.append((3.01,-47.41,-13.61))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((3.01,-47.41,-13.61))
Interior8V.append((1.05,-45.17,-14.41))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((1.05,-45.17,-14.41))
Interior8V.append((-1.50,-46.74,-15.84))
Interior8V.append((.33,-44.13,-19.13))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((1.83,-53.25,-18.04))
Interior8V.append((.33,-44.13,-19.13))
Interior8V.append((1.83,-53.25,-18.04))
Interior8V.append((5.25,-52.17,-18.28))
Interior8V.append((.33,-44.13,-19.13))
Interior8V.append((5.25,-52.17,-18.28))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((3.14,-52.78,-15.96))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((5.25,-52.17,-18.28))
Interior8V.append((3.14,-52.78,-15.96))
Interior8V.append((5.25,-52.17,-18.28))
Interior8V.append((1.83,-53.25,-18.04))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((3.14,-52.78,-15.96))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((3.14,-52.78,-15.96))
Interior8V.append((1.83,-53.25,-18.04))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((3.01,-47.41,-13.61))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((.69,-49.41,-12.45))
Interior8V.append((3.01,-47.41,-13.61))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((-3.03,-48.88,-15.89))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((-1.50,-46.74,-15.84))
Interior8V.append((2.08,-53.11,-13.54))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((.45,-53.90,-13.47))
Interior8V.append((2.08,-53.11,-13.54))
Interior8V.append((.45,-53.90,-13.47))
Interior8V.append((.69,-49.41,-12.45))
Interior8V.append((2.08,-53.11,-13.54))
Interior8V.append((.69,-49.41,-12.45))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((.79,-54.81,-15.70))
Interior8V.append((.45,-53.90,-13.47))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((.79,-54.81,-15.70))
Interior8V.append((-4.88,-50.10,-14.86))
Interior8V.append((.45,-53.90,-13.47))
Interior8V.append((.59,-56.80,-18.99))
Interior8V.append((.79,-54.81,-15.70))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((.59,-56.80,-18.99))
Interior8V.append((-4.88,-50.10,-14.86))
Interior8V.append((.79,-54.81,-15.70))
Interior8V.append((.59,-56.80,-18.99))
Interior8V.append((-3.03,-48.88,-15.89))
Interior8V.append((-4.88,-50.10,-14.86))
Interior8V.append((.59,-56.80,-18.99))
Interior8V.append((.65,-53.01,-15.71))
Interior8V.append((1.83,-53.25,-18.04))
Interior8V.append((-2.74,-47.27,-18.04))
Interior8V.append((-3.03,-48.88,-15.89))
Interior8V.append((.59,-56.80,-18.99))
Interior8V.append((-2.74,-47.27,-18.04))
Interior8V.append((.59,-56.80,-18.99))
Interior8V.append((1.83,-53.25,-18.04))
Interior8V.append((-2.74,-47.27,-18.04))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((-3.03,-48.88,-15.89))
Interior8V.append((-2.74,-47.27,-18.04))
Interior8V.append((1.83,-53.25,-18.04))
Interior8V.append((.08,-45.89,-17.54))
Interior8V.append((-3.64,-45.00,-15.24))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-2.64,-45.10,-15.25))
Interior8V.append((-3.64,-45.00,-15.24))
Interior8V.append((-4.02,-44.72,-12.80))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-3.64,-45.00,-15.24))
Interior8V.append((-2.64,-45.10,-15.25))
Interior8V.append((-4.02,-44.72,-12.80))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-4.02,-44.72,-12.80))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-4.02,-44.72,-12.80))
Interior8V.append((-2.64,-45.10,-15.25))
Interior8V.append((-3.99,-48.40,-15.81))
Interior8V.append((-2.64,-45.10,-15.25))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-3.99,-48.40,-15.81))
Interior8V.append((-1.50,-46.74,-15.84))
Interior8V.append((-2.64,-45.10,-15.25))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-3.42,-48.21,-10.88))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-1.07,-49.10,-10.81))
Interior8V.append((-3.42,-48.21,-10.88))
Interior8V.append((-1.50,-46.74,-15.84))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-2.64,-45.10,-15.25))
Interior8V.append((-.70,-44.87,-14.24))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-1.50,-46.74,-15.84))
Interior8V.append((-.70,-44.87,-14.24))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((-2.30,-45.20,-11.23))
Interior8V.append((-.70,-44.87,-14.24))
Interior8V.append((1.05,-45.17,-14.41))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((-.70,-44.87,-14.24))
Interior8V.append((-1.50,-46.74,-15.84))
Interior8V.append((1.05,-45.17,-14.41))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((.69,-49.41,-12.45))
Interior8V.append((-1.07,-49.10,-10.81))
Interior8V.append((.69,-49.41,-12.45))
Interior8V.append((1.45,-46.99,-12.71))
Interior8V.append((3.01,-47.41,-13.61))
Interior8V.append((-3.99,-48.40,-15.81))
Interior8V.append((-3.03,-48.88,-15.89))
Interior8V.append((-1.50,-46.74,-15.84))
Interior8V.append((-3.99,-48.40,-15.81))
Interior8V.append((-4.93,-48.03,-12.69))
Interior8V.append((-3.03,-48.88,-15.89))

Interior8I = []
for x in range(0,64):
    Interior8I.append((x*3, x*3+1, x*3+2))

Interior8V = array(tuple(Interior8V), floatc)
Interior8I = array(tuple(Interior8I), intc)
Interior8Piece = Interior8.addPiece(Interior8V, Interior8I, (0.12,0.7,0.66,.5))
Interior8Piece.display = True
Interior8Piece.displayStyle = Interior8Piece.Solid
chimera.openModels.add([Interior8])
Interior9 = _surface.SurfaceModel()
Interior9V = []
Interior9V.append((-8.55,-38.03,27.26))
Interior9V.append((-5.80,-36.70,27.49))
Interior9V.append((-6.75,-37.89,28.84))
Interior9V.append((-8.55,-38.03,27.26))
Interior9V.append((-6.75,-37.89,28.84))
Interior9V.append((-5.61,-40.51,27.19))
Interior9V.append((-7.70,-40.72,25.23))
Interior9V.append((-5.61,-40.51,27.19))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-7.70,-40.72,25.23))
Interior9V.append((-8.55,-38.03,27.26))
Interior9V.append((-5.61,-40.51,27.19))
Interior9V.append((-3.77,-41.24,24.33))
Interior9V.append((-4.81,-37.44,22.25))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-3.77,-41.24,24.33))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-2.71,-40.51,24.76))
Interior9V.append((-3.77,-41.24,24.33))
Interior9V.append((-2.71,-40.51,24.76))
Interior9V.append((-4.81,-37.44,22.25))
Interior9V.append((-1.76,-38.08,23.48))
Interior9V.append((-4.81,-37.44,22.25))
Interior9V.append((-2.71,-40.51,24.76))
Interior9V.append((-1.76,-38.08,23.48))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-4.81,-37.44,22.25))
Interior9V.append((-1.76,-38.08,23.48))
Interior9V.append((-2.71,-40.51,24.76))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-2.71,-40.51,24.76))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-3.27,-35.86,25.23))
Interior9V.append((-4.81,-37.44,22.25))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-9.58,-37.35,24.20))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-8.98,-37.24,25.10))
Interior9V.append((-9.58,-37.35,24.20))
Interior9V.append((-9.16,-39.42,24.21))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-9.58,-37.35,24.20))
Interior9V.append((-8.98,-37.24,25.10))
Interior9V.append((-9.16,-39.42,24.21))
Interior9V.append((-6.44,-39.91,23.04))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-9.16,-39.42,24.21))
Interior9V.append((-5.55,-33.84,27.63))
Interior9V.append((-1.73,-34.73,27.58))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((-1.71,-35.72,27.70))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((-1.73,-34.73,27.58))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-5.55,-33.84,27.63))
Interior9V.append((-4.49,-37.15,33.08))
Interior9V.append((-6.06,-35.49,34.03))
Interior9V.append((-4.49,-37.15,33.08))
Interior9V.append((-5.55,-33.84,27.63))
Interior9V.append((-6.06,-35.49,34.03))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((-4.49,-37.15,33.08))
Interior9V.append((-6.06,-35.49,34.03))
Interior9V.append((-5.55,-33.84,27.63))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-4.49,-37.15,33.08))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((1.76,-34.85,26.09))
Interior9V.append((.35,-36.95,26.23))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((1.76,-34.85,26.09))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((1.76,-34.85,26.09))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((.35,-36.95,26.23))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-.27,-41.33,26.59))
Interior9V.append((1.15,-39.34,25.76))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((1.15,-39.34,25.76))
Interior9V.append((.35,-36.95,26.23))
Interior9V.append((-3.06,-41.13,28.13))
Interior9V.append((-.27,-41.33,26.59))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-3.95,-39.59,32.28))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-4.06,-41.73,31.82))
Interior9V.append((-3.95,-39.59,32.28))
Interior9V.append((-4.06,-41.73,31.82))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-3.95,-39.59,32.28))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-3.95,-39.59,32.28))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-3.06,-41.13,28.13))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-1.71,-35.72,27.70))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((.35,-36.95,26.23))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-.27,-41.33,26.59))
Interior9V.append((-3.06,-41.13,28.13))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((1.15,-39.34,25.76))
Interior9V.append((-.27,-41.33,26.59))
Interior9V.append((1.15,-39.34,25.76))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((.35,-36.95,26.23))
Interior9V.append((-.08,-43.68,27.58))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((-.08,-43.68,27.58))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((-.27,-41.33,26.59))
Interior9V.append((-.08,-43.68,27.58))
Interior9V.append((-.27,-41.33,26.59))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-3.06,-41.13,28.13))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-5.61,-40.51,27.19))
Interior9V.append((-3.06,-41.13,28.13))
Interior9V.append((-5.61,-40.51,27.19))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-5.61,-40.51,27.19))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-6.75,-37.89,28.84))
Interior9V.append((-5.80,-36.70,27.49))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-5.61,-40.51,27.19))
Interior9V.append((-6.75,-37.89,28.84))
Interior9V.append((-3.77,-36.09,26.94))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-5.80,-36.70,27.49))
Interior9V.append((-3.27,-35.86,25.23))
Interior9V.append((-1.71,-35.72,27.70))
Interior9V.append((-3.77,-36.09,26.94))
Interior9V.append((-3.27,-35.86,25.23))
Interior9V.append((-2.93,-39.70,25.68))
Interior9V.append((-1.71,-35.72,27.70))
Interior9V.append((-1.71,-35.72,27.70))
Interior9V.append((.35,-36.95,26.23))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-1.16,-34.00,27.96))
Interior9V.append((3.06,-36.65,26.83))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-1.20,-44.69,30.27))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-1.20,-44.69,30.27))
Interior9V.append((-2.43,-41.05,29.81))
Interior9V.append((-4.06,-41.73,31.82))
Interior9V.append((-1.20,-44.69,30.27))
Interior9V.append((-4.06,-41.73,31.82))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-5.55,-33.84,27.63))
Interior9V.append((-3.77,-36.09,26.94))
Interior9V.append((-1.71,-35.72,27.70))
Interior9V.append((-5.55,-33.84,27.63))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-3.77,-36.09,26.94))
Interior9V.append((-1.71,-35.72,27.70))
Interior9V.append((-1.73,-34.73,27.58))
Interior9V.append((-5.55,-33.84,27.63))
Interior9V.append((-4.60,-37.93,30.33))
Interior9V.append((-4.49,-37.15,33.08))
Interior9V.append((-2.43,-38.60,34.28))
Interior9V.append((-3.77,-36.09,26.94))
Interior9V.append((-5.80,-36.70,27.49))
Interior9V.append((-5.41,-35.53,25.13))
Interior9V.append((-5.41,-35.53,25.13))
Interior9V.append((-3.27,-35.86,25.23))
Interior9V.append((-3.77,-36.09,26.94))
Interior9V.append((-3.27,-35.86,25.23))
Interior9V.append((-5.41,-35.53,25.13))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-4.81,-37.44,22.25))
Interior9V.append((-3.27,-35.86,25.23))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-4.81,-37.44,22.25))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-6.44,-39.91,23.04))
Interior9V.append((-5.45,-40.26,25.22))
Interior9V.append((-6.44,-39.91,23.04))
Interior9V.append((-7.70,-40.72,25.23))
Interior9V.append((-8.98,-37.24,25.10))
Interior9V.append((-8.55,-38.03,27.26))
Interior9V.append((-7.70,-40.72,25.23))
Interior9V.append((-5.80,-36.70,27.49))
Interior9V.append((-8.55,-38.03,27.26))
Interior9V.append((-8.98,-37.24,25.10))
Interior9V.append((-8.98,-37.24,25.10))
Interior9V.append((-6.27,-36.99,23.17))
Interior9V.append((-5.41,-35.53,25.13))
Interior9V.append((-8.98,-37.24,25.10))
Interior9V.append((-5.41,-35.53,25.13))
Interior9V.append((-5.80,-36.70,27.49))
Interior9V.append((-7.70,-40.72,25.23))
Interior9V.append((-9.16,-39.42,24.21))
Interior9V.append((-8.98,-37.24,25.10))
Interior9V.append((-7.70,-40.72,25.23))
Interior9V.append((-6.44,-39.91,23.04))
Interior9V.append((-9.16,-39.42,24.21))

Interior9I = []
for x in range(0,72):
    Interior9I.append((x*3, x*3+1, x*3+2))

Interior9V = array(tuple(Interior9V), floatc)
Interior9I = array(tuple(Interior9I), intc)
Interior9Piece = Interior9.addPiece(Interior9V, Interior9I, (0,0,1,.5))
Interior9Piece.display = True
Interior9Piece.displayStyle = Interior9Piece.Solid
chimera.openModels.add([Interior9])
Interior10 = _surface.SurfaceModel()
Interior10V = []
Interior10V.append((-3.07,-38.58,21.26))
Interior10V.append((-1.76,-38.08,23.48))
Interior10V.append((-.56,-36.27,22.49))
Interior10V.append((-3.07,-38.58,21.26))
Interior10V.append((-4.81,-37.44,22.25))
Interior10V.append((-1.76,-38.08,23.48))
Interior10V.append((-.48,-36.38,20.20))
Interior10V.append((-3.07,-38.58,21.26))
Interior10V.append((-.56,-36.27,22.49))
Interior10V.append((-.48,-36.38,20.20))
Interior10V.append((-.56,-36.27,22.49))
Interior10V.append((-1.33,-35.87,20.21))
Interior10V.append((-.48,-36.38,20.20))
Interior10V.append((-1.33,-35.87,20.21))
Interior10V.append((-3.07,-38.58,21.26))
Interior10V.append((-.81,-34.11,21.45))
Interior10V.append((-1.33,-35.87,20.21))
Interior10V.append((-.56,-36.27,22.49))
Interior10V.append((-1.60,-32.13,21.11))
Interior10V.append((.89,-32.27,21.97))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-1.60,-32.13,21.11))
Interior10V.append((1.20,-33.72,22.79))
Interior10V.append((.89,-32.27,21.97))
Interior10V.append((-.81,-34.11,21.45))
Interior10V.append((1.20,-33.72,22.79))
Interior10V.append((-1.60,-32.13,21.11))
Interior10V.append((-7.30,-32.34,27.45))
Interior10V.append((-6.23,-31.55,24.16))
Interior10V.append((-7.99,-30.38,27.29))
Interior10V.append((-7.21,-28.43,25.26))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-7.99,-30.38,27.29))
Interior10V.append((-7.21,-28.43,25.26))
Interior10V.append((-7.99,-30.38,27.29))
Interior10V.append((-6.23,-31.55,24.16))
Interior10V.append((-2.02,-27.94,23.10))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-7.21,-28.43,25.26))
Interior10V.append((-5.55,-33.84,27.63))
Interior10V.append((-7.30,-32.34,27.45))
Interior10V.append((-7.99,-30.38,27.29))
Interior10V.append((-5.55,-33.84,27.63))
Interior10V.append((-7.99,-30.38,27.29))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-5.02,-33.76,25.31))
Interior10V.append((-5.55,-33.84,27.63))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-5.02,-33.76,25.31))
Interior10V.append((-7.30,-32.34,27.45))
Interior10V.append((-5.55,-33.84,27.63))
Interior10V.append((-1.76,-38.08,23.48))
Interior10V.append((-4.90,-35.89,23.05))
Interior10V.append((-3.27,-35.86,25.23))
Interior10V.append((-1.76,-38.08,23.48))
Interior10V.append((-3.27,-35.86,25.23))
Interior10V.append((-.56,-36.27,22.49))
Interior10V.append((-.56,-36.27,22.49))
Interior10V.append((-3.27,-35.86,25.23))
Interior10V.append((-.34,-35.73,25.04))
Interior10V.append((-.56,-36.27,22.49))
Interior10V.append((-.34,-35.73,25.04))
Interior10V.append((-.81,-34.11,21.45))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-.34,-35.73,25.04))
Interior10V.append((-3.27,-35.86,25.23))
Interior10V.append((-5.02,-33.76,25.31))
Interior10V.append((-4.90,-35.89,23.05))
Interior10V.append((-3.66,-33.02,22.01))
Interior10V.append((-5.02,-33.76,25.31))
Interior10V.append((-3.27,-35.86,25.23))
Interior10V.append((-4.90,-35.89,23.05))
Interior10V.append((-5.02,-33.76,25.31))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-3.27,-35.86,25.23))
Interior10V.append((-3.66,-33.02,22.01))
Interior10V.append((-3.06,-30.42,22.28))
Interior10V.append((-6.23,-31.55,24.16))
Interior10V.append((-3.66,-33.02,22.01))
Interior10V.append((-6.23,-31.55,24.16))
Interior10V.append((-5.02,-33.76,25.31))
Interior10V.append((-1.60,-32.13,21.11))
Interior10V.append((-3.06,-30.42,22.28))
Interior10V.append((-3.66,-33.02,22.01))
Interior10V.append((-3.66,-33.02,22.01))
Interior10V.append((-.81,-34.11,21.45))
Interior10V.append((-1.60,-32.13,21.11))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((-1.60,-32.13,21.11))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((-3.06,-30.42,22.28))
Interior10V.append((-1.60,-32.13,21.11))
Interior10V.append((-2.02,-27.94,23.10))
Interior10V.append((-3.06,-30.42,22.28))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((.89,-32.27,21.97))
Interior10V.append((4.38,-34.77,25.95))
Interior10V.append((.89,-32.27,21.97))
Interior10V.append((1.20,-33.72,22.79))
Interior10V.append((4.38,-34.77,25.95))
Interior10V.append((1.20,-33.72,22.79))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((-.34,-35.73,25.04))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((1.20,-33.72,22.79))
Interior10V.append((-.34,-35.73,25.04))
Interior10V.append((1.20,-33.72,22.79))
Interior10V.append((-.81,-34.11,21.45))
Interior10V.append((-.34,-35.73,25.04))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((-.34,-35.73,25.04))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((-2.02,-27.94,23.10))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((-2.02,-27.94,23.10))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((-2.59,-33.11,26.30))
Interior10V.append((-2.02,-27.94,23.10))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((.89,-32.27,21.97))
Interior10V.append((4.38,-34.77,25.95))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((.89,-32.27,21.97))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((4.38,-34.77,25.95))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((-.72,-29.77,22.25))
Interior10V.append((.26,-27.64,22.73))
Interior10V.append((1.76,-34.85,26.09))
Interior10V.append((-1.16,-34.00,27.96))
Interior10V.append((-3.06,-30.42,22.28))
Interior10V.append((-7.21,-28.43,25.26))
Interior10V.append((-6.23,-31.55,24.16))
Interior10V.append((-3.06,-30.42,22.28))
Interior10V.append((-2.02,-27.94,23.10))
Interior10V.append((-7.21,-28.43,25.26))
Interior10V.append((-5.14,-35.57,20.67))
Interior10V.append((-4.81,-37.44,22.25))
Interior10V.append((-3.07,-38.58,21.26))
Interior10V.append((-2.40,-37.44,19.29))
Interior10V.append((-3.07,-38.58,21.26))
Interior10V.append((-1.33,-35.87,20.21))
Interior10V.append((-2.40,-37.44,19.29))
Interior10V.append((-5.14,-35.57,20.67))
Interior10V.append((-3.07,-38.58,21.26))
Interior10V.append((-2.40,-37.44,19.29))
Interior10V.append((-1.33,-35.87,20.21))
Interior10V.append((-5.14,-35.57,20.67))
Interior10V.append((-4.90,-35.89,23.05))
Interior10V.append((-4.81,-37.44,22.25))
Interior10V.append((-5.14,-35.57,20.67))
Interior10V.append((-2.72,-34.72,19.68))
Interior10V.append((-4.90,-35.89,23.05))
Interior10V.append((-5.14,-35.57,20.67))
Interior10V.append((-2.72,-34.72,19.68))
Interior10V.append((-5.14,-35.57,20.67))
Interior10V.append((-1.33,-35.87,20.21))
Interior10V.append((-4.90,-35.89,23.05))
Interior10V.append((-1.76,-38.08,23.48))
Interior10V.append((-4.81,-37.44,22.25))
Interior10V.append((-2.72,-34.72,19.68))
Interior10V.append((-1.33,-35.87,20.21))
Interior10V.append((-.81,-34.11,21.45))
Interior10V.append((-2.72,-34.72,19.68))
Interior10V.append((-.81,-34.11,21.45))
Interior10V.append((-3.66,-33.02,22.01))
Interior10V.append((-2.72,-34.72,19.68))
Interior10V.append((-3.66,-33.02,22.01))
Interior10V.append((-4.90,-35.89,23.05))
Interior10V.append((-5.02,-33.76,25.31))
Interior10V.append((-6.23,-31.55,24.16))
Interior10V.append((-7.30,-32.34,27.45))

Interior10I = []
for x in range(0,66):
    Interior10I.append((x*3, x*3+1, x*3+2))

Interior10V = array(tuple(Interior10V), floatc)
Interior10I = array(tuple(Interior10I), intc)
Interior10Piece = Interior10.addPiece(Interior10V, Interior10I, (0.39,0.58,0.93,.5))
Interior10Piece.display = True
Interior10Piece.displayStyle = Interior10Piece.Solid
chimera.openModels.add([Interior10])
Interior11 = _surface.SurfaceModel()
Interior11V = []
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-7.50,-28.84,-2.23))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-6.89,-28.79,3.00))
Interior11V.append((-10.59,-31.06,1.17))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-10.59,-31.06,1.17))
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-9.49,-30.12,3.29))
Interior11V.append((-10.59,-31.06,1.17))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-9.49,-30.12,3.29))
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-10.59,-31.06,1.17))
Interior11V.append((-12.77,-29.43,1.95))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-12.77,-29.43,1.95))
Interior11V.append((-13.32,-28.04,4.14))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-12.77,-29.43,1.95))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-13.32,-28.04,4.14))
Interior11V.append((-6.13,-32.58,.74))
Interior11V.append((-8.37,-31.65,-.87))
Interior11V.append((-8.10,-32.38,1.67))
Interior11V.append((-6.13,-32.58,.74))
Interior11V.append((-8.10,-32.38,1.67))
Interior11V.append((-5.70,-29.94,2.27))
Interior11V.append((-8.79,-31.82,2.13))
Interior11V.append((-8.10,-32.38,1.67))
Interior11V.append((-8.37,-31.65,-.87))
Interior11V.append((-8.79,-31.82,2.13))
Interior11V.append((-5.70,-29.94,2.27))
Interior11V.append((-8.10,-32.38,1.67))
Interior11V.append((-6.89,-28.79,3.00))
Interior11V.append((-5.70,-29.94,2.27))
Interior11V.append((-8.79,-31.82,2.13))
Interior11V.append((-8.37,-31.65,-.87))
Interior11V.append((-7.50,-28.84,-2.23))
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-7.64,-21.65,7.91))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-8.73,-22.46,5.96))
Interior11V.append((-7.64,-21.65,7.91))
Interior11V.append((-8.05,-23.44,8.00))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-7.64,-21.65,7.91))
Interior11V.append((-8.73,-22.46,5.96))
Interior11V.append((-8.05,-23.44,8.00))
Interior11V.append((-9.03,-26.08,7.04))
Interior11V.append((-14.16,-26.57,5.50))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-14.88,-26.27,3.85))
Interior11V.append((-14.16,-26.57,5.50))
Interior11V.append((-13.32,-28.04,4.14))
Interior11V.append((-13.94,-27.42,1.12))
Interior11V.append((-14.88,-26.27,3.85))
Interior11V.append((-13.32,-28.04,4.14))
Interior11V.append((-13.94,-27.42,1.12))
Interior11V.append((-13.32,-28.04,4.14))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-9.74,-26.02,.06))
Interior11V.append((-13.94,-27.42,1.12))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-9.74,-26.02,.06))
Interior11V.append((-14.88,-26.27,3.85))
Interior11V.append((-13.94,-27.42,1.12))
Interior11V.append((-6.89,-28.79,3.00))
Interior11V.append((-5.52,-27.71,-.68))
Interior11V.append((-5.70,-29.94,2.27))
Interior11V.append((-5.52,-27.71,-.68))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-7.50,-28.84,-2.23))
Interior11V.append((-5.52,-27.71,-.68))
Interior11V.append((-6.89,-28.79,3.00))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-5.42,-30.36,-1.29))
Interior11V.append((-5.52,-27.71,-.68))
Interior11V.append((-7.50,-28.84,-2.23))
Interior11V.append((-5.42,-30.36,-1.29))
Interior11V.append((-5.70,-29.94,2.27))
Interior11V.append((-5.52,-27.71,-.68))
Interior11V.append((-8.37,-31.65,-.87))
Interior11V.append((-5.42,-30.36,-1.29))
Interior11V.append((-7.50,-28.84,-2.23))
Interior11V.append((-5.42,-30.36,-1.29))
Interior11V.append((-8.37,-31.65,-.87))
Interior11V.append((-6.13,-32.58,.74))
Interior11V.append((-5.42,-30.36,-1.29))
Interior11V.append((-6.13,-32.58,.74))
Interior11V.append((-5.70,-29.94,2.27))
Interior11V.append((-7.93,-26.07,1.30))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-7.93,-26.07,1.30))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-7.93,-26.07,1.30))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-7.52,-23.74,5.60))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-8.73,-22.46,5.96))
Interior11V.append((-7.52,-23.74,5.60))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-7.52,-23.74,5.60))
Interior11V.append((-8.73,-22.46,5.96))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-9.74,-26.02,.06))
Interior11V.append((-10.01,-26.90,1.00))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-14.88,-26.27,3.85))
Interior11V.append((-9.74,-26.02,.06))
Interior11V.append((-16.55,-24.98,4.64))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-14.88,-26.27,3.85))
Interior11V.append((-16.55,-24.98,4.64))
Interior11V.append((-14.88,-26.27,3.85))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-8.73,-22.46,5.96))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-7.62,-19.69,2.49))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-16.55,-24.98,4.64))
Interior11V.append((-7.62,-19.69,2.49))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-7.62,-19.69,2.49))
Interior11V.append((-16.55,-24.98,4.64))
Interior11V.append((-8.18,-21.82,3.55))
Interior11V.append((-14.88,-26.27,3.85))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-14.16,-26.57,5.50))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-9.03,-26.08,7.04))
Interior11V.append((-8.73,-22.46,5.96))
Interior11V.append((-9.03,-26.08,7.04))
Interior11V.append((-13.32,-28.04,4.14))
Interior11V.append((-14.16,-26.57,5.50))
Interior11V.append((-9.03,-26.08,7.04))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-13.32,-28.04,4.14))
Interior11V.append((-9.03,-26.08,7.04))
Interior11V.append((-8.85,-26.96,1.78))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-8.54,-30.86,3.10))
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-9.49,-30.12,3.29))
Interior11V.append((-8.54,-30.86,3.10))
Interior11V.append((-9.49,-30.12,3.29))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-8.54,-30.86,3.10))
Interior11V.append((-8.72,-27.63,2.62))
Interior11V.append((-6.89,-28.79,3.00))
Interior11V.append((-8.79,-31.82,2.13))
Interior11V.append((-8.54,-30.86,3.10))
Interior11V.append((-6.89,-28.79,3.00))
Interior11V.append((-8.79,-31.82,2.13))
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-8.54,-30.86,3.10))
Interior11V.append((-10.03,-29.83,-.85))
Interior11V.append((-8.79,-31.82,2.13))
Interior11V.append((-8.37,-31.65,-.87))
Interior11V.append((-9.03,-26.08,7.04))
Interior11V.append((-15.73,-24.77,6.30))
Interior11V.append((-8.05,-23.44,8.00))
Interior11V.append((-9.03,-26.08,7.04))
Interior11V.append((-8.05,-23.44,8.00))
Interior11V.append((-8.73,-22.46,5.96))

Interior11I = []
for x in range(0,60):
    Interior11I.append((x*3, x*3+1, x*3+2))

Interior11V = array(tuple(Interior11V), floatc)
Interior11I = array(tuple(Interior11I), intc)
Interior11Piece = Interior11.addPiece(Interior11V, Interior11I, (0.2,0.2,0.8,.5))
Interior11Piece.display = True
Interior11Piece.displayStyle = Interior11Piece.Solid
chimera.openModels.add([Interior11])
Interior12 = _surface.SurfaceModel()
Interior12V = []
Interior12V.append((-19.25,-50.27,28.92))
Interior12V.append((-20.58,-45.41,32.95))
Interior12V.append((-19.17,-50.68,29.78))
Interior12V.append((-19.25,-50.27,28.92))
Interior12V.append((-18.79,-46.75,32.00))
Interior12V.append((-20.58,-45.41,32.95))
Interior12V.append((-11.75,-52.88,37.78))
Interior12V.append((-19.36,-46.10,33.90))
Interior12V.append((-12.90,-48.52,34.31))
Interior12V.append((-11.75,-52.88,37.78))
Interior12V.append((-12.90,-48.52,34.31))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-11.75,-52.88,37.78))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-19.36,-46.10,33.90))
Interior12V.append((-19.17,-50.68,29.78))
Interior12V.append((-19.36,-46.10,33.90))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-12.90,-48.52,34.31))
Interior12V.append((-12.92,-48.70,33.10))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-11.98,-51.08,31.75))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-12.92,-48.70,33.10))
Interior12V.append((-11.98,-51.08,31.75))
Interior12V.append((-13.79,-53.05,31.27))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-14.11,-51.68,29.13))
Interior12V.append((-13.79,-53.05,31.27))
Interior12V.append((-11.98,-51.08,31.75))
Interior12V.append((-14.11,-51.68,29.13))
Interior12V.append((-16.07,-50.75,29.70))
Interior12V.append((-13.79,-53.05,31.27))
Interior12V.append((-16.17,-53.12,29.81))
Interior12V.append((-19.17,-50.68,29.78))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-16.17,-53.12,29.81))
Interior12V.append((-13.79,-53.05,31.27))
Interior12V.append((-16.07,-50.75,29.70))
Interior12V.append((-16.17,-53.12,29.81))
Interior12V.append((-16.07,-50.75,29.70))
Interior12V.append((-19.17,-50.68,29.78))
Interior12V.append((-16.14,-55.44,30.14))
Interior12V.append((-16.17,-53.12,29.81))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-16.14,-55.44,30.14))
Interior12V.append((-13.79,-53.05,31.27))
Interior12V.append((-16.17,-53.12,29.81))
Interior12V.append((-16.14,-55.44,30.14))
Interior12V.append((-12.49,-53.52,35.05))
Interior12V.append((-13.79,-53.05,31.27))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-16.07,-50.75,29.70))
Interior12V.append((-14.11,-51.68,29.13))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-11.77,-50.21,30.34))
Interior12V.append((-12.78,-48.71,27.32))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-12.78,-48.71,27.32))
Interior12V.append((-14.29,-46.83,29.67))
Interior12V.append((-12.28,-48.12,31.28))
Interior12V.append((-12.78,-48.71,27.32))
Interior12V.append((-11.77,-50.21,30.34))
Interior12V.append((-12.28,-48.12,31.28))
Interior12V.append((-14.29,-46.83,29.67))
Interior12V.append((-12.78,-48.71,27.32))
Interior12V.append((-12.28,-48.12,31.28))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-14.29,-46.83,29.67))
Interior12V.append((-11.77,-50.21,30.34))
Interior12V.append((-14.11,-51.68,29.13))
Interior12V.append((-11.98,-51.08,31.75))
Interior12V.append((-11.77,-50.21,30.34))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-14.11,-51.68,29.13))
Interior12V.append((-11.98,-51.08,31.75))
Interior12V.append((-12.28,-48.12,31.28))
Interior12V.append((-11.77,-50.21,30.34))
Interior12V.append((-12.28,-48.12,31.28))
Interior12V.append((-12.92,-48.70,33.10))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-12.28,-48.12,31.28))
Interior12V.append((-11.98,-51.08,31.75))
Interior12V.append((-12.92,-48.70,33.10))
Interior12V.append((-16.75,-45.55,32.97))
Interior12V.append((-12.92,-48.70,33.10))
Interior12V.append((-12.90,-48.52,34.31))
Interior12V.append((-16.75,-45.55,32.97))
Interior12V.append((-19.36,-46.10,33.90))
Interior12V.append((-18.79,-46.75,32.00))
Interior12V.append((-16.75,-45.55,32.97))
Interior12V.append((-12.90,-48.52,34.31))
Interior12V.append((-19.36,-46.10,33.90))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-16.75,-45.55,32.97))
Interior12V.append((-18.79,-46.75,32.00))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-12.92,-48.70,33.10))
Interior12V.append((-16.75,-45.55,32.97))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-18.79,-46.75,32.00))
Interior12V.append((-18.30,-48.59,29.87))
Interior12V.append((-15.66,-48.70,30.05))
Interior12V.append((-18.30,-48.59,29.87))
Interior12V.append((-16.07,-50.75,29.70))
Interior12V.append((-19.36,-46.10,33.90))
Interior12V.append((-19.17,-50.68,29.78))
Interior12V.append((-20.58,-45.41,32.95))
Interior12V.append((-19.36,-46.10,33.90))
Interior12V.append((-20.58,-45.41,32.95))
Interior12V.append((-18.79,-46.75,32.00))
Interior12V.append((-18.30,-48.59,29.87))
Interior12V.append((-18.79,-46.75,32.00))
Interior12V.append((-19.25,-50.27,28.92))
Interior12V.append((-18.30,-48.59,29.87))
Interior12V.append((-19.25,-50.27,28.92))
Interior12V.append((-19.17,-50.68,29.78))
Interior12V.append((-19.17,-50.68,29.78))
Interior12V.append((-16.07,-50.75,29.70))
Interior12V.append((-18.30,-48.59,29.87))

Interior12I = []
for x in range(0,40):
    Interior12I.append((x*3, x*3+1, x*3+2))

Interior12V = array(tuple(Interior12V), floatc)
Interior12I = array(tuple(Interior12I), intc)
Interior12Piece = Interior12.addPiece(Interior12V, Interior12I, (0.63,0.13,0.94,.5))
Interior12Piece.display = True
Interior12Piece.displayStyle = Interior12Piece.Solid
chimera.openModels.add([Interior12])
chimera.runCommand('open cifID:state_apo_All_14tic_n6_3_0')
