# vim: set expandtab shiftwidth=4 softtabstop=4:

from PyQt5.QtCore import QObject, pyqtSignal, pyqtSlot

class Dialog(QObject):

    _sendText = pyqtSignal(str, name="sendText")

    def sendText(self, text):
        self._sendText.emit(text)

    @pyqtSlot(str)
    def receiveText(self, text):
        print("receiveText", text)


def setup_channel():
    from PyQt5.QtWebChannel import QWebChannel
    channel = QWebChannel()
    dialog = Dialog()
    channel.registerObject("dialog", dialog)
    from chimerax.help_viewer.tool import HelpUI
    HelpUI.get_viewer(session).help_window.page().setWebChannel(channel)
    return dialog, channel

print(setup_channel())
