def _pdbFetch(site, url, params, statusName, saveDir='', saveName='',
		ignore_cache=False, post=True):

	print "custom _pdbFetch"
	if saveName and not ignore_cache:
		print "fetching local file"
		try:
			from chimera import fetch
		except Exception, v:
			print "importing fetch threw error:", str(v)
			raise
		print "fetch imported"
		path = fetch.fetch_local_file(saveDir, saveName)
		print "fetch_local_file returned", path
		if path:
			print "fetched local file", saveName, "to", path
			return path
	print "issuing status"
	from chimera import replyobj
	replyobj.status('Fetching %s from web site %s' %
					(statusName, site), blankAfter=0)

	from chimera import tasks
	cancelled = []
	def cancelCB():
		cancelled.append(True)
	print "creating task"
	task = tasks.Task("Fetch %s" % statusName, cancelCB, modal=True)

	def reportCB(barrived, bsize, fsize):
		if cancelled:
			raise IOError("cancelled at user request")
		if fsize > 0:
			percent = (100.0 * barrived * bsize) / fsize
			prog = '%.0f%% of %d bytes' % (percent, fsize)
		else:
			prog = '%.0f Kbytes received' % ((barrived * bsize) / 1024,)
		task.updateStatus(prog)
	import urllib
	print "encoding params"
	params = urllib.urlencode(params)
	print "urlretrieve"
	try:
		if post:
			print "post", "http://%s/%s" % (site, url), "with data:", params
			tf, headers = urllib.urlretrieve("http://%s/%s" % (site, url),
				data=params, reporthook=reportCB)
		else:
			print "non-post", "http://%s/%s?%s" % (site, url, params)
			tf, headers = urllib.urlretrieve("http://%s/%s?%s"
				% (site, url, params), reporthook=reportCB)
	except (IOError, UnicodeError), v:
		replyobj.status("")
		raise NonChimeraError("Error during PDB fetch: " + str(v))
	finally:
		task.finished()
	task = None

	replyobj.status('Done fetching %s; verifying...' % statusName)
	fetched = open(tf, "r")
	numLines = 0
	for l in fetched:
		numLines += 1
		if numLines >= 20:
			break
	else:
		# too short; not a PDB file
		fetched.close()
		os.unlink(tf)
		replyobj.status("")
		raise UserError, "No such ID: %s" % statusName
	fetched.close()
	if saveName:
		from chimera import fetch
		spath = fetch.save_fetched_file(tf, saveDir, saveName)
		if spath:
			tf = spath
	replyobj.status("Opening %s..." % statusName, blankAfter=0)
	return tf

import chimera
oldPdbFetch = chimera._pdbFetch
chimera._pdbFetch = _pdbFetch
try:
	chimera.runCommand("open pdb:2val")
	print "open worked"
except:
	print "open failed"
import urllib
params = urllib.urlencode({})
try:
	urllib.urlretrieve("http://www.rcsb.org/files/pdb/2VAL.pdb", data=params)
	print "plain http to RCSB works"
except:
	print "plain http to RCSB fails"
try:
	urllib.urlretrieve("https://www.rcsb.org/files/pdb/2VAL.pdb", data=params)
	print "https to RCSB works"
except:
	print "https to RCSB fails"
try:
	urllib.urlretrieve("http://www.cgl.ucsf.edu/chimera/docindex.html", data=params)
	print "plain http to CGL works"
except:
	print "plain http to CGL fails"

import os
host_file = "C:\\Windows\\System32\\drivers\\etc\\host"
if os.path.exists(host_file):
	print "host file exists; contents:"
	f = open(host_file, "r")
	for line in f:
		print line,
	f.close()
else:
	print "host file does not exist"

chimera._pdbFetch = oldPdbFetch
